function ConduitAutoCompleteSearch() {
	this.commands = [];
}

ConduitAutoCompleteSearch.prototype = {
	startSearch: function(searchString, searchParam, prevResult, listener) {
		this.setHistory()
		var result = new AutoCompleteResult(searchString, this.commands);
		listener.onSearchResult(this, result);
	},

	stopSearch: function() {
	},

	setHistory: function() {
		var dir = null;
		try 
		{
			var dir = Components.classes['@mozilla.org/file/directory_service;1']
									.createInstance(Components.interfaces.nsIProperties)
									.get('ProfD', Components.interfaces.nsIFile);
		}
		catch(e){return null }	
		var sep = '/';
		var path = dir.path + sep + 'EBSuggestHistory';
		try 
		{
			var ebDir = Components.classes['@mozilla.org/file/local;1']
						.createInstance(Components.interfaces.nsILocalFile);
			ebDir.initWithPath(path);
		}
		catch(e) 
		{ 
			sep = '\\';
			path = dir.path + sep + 'EBSuggestHistory';
			try 
			{
				var ebDir = Components.classes['@mozilla.org/file/local;1']
							.createInstance(Components.interfaces.nsILocalFile);
				ebDir.initWithPath(path);
			}
			catch(e) { return null }
		}
		
		try 
		{
			var file = Components.classes['@mozilla.org/file/local;1']
						.createInstance(Components.interfaces.nsILocalFile);
			file.initWithPath(ebDir.path + sep + 'search_history.xml');
		}
		catch(e) { return null }
		
		try 
		{
			var data     = new String();
			
			var fiStream = Components.classes['@mozilla.org/network/file-input-stream;1']
					.createInstance(Components.interfaces.nsIFileInputStream);
			
			var siStream = Components.classes['@mozilla.org/scriptableinputstream;1']
					.createInstance(Components.interfaces.nsIScriptableInputStream);

			fiStream.init(file, 1, 0, false);
			siStream.init(fiStream);
			data += siStream.read(-1);
			siStream.close();
			fiStream.close();

			try
			{
				var uniConv = Components.classes['@mozilla.org/intl/scriptableunicodeconverter']
						.createInstance(Components.interfaces.nsIScriptableUnicodeConverter);
				uniConv.charset = 'UTF-8';
				data = uniConv.ConvertToUnicode(data);
			} 
			catch(e) { return null }
		}
		catch(e) { return null }
		var parser = Components.classes['@mozilla.org/xmlextras/domparser;1']
						.createInstance(Components.interfaces.nsIDOMParser);
		
		var xmlDoc		= parser.parseFromString(data, "text/xml");
		
		var xmlItems	= xmlDoc.documentElement.getElementsByTagName('ITEM');
		
		var result = [];
		
		var nodeValue = '';
		
		for(var i=0; i<xmlItems.length; i++)
		{
			if(typeof (xmlItems.item(i).childNodes[0]) != "undefined")
			{
				nodeValue = xmlItems.item(i).childNodes[0].nodeValue;
				result[result.length] = nodeValue;
			}
		}
		
		var commands = Components.classes["@mozilla.org/supports-array;1"].createInstance(Components.interfaces.nsISupportsArray);
		for (var i = 0; i < result.length; i++) 
		{
			var string = Components.classes["@mozilla.org/supports-string;1"].createInstance(Components.interfaces.nsISupportsString);
			string.data = result[i];
			commands.AppendElement(string);
		}
		
		var count = commands.Count();
		this.commands = new Array(count);
		for (var i = 0; i < count; i++) {
			this.commands[i] = commands.GetElementAt(i).QueryInterface(Components.interfaces.nsISupportsString).data;
		}
	},

    QueryInterface: function (uuid) {
		if (uuid.equals(Components.interfaces.nsIConduitAutoCompleteSearch) ||
			uuid.equals(Components.interfaces.nsIAutoCompleteSearch) ||
			uuid.equals(Components.interfaces.nsISupports)) {
			return this;
		}
        Components.returnCode = Components.results.NS_ERROR_NO_INTERFACE;
        return null;
    }
}

function AutoCompleteResult(search, commands) {
	this.search = search;
	this.commands = [];
	var lsearch = search.toLowerCase();
	for (var i = 0; i < commands.length; i++) {
		if (commands[i].toLowerCase().indexOf(lsearch) == 0) {
			this.commands.push(commands[i]);
		}
	//this.commands.sort();	
	}
}

AutoCompleteResult.prototype = {
	get defaultIndex() {
		return 0;
	},
	get errorDescription() {
		return '';
	},
	get matchCount() {
		return this.commands.length;
	},
	get searchResult() {
		return Components.interfaces.nsIAutoCompleteResult.RESULT_SUCCESS;
	},
	get searchString() {
		return this.search;
	},
	getCommentAt: function(index) {
		return '';
	},
	getStyleAt: function(index) {
		return '';
	},
	getValueAt: function(index) {
		return this.commands[index];
	},
	removeValueAt: function(rowIndex, removeFromDb) {
	},
    QueryInterface: function (uuid) {
		if (uuid.equals(Components.interfaces.nsIAutoCompleteResult) ||
			uuid.equals(Components.interfaces.nsISupports)) {
			return this;
		}
        Components.returnCode = Components.results.NS_ERROR_NO_INTERFACE;
        return null;
    }
}

const COMPONENT_ID = Components.ID("{3B586328-87AA-4e91-AD60-02F830CA6DE1}");

var ConduitAutoCompleteModule = {
    registerSelf: function (compMgr, fileSpec, location, type) {
        compMgr = compMgr.QueryInterface(Components.interfaces.nsIComponentRegistrar);
        compMgr.registerFactoryLocation(COMPONENT_ID,
                                        "Conduit Auto Complete",
                                        "@mozilla.org/autocomplete/search;1?name=conduit-auto-complete",
                                        fileSpec,
                                        location,
                                        type);
    },

    getClassObject: function (compMgr, cid, iid) {
        if (!cid.equals(COMPONENT_ID))
            throw Components.results.NS_ERROR_NO_INTERFACE;
        if (!iid.equals(Components.interfaces.nsIFactory))
            throw Components.results.NS_ERROR_NOT_IMPLEMENTED;

		return ConduitAutoCompleteFactory;
    },

    canUnload: function(compMgr) {
        return true;
    }
};

var ConduitAutoCompleteFactory = {
	createInstance: function (outer, iid) {
		if (outer != null)
			throw Components.results.NS_ERROR_NO_AGGREGATION;
		return new ConduitAutoCompleteSearch().QueryInterface(iid);
	}
};

function NSGetModule(compMgr, fileSpec) {
    return ConduitAutoCompleteModule;
}

