
//consts Class:
var EBEmailAccountsConsts_CT459487 = 
{
	LOGIN_FAILED			: -1,
	LOGIN_ANOTHER_ACCOUNT	: -2,
	
	CheckURL				: 'http://www.conduit.com',
	
	DomainCaptionDelimiter	: '/',
	
	GMail : 
	{
		MailURL				: 'http://www.gmail.com',
		MailLogoutURL		: 'https://mail.google.com/mail/?logout&hl=en',
		EMailDomain			: ['@gmail.com','@googlemail.com'],
		EMailDomainCaption	: ['.com'],
		FeedURL				: 'https://gmail.google.com/gmail/feed/atom',
		AccountName			: 'Gmail'
	},
	
	Yahoo : 
	{
		MailURL				: 'http://login.yahoo.com/config/login',
		MailLogoutURL		: 'http://login.yahoo.com/config/login?logout=1',
		EMailDomain			: ['@yahoo.com','@yahoo.co.uk','@yahoo.com.au','@yahoo.ca'],
		EMailDomainCaption	: ['.com','.co.uk','.com.au','.ca'],
		AccountName			: 'Yahoo',
		CheckLoginInURL		: '.mail.yahoo.'
	},
	
	Hotmail : 
	{
		MailURL				: 'http://www.hotmail.com/',
		MailLogoutURL		: 'http://login.live.com/logout.srf',
		EMailDomain			: ['@hotmail.com','@hotmail.co.uk','@msn.com','@msn.co.uk'],
		EMailDomainCaption	: ['.com','.co.uk'],
		AccountName			: 'Hotmail',
		URL					: 'http://www.hotmail.com',
		CheckLoginInURL		: ['.hotmail.msn.','.mail.live.']
	},
	
	Pop3 : 
	{
		AccountName			: 'POP3',
		StateStart			: 0,
		StateUserName		: 1,
		StatePassword		: 2,
		StateStatus			: 3,
		StateQuit			: 4,
		
		DefaultPort			: 110,
		
		
		CommandOKPrefix		: '+OK',
		CommandERRPrefix	: '-ERR'
	}
}

var EBEmailAccountsTypes_CT459487 = 
{
	GMail	: 1,
	Yahoo	: 2,
	Hotmail : 3,
	Pop3    : 4
}


//the base class of the email notifier hierarchy
function EBEMailAccount_CT459487(strMailURL,strEMail,strPassword)
{
	this.EMail		= strEMail;
	this.Password	= strPassword;
	this.MailURL	= strMailURL;
	
	this.UserName	= '';
	
	this.Init = function()
	{
		this.UserName = EBEMailNotifierManager_CT459487.GetUserNameByEMail(this.EMail);
	}
	
	this.Init();
}

//every mail account inherits the EBMailAccount (by define it in his class - it's not really inheritance)
//and it defined in it the same functions:

/********************* GMail Account ****************************/
function EBGmailAccount_CT459487(strEMail,strPassword)
{
	this.MailAccount = null; 
	
	//Constructor
	this.InitAccount = function(strEMail,strPassword)
	{
		//initialize the email account object
		this.MailAccount = new EBEMailAccount_CT459487(EBEmailAccountsConsts_CT459487.GMail.MailURL ,strEMail,strPassword);
	}
	
	
	this.Login = function(event)
	{
		//get the post data of the account
		var strPostData = this._GetGmailPostData();
		EBLinkManager_CT459487.LoadLinkURL(event,this.MailAccount.MailURL,false,strPostData);
		
	};
	
	this.Logout = function(event)
	{
		var strLogoutURL = EBEmailAccountsConsts_CT459487.GMail.MailLogoutURL;
		var strLoginURL = EBEmailAccountsConsts_CT459487.GMail.MailURL;
		EBLinkManager_CT459487.LoadLinkURL(event,strLogoutURL,false,null);
		EBLinkManager_CT459487.LoadLinkURL(event,strLoginURL,false,null);
	};
	
	
	this._GetGmailPostData = function()
	{
		var strPostData = "ltmpl=wsad&ltmplcache=2&continue=https%3A%2F%2Fmail.google.com%2Fmail%2F%3F&service=mail&rm=false&ltmpl=wsad&Email=" +
					encodeURIComponent(this.MailAccount.UserName) + "&Passwd=" + encodeURIComponent(this.MailAccount.Password) + "&null=Sign+in";
			
		return strPostData;
	};
	
	this.GetNewMessagesCount = function(objCallBackFunction)
	{
		
		//define the response function coming from the server
		//after retrieving the string data
		var objServerResponseFunction = function(strData,objRequest)
		{
			var iNewMessagesCount = EBEmailAccountsConsts_CT459487.LOGIN_FAILED;
			//parse the data of the xml
			var XMLDoc = EBGlobalManager_CT459487.GetXmlDocument(strData);
		
			var objXMLRoot = XMLDoc.documentElement;
			var objXMLChildNode = null;
			if(objXMLRoot.tagName == "feed")
			{
				for(var i=0;i<objXMLRoot.childNodes.length;i++)
				{
					objXMLChildNode = objXMLRoot.childNodes[i];
					if(objXMLChildNode.tagName == 'fullcount')
					{
						iNewMessagesCount = EBGlobalManager_CT459487.GetXmlNodeValue(objXMLChildNode);
						break;
					}
				}
			}
			objCallBackFunction(iNewMessagesCount);	
		};
		
		//call a dummy request first to nullify the gmail feed session
		EBServerDataURL_CT459487.ServerRequest(EBEmailAccountsConsts_CT459487.GMail.FeedURL,
										'',
										'dummy',
										'dummy',
										null);
		
		EBServerDataURL_CT459487.ServerRequest(EBEmailAccountsConsts_CT459487.GMail.FeedURL,
										'',
										this.MailAccount.UserName,
										this.MailAccount.Password,
										objServerResponseFunction);

	};
	
	
	//call the constructor when the object is raised
	this.InitAccount(strEMail,strPassword);
	
}

/********************* Yahoo Account ****************************/
function EBYahooAccount_CT459487(strEMail,strPassword)
{
	this.MailAccount = null; 
	
	//Constructor
	this.InitAccount = function(strEMail,strPassword)
	{
		//initialize the email account object
		this.MailAccount = new EBEMailAccount_CT459487(EBEmailAccountsConsts_CT459487.Yahoo.MailURL ,strEMail,strPassword);
	}

	this.Login = function(event)
	{
		//in yahoo you have to logout first before login
		//so i login after i log out using NavigationWithCallBack function
		
		//get the post data of the account
		var strPostData		= this._GetYahooPostData();
		var strMailURL		= this.MailAccount.MailURL;
		var oEvent			= event;
		var bIsInNewTab		= oEvent.button == 1;
		
		
		var objCallBackFunction = function()
		{
			EBLinkManager_CT459487.LoadLinkURL(oEvent,strMailURL,bIsInNewTab,strPostData);
		};
		
		//logout before navigating to the account
		this.DeleteSessionCookies();
		EBGlobalManager_CT459487.NavigationWithCallBack(EBEmailAccountsConsts_CT459487.Yahoo.MailLogoutURL,objCallBackFunction);
		
	}
	
	this.Logout  = function(event)
	{
		var strLogoutURL = EBEmailAccountsConsts_CT459487.Yahoo.MailLogoutURL;
		var strLoginURL = EBEmailAccountsConsts_CT459487.Yahoo.MailURL;
		EBLinkManager_CT459487.LoadLinkURL(event,strLogoutURL,false,null);
		EBLinkManager_CT459487.LoadLinkURL(event,strLoginURL,false,null);
	};
	
	
	this.DeleteSessionCookies = function()
	{
		var oCookieManager = Components.classes["@mozilla.org/cookieService;1"].
                  getService(Components.interfaces.nsICookieManager);
                 
		oCookieManager.remove('.yahoo.com','YGCV','/',false);
		oCookieManager.remove('.mail.yahoo.com','YM.Gen','/',false);

	};

	
	this.GetNewMessagesCount = function(objCallBackFunction)
	{	
		var strPostData		= this._GetYahooPostData();
		var strMailURL		= this.MailAccount.MailURL;
		var strEMail		= this.MailAccount.EMail;
		
		var iNewMessages	= null;
		
		//check if there an open window on yahoo mail and check to retrive the 
		//new messages from this window using it html document
		var objWindowsManager = Components.classes['@mozilla.org/appshell/window-mediator;1']
						.getService(Components.interfaces.nsIWindowMediator);
		
		var objEnumerator = objWindowsManager.getEnumerator('navigator:browser');	
		while(objEnumerator.hasMoreElements()) 
		{
			var objWindow = objEnumerator.getNext();
			var objTabBrowser =	objWindow.document.getElementById('content');
			var objTab = null;
			for(var i=0;i<objTabBrowser.browsers.length; i++) 
			{
				objTab = objTabBrowser.browsers[i];
				var objTabDocument = objTab.contentWindow.document;
				
				var strLocationURL = objTabDocument.location.href;
				
				if(strLocationURL.toLowerCase().indexOf(EBEmailAccountsConsts_CT459487.Yahoo.CheckLoginInURL) != -1)
				{
				
					iNewMessages = EBEmailAccountsConsts_CT459487.LOGIN_ANOTHER_ACCOUNT;
						
					objCallBackFunction(iNewMessages);
					return;
				}
				
			}
			
		}
		
		//if there isn't any page open in this account - i check it in the regular way
		//perform logut and then login to the account
		var objServerResponseFunction = function(strData,objRequest)
		{
			iNewMessages = EBEmailAccountsConsts_CT459487.LOGIN_FAILED;
			
			//check yahoo beta.
			if(strData.indexOf('kPartner') != -1)
			{
				EBYahooBetaAccountManager_CT459487.CheckFromWebService(strData,objCallBackFunction);
			}
			else//check regular yahoo.
			{
				if(strData.indexOf(strEMail) != -1)
				{
					iNewMessages = 0;
					//find the new messages using regular expression on the page
					var arrResults = strData.match(/\<a\s+.*\>\s*Inbox\s*\(\s*(\d+)\s*\)\s*\<\/a\>/i);
					if(arrResults)
					{
						iNewMessages = arrResults[1];
					}
				}
				objCallBackFunction(iNewMessages);
			}
			
			
		};
		
		var objLogoutWithCallBackFunction = function()
		{
			EBServerDataURL_CT459487.ServerRequest(strMailURL,
										strPostData,
										null,
										null,
										objServerResponseFunction);	
		};
		
		
		this.DeleteSessionCookies();
		EBGlobalManager_CT459487.NavigationWithCallBack(EBEmailAccountsConsts_CT459487.Yahoo.MailLogoutURL,objLogoutWithCallBackFunction);
	};
	
	this._GetYahooPostData = function()
	{
		var strPostData = '.tries=1&.intl=us&.v=0&hasMsgr=0&.chkP=Y&.done=http://mail.yahoo.com&.persistent=Y&login=' + this.MailAccount.UserName + '&passwd=' + this.MailAccount.Password;
		return strPostData;
	};
	
	this.InitAccount(strEMail,strPassword);

}

var EBYahooBetaAccountManager_CT459487 = 
{
	CheckFromWebService : function(strSource,objCallBackFunction)
	{
		//clear the new line from the code for the regex to succeed
		strSource = strSource.replace(/\n/g,'');
		var arrMatches = strSource.match(/kPartner.*location\s*\:\s*[\"|\']([^\"|^\']+)[\"|\'].*wssid\s*\:\s*[\"|\']([^\"|^\']+)[\"|\'].*webserviceUrl\s*\:\s*[\"|\']([^\"|^\']+)[\"|\']/i);
		
		var strLocation			= '';
		var strWSSID			= '';
		var strWebServiceURL	= '';
		
		if(arrMatches)
		{
			strLocation			= arrMatches[1];
			strWSSID			= arrMatches[2];
			strWebServiceURL	= arrMatches[3];
		}
		 
		var strFullWebServiceURL = '';
		
		if(strLocation && strWSSID && strWebServiceURL)
		{
			strFullWebServiceURL = this.GetFullWebSerivceURL(strLocation,strWSSID,strWebServiceURL);
		}
		
		var strPostWebService = this.GetSoapPostWebService();
		
		if(strFullWebServiceURL)
		{	
			var objServerResponseFunction = function(strData,aRequest)
			{
				var strXML = strData;
				
				var XMLDoc = EBGlobalManager_CT459487.GetXmlDocument(strXML);
	
				var XMLRoot = XMLDoc.documentElement;
				
				//check first if the wssid is expires and there is new one in
				//this soap XML
				if(XMLRoot.tagName == 'NewWSSID')
				{
					var XMLNode		= null;
					strWSSID		= '';
					for(var i=0;i<XMLRoot.childNodes.length;i++)
					{
						XMLNode = XMLRoot.childNodes[i];
						if(XMLNode.tagName == 'WSSID')
						{
							strWSSID = EBGlobalManager_CT459487.GetXmlNodeValue(XMLNode);
						}
					}
					
					if(strWSSID)
					{	
						strFullWebServiceURL = EBYahooBetaAccountManager_CT459487.GetFullWebSerivceURL(strLocation,strWSSID,strWebServiceURL);
					
						//if there is the new wssid i call to this function again
						//it's kind of recurse call cause i use the objServerResponseFunction
						//which this code is inside
						EBServerDataURL_CT459487.ServerRequest(strFullWebServiceURL,
												strPostWebService,
												null,
												null,
												objServerResponseFunction);
					}
					else
					{
						objCallBackFunction(0);
					}
				}
				else
				{
					var iNewMessages = 0;
					
					var oFDataList = XMLRoot.getElementsByTagName('fdata');
					
					var oFData					= null;
					var oAttributeDFName		= null;
					var oAttributeDFNameValue	= null;
					var oAttributeFUnread		= null;
					var oAttributeFUnreadValue	= null;
					
					for(var i=0;i<oFDataList.length;i++)
					{
						oFData = oFDataList[i];
						oAttributeDFName		= oFData.attributes.getNamedItem('dfname');
						
						if(oAttributeDFName)
						{
							oAttributeDFNameValue	= EBGlobalManager_CT459487.GetXmlNodeValue(oAttributeDFName)
							if(oAttributeDFNameValue.toLowerCase() == 'inbox')
							{
								oAttributeFUnread = oFData.attributes.getNamedItem('funread');
								if(oAttributeFUnread)
								{
									oAttributeFUnreadValue = EBGlobalManager_CT459487.GetXmlNodeValue(oAttributeFUnread);
									iNewMessages = oAttributeFUnreadValue;
								}
							}
						}
					}
					
					objCallBackFunction(iNewMessages);
				}
			};
			
			EBServerDataURL_CT459487.ServerRequest(strFullWebServiceURL,
												strPostWebService,
												null,
												null,
												objServerResponseFunction);
		}
			
	},
	
	GetFullWebSerivceURL : function(strLocation,strWSSID,strWebServiceURL)
	{
		var strFullWebServiceURL = '';
		var strBaseURL = EBGlobalManager_CT459487.GetBaseUrl(strLocation);
		strFullWebServiceURL = strBaseURL + '/' +  strWebServiceURL + '?m=LstMsgs&wssid=' + strWSSID;
		
		return strFullWebServiceURL;
	},
	
	GetSoapPostWebService : function()
	{
		var strPostWebService = '<SOAP-ENV:Envelope xmlns:SOAP-ENV="http://schemas.xmlsoap.org/soap/envelope/" xmlns:xsi="http://www.w3.org/1999/XMLSchema-instance" xmlns:xsd="http://www.w3.org/1999/XMLSchema" SOAP-ENV:encodingStyle="http://schemas.xmlsoap.org/soap/encoding/"><SOAP-ENV:Body><m:LstMsgs xmlns:m="urn:yahoo:ymws"><param1 startMid="0" numMid="300" startInfo="0" numInfo="53" startBody="0" numBody="0"><greq gve="8" getUserData="true" getMetaData="true" listFoldersAfterOp="true" resetUnseen="true"><gid>cg</gid></greq><sortKey>date</sortKey><sortOrder>down</sortOrder><fi fname="Inbox"/></param1></m:LstMsgs></SOAP-ENV:Body></SOAP-ENV:Envelope>';
		return strPostWebService;
	}
}






/********************* Hotmail Account ****************************/
function EBHotmailAccount_CT459487(strEMail,strPassword)
{
	this.MailAccount = null; 
	
	//Constructor
	this.InitAccount = function(strEMail,strPassword)
	{
		//initialize the email account object
		this.MailAccount = new EBEMailAccount_CT459487('' ,strEMail,strPassword);
	};
	
	
	
	
	this.Login = function(event)
	{
		var strPostData = this._GetHotmailPostData();
		var oEvent			= event;
		var bIsInNewTab		= oEvent.button == 1;
		var objCallBackFunction = function(strFormAction,strPPFTHiddenValue)
		{
			if(strFormAction && strPPFTHiddenValue)
			{
				strPostData += strPPFTHiddenValue;
				EBLinkManager_CT459487.LoadLinkURL(oEvent,strFormAction,bIsInNewTab,strPostData);
			}
		};
		
		var objLogoutWithCallBackFunction = function()
		{
			EBHotmailAccountManager_CT459487.GetLoginInformation(objCallBackFunction);	
		};
		
		this.DeleteSessionCookies();
		EBGlobalManager_CT459487.NavigationWithCallBack(EBEmailAccountsConsts_CT459487.Hotmail.MailLogoutURL,objLogoutWithCallBackFunction);
		
	};
	
	this.Logout = function(event)
	{
		var strLogoutURL = EBEmailAccountsConsts_CT459487.Hotmail.MailLogoutURL;
		var strLoginURL = EBEmailAccountsConsts_CT459487.Hotmail.MailURL;
		EBLinkManager_CT459487.LoadLinkURL(event,strLogoutURL,false,null);
		EBLinkManager_CT459487.LoadLinkURL(event,strLoginURL,false,null);
	};

	this._GetHotmailPostData = function()
	{
		var strPostData = 'PPSX=Pas&PwdPad=IfYouAreReadingThisYouHaveTooMuchFreeTime&login='+encodeURIComponent(this.MailAccount.EMail)+'&passwd='+encodeURIComponent(this.MailAccount.Password)+'&PPFT=';
		return strPostData;
	};
	
	this.DeleteSessionCookies = function()
	{
		var oCookieManager = Components.classes["@mozilla.org/cookieService;1"].
                  getService(Components.interfaces.nsICookieManager);
                 
		oCookieManager.remove('.msn.com','MSPAuth','/',false);
		oCookieManager.remove('.msn.com','MSPProf','/',false);
		oCookieManager.remove('.msn.com','MailToken','/',false);
		oCookieManager.remove('.msn.com','PIM','/',false);
		
		oCookieManager.remove('.login.live.com','PPAuth','/',false);
		oCookieManager.remove('.login.live.com','RPSTAuthTime','/',false);
		oCookieManager.remove('.login.live.com','MSPVis','/',false);
		oCookieManager.remove('.login.live.com','MSPSoftVis','/',false);
		
		oCookieManager.remove('.live.com','PPLState','/',false);
		oCookieManager.remove('.live.com','RPSTAuth','/',false);
		oCookieManager.remove('.live.com','MSPAuth','/',false);
		oCookieManager.remove('.live.com','MSPProf','/',false);
		
		oCookieManager.remove('.hotmail.msn.com','HMSC0899','/',false);
		oCookieManager.remove('.hotmail.msn.com','HMSatchmo','/',false);	
		
		oCookieManager.remove('.passport.com','MSPBack','/',false);	
		oCookieManager.remove('.passport.com','PPWLRedir','/',false);	
		oCookieManager.remove('.passport.com','PPStateXfer','/',false);
		
		oCookieManager.remove('login.passport.com','MSPRequ','/',false);
		
		oCookieManager.remove('.mail.live.com','KSC1106','/',false);
		oCookieManager.remove('.mail.live.com','bigInboxCookie','/',false);
		
		
	};
	
	this.IsLogIn = function(strLocation)
	{
		strLocation = strLocation.toLowerCase();
		var arrLoginURL = EBEmailAccountsConsts_CT459487.Hotmail.CheckLoginInURL;
		for(var i=0;i<arrLoginURL.length;i++)
		{
			if(strLocation.indexOf(arrLoginURL[i]) != -1)
			{
				return true;
			}	
		}
	
		return false;
	};
	
	this.GetNewMessagesCount = function(objCallBackNewMessagesFunction)
	{
		var iNewMessages = null;
	
		var strPostData = this._GetHotmailPostData();
		var strEMail	= this.MailAccount.EMail.toLowerCase();
		
		
		//check if there an open window on hotmail mail and check to retrive the 
		var objWindowsManager = Components.classes['@mozilla.org/appshell/window-mediator;1']
						.getService(Components.interfaces.nsIWindowMediator);
		
		var objEnumerator = objWindowsManager.getEnumerator('navigator:browser');	
		while(objEnumerator.hasMoreElements()) 
		{
			var objWindow = objEnumerator.getNext();
			var objTabBrowser =	objWindow.document.getElementById('content');
			var objTab = null;
			for(var i=0;i<objTabBrowser.browsers.length; i++) 
			{
				objTab = objTabBrowser.browsers[i];
				var objTabDocument	= objTab.contentWindow.document;
				var objTabBody		= objTabDocument.body;
				var strLocationURL	= objTabDocument.location.href;
				
				//check if the user is logged in to Hotmail account
				//to prevent the check new messages (which log you out 
				//from your current account!)
				if(this.IsLogIn(strLocationURL))
				{
					//in hotmail i can't always check his new messages
					//because of the different pages so i always return login anouther 
					//user to make him disconnect
					iNewMessages = EBEmailAccountsConsts_CT459487.LOGIN_ANOTHER_ACCOUNT;
					objCallBackNewMessagesFunction(iNewMessages);
					return;
				}
			}
		}
		
		
		
		iNewMessages = EBEmailAccountsConsts_CT459487.LOGIN_FAILED;
		
		var objCallBackFunction = function(strFormAction,strPPFTHiddenValue)
		{
			if(strFormAction && strPPFTHiddenValue)
			{
				strPostData += strPPFTHiddenValue;

				
				var objServerResponseFunction = function(strData,aRequest)
				{
					var strInboxURL = '';
					
					//first check within the javascript location.replace
					var arrMatches = strData.match(/location.replace\([\"|\']*([^\"|^\']+)[\"|\']*\).*/i);
					
					if(arrMatches)
					{
						strInboxURL = arrMatches[1];
					}
					else 
					{
						//second check in the meta tag
						arrMatches = strData.match(/URL=[\"|\']*([^\"|^\'|^\>]+)[\"|\']*.*/i);
						if(arrMatches)
						{
							strInboxURL = arrMatches[1];
						}
					}
					
					if(strInboxURL)
					{
  						var objServerResponseFunctionInner = function(strDataInner,aRequestInner)
  						{			
  							var strSource = strDataInner;
  							
  							//check for hotmail beta:
  							var strLocationReplaceURL = '';
  							var arrMatches = strSource.match(/location.replace\([\"|\']*([^\"|^\']+)[\"|\']*\).*/i);
  							if(arrMatches)
							{
								strLocationReplaceURL = arrMatches[1];
							}
							
  							if(strLocationReplaceURL)//hotmail beta
  							{
  								EBHotmailBetaAccountManager_CT459487.CheckNewMessages(strLocationReplaceURL,objCallBackNewMessagesFunction);
  							}
  							else //regular hotmail
  							{
  								iNewMessages = EBEmailAccountsConsts_CT459487.LOGIN_FAILED;
	  							//parse the source using indexOf and not regular expression cause there
	  							//is too many matching templates to the new messages templates
	  							var strFontClassK = strSource.substring(strSource.indexOf('<font class="K">'));
	  							
	  							var strNewMessages		  = strFontClassK.substring(strFontClassK.indexOf('(') + 1,strFontClassK.indexOf(')'));
	
	  							if(strNewMessages && isFinite(strNewMessages))
	  							{
	  								iNewMessages = strNewMessages;
	  							}
	  							
								objCallBackNewMessagesFunction(iNewMessages);
							}
						};
						
						EBServerDataURL_CT459487.ServerRequest(strInboxURL,
											null,
											null,
											null,
											objServerResponseFunctionInner);
  					}
  					else
  					{
  						objCallBackNewMessagesFunction(iNewMessages);
  					}
				}
				
				EBServerDataURL_CT459487.ServerRequest(strFormAction,
												strPostData,
												null,
												null,
												objServerResponseFunction);
				
			}
			else
			{
				objCallBackNewMessagesFunction(iNewMessages);
			}
		};
		
		var objLogoutWithCallBackFunction = function()
		{
			EBHotmailAccountManager_CT459487.GetLoginInformation(objCallBackFunction);	
		};
		
		this.DeleteSessionCookies();
		EBGlobalManager_CT459487.NavigationWithCallBack(EBEmailAccountsConsts_CT459487.Hotmail.MailLogoutURL,objLogoutWithCallBackFunction);
	};
	
	this.InitAccount(strEMail,strPassword);
}



var EBHotmailAccountManager_CT459487 = 
{
	GetLoginInformation : function(objCallBackFunction)
	{	
		var objServerResponseFunction = function(strDataInner,aRequestInner)
		{
			
			var strFormAction		= '';
			var strPPFTHiddenValue	= '';
			
			var arrMatches = strDataInner.match(/\<form\s+.*action=[\"|\']*([^\"|^\']+)[\"|\']*.*\>/i);
			if(arrMatches)
			{
				strFormAction = arrMatches[1];
			}
			arrMatches = strDataInner.match(/\<input\s+.*name=[\"|\']*PPFT[\"|\']*\s+.*value=[\"|\']*([^\"|^\']+)[\"|\']*.*\>/i);
			if(arrMatches)
			{
				strPPFTHiddenValue = arrMatches[1];
			}
			
			objCallBackFunction(strFormAction,strPPFTHiddenValue);
		};
			
  		EBServerDataURL_CT459487.ServerRequest(EBEmailAccountsConsts_CT459487.Hotmail.URL,
												null,
												null,
												null,
												objServerResponseFunction);
	}
}


var EBHotmailBetaAccountManager_CT459487 = 
{
	CheckNewMessages : function(strLocationReplaceURL,objCallBackNewMessagesFunction)
	{
		var oServerResponseFunction = function(strData,oRequest)
		{
			var strMainFrameSrc = '';
			//find the main frame src from the html frameset code:
			var arrMatches = strData.match(/frame\s+.*name=[\"|\']*main[\"|\']*\s+.*src=[\"|\']*([^\"|^\']+)[\"|\']*\s+/i);
			
			if(arrMatches)
			{
				strMainFrameSrc = arrMatches[1];
			}
			var strHotmailURLPath = strLocationReplaceURL.substring(0,strLocationReplaceURL.lastIndexOf('/') + 1);
			if(strMainFrameSrc)
			{
				var strFullApplicationMailURL = strHotmailURLPath + strMainFrameSrc;
				EBHotmailBetaAccountManager_CT459487.ParseApplicationMailFrame(strHotmailURLPath,strFullApplicationMailURL,objCallBackNewMessagesFunction);
			}
			else
			{
				objCallBackNewMessagesFunction(EBEmailAccountsConsts_CT459487.LOGIN_FAILED);
			}
		};
		
		EBServerDataURL_CT459487.ServerRequest(strLocationReplaceURL,
								null,
								null,
								null,
								oServerResponseFunction);
	},


		
	ParseApplicationMailFrame : function(strHotmailURLPath,strApplicationMailURL,objCallBackNewMessagesFunction)
	{
		var arrMatches = null;
		var oServerResponseFunctionFirst = function(strData,oRequest)
		{
			var strSessionHash = '';
			//looking for sessionidhash in the js code example: 
			//"sessionidhash" : "yBUJQZ0rvmjNav9NBYv3iA%3d%3d",;
			arrMatches = strData.match(/[\"|\']*sessionidhash[\"|\']*\s*\:\s*[\"|\']([^\"|^\']+)[\"|\']/i);
			
			if(arrMatches)
			{
				strSessionHash = arrMatches[1];
			}
			
			var strCheckInboxURL = '';
			if(strSessionHash)
			{
				strCheckInboxURL = EBHotmailBetaAccountManager_CT459487.GetFullCheckInboxURL(strHotmailURLPath,strSessionHash);
				
			}
		
			if(strCheckInboxURL)
			{
				var oServerResponseFunctionSecond = function(strData2,oRequest2)
				{
					var iNewMessages = 0;
					
					arrMatches = strData2.match(/[\"|\']i_inbox[\"|\']\D+(\d+)/i);
					
					if(arrMatches)
					{
						iNewMessages = parseInt(arrMatches[1]);
					}
					objCallBackNewMessagesFunction(iNewMessages);
				};
				
				EBServerDataURL_CT459487.ServerRequest(strCheckInboxURL,
											'cn=Microsoft.Msn.Hotmail.MailBox&mn=Bootstrap&d=',
											null,
											null,
											oServerResponseFunctionSecond);
				
			}
			else
			{
				objCallBackNewMessagesFunction(EBEmailAccountsConsts_CT459487.LOGIN_FAILED);
			}
		};
		
		
		EBServerDataURL_CT459487.ServerRequest(strApplicationMailURL,
											null,
											null,
											null,
											oServerResponseFunctionFirst);
	},
	
	GetFullCheckInboxURL : function(strHotmailURLPath,strSessionHash)
	{
		var strURL = strHotmailURLPath + 'mail.fpp?cnmn=Microsoft.Msn.Hotmail.MailBox.Bootstrap&ptid=0&a=' + strSessionHash;
		
		return strURL;
	}
}


/********************* Pop3 Account ****************************/
function EBPop3Account_CT459487(strUserName,strPassword,strServerURL,iPort)
{
	this.MailAccount	= null; 
	this.Server			= strServerURL;
	this.Port			= iPort;
	
	//legalize port
	if(!this.Port)
	{
		this.Port = EBEmailAccountsConsts_CT459487.Pop3.DefaultPort
	}
	
	//Constructor
	this.InitAccount = function(strEMail,strPassword)
	{
		//initialize the email account object
		this.MailAccount = new EBEMailAccount_CT459487(this.Server ,strUserName,strPassword);
	};
	
	this.Login = function(event)
	{
		EBGlobalManager_CT459487.OpenDefaultMailClient();
	};
	
	this.Logout = function(event)
	{
			
	};
	
	this.GetNewMessagesCount = function(objCallBackNewMessagesFunction)
	{
		//set the check from the most recent browser cause it can come from 
		//the test dialog(to prevent bug when the user closes the test dialog
		//before the process eneded!)
		var objWindow = EBGlobalManager_CT459487.GetMostRecentBrowserWindow();
		if(objWindow)
		{
			objWindow.EBPop3AccountManager_CT459487.Start(this.MailAccount.MailURL,
									this.MailAccount.EMail,
									this.MailAccount.Password,
									this.Port,
									objCallBackNewMessagesFunction);
		}
	};
	
	
	this.InitAccount(strUserName,strPassword);
}


var EBPop3AccountManager_CT459487 = 
{
	UserName			: null,
	Password			: null,
	
	InputStream			: null,
	OutputStream		: null,
	
	CallBack			: null, //the callback function(gets new message param) 
								//to execute when the process done
	EndOfLine			: null,
								
	NewMessages			: null,
	
	Start : function(strServerURL,strUserName,strPassword,iPort,objCallBackFunction)
	{
		this.UserName	= strUserName;
		this.Password	= strPassword;
		this.CallBack	= objCallBackFunction;
		
		//the EndOfLine char according to operation system
		this.EndOfLine	= EBGlobalManager_CT459487.GetEndOfLine();
		
		var objTransportSocket = Components.classes["@mozilla.org/network/socket-transport-service;1"]
									.getService(Components.interfaces.nsISocketTransportService);
		
		var objTransport = objTransportSocket.createTransport(null,0,strServerURL,iPort,null);
		
		//initialize output stream:
		this.OutputStream	= objTransport.openOutputStream(0,0,0);
		
		var objStream		= objTransport.openInputStream(0,0,0);
		
		//initialize input stream:
		this.InputStream	= Components.classes["@mozilla.org/scriptableinputstream;1"]
								.createInstance(Components.interfaces.nsIScriptableInputStream);
		
		this.InputStream.init(objStream);
		
		var objPump = Components.classes["@mozilla.org/network/input-stream-pump;1"]
						.createInstance(Components.interfaces.nsIInputStreamPump);
		objPump.init(objStream, -1, -1, 0, 0, false);
		objPump.asyncRead(this.Listener,null);
	},
	
	Finish : function()
	{
		this.InputStream.close();
		this.OutputStream.close();
		this.CallBack(this.NewMessages);	
	},
	
	Listener : 
	{
		onStartRequest: function(request, context)
		{
			EBPop3AccountManager_CT459487.NewMessages		= EBEmailAccountsConsts_CT459487.LOGIN_FAILED;
			EBPop3AccountManager_CT459487.Pop3Commands.State = EBEmailAccountsConsts_CT459487.Pop3.StateStart;
		},
		onStopRequest: function(request, context, status)
		{
			EBPop3AccountManager_CT459487.Finish();
		},
		onDataAvailable: function(request, context, inputStream, offset, count)
		{
			var strData = EBPop3AccountManager_CT459487.InputStream.read(count);	
			EBPop3AccountManager_CT459487.Pop3Commands.Execute(strData);
		}
	},
	
	Pop3Commands : 
	{	
		State			: null,
		
		CMD	  : '',
		
		Execute : function(strData)
		{
			//check the data
			if(EBGlobalManager_CT459487.BeginsWith(strData,EBEmailAccountsConsts_CT459487.Pop3.CommandOKPrefix))
			{
				if(this.State == EBEmailAccountsConsts_CT459487.Pop3.StateStatus)
				{
					this.ParseStatus(strData);
				}
				this.State++;
				switch(this.State)
				{
					case EBEmailAccountsConsts_CT459487.Pop3.StateUserName:
						this.UserName();
						break;
					case EBEmailAccountsConsts_CT459487.Pop3.StatePassword:
						this.Password();
						break;
					case EBEmailAccountsConsts_CT459487.Pop3.StateStatus:
						this.Status();
						break;
					case EBEmailAccountsConsts_CT459487.Pop3.StateQuit:
						this.Quit();
						break;
				}
			}
			else if(EBGlobalManager_CT459487.BeginsWith(strData,EBEmailAccountsConsts_CT459487.Pop3.CommandERRPrefix))
			{
				this.Quit();
			}
		},
		
		UserName : function()
		{
			this.CMD = 'USER '+EBPop3AccountManager_CT459487.UserName + EBPop3AccountManager_CT459487.EndOfLine;
			this.RequestData();
		},
		Password : function()
		{
			this.CMD = 'PASS '+EBPop3AccountManager_CT459487.Password + EBPop3AccountManager_CT459487.EndOfLine;
			this.RequestData();
		},
		Status	: function()
		{
			this.CMD = 'STAT' + EBPop3AccountManager_CT459487.EndOfLine;
			this.RequestData();
		},
		Quit	: function()
		{
			this.CMD = 'QUIT' + EBPop3AccountManager_CT459487.EndOfLine;
			this.RequestData();
		},
		
		RequestData : function()
		{
			EBPop3AccountManager_CT459487.OutputStream.write(this.CMD,this.CMD.length);	
		},
		
		ParseStatus : function(strData)
		{
			//parse the status string from the server to see how much messages there is:
			var arrMessages = strData.split(' ');
			
			var iNewMessages = 0;
			if(arrMessages[1])
			{
				var iNewMessages = arrMessages[1];
			}
			
			EBPop3AccountManager_CT459487.NewMessages = iNewMessages;
			
		}
		
	}
	
	
}

var EBEMailNotifierDialogsConsts_CT459487 = 
{	
	WindowTypeAttributeName		: 'EBEMailNotifierDialogs_CT459487',
	
	XULDialogsDirectoryName		: 'EMailNotifierDialogs',
	
	SettingsDialog				:	 
	{
		FileName					: 'enSettings.xul',
		Name						: 'EBEmailNotifierXULSettingsDialogName_CT459487',
		SupportSubjectCaption		: 'E-mail Notifier Feedback [Firefox]',
		TreeCellPasswordAttribute	: 'TreeCellPasswordAttribute',
		TreeCellTypeAttribute		: 'TreeCellTypeAttribute',
		TreeCellAutoLoginAttribute	: 'TreeCellAutoLoginAttribute',
		TreeCellServerAttribute		: 'TreeCellServerAttribute'
	},
	
	AddEditDialog				:
	{
		FileName					: 'enAddEdit.xul',
		Name						: 'EBEmailNotifierXULAddEditDialogName_CT459487',
		ModeAdd						: 'ADD',
		ModeEdit					: 'EDIT'
	},
	
	ConfirmDialog				: 
	{
		FileName					: 'enConfirm.xul',	
		Name						: 'EBEmailNotifierXULConfirmDialogName_CT459487',
		MismatchErrorTitle			: 'Check e-mail password',
		MismatchErrorContent		: 'Incorrect password!\nPlease enter the password that you have defined in this account'
	},
	
	TestAccountDialog			:
	{
		FileName					: 'enTestAccount.xul',
		ID							: 'EBEmailNotifierXULTestAccountDialogID',
		Name						: 'EBEmailNotifierXULTestAccountDialogName_CT459487',
		AccountNameAlias			: '{{ACCOUNT_NAME}}'
	}
}

//the default values of the dialogs captions
//if there is xml it will change for the languages support!
var EBEMailNotifierDialogsCaption_CT459487 = 
{
	SettingsDialog		:
	{
		Yes						: 'Yes',
		No						: 'No'
	},
	
	
	AddEditDialog		:
	{
		EMailAddress						: 'E-mail Address:',
		AutoLogin							: 'Auto Login (will not ask for password when logging into my account)',
		Pop3AutoLogin						: 'Open Default Mail Client',
		Pop3EMailAddress					: 'User Name:',
		ErrorTitleAlertMsg					: 'Invalid E-mail address',
		ErrorMsgIncorrectEMailAddress		: 'The E-mail address you have entered appears to be incorrect',
		ErrorMsgEmailAlreadyExist			: 'You have already defined an account with that E-mail address',
		ErrorMsgPOP3AlreadyExist			: 'You have already defined that account',
		ErrorMsgEmailAddressNotSupported	: 'The E-mail address is not supported. We currently support Hotmail (.com/.co.uk), Gmail, and Yahoo(.com/.co.uk/.com.au/.ca).',
		ErrorMsgEmailTypeIncorrect			: 'The E-mail address and the account type do not match.'
		
	},
	
	TestAccountDialog	:
	{
		TasksSuccessFinishMsg		: 'Mail account tested successfully',
		TasksFailureFinishMsg		: 'Failed testing mail account',
		TasksSuccess				: 'Completed',
		TasksFailure				: 'Failed',
		ButtonOK					: 'OK',
		TestWarningMsg1				: 'Please logout of all your ' + EBEMailNotifierDialogsConsts_CT459487.TestAccountDialog.AccountNameAlias + ' accounts before',
		TestWarningMsg2		        : ' testing your account settings.' 
	}
	
}



var EBEMailNotifierDialogsManager_CT459487 = 
{
	GetDialogWindow : function(strWindowName)
	{
		var strWindowType = EBEMailNotifierDialogsConsts_CT459487.WindowTypeAttributeName;
		
		return EBGlobalManager_CT459487.GetXULWindowByTypeAndName(strWindowType,strWindowName);
	
	},
	
		
	OpenSettingsDialog : function(objParentWindow,isFromToolbarOptions)
	{
		//check if one of the email notifier windows is open to make the focus on it
		var objSettingsWindow		= this.GetDialogWindow(EBEMailNotifierDialogsConsts_CT459487.SettingsDialog.Name);
		var objAddEditWindow		= this.GetDialogWindow(EBEMailNotifierDialogsConsts_CT459487.AddEditDialog.Name);
		var objTestAccountWindow	= this.GetDialogWindow(EBEMailNotifierDialogsConsts_CT459487.TestAccountDialog.Name);
		var objConfirmWindow		= this.GetDialogWindow(EBEMailNotifierDialogsConsts_CT459487.ConfirmDialog.Name);
		
		
		//check if the dialogs already open in a different browser to set 
		//focus on them - the order is important! of course (from the last dialog shown to the first)
		if(objTestAccountWindow)
		{
			objTestAccountWindow.focus();
		}
		else if(objConfirmWindow)
		{
			objConfirmWindow.focus();
		}
		else if(objAddEditWindow)
		{
			objAddEditWindow.focus();
		}
		else if(objSettingsWindow)
		{
			objSettingsWindow.focus();
		}
		else
		{
		
		
			var strXULSettingsDialogChromePath	= EBGlobalConsts_CT459487.ChromeContentPath + EBEMailNotifierDialogsConsts_CT459487.SettingsDialog.FileName;
			
			
			//adding the EBEMailNotifierDialogsXULEvents as a window argument 
			//and retrieving it from the code inside the xul window using window.arguments[iIndex]
			objParentWindow.openDialog(strXULSettingsDialogChromePath,
											EBEMailNotifierDialogsConsts_CT459487.SettingsDialog.Name,
											'modal,centerscreen,chrome,resizable=no',
											isFromToolbarOptions);
		}
	},
	
	OpenAddEditDialog : function(oSettingsWindow,strMode,objAccountData)
	{
		if(oSettingsWindow)
		{
			var strXULAddEditDialogChromePath	= EBGlobalConsts_CT459487.ChromeContentPath + EBEMailNotifierDialogsConsts_CT459487.AddEditDialog.FileName;
			
			oSettingsWindow.openDialog(strXULAddEditDialogChromePath,
										EBEMailNotifierDialogsConsts_CT459487.AddEditDialog.Name,
										'modal,centerscreen,chrome,resizable=no',
										strMode,
										objAccountData);
		}
		
	},
	
	OpenConfirmDialog : function(oAddEditWindow,oAccountData)
	{
		if(oAddEditWindow)
		{
			var strXULConfirmDialogChromePath = EBGlobalConsts_CT459487.ChromeContentPath + EBEMailNotifierDialogsConsts_CT459487.ConfirmDialog.FileName;
			
			oAddEditWindow.openDialog(strXULConfirmDialogChromePath,
										EBEMailNotifierDialogsConsts_CT459487.ConfirmDialog.Name,
										'modal,centerscreen,chrome,resizable=no',
										oAccountData,
										oAddEditWindow.document);
		}
		
	},
	
	OpenTestAccountDialog : function(oAddEditWindow)
	{
		if(oAddEditWindow)
		{	
			var strXULTestAccountDialogChromePath	= EBGlobalConsts_CT459487.ChromeContentPath + EBEMailNotifierDialogsConsts_CT459487.TestAccountDialog.FileName;
			
			oAddEditWindow.openDialog(strXULTestAccountDialogChromePath,
										EBEMailNotifierDialogsConsts_CT459487.TestAccountDialog.Name,
										'modal,centerscreen,chrome,resizable=no',
										oAddEditWindow.document);
		}

	}
}


var EBEMailNotifierDialogsXULEvents_CT459487  =
{

	OnLoadSettingsDialog : function(event)
	{
		//set the global accounts object
		window.m_oDialogsMailAccountsCollection = new EBArrayCollection_CT459487();
	
		//loads the accounts from the file and set the xul tree according it
		//take them from the browser window(this window is the window of the xul dialog so the 
		//EBEMailNotifierToolbarManager_CT459487.MailAccountsCollection is not define in this scope!!
		var oBrowserWindow = EBGlobalManager_CT459487.GetMostRecentBrowserWindow();
		var objMailAccountsCollection = oBrowserWindow.EBEMailNotifierToolbarManager_CT459487.MailAccountsCollection;
		
		if(objMailAccountsCollection)
		{
			var arrAccounts = objMailAccountsCollection.Arr;
			
			var objAccountData = null;
			
			for(var i=0;i<arrAccounts.length;i++)
			{
				objAccountData = arrAccounts[i];
				
				this.AddMailAccountTreeItem(objAccountData,false);
			}
		}
		
		
		//check if it's open from toolbar options to disable the toolbar option button:
		var isFromToolbarOptions			= null;
		
		try
		{
			isFromToolbarOptions =	window.arguments[0];
		}
		catch(ex)
		{
			isFromToolbarOptions = false;
		}
		
		if(isFromToolbarOptions)
		{
			document.getElementById('btnToolbarOptions').disabled = true;
		}
		
		//set the check event to the sound checkbox
		var objCheckBoxPlaySound = document.getElementById('checkPlaySound');
		//add event to the checkbox
		objCheckBoxPlaySound.addEventListener("CheckboxStateChange",
										EBEMailNotifierDialogsXULEvents_CT459487.OnCheckBoxSettingsPlaySoundChange,
										false);
		
		
		//set the check interval according to the save value from pref
		this.SetCheckIntervalSelection();
		//set the sound xul elements according to the saved sound (in the prefs)
		this.SetSoundSelection();
		
	},
	
	OnCheckBoxSettingsPlaySoundChange : function(event)
	{
		var objCheckBoxPlaySound	= document.getElementById('checkPlaySound');
		var objRadioGroupSound		= document.getElementById('radioGroupSound');
		
		var bCheck = objCheckBoxPlaySound.checked;
		
		
		var objButtonSoundChooseFile	= document.getElementById('btnSoundChooseFile');
		var objButtonSoundPlay			= document.getElementById('btnSoundPlay');
		var objTextBoxSoundFilePath		= document.getElementById('txtSoundFilePath');
		
		objRadioGroupSound.disabled			= !bCheck;
		objButtonSoundChooseFile.disabled	= !bCheck;
		objButtonSoundPlay.disabled			= !bCheck;
		objTextBoxSoundFilePath.disabled	= !bCheck;
		
	},
	
	OnCommandSettingsChooseSoundFile : function(event)
	{
		var objRadioGroupSound		= document.getElementById('radioGroupSound');
		var objRadioSoundChoose		= document.getElementById('radSoundChoose');
		
		var objTextBoxSoundFilePath	= document.getElementById('txtSoundFilePath');
	
		var nsIFilePicker = Components.interfaces.nsIFilePicker;
		var objFilePicker = Components.classes["@mozilla.org/filepicker;1"].createInstance(nsIFilePicker);
		objFilePicker.init(window, "Select a File", nsIFilePicker.modeOpen);
		objFilePicker.appendFilter("Wav Files (*.wav)","*.wav");
		
		//set the display dir path to what he chose
		//and if he doesn't so to the windows xp media path as the default path:
		var strDisplayDir = objTextBoxSoundFilePath.value;
		if(!strDisplayDir)
		{
			strDisplayDir = EBGlobalManager_CT459487.GetWindowsMediaPath();
		}
		var objDisplayDir = EBDirIO_CT459487.open(strDisplayDir);
		if(objDisplayDir)
		{
			objFilePicker.displayDirectory = objDisplayDir;
		}
		
		var iResult = objFilePicker.show();
		if(iResult == nsIFilePicker.returnOK)
		{
			objRadioGroupSound.selectedItem = objRadioSoundChoose;
			var strPath = objFilePicker.file.path;
			
			objTextBoxSoundFilePath.value = strPath;
		}
	},
	
	OnCommandSettingsPlaySoundFile : function(event)
	{
		var objRadioGroupSound		= document.getElementById('radioGroupSound');
		var objRadioSoundChoose		= document.getElementById('radSoundChoose');
		var objRadioSoundDefault	= document.getElementById('radSoundUseDefault');
		
		var strFilePath = '';
		if(objRadioGroupSound.selectedItem == objRadioSoundChoose)
		{
			strFilePath	= document.getElementById('txtSoundFilePath').value;
		}
		else if(objRadioGroupSound.selectedItem == objRadioSoundDefault)
		{
			strFilePath = EBEMailNotifierConsts_CT459487.Sound.DefaultWavChromePath;
		}
		
		if(strFilePath)
		{
			EBGlobalManager_CT459487.PlaySound(strFilePath);
		}	
	},
	
	
	
	OnUnLoadSettingsDialog : function(event)
	{
		window.m_oDialogsMailAccountsCollection = null;
	},
	
	OnCommandSettingsOKButton : function()
	{
		try
		{
			this.SaveCheckIntervalSelection();
			this.SaveSoundSelection();
			var oBrowserWindow = EBGlobalManager_CT459487.GetMostRecentBrowserWindow();
			oBrowserWindow.EBEMailNotifierToolbarManager_CT459487.OnCommandSettingsOKButton(window.m_oDialogsMailAccountsCollection);
		}
		catch(ex){}
	},
	
	SetCheckIntervalSelection : function()
	{
		//get value from pref
		var iMinutesFromPref = EBEMailNotifierToolbarManager_CT459487.GetCheckIntervalPref();
		if(!iMinutesFromPref || !isFinite(iMinutesFromPref))
		{
			return;
		}
	
		var oComboInterval = document.getElementById('cmbCheckInterval');
		var oPopupMenu	   = oComboInterval.firstChild;
		
		var oMenuItem = null;
		for(var i=0;i<oPopupMenu.childNodes.length;i++)
		{
			oMenuItem = oPopupMenu.childNodes[i];
			if(oMenuItem.getAttribute('label') == iMinutesFromPref)
			{
				oComboInterval.selectedItem = oMenuItem;
				break;
			}
		}
	},
	
	SetSoundSelection : function()
	{
		var objCheckBoxPlaySound	= document.getElementById('checkPlaySound');
		
		var objRadioGroupSound		= document.getElementById('radioGroupSound');
		var objRadioSoundChoose		= document.getElementById('radSoundChoose');
		var objRadioSoundDefault	= document.getElementById('radSoundUseDefault');
		var objTextBoxSoundFilePath	= document.getElementById('txtSoundFilePath');
		
		var strSound = EBEMailNotifierToolbarManager_CT459487.GetSoundPref();
		
		if(strSound != EBEMailNotifierConsts_CT459487.Sound.NONE)
		{
			objCheckBoxPlaySound.checked = true;
			if(!strSound || strSound  == EBEMailNotifierConsts_CT459487.Sound.DEFAULT)
			{
				objRadioGroupSound.selectedItem = objRadioSoundDefault;
			}
			else
			{	
				objTextBoxSoundFilePath.value	= strSound;
				objRadioGroupSound.selectedItem = objRadioSoundChoose;
			}
		}
		else
		{
			objCheckBoxPlaySound.checked = false;
		}
		
			
	},
	
	SaveCheckIntervalSelection : function()
	{
		var oComboInterval = document.getElementById('cmbCheckInterval');
		
		var oSelectedMenuItem = oComboInterval.selectedItem;
		var iMinutesValue = oSelectedMenuItem.getAttribute('label');
		
		EBEMailNotifierToolbarManager_CT459487.SaveCheckIntervalPref(iMinutesValue);
	},
	
	//save the sound 
	SaveSoundSelection : function()
	{
		
		var objCheckBoxPlaySound	= document.getElementById('checkPlaySound');
		
		var objRadioGroupSound		= document.getElementById('radioGroupSound');
		var objRadioSoundChoose		= document.getElementById('radSoundChoose');
		var objRadioSoundDefault	= document.getElementById('radSoundUseDefault');
		var objTextBoxSoundFilePath	= document.getElementById('txtSoundFilePath');
		
		var strSound = '';
		
		if(objCheckBoxPlaySound.checked)
		{
			var strTxtFilePathValue = objTextBoxSoundFilePath.value;
			if(objRadioGroupSound.selectedItem == objRadioSoundDefault || !strTxtFilePathValue)
			{
				strSound = EBEMailNotifierConsts_CT459487.Sound.DEFAULT;
			}
			else if(objRadioGroupSound.selectedItem == objRadioSoundChoose)
			{
				strSound = strTxtFilePathValue;
			}
		}
		else
		{
			strSound = EBEMailNotifierConsts_CT459487.Sound.NONE;
		}
	
		
		EBEMailNotifierToolbarManager_CT459487.SaveSoundPref(strSound);
	},
	
	
	
	AccountDataObjectToTreeRow : function(objSettingsDocument,objAccountData)
	{
		var strAccountName	= objAccountData.AccountName;
		var strEMailAddress = objAccountData.EMailAddress;
		var strPassword		= objAccountData.Password;
		var iAccountType	= objAccountData.AccountType;
		var isAutoLogin		= objAccountData.AutoLogin;
		var strPop3Server	= objAccountData.Pop3Server;
		
		var objTreeRow	= objSettingsDocument.createElement('treerow');
		
		var objTreeCellAccountName = objSettingsDocument.createElement('treecell');
		objTreeCellAccountName.setAttribute('label',strAccountName);
		
		var objTreeCellEMailAddress = objSettingsDocument.createElement('treecell');
		objTreeCellEMailAddress.setAttribute('label',strEMailAddress);
		//save the password in the email treecell as an attribute
		objTreeCellEMailAddress.setAttribute(EBEMailNotifierDialogsConsts_CT459487.SettingsDialog.TreeCellPasswordAttribute,strPassword);
		//save the pop3 server url as an attribute
		objTreeCellEMailAddress.setAttribute(EBEMailNotifierDialogsConsts_CT459487.SettingsDialog.TreeCellServerAttribute,strPop3Server);
		
		
		var strAccountType = EBEMailNotifierManager_CT459487.GetAccountNameByType(iAccountType);
		var objTreeCellAccountType = objSettingsDocument.createElement('treecell');
		objTreeCellAccountType.setAttribute('label',strAccountType);
		//save the actual type in an attribute for retrieving it.
		objTreeCellAccountType.setAttribute(EBEMailNotifierDialogsConsts_CT459487.SettingsDialog.TreeCellTypeAttribute,iAccountType);
		
		
		var strAutoLogin = isAutoLogin ? EBEMailNotifierDialogsCaption_CT459487.SettingsDialog.Yes : EBEMailNotifierDialogsCaption_CT459487.SettingsDialog.No;
		var objTreeCellAutoLogin = objSettingsDocument.createElement('treecell');
		objTreeCellAutoLogin.setAttribute('label',strAutoLogin);
		//save the actual auto login value in an attribute for retrieving it.
		objTreeCellAutoLogin.setAttribute(EBEMailNotifierDialogsConsts_CT459487.SettingsDialog.TreeCellAutoLoginAttribute,isAutoLogin);
		
		//build the dom elements
		objTreeRow.appendChild(objTreeCellAccountName);
		objTreeRow.appendChild(objTreeCellEMailAddress);
		objTreeRow.appendChild(objTreeCellAccountType);
		objTreeRow.appendChild(objTreeCellAutoLogin);
		
		return objTreeRow;
	},

	OnSelectSettingsMailAccountsTree : function(event)
	{
		this.SetSettingsEditDeleteButtonsDisabled(false);
	},
	
	OnDoubleClickSettingsMailAccountsTree : function(event)
	{
		//this is how you illustrate double click on a tree row element:
		var objTreeMailAccounts = document.getElementById('treeMailAccounts');
		var iIndex = objTreeMailAccounts.treeBoxObject.getRowAt(event.clientX,event.clientY);
		
		if(iIndex > -1)
		{
			var objAccountDataToEdit = window.m_oDialogsMailAccountsCollection.GetItem(iIndex);
			
			EBEMailNotifierDialogsManager_CT459487.OpenAddEditDialog(window,EBEMailNotifierDialogsConsts_CT459487.AddEditDialog.ModeEdit,
																	objAccountDataToEdit);
		}
	},
	
	SetSettingsEditDeleteButtonsDisabled : function(isDisabled)
	{
		var objEditButton = document.getElementById('btnEdit');
		var objEditDelete = document.getElementById('btnDelete');
		objEditButton.disabled = isDisabled;	
		objEditDelete.disabled = isDisabled;
	},
	
	OnCommandSettingsToolbarOptionsButton : function(event)
	{
		//get this with the most recent browser window cause this function 
		//is not in the email notifier scope
		var oRecentBrowserWindow = EBGlobalManager_CT459487.GetMostRecentBrowserWindow();
		oRecentBrowserWindow.EBToolbarOptionsDialogManager_CT459487.OpenDialog(window,true);
	},
	
	OnCommandSettingsAddButton : function(event)
	{
		EBEMailNotifierDialogsManager_CT459487.OpenAddEditDialog(window,EBEMailNotifierDialogsConsts_CT459487.AddEditDialog.ModeAdd,
																	null);
	},
	
	OnCommandSettingsEditButton : function(event)
	{
		var objTreeMailAccounts = document.getElementById('treeMailAccounts');
		var iIndex = objTreeMailAccounts.currentIndex;
		var objAccountDataToEdit = window.m_oDialogsMailAccountsCollection.GetItem(iIndex);
		
		EBEMailNotifierDialogsManager_CT459487.OpenAddEditDialog(window,EBEMailNotifierDialogsConsts_CT459487.AddEditDialog.ModeEdit,
																	objAccountDataToEdit);
	},
	
	OnCommandSettingsDeleteButton : function(event)
	{
		var objTreeMailAccounts = document.getElementById('treeMailAccounts');
		var objTreeItemToDelete = this.GetSelectedTreeItem(objTreeMailAccounts);
		
		if(objTreeItemToDelete)
		{
			var iDeleteItemIndex = objTreeMailAccounts.currentIndex;
			var objTreeChildrenParent = objTreeItemToDelete.parentNode;
			objTreeChildrenParent.removeChild(objTreeItemToDelete);
			
			//delete it from the data object:
			window.m_oDialogsMailAccountsCollection.RemoveElement(iDeleteItemIndex);
			
			var iIndexToSelect = -1;
			
			if(iDeleteItemIndex > 0)//check to select the previous element:
			{
				iIndexToSelect = iDeleteItemIndex - 1;
			}
			else if(objTreeChildrenParent.childNodes.length > 0)//check to select the next element
			{
				iIndexToSelect = iDeleteItemIndex;
			}
			
			if(iIndexToSelect != -1)//select the treeItem
			{
				var objPrevElementTreeItem = objTreeChildrenParent.childNodes[iIndexToSelect];
				this.SelectTreeItem(objPrevElementTreeItem);
			}
			else //if there isn't any elements left i disable the add-edit buttons
			{
				this.SetSettingsEditDeleteButtonsDisabled(true);
			}
			
			
			
		}
	},
	
	GetSelectedTreeItem : function(objTree)
	{
		var objTreeItem = null;
		var iIndex = objTree.currentIndex;
		if(iIndex != -1)
		{
			objTreeItem = objTree.contentView.getItemAtIndex(iIndex);
		}
		return objTreeItem;
	},
	
	OnLoadAddEditDialog : function(event)
	{
		var objEMailTextBox = document.getElementById('txtEMail');
		
		var objRadioGroupEMails		= document.getElementById('radioGroupEMails');
		var objRadioHotmail			= document.getElementById('radHotmail');
		var objRadioYahoo			= document.getElementById('radYahoo');
		var objRadioGmail			= document.getElementById('radGMail');
		var objRadioPop3			= document.getElementById('radPop3');
		
		if(MODE == EBEMailNotifierDialogsConsts_CT459487.AddEditDialog.ModeEdit)
		{
			var objPasswordTextBox			= document.getElementById('txtPassword');
			var objAccountNameTextBox		= document.getElementById('txtAccountName');
			var objTextBoxPop3MailServer	= document.getElementById('txtPop3MailServer');
			var objTextBoxPop3Port			= document.getElementById('txtPop3Port');
			
			var objAutoLoginCheckBox	= document.getElementById('checkAutoLogin');
			
			var objButtonTestAccount	= document.getElementById('btnTestAccount');
			var objButtonOK				= document.getElementById('btnOK');
			
			//set the values
			objEMailTextBox.value		= m_oAccountData.EMailAddress;
			objPasswordTextBox.value	= m_oAccountData.Password;
			objAccountNameTextBox.value	= m_oAccountData.AccountName;
			
			//check account type
			if(m_oAccountData.AccountType == EBEmailAccountsTypes_CT459487.GMail)
			{
				objRadioGroupEMails.selectedItem = objRadioGmail;
			}
			else if(m_oAccountData.AccountType == EBEmailAccountsTypes_CT459487.Yahoo)
			{
				objRadioGroupEMails.selectedItem = objRadioYahoo;
			}
			else if(m_oAccountData.AccountType == EBEmailAccountsTypes_CT459487.Hotmail)
			{
				objRadioGroupEMails.selectedItem = objRadioHotmail;
			}
			else if(m_oAccountData.AccountType == EBEmailAccountsTypes_CT459487.Pop3)
			{
				objRadioGroupEMails.selectedItem	= objRadioPop3;
				objTextBoxPop3MailServer.value		= m_oAccountData.Pop3Server;
				
				var iPort			= EBEmailAccountsConsts_CT459487.Pop3.DefaultPort;
				var iPortFromObject = m_oAccountData.Pop3Port;
				if(iPortFromObject)
				{
					iPort = iPortFromObject;
				}
				objTextBoxPop3Port.value			= iPort;
			}
			
			objAutoLoginCheckBox.checked = m_oAccountData.AutoLogin;
			
			objEMailTextBox.select();
			
			objButtonTestAccount.disabled = false;
			objButtonOK.disabled = false;	
			
			
			//if it's edit mode we are set the checkbox an oncheckcahnged event 
			//for the confirm dialog
			var oCheckBoxAutoLogin = document.getElementById('checkAutoLogin');
			oCheckBoxAutoLogin.addEventListener("CheckboxStateChange",
										EBEMailNotifierDialogsXULEvents_CT459487.OnCheckBoxStateChangeAutoLogin,
										false);
			
		}
		else
		{
			objRadioGroupEMails.selectedItem = objRadioHotmail;
		}
		
		objEMailTextBox.focus();
	},
	
	OnCheckBoxStateChangeAutoLogin : function(event)
	{
		var oCheckBox = event.target;
		if(oCheckBox.checked)
		{
			EBEMailNotifierDialogsManager_CT459487.OpenConfirmDialog(window,m_oAccountData);
		}
	},
	
	
	OnAcceptConfirmDialog : function(event)
	{
		try
		{
		
			var oTextBoxPassword		= document.getElementById('txtPassword');
			var strPassword				= oTextBoxPassword.value;
			var strAccountDataPassword	= m_oAccountData.Password;		
			
			if(strPassword != strAccountDataPassword)
			{
				var strTitle = EBEMailNotifierDialogsConsts_CT459487.ConfirmDialog.MismatchErrorTitle;
				var strMsg = EBEMailNotifierDialogsConsts_CT459487.ConfirmDialog.MismatchErrorContent;
				EBGlobalManager_CT459487.Alert(window,strTitle,strMsg);
				m_bIsCloseAcceptDialog = false;
			}
			else
			{
				m_bIsCloseAcceptDialog = true;
			}
		}
		catch(ex)
		{
			//if there is any error we want to close the dialog
			m_bIsCloseAcceptDialog = true;
		}
		
		return m_bIsCloseAcceptDialog;
		
	},
	
	OnUnloadConfirmDialog : function(event)
	{
		//in the onload document we set the addedit dialog autologin checkbox
		//according to the matching of the password if the user didn't
		//click on the accept button
		if(!m_bIsCloseAcceptDialog)
		{
			var oCheckBoxAutoLogin = m_oAddEditDocument.getElementById('checkAutoLogin');
			oCheckBoxAutoLogin.checked = false;
		}
	},
	
	OnInputAddEditEmailTextBox : function(event)
	{
		var objTextBoxEmail			= event.target;
		var strEmail				= objTextBoxEmail.value;
		var objTextBoxAccountName	= document.getElementById('txtAccountName');
		
		var objRadioGroupEMails = document.getElementById('radioGroupEMails');
		var objRadioHotmail		= document.getElementById('radHotmail');
		var objRadioYahoo		= document.getElementById('radYahoo');
		var objRadioGmail		= document.getElementById('radGMail');
		
		objTextBoxAccountName.value = strEmail;
		
		var isGMailDmain	= EBEMailNotifierManager_CT459487.IsEMailDomain(EBEmailAccountsConsts_CT459487.GMail,strEmail);
		var isYahooDomain	= EBEMailNotifierManager_CT459487.IsEMailDomain(EBEmailAccountsConsts_CT459487.Yahoo,strEmail);
		var isHotmailDomain	= EBEMailNotifierManager_CT459487.IsEMailDomain(EBEmailAccountsConsts_CT459487.Hotmail,strEmail);
		
		if(isGMailDmain)
		{
			objRadioGroupEMails.selectedItem = objRadioGmail;
		}
		else if(isYahooDomain)
		{
			objRadioGroupEMails.selectedItem = objRadioYahoo;
		}
		else if(isHotmailDomain)
		{
			objRadioGroupEMails.selectedItem = objRadioHotmail;
		}
		
		this.SetTestAccountOKButtonsState();
	},
	
	OnInputAddEditPasswordTextBox : function(event)
	{
		this.SetTestAccountOKButtonsState();
	},
	
	OnInputAddEditAccountNameTextBox : function(event)
	{
		this.SetTestAccountOKButtonsState();
	},
	
	OnInputAddEditPop3MailServerTextBox : function(event)
	{
		this.SetTestAccountOKButtonsState();
	},
	
	IsAddEditPop3Mode : function()
	{
		var objRadioGroupEMails		= document.getElementById('radioGroupEMails');
		var objRadioPop3			= document.getElementById('radPop3');
		
		return objRadioGroupEMails.selectedItem	== objRadioPop3;
	},
	
	OnSelectAddEditRadioGroupEMails : function(event)
	{	
		
		var objRadioGroupEMails = document.getElementById('radioGroupEMails');
		var objRadioHotmail		= document.getElementById('radHotmail');
		var objRadioYahoo		= document.getElementById('radYahoo');
		var objRadioGmail		= document.getElementById('radGMail');
		var objRadioPOP3		= document.getElementById('radPop3');
	
		
		var objLabelSupportedDomains	= document.getElementById('lblSupportedDomains');
		
		//set the caption domains:
		var strCaptionDomains = '';
		if(objRadioGroupEMails.selectedItem == objRadioHotmail)
		{
			strCaptionDomains = EBEMailNotifierManager_CT459487.GetHotmailDomainCaption();
		}
		else if(objRadioGroupEMails.selectedItem == objRadioYahoo)
		{
			strCaptionDomains = EBEMailNotifierManager_CT459487.GetYahooDomainCaption();
		}
		else if(objRadioGroupEMails.selectedItem == objRadioGmail)
		{
			strCaptionDomains = EBEMailNotifierManager_CT459487.GetGMailDomainCaption();
		}
		else if(objRadioGroupEMails.selectedItem == objRadioPOP3)
		{
			strCaptionDomains = '';
		}
		
		objLabelSupportedDomains.setAttribute('value',strCaptionDomains);
		
		var objRowPop3MailServer		= document.getElementById('rowPop3MailServer');
		var objLabelEMail				= document.getElementById('lblEMail');
		var objCheckBoxAutoLogin		= document.getElementById('checkAutoLogin');
		
		var oTextBoxPop3MailServerURL	= document.getElementById('txtPop3MailServer');
		if(this.IsAddEditPop3Mode())
		{
			objRowPop3MailServer.style.visibility = '';
			objLabelEMail.setAttribute('value',EBEMailNotifierDialogsCaption_CT459487.AddEditDialog.Pop3EMailAddress);
			objCheckBoxAutoLogin.setAttribute('accesskey','O');
			objCheckBoxAutoLogin.setAttribute('label',EBEMailNotifierDialogsCaption_CT459487.AddEditDialog.Pop3AutoLogin);
			oTextBoxPop3MailServerURL.focus();	
		}
		else
		{
			objRowPop3MailServer.style.visibility = 'hidden';
			objLabelEMail.setAttribute('value',EBEMailNotifierDialogsCaption_CT459487.AddEditDialog.EMailAddress);
			objCheckBoxAutoLogin.setAttribute('accesskey','A');
			objCheckBoxAutoLogin.setAttribute('label',EBEMailNotifierDialogsCaption_CT459487.AddEditDialog.AutoLogin);
		}
		
		//when selection check the state of the buttons:
		this.SetTestAccountOKButtonsState();
	},
	
	SetTestAccountOKButtonsState : function()
	{
		var objButtonTestAccount		= document.getElementById('btnTestAccount');
		var objButtonOK					= document.getElementById('btnOK');
	
		var objTextBoxEmail				= document.getElementById('txtEMail');
		var objTextBoxPassword			= document.getElementById('txtPassword');
		var objTextBoxAccountName		= document.getElementById('txtAccountName');
		var objTextBoxPop3MailServer	= document.getElementById('txtPop3MailServer');
		
		//get the values from the text boxes
		var strEMail			= objTextBoxEmail.value;
		var strPassword			= objTextBoxPassword.value;
		var strAccountName		= objTextBoxAccountName.value;
		
		var strPop3MailServer	= objTextBoxPop3MailServer.value;
		
		if(EBGlobalManager_CT459487.TotalTrim(strEMail) != '' &&
			strPassword != '' &&
			EBGlobalManager_CT459487.TotalTrim(strAccountName) != '')
		{
			objButtonTestAccount.disabled	= false;
			objButtonOK.disabled			= false;
		}
		else
		{
			objButtonTestAccount.disabled	= true;
			objButtonOK.disabled			= true;
		}
		
		if(this.IsAddEditPop3Mode())
		{
			if(EBGlobalManager_CT459487.TotalTrim(strPop3MailServer) != '')
			{
				objButtonTestAccount.disabled	= false;
				objButtonOK.disabled			= false;
			}
			else
			{
				objButtonTestAccount.disabled	= true;
				objButtonOK.disabled			= true;
			}
		}
		
		
	},
	
	OnCommandAddEditTestAccountButton : function(event)
	{
		if(this.IsValidEMailAddress())
		{
			EBEMailNotifierDialogsManager_CT459487.OpenTestAccountDialog(window);
		}
	},
	
	IsValidEMailAddress : function()
	{
		var objTextBoxEmail		= document.getElementById('txtEMail');
		var strEMail = objTextBoxEmail.value;
		
		
		//if it's pop3 there isn't any check
		if(this.IsAddEditPop3Mode())
		{			
			var strUserName			= strEMail;
			var strMailServerURL	= document.getElementById('txtPop3MailServer').value;
			if(this.IsPop3AccountExists(strUserName,strMailServerURL))
			{
				EBGlobalManager_CT459487.Alert(window,EBEMailNotifierDialogsCaption_CT459487.AddEditDialog.ErrorTitleAlertMsg,
							EBEMailNotifierDialogsCaption_CT459487.AddEditDialog.ErrorMsgPOP3AlreadyExist);
				objTextBoxEmail.select();
				return false;
			}
			else
			{
				return true;
			}
		}
	
	
		//check incorrect email
		if(!EBGlobalManager_CT459487.IsValidEMail(strEMail))
		{
			EBGlobalManager_CT459487.Alert(window,EBEMailNotifierDialogsCaption_CT459487.AddEditDialog.ErrorTitleAlertMsg,
								EBEMailNotifierDialogsCaption_CT459487.AddEditDialog.ErrorMsgIncorrectEMailAddress);
			objTextBoxEmail.select();
			return false;
		}
		
		//check supported email
		if(!EBEMailNotifierManager_CT459487.IsSupportedEMailAccounts(strEMail))
		{
			EBGlobalManager_CT459487.Alert(window,EBEMailNotifierDialogsCaption_CT459487.AddEditDialog.ErrorTitleAlertMsg,
								EBEMailNotifierDialogsCaption_CT459487.AddEditDialog.ErrorMsgEmailAddressNotSupported);
			objTextBoxEmail.select();
			return false;
		}
		
		//check for existing email(using the data object account)
		if(this.IsEMailExists(strEMail))
		{
			EBGlobalManager_CT459487.Alert(window,EBEMailNotifierDialogsCaption_CT459487.AddEditDialog.ErrorTitleAlertMsg,
								EBEMailNotifierDialogsCaption_CT459487.AddEditDialog.ErrorMsgEmailAlreadyExist);
			objTextBoxEmail.select();
			return false;
		}
		
		//check if the radio button suit to the account:
		
		//check the desirable type
		var iAcceptableAccountType = EBEMailNotifierManager_CT459487.GetAccountTypeByEMail(strEMail);
		//check actual radio selection
		var iActualAccountType	= 0;
		var objRadioGroupEMails = document.getElementById('radioGroupEMails');
		var objRadioHotmail		= document.getElementById('radHotmail');
		var objRadioYahoo		= document.getElementById('radYahoo');
		var objRadioGmail		= document.getElementById('radGMail');
		
		
		if(objRadioGroupEMails.selectedItem == objRadioHotmail)
		{
			iActualAccountType = EBEmailAccountsTypes_CT459487.Hotmail;
		}
		else if(objRadioGroupEMails.selectedItem == objRadioYahoo)
		{
			iActualAccountType = EBEmailAccountsTypes_CT459487.Yahoo;
		}
		else if(objRadioGroupEMails.selectedItem == objRadioGmail)
		{
			iActualAccountType = EBEmailAccountsTypes_CT459487.GMail;
		}
		
		if(iAcceptableAccountType != iActualAccountType)
		{
			EBGlobalManager_CT459487.Alert(window,EBEMailNotifierDialogsCaption_CT459487.AddEditDialog.ErrorTitleAlertMsg,
								EBEMailNotifierDialogsCaption_CT459487.AddEditDialog.ErrorMsgEmailTypeIncorrect);
			objRadioGroupEMails.focus();
			return false;
		}
		
		return true;
	},
	
	IsEMailExists : function(strEMail)
	{
		//get the dialogs mail account collection:
		var oMailAccountsColl = this.GetDialogsMailAccountCollection();
		if(oMailAccountsColl)
		{
			var arrAccounts = oMailAccountsColl.Arr;
			var objAccountData = null;
			for(var i=0;i<arrAccounts.length;i++)
			{
				objAccountData = arrAccounts[i];
				if(m_oAccountData != objAccountData && objAccountData.EMailAddress.toLowerCase() == strEMail.toLowerCase())
				{
					return true;
				}
			}
		}
		
		return false;
	},
	
	IsPop3AccountExists : function(strUserName,strMailServerURL)
	{
		var oMailAccountsColl = this.GetDialogsMailAccountCollection();
		if(oMailAccountsColl)
		{
			var arrAccounts = oMailAccountsColl.Arr;
			var objAccountData = null;
			for(var i=0;i<arrAccounts.length;i++)
			{
				objAccountData = arrAccounts[i];
				if(m_oAccountData != objAccountData && 
				objAccountData.EMailAddress == strUserName &&
				objAccountData.Pop3Server.toLowerCase() == strMailServerURL.toLowerCase())
				{
					return true;
				}
			}
		}
		
		return false;
		
	},
	
	GetIndexByAccountDataObject : function(objCurrentAccountData)
	{
		var oMailAccountsColl = this.GetDialogsMailAccountCollection();
		if(oMailAccountsColl)
		{
			var arrAccounts = oMailAccountsColl.Arr;
			var objAccountData = null;
			for(var i=0;i<arrAccounts.length;i++)
			{
				objAccountData = arrAccounts[i];
				if(objAccountData == objCurrentAccountData)
				{
					return i;
				}
			}
		}
		
		return -1;
	},
	
	OnCommandAddEditOKButton : function(event)
	{	
		try
		{
			var objTextBoxEmail				= document.getElementById('txtEMail');
			var strEMailAddress				= objTextBoxEmail.value;
			
			if(!this.IsValidEMailAddress())
			{
				return false;
			}
			
			var strPassword			= document.getElementById('txtPassword').value;
			var strAccountName		= document.getElementById('txtAccountName').value;
			
			var strPop3ServerURL	= null;
			var strPop3Port			= null;
			if(this.IsAddEditPop3Mode())
			{
				strPop3ServerURL = document.getElementById('txtPop3MailServer').value;
				strPop3Port		 = document.getElementById('txtPop3Port').value;
			}

			var objRadioGroupEMails = document.getElementById('radioGroupEMails');
			var objRadioHotmail		= document.getElementById('radHotmail');
			var objRadioYahoo		= document.getElementById('radYahoo');
			var objRadioGmail		= document.getElementById('radGMail');
			var objRadioPop3		= document.getElementById('radPop3');
			
			var iAccountType;
			if(objRadioGroupEMails.selectedItem == objRadioGmail)
			{
				iAccountType = EBEmailAccountsTypes_CT459487.GMail;
			}
			else if(objRadioGroupEMails.selectedItem == objRadioYahoo)
			{
				iAccountType = EBEmailAccountsTypes_CT459487.Yahoo;
			}
			else if(objRadioGroupEMails.selectedItem == objRadioHotmail)
			{
				iAccountType = EBEmailAccountsTypes_CT459487.Hotmail;
			}
			else if(objRadioGroupEMails.selectedItem == objRadioPop3)
			{
				iAccountType = EBEmailAccountsTypes_CT459487.Pop3;
			}
			
			var isAutoLogin		= document.getElementById('checkAutoLogin').checked;
			
			if(MODE == EBEMailNotifierDialogsConsts_CT459487.AddEditDialog.ModeAdd)
			{
				var objAccountDataToAdd = new EBEMailAccountDataObject_CT459487(strAccountName,
															strEMailAddress,
															strPassword,
															iAccountType,
															isAutoLogin,
															null,
															null,
															strPop3ServerURL,
															strPop3Port);
															
				this.AddMailAccountTreeItem(objAccountDataToAdd,true);
			}
			else
			{
				this.EditMailAccountTreeItem(strAccountName,strEMailAddress,strPassword,iAccountType,isAutoLogin,strPop3ServerURL,strPop3Port,m_oAccountData);
			}
		}
		catch(ex){}
		
		return true;
		
	},
	
	OnLoadTestAccountDialog : function(event)
	{
		//set focus to the ok button
		document.getElementById('btnOKCancel').focus();
		
		//open the test from the browser window to prevent bug
		//when the user close the test before the end of the process
		var objWindow = EBGlobalManager_CT459487.GetMostRecentBrowserWindow();
		if(objWindow)
		{
			objWindow.TestAccountDialogCheck_CT459487.Start(document,m_oAddEditDialogDocument);
		}
	},
	
	OnUnloadTestAccountDialog : function(event)
	{
		//open the test from the browser window to prevent bug
		//when the user close the test before the end of the process
		var objWindow = EBGlobalManager_CT459487.GetMostRecentBrowserWindow();
		if(objWindow)
		{
			objWindow.TestAccountDialogCheck_CT459487.NullifyMemebers();
		}
	},
	
	//get the dialog account collection which define in the settings dialog!
	GetDialogsMailAccountCollection : function()
	{
		var objSettingsWindow	= EBEMailNotifierDialogsManager_CT459487.GetDialogWindow(EBEMailNotifierDialogsConsts_CT459487.SettingsDialog.Name);
		
		return objSettingsWindow.m_oDialogsMailAccountsCollection;
	},
	
	AddMailAccountTreeItem : function(objAccountData,isSelectItem)
	{
		var objSettingsWindow	= EBEMailNotifierDialogsManager_CT459487.GetDialogWindow(EBEMailNotifierDialogsConsts_CT459487.SettingsDialog.Name);
		
		if(!objSettingsWindow)
		{
			return;
		}
		
		var objSettingsDocument = objSettingsWindow.document;
		
		var objTreeChildrenMailAccounts = objSettingsDocument.getElementById('treeChildrenMailAccounts');
		
		var objTreeItem = objSettingsDocument.createElement('treeitem');
		
		var objTreeRow	= this.AccountDataObjectToTreeRow(objSettingsDocument,objAccountData);
		
		objTreeItem.appendChild(objTreeRow);
		
		objTreeChildrenMailAccounts.appendChild(objTreeItem);
		
		
		if(isSelectItem)
		{
			this.SelectTreeItem(objTreeItem);
		}
		
		
		//add the data to the dialog collection
		objSettingsWindow.m_oDialogsMailAccountsCollection.AppendElement(objAccountData);
	
	},
	
	EditMailAccountTreeItem : function(strAccountName,strEMailAddress,strPassword,iAccountType,isAutoLogin,strPop3ServerURL,strPop3Port,objAccountData)
	{
		var objSettingsWindow	= EBEMailNotifierDialogsManager_CT459487.GetDialogWindow(EBEMailNotifierDialogsConsts_CT459487.SettingsDialog.Name);
		
		if(!objSettingsWindow)return;
		
		var objSettingsDocument		= objSettingsWindow.document;
		
		var iIndexToEdit			= this.GetIndexByAccountDataObject(objAccountData);
		
		if(iIndexToEdit == -1)return;
		
		var objTreeChildren			= objSettingsDocument.getElementById('treeChildrenMailAccounts');
		
		var objTreeRowCollection	= objTreeChildren.getElementsByTagName('treerow');
		
		var objTreeRowToEdit		= objTreeRowCollection.item(iIndexToEdit);
		
		var objTreeCellAccountName	= objTreeRowToEdit.childNodes[0];
		var objTreeCellEMailAddress = objTreeRowToEdit.childNodes[1];
		var objTreeCellAccountType	= objTreeRowToEdit.childNodes[2];
		var objTreeCellAutoLogin	= objTreeRowToEdit.childNodes[3];
		
		objTreeCellAccountName.setAttribute('label',strAccountName);
		
		objTreeCellEMailAddress.setAttribute('label',strEMailAddress);
		objTreeCellEMailAddress.setAttribute(EBEMailNotifierDialogsConsts_CT459487.SettingsDialog.TreeCellPasswordAttribute,strPassword);
		objTreeCellEMailAddress.setAttribute(EBEMailNotifierDialogsConsts_CT459487.SettingsDialog.TreeCellServerAttribute,strPop3ServerURL);
		
		var strAccountType = EBEMailNotifierManager_CT459487.GetAccountNameByType(iAccountType);
		objTreeCellAccountType.setAttribute('label',strAccountType);
		objTreeCellAccountType.setAttribute(EBEMailNotifierDialogsConsts_CT459487.SettingsDialog.TreeCellTypeAttribute,iAccountType);
		
		var strIsAutoLogin = isAutoLogin ? EBEMailNotifierDialogsCaption_CT459487.SettingsDialog.Yes : EBEMailNotifierDialogsCaption_CT459487.SettingsDialog.No;
		objTreeCellAutoLogin.setAttribute('label',strIsAutoLogin);
		objTreeCellAutoLogin.setAttribute(EBEMailNotifierDialogsConsts_CT459487.SettingsDialog.TreeCellAutoLoginAttribute,isAutoLogin);
		
		//set the data object
		objAccountData.AccountName	= strAccountName;
		objAccountData.EMailAddress	= strEMailAddress;
		objAccountData.Password		= strPassword;
		objAccountData.AccountType	= iAccountType;
		objAccountData.AutoLogin	= isAutoLogin;
		objAccountData.Pop3Server	= strPop3ServerURL;
		objAccountData.Pop3Port		= strPop3Port;
		
	},
	
	SelectTreeItem : function(objTreeItem)
	{
		var objTree = objTreeItem.parentNode.parentNode;
		var iIndex	= objTree.contentView.getIndexOfItem(objTreeItem);
		objTree.view.selection.select(iIndex);
		objTree.focus();
	},
	
	Test : function(doc)
	{
		
	}	
}



var TestAccountDialogCheck_CT459487  = 
{
	EMailAccountType			: null,
	
	EMail						: '',
	
	Password					: '',
	
	Pop3ServerURL				: '',
	
	Pop3Port					: 0,

	TestDialogDocument			: null,
	
	AddEditDialogDocument		: null,
	
	IsTestAccountDialogExists : function()
	{
		var objTestAccountWindow = EBEMailNotifierDialogsManager_CT459487.GetDialogWindow(EBEMailNotifierDialogsConsts_CT459487.TestAccountDialog.Name);
		return objTestAccountWindow ? true : false;
	},
	
	Start : function(oTestDialogDocument,oAddEditDialogDocument)
	{
		this.TestDialogDocument		= oTestDialogDocument;
		this.AddEditDialogDocument	= oAddEditDialogDocument;
		
		var objTextBoxEmail				= this.AddEditDialogDocument.getElementById('txtEMail');
		var objTextBoxPassword			= this.AddEditDialogDocument.getElementById('txtPassword');
		var objTextBoxPop3MailServer	= this.AddEditDialogDocument.getElementById('txtPop3MailServer');
		var objTextBoxPop3Port			= this.AddEditDialogDocument.getElementById('txtPop3Port');
		
		var objRadioGroupEMails = this.AddEditDialogDocument.getElementById('radioGroupEMails');
		var objRadioHotmail		= this.AddEditDialogDocument.getElementById('radHotmail');
		var objRadioYahoo		= this.AddEditDialogDocument.getElementById('radYahoo');
		var objRadioGmail		= this.AddEditDialogDocument.getElementById('radGMail');
		var objRadioPop3		= this.AddEditDialogDocument.getElementById('radPop3');
		
		var iEMailAccountType = null;
		if(objRadioGroupEMails.selectedItem == objRadioGmail)
		{
			iEMailAccountType = EBEmailAccountsTypes_CT459487.GMail;
		}
		else if(objRadioGroupEMails.selectedItem == objRadioYahoo)
		{
			iEMailAccountType = EBEmailAccountsTypes_CT459487.Yahoo;
		}
		else if(objRadioGroupEMails.selectedItem == objRadioHotmail)
		{
			iEMailAccountType = EBEmailAccountsTypes_CT459487.Hotmail;
		}
		else if(objRadioGroupEMails.selectedItem == objRadioPop3)
		{
			iEMailAccountType = EBEmailAccountsTypes_CT459487.Pop3;
		}
		
		//get the values from the text boxes
		var strEMail				= objTextBoxEmail.value;
		var strPassword				= objTextBoxPassword.value;
		var strPop3MailServerURL	= objTextBoxPop3MailServer.value;
		var strPop3Port				= objTextBoxPop3Port.value;
		
		//set the class members for later use
		this.EMailAccountType			= iEMailAccountType;
		this.EMail						= strEMail;
		this.Password					= strPassword;
		this.Pop3ServerURL				= strPop3MailServerURL;
		this.Pop3Port					= strPop3Port;
		
		this.StepOneCheckInternetConnection();
	},
	
	StepOneCheckInternetConnection : function()
	{
		//check internet connection:
		var strCheckURL = EBEmailAccountsConsts_CT459487.CheckURL;
		
		var oCallBackFunction = function(oData,o)
		{
			if(o.value == EBGlobalConsts_CT459487.NetworkError)
			{
				TestAccountDialogCheck_CT459487.ConnectionFailed();
			}
			else
			{
				TestAccountDialogCheck_CT459487.ConnectionSuccess();
			}
		};
		
		EBGlobalManager_CT459487.HTTPServerRequest(strCheckURL,null,false,oCallBackFunction);
	},
	
	StepTwoLoginToMailServer : function()
	{
		var objMailAccount = EBEMailNotifierManager_CT459487.GetAccountObjectByType(this.EMailAccountType,
																			this.EMail,
																			this.Password,
																			this.Pop3ServerURL,
																			this.Pop3Port);
		
		var objResponseFunction = function(iNewMessages)
		{
			TestAccountDialogCheck_CT459487.ResponseLoginMailServer(iNewMessages);
		};
		
		objMailAccount.GetNewMessagesCount(objResponseFunction);
	},
	
	ConnectionSuccess : function()
	{
		//check if the user close the window in the middle of the check
		if(!this.IsTestAccountDialogExists())return;
	
		//set the check connection tree cell to success
		this.SetTreeCellIndicatorSuccess('tcEstablishConnection');
		
		//make time effect for the check function
		var objIntervalFunction = function()
		{
			TestAccountDialogCheck_CT459487.SetTreeCellIndicatorSuccess('tcFindMailServer');	
			TestAccountDialogCheck_CT459487.StepTwoLoginToMailServer();
		};
		setTimeout(objIntervalFunction,500);
	},
	
	ResponseLoginMailServer : function(iNewMessages)
	{
		//check if the user close the window in the middle of the check
		if(!this.IsTestAccountDialogExists())return;
		
		if(iNewMessages == EBEmailAccountsConsts_CT459487.LOGIN_FAILED)
		{
			this.SetTreeCellIndicatorFailed('tcLoginMsg');
			this.TestFailed();
		}
		else if(iNewMessages == EBEmailAccountsConsts_CT459487.LOGIN_ANOTHER_ACCOUNT)
		{
			this.TestWarning();
		}
		else
		{
			this.SetTreeCellIndicatorSuccess('tcLoginMsg');
			this.TestSuccess();
		}
	},
	
	ConnectionFailed : function()
	{
		//check if the user close the window in the middle of the check
		if(!this.IsTestAccountDialogExists())return;
		
		
		this.SetTreeCellIndicatorFailed('tcEstablishConnection');
		this.SetTreeCellIndicatorFailed('tcFindMailServer');
		this.SetTreeCellIndicatorFailed('tcLoginMsg');
		this.TestFailed();
	},
	
	SetTreeCellIndicatorSuccess : function(strTreeCellID)
	{
		var objTreeCellIndicator	= this.TestDialogDocument.getElementById(strTreeCellID);	
		var objTreeCellValue		= this.TestDialogDocument.getElementById(strTreeCellID + 'Value');
		
		objTreeCellIndicator.setAttribute('src',EBEMailNotifierConsts_CT459487.Images.V_Image);
		
		objTreeCellValue.setAttribute('label',EBEMailNotifierDialogsCaption_CT459487.TestAccountDialog.TasksSuccess);	
	
		return objTreeCellIndicator;
	},
	
	SetTreeCellIndicatorFailed : function(strTreeCellID)
	{
		var objTreeCellIndicator	= this.TestDialogDocument.getElementById(strTreeCellID);	
		var objTreeCellValue		= this.TestDialogDocument.getElementById(strTreeCellID + 'Value');
		
		objTreeCellIndicator.setAttribute('src',EBEMailNotifierConsts_CT459487.Images.X_Image);
		
		objTreeCellValue.setAttribute('label',EBEMailNotifierDialogsCaption_CT459487.TestAccountDialog.TasksFailure);	
		
		return objTreeCellIndicator;
	},
	
	TestSuccess : function()
	{
		var objTreeCellFinish	= this.SetTreeCellIndicatorSuccess('tcFinishMsg');
		objTreeCellFinish.setAttribute('label',' ' + EBEMailNotifierDialogsCaption_CT459487.TestAccountDialog.TasksSuccessFinishMsg);
	
		this.Finish();
	},
	
	TestFailed : function()
	{
		var objTreeCellFinish	= this.SetTreeCellIndicatorFailed('tcFinishMsg');
		objTreeCellFinish.setAttribute('label',' ' + EBEMailNotifierDialogsCaption_CT459487.TestAccountDialog.TasksFailureFinishMsg);
	
		this.Finish();
	},
	
	TestWarning : function()
	{
		var objTreeCellEstablish		= this.TestDialogDocument.getElementById('tcEstablishConnection');		
		var objTreeCellEstablishValue	= this.TestDialogDocument.getElementById('tcEstablishConnectionValue');		
		var objTreeCellFind				= this.TestDialogDocument.getElementById('tcFindMailServer');		
		var objTreeCellFindValue		= this.TestDialogDocument.getElementById('tcFindMailServerValue');		
		var objTreeCellLogin			= this.TestDialogDocument.getElementById('tcLoginMsg');		
		var objTreeCellLoginValue		= this.TestDialogDocument.getElementById('tcLoginMsgValue');			
		
		//the string of the warning message devide into 2 strings beacuse
		//of spacing problem
		//convert the warning string according to the account type
		var strWarning1 = EBEMailNotifierDialogsCaption_CT459487.TestAccountDialog.TestWarningMsg1;
		var strAccountName = EBEMailNotifierManager_CT459487.GetAccountNameByType(this.EMailAccountType);
		strWarning1 = strWarning1.replace(EBEMailNotifierDialogsConsts_CT459487.TestAccountDialog.AccountNameAlias,strAccountName);
		
		objTreeCellEstablish.setAttribute('src',EBEMailNotifierConsts_CT459487.Images.WarningImage);
		objTreeCellEstablish.setAttribute('label',strWarning1);	
		
		objTreeCellEstablishValue.setAttribute('label','');
		objTreeCellFind.setAttribute('label',EBEMailNotifierDialogsCaption_CT459487.TestAccountDialog.TestWarningMsg2);
		objTreeCellFind.setAttribute('src',EBEMailNotifierConsts_CT459487.Images.BlankImage);
		
		objTreeCellFindValue.setAttribute('label','');
		objTreeCellLogin.setAttribute('label','');
		objTreeCellLoginValue.setAttribute('label','');
		
		this.Finish();
	
	},
	
	Finish : function()
	{
		var objButtonOKCancel = this.TestDialogDocument.getElementById('btnOKCancel');
		objButtonOKCancel.setAttribute('label',EBEMailNotifierDialogsCaption_CT459487.TestAccountDialog.ButtonOK);
	},
	
	NullifyMemebers : function()
	{
		this.EMailAccountType			= null;
		this.EMail						= '';
		this.Password					= '';
		this.TestDialogDocument			= null;
		this.AddEditDialogDocument		= null;
	}
	
	
}


var EBEMailNotifierConsts_CT459487 = 
{
	EMailNotifierDirectory			: 'emailnotifier',
	
	EMailNotifierAccountsFileName	: 'acc',
	
	EncryptionPass					: 'EBEMailNotifierAcc',
	
	DefaultIntervalMinutes			: 5,
	
	Images : 
	{
		V_Image				: 'chrome://folkoteka.com/skin/v.png',
		X_Image				: 'chrome://folkoteka.com/skin/x.png',
		BlankImage			: 'chrome://folkoteka.com/skin/blank.png',
		EMailImage			: 'chrome://folkoteka.com/skin/email.png',
		EMailNewImage		: 'chrome://folkoteka.com/skin/emailnew.png',
		EMailNewSmallImage	: 'chrome://folkoteka.com/skin/emailnewsmall.png',
		StarImage			: 'chrome://folkoteka.com/skin/star.png',
		WarningImage		: 'chrome://folkoteka.com/skin/warning.png'
	},
	
	XML : 
	{
		ACCOUNTS		: 'ACCOUNTS',
		ACCOUNT			: 'ACCOUNT',
		NAME			: 'NAME',
		EMAIL			: 'EMAIL',
		PASSWORD		: 'PASSWORD',
		SERVER			: 'SERVER',
		PORT			: 'PORT',
		TYPE			: 'TYPE',
		AUTO_LOGIN  	: 'AUTO_LOGIN',
		STARED			: 'STARED',
		NEW_MESSAGES	: 'NEW_MESSAGES'
	},
	
	Attributes :
	{
		MAIL_ACCOUNT				: 'EB_ATTRIBUTE_MAIL_ACCOUNT',
		MAIL_ACCOUNT_VALUE			: 'EB_ATTRIBUTE_MAIL_ACCOUNT_VALUE',
		CHECK_NEW_EMAIL_INTERVAL	: 'EB_ATTRIBUTE_CHECK_NEW_EMAIL_INTERVAL',
		SOUND						: 'EB_ATTRIBUTE_SOUND',
		STARED_ICON_URL				: 'EB_ATTRIBUTE_STARED_ICON_URL',
		STARED_TOOLTIP				: 'EB_ATTRIBUTE_STARED_TOOLTIP',
		DEFAULT_TOOLTIP				: 'EB_ATTRIBUTE_DEFAULT_TOOLTIP',
		DEFAULT_CAPTION				: 'EB_ATTRIBUTE_DEFAULT_CAPTION',
		EMAIL						: 'EB_ATTRIBUTE_EMAIL',
		PASSWORD					: 'EB_ATTRIBUTE_PASSWORD',
		ACCOUNT_TYPE				: 'EB_ATTRIBUTE_ACCOUNT_TYPE',
		AUTO_LOGIN					: 'EB_ATTRIBUTE_AUTO_LOGIN',
		POP3_SERVER					: 'EB_ATTRIBUTE_POP3_SERVER',
		POP3_PORT					: 'EB_ATTRIBUTE_POP3_PORT',
		TOTAL_NEW_MESSAGES			: 'EB_ATTRIBUTE_TOTAL_NEW_MESSAGES'
	},
	
	Sound : 
	{
		DefaultWavChromePath		: 'chrome://folkoteka.com/skin/enSound.wav',
		
		NONE						: 'NONE',
		DEFAULT						: 'DEFAULT'
	}
	
}

var EBEMailNotifierManager_CT459487 = 
{
	GetAccountObjectByType : function(iAccountType,strEMail,strPassword,strPop3ServerURL,iPop3Port)
	{
		var objMailAccount = null;
		
		if(iAccountType == EBEmailAccountsTypes_CT459487.GMail)
		{
			objMailAccount = new EBGmailAccount_CT459487(strEMail,
												strPassword);
		}
		else if(iAccountType == EBEmailAccountsTypes_CT459487.Yahoo)
		{
			objMailAccount = new EBYahooAccount_CT459487(strEMail,
												strPassword);
		}
		else if(iAccountType == EBEmailAccountsTypes_CT459487.Hotmail)
		{
			objMailAccount = new EBHotmailAccount_CT459487(strEMail,
												strPassword);
		}
		else if(iAccountType == EBEmailAccountsTypes_CT459487.Pop3)
		{
			objMailAccount = new EBPop3Account_CT459487(strEMail,
												strPassword,
												strPop3ServerURL,
												iPop3Port);
		}
		
		
		return objMailAccount;
	},
	
	GetAccountNameByType : function(iAccountType)
	{
		var strAccountName = '';
		if(iAccountType == EBEmailAccountsTypes_CT459487.GMail)
		{
			strAccountName = EBEmailAccountsConsts_CT459487.GMail.AccountName;
		}
		else if(iAccountType == EBEmailAccountsTypes_CT459487.Yahoo)
		{
			strAccountName = EBEmailAccountsConsts_CT459487.Yahoo.AccountName;
		}
		else if(iAccountType == EBEmailAccountsTypes_CT459487.Hotmail)
		{
			strAccountName = EBEmailAccountsConsts_CT459487.Hotmail.AccountName;
		}
		else if(iAccountType == EBEmailAccountsTypes_CT459487.Pop3)
		{
			strAccountName = EBEmailAccountsConsts_CT459487.Pop3.AccountName;
		}
		
		return strAccountName;
	},
	
	GetAccountTypeByEMail : function(strEMail)
	{
		var iAccountType = 0;
		if(this.IsSupportedEMailGMail(strEMail))
		{
			iAccountType = EBEmailAccountsTypes_CT459487.GMail;
		}
		else if(this.IsSupportedEMailYahoo(strEMail))
		{
			iAccountType = EBEmailAccountsTypes_CT459487.Yahoo;
		}
		else if(this.IsSupportedEMailHotmail(strEMail))
		{
			iAccountType = EBEmailAccountsTypes_CT459487.Hotmail;
		}
		
		return iAccountType;
	},

	
	GetUserNameByEMail : function(strFullEMail)
	{
		var strUserName = strFullEMail;
		var iIndexOfAT = strFullEMail.indexOf('@');
		if(iIndexOfAT != -1)
		{
			strUserName = strFullEMail.substring(0,iIndexOfAT);
		}
		
		return strUserName;
	},
	
	IsEMailDomain : function(AccountConstClass,strEMail)
	{
		var arrDomains = AccountConstClass.EMailDomain;
		for(var i=0;i<arrDomains.length;i++)
		{
			if(strEMail.toLowerCase().indexOf(arrDomains[i]) != -1)
			{
				return true;
			}
		}
		
		return false;
	},
	
	IsSupportedEMail : function(strEMail,arrDomains)
	{
		var isSupported = false;
		for(var i=0;i<arrDomains.length;i++)
		{
			isSupported = EBGlobalManager_CT459487.EndsWith(strEMail,arrDomains[i]);
			if(isSupported)break;
		}
		return isSupported;
	},
	
	IsSupportedEMailGMail : function(strEMail)
	{
		var arrDomains = EBEmailAccountsConsts_CT459487.GMail.EMailDomain;
		return this.IsSupportedEMail(strEMail,arrDomains);
	},
	
	IsSupportedEMailYahoo : function(strEMail)
	{
		var arrDomains = EBEmailAccountsConsts_CT459487.Yahoo.EMailDomain;
		return this.IsSupportedEMail(strEMail,arrDomains);
	},
	
	IsSupportedEMailHotmail : function(strEMail)
	{
		var arrDomains = EBEmailAccountsConsts_CT459487.Hotmail.EMailDomain;
		return this.IsSupportedEMail(strEMail,arrDomains);
	},
	
	IsSupportedEMailAccounts : function(strEMail)
	{
		return	this.IsSupportedEMailGMail(strEMail) 
				||
				this.IsSupportedEMailYahoo(strEMail)
				||
				this.IsSupportedEMailHotmail(strEMail);
	},
	
	GetEMailDomainCaption : function(arrCaptionDomains)
	{
		var strDelimiter = EBEmailAccountsConsts_CT459487.DomainCaptionDelimiter;
		var strDomainCaptions = '';
		for(var i=0;i<arrCaptionDomains.length;i++)
		{
			if((i+1) ==  arrCaptionDomains.length)
			{
				strDelimiter = '';
			}
			strDomainCaptions += arrCaptionDomains[i] + strDelimiter;
		}
		
		return strDomainCaptions;
	},
	
	GetGMailDomainCaption : function()
	{
		var arrCaptionDomains = EBEmailAccountsConsts_CT459487.GMail.EMailDomainCaption;
		return this.GetEMailDomainCaption(arrCaptionDomains);
	},
	
	GetYahooDomainCaption : function(strEMail)
	{
		var arrCaptionDomains = EBEmailAccountsConsts_CT459487.Yahoo.EMailDomainCaption;
		return this.GetEMailDomainCaption(arrCaptionDomains);
	},
	
	GetHotmailDomainCaption : function(strEMail)
	{
		var arrCaptionDomains = EBEmailAccountsConsts_CT459487.Hotmail.EMailDomainCaption;
		return this.GetEMailDomainCaption(arrCaptionDomains);
	}
}

//the object that the dialogs is used to handle the numbers of emails accoutns
//that the user defined. the file of the emails is writing from this object.
//and the loading of the menu item to the toolbar component email notifier is using 
//the file to read all that accounts
function EBEMailAccountDataObject_CT459487(strAccountName,
								strEMailAddress,
								strPassword,
								iAccountType,
								isAutoLogin,
								isStared,
								iNewMessages,
								strPop3Server,
								iPop3Port)
{
	this.AccountName	= strAccountName;
	this.EMailAddress	= strEMailAddress;
	this.Password		= strPassword;
	this.AccountType	= iAccountType;
	this.AutoLogin		= isAutoLogin;
	
	this.Stared			= false;
	this.NewMessages	= 0;
	this.Pop3Server		= '';
	this.Pop3Port		= 0;
	
	if(isStared)
	{
		this.Stared = isStared;
	}
	if(iNewMessages)
	{
		this.NewMessages = iNewMessages;
	}
	if(strPop3Server)
	{
		this.Pop3Server = strPop3Server;
	}
	if(iPop3Port)
	{
		this.Pop3Port = iPop3Port;
	}
}




var EBEMailNotifierToolbarManager_CT459487 = 
{
	MailAccountsCollection			: null,
	
	TimeoutID						: null,
	
	//var to check if the button is stared on the onhidden popup
	//so just if it is stared i nullify the stars and write to the file
	ButtonStared					: false,
	
	Sound							: null,

	OnLoadToolbarEMailNotifier    : function()
	{
		//set the mail collection from the file
		this.MailAccountsCollection = this.AccountsFileToAccountsCollection();
		
		//set the on hidden popup event (to clear the stars when it closed!)
		var objXULMenuPopup = this.GetXULToolbarMenuPopup();
		objXULMenuPopup.setAttribute('onpopuphidden','EBEMailNotifierToolbarManager_CT459487.OnPopupHiddenMailAccounts(event);event.preventBubble();');
		
		this.RemoveToolbarMailAccounts();
		this.BuildToolbarMailAccounts();
		
		this.CheckToolbarMenuItemsMailAccounts(false);
	},
	
	OnUnloadToolbarEMailNotifier : function()
	{
		var oEmailNotifierToolbarButton = EBComponentsManager_CT459487.GetEMailNotifierToolbarButton();
		if(oEmailNotifierToolbarButton)
		{
			this.RemoveToolbarMailAccounts();
			this.ClearMailAccountsTimeoutID();
		}
	},
	
	OnCommandSettingsOKButton : function(oMailAccountsCollection)
	{	
		this.RemoveToolbarMailAccounts();
		
		//get the accounts from the dialog accounts collection
		this.MailAccountsCollection = oMailAccountsCollection;
		
		//write the changes to the file
		this.AccountsCollectionToAccountsFile(this.MailAccountsCollection);
		
		//send the changes to the rest of the open browsers
		this.BroadcastChangesToAllBrowsers();
		
		this.BuildToolbarMailAccounts();
		
		this.CheckToolbarMenuItemsMailAccounts(true);
	},
	
	OnPopupHiddenMailAccounts : function(event)
	{
		//check if the button is already not stared so no need to nullify it!
		if(!this.ButtonStared)
		{
			return;
		}
		
		
		//clear all the stars 
		var arrAccounts = this.MailAccountsCollection.Arr;
		for(var i=0;i<arrAccounts.length;i++)
		{
			arrAccounts[i].Stared = false;
		}
		
		//update the button and all the menu item
		//button image update
		this.SetToolbarButtonImageTooltip(false);
		//menu items image update
		var objMenuItemsMailAccounts = this.GetMenuItemsMailAccounts();
		var objMenuItem = null;
		var strCurrentImage = '';
		for(var i=0;i<objMenuItemsMailAccounts.length;i++)
		{
			objMenuItem = objMenuItemsMailAccounts.item(i);
			strCurrentImage = objMenuItem.getAttribute('image');
			if(strCurrentImage == EBEMailNotifierConsts_CT459487.Images.StarImage)
			{
				objMenuItem.setAttribute('image',EBEMailNotifierConsts_CT459487.Images.BlankImage);
			}
		}
		
		//write the file
		this.AccountsCollectionToAccountsFile(this.MailAccountsCollection);
		this.BroadcastChangesToAllBrowsers();
	},
	
	GetMenuItemsMailAccounts : function()
	{
		var objXULMenuPopup = this.GetXULToolbarMenuPopup();
		
		var objMenuItemsMailAccounts = objXULMenuPopup.getElementsByAttribute(EBEMailNotifierConsts_CT459487.Attributes.MAIL_ACCOUNT,EBEMailNotifierConsts_CT459487.Attributes.MAIL_ACCOUNT_VALUE);
		
		return 	objMenuItemsMailAccounts;
	},
	
	GetMenuItemAccountIndex : function(objMenuItemMailAccount)
	{
		var objMenuItemsMailAccounts = this.GetMenuItemsMailAccounts();
		
		for(var i=0;i<objMenuItemsMailAccounts.length;i++)
		{
			if(objMenuItemsMailAccounts.item(i) == objMenuItemMailAccount)
			{
				return i;
			}
		}
		
		return -1;
	},
	
	BuildToolbarMailAccounts : function()
	{
		var arrAccounts = this.MailAccountsCollection.Arr;
		var objAccountData;
		
		if(!arrAccounts || arrAccounts.length == 0)
		{
			//set the default caption of the button 
			this.SetToolbarButtonDefaulCaption();
			this.SetToolbarButtonImageTooltip(false);
			
			//remove the separator if there is no accounts
			this.ShowHideSeparatorCheckMenuItems(true);
		}
		else
		{
			//set button defalt caption with elements ([0 new])
			this.SetToolbarButtonCaption(0);
			
			this.SetToolbarButtonImageTooltip(this.IsButtonToStared());
			
			//add the separator and the check menu items
			this.ShowHideSeparatorCheckMenuItems(false);
			
			for(var i=0;i<arrAccounts.length;i++)
			{
				objAccountData = arrAccounts[i];
				this.BuildToolbarMenuItemMailAccount(objAccountData);
			}
			
			
		}
	},
	
	//check if one of the accounts are stared to star 
	//the main button
	IsButtonToStared : function()
	{
		var arrAccounts = this.MailAccountsCollection.Arr;
		for(var i=0;i<arrAccounts.length;i++)
		{
			if(arrAccounts[i].Stared)
			{
				return true;
			}
		}
		
		return false;
	},
	
	BuildToolbarMenuItemMailAccount : function(objAccountData)
	{
		var objXULMenuPopup = this.GetXULToolbarMenuPopup();
		
		var strLabel	= '';
		var strImage	= '';
		var strCommand	= 'EBEMailNotifierToolbarManager_CT459487.OnCommandMenuItemMailAccount(event);event.preventBubble();';
		var arrData		= new Array();
		
		objAccountData.NewMessages = parseInt(objAccountData.NewMessages);
		
		strLabel = this.GetMailAccountFullCaption(objAccountData);
		strImage = this.GetMailAccountImage(objAccountData);
		
		//build the attributes 
		//special attribute to distinguish between mail account menu item and othe menu items(check,settings)
		arrData[EBEMailNotifierConsts_CT459487.Attributes.MAIL_ACCOUNT]	= EBEMailNotifierConsts_CT459487.Attributes.MAIL_ACCOUNT_VALUE;
		arrData[EBEMailNotifierConsts_CT459487.Attributes.EMAIL]			= objAccountData.EMailAddress;
		arrData[EBEMailNotifierConsts_CT459487.Attributes.PASSWORD]		= objAccountData.Password;
		arrData[EBEMailNotifierConsts_CT459487.Attributes.ACCOUNT_TYPE]	= objAccountData.AccountType;
		arrData[EBEMailNotifierConsts_CT459487.Attributes.AUTO_LOGIN]	= objAccountData.AutoLogin;
		arrData[EBEMailNotifierConsts_CT459487.Attributes.POP3_SERVER]	= objAccountData.Pop3Server;
		arrData[EBEMailNotifierConsts_CT459487.Attributes.POP3_PORT]		= objAccountData.Pop3Port;
		
		var objXULMenuItem = EBXULFactory_CT459487.CreateMenuItem(strLabel,
														strImage,
														objAccountData.EMailAddress,
														strCommand,
														'',
														arrData);
		
		var objXULSeparatorItem = this.GetXULToolbarSeparatorItem();
		objXULMenuPopup.insertBefore(objXULMenuItem,objXULSeparatorItem);
		
		//update the main button caption
		if(objAccountData.NewMessages != EBEmailAccountsConsts_CT459487.LOGIN_FAILED)
		{
			this.UpdateButtonNewMessages(objAccountData.NewMessages);
		}
		
	},
	
	ClearMailAccountsTimeoutID : function()
	{
		
		if(this.TimeoutID)
		{
			clearTimeout(this.TimeoutID);
		}
		
		this.TimeoutID = null;
	},

	RemoveToolbarMailAccounts : function()
	{
		var objMenuItemsMailAccounts = this.GetMenuItemsMailAccounts();
		while(objMenuItemsMailAccounts.length > 0)
		{
			this.RemoveToolbarMailAccount(objMenuItemsMailAccounts.item(objMenuItemsMailAccounts.length - 1));
			
			//get the objMenuItemsMailAccounts due to a bug in Firefox 1.0.7
			//probably the getElementsByAttribute not related to the dom in 1.0.7
			objMenuItemsMailAccounts = this.GetMenuItemsMailAccounts();
		}
		
		
	},
	
	RemoveToolbarMailAccount : function(objMenuItemMailAccount)
	{	
		//remove the menu item
		var objXULMenuPopup = this.GetXULToolbarMenuPopup();
		objXULMenuPopup.removeChild(objMenuItemMailAccount);
	},
	
	OnCommandCheckForNewEMailsButton : function()
	{
		//re-check all accounts
		this.CheckToolbarMenuItemsMailAccounts(true);
	},
	
	CheckToolbarMenuItemsMailAccounts : function(isForceCheck)
	{
		if(isForceCheck || this.IsPollDateElapsed())
		{
			this.CheckMailAccountsFromServers();
		}
		
		//make the interval call
		this.SetTimeoutAccountsCheck();
	},
	
	//check if need to make a master check(check from server) or not(check from file)
	IsPollDateElapsed : function()
	{
		var strPollDate = EBToolbarPreferenceManager_CT459487.GetPref(EBPreferenceConsts_CT459487.EMailNotifierPollDate);
		if(strPollDate == null || strPollDate == "")
		{
			return true;
		}
		
		var objCurrentDate = new Date();
		var objPollDate = new Date(strPollDate);
		
		var iCheckIntervalTime = this.GetCheckAccountIntervalTime();
		
		var iDateDiff  = objCurrentDate - objPollDate;
		
		return iDateDiff > iCheckIntervalTime;
	},
	
	SetPollDatePreference : function()
	{
		var objCurrentDate = new Date();
		var strDateValue = objCurrentDate.toString();
		EBToolbarPreferenceManager_CT459487.SetPref(EBPreferenceConsts_CT459487.EMailNotifierPollDate,strDateValue);
	},
	
	//this call actually check the accounts using the account objects(using GetNewMessages function)
	//and the rest of the open browsers update themselves from the file each interval time
	CheckMailAccountsFromServers : function()
	{
		//set the time of the check
		this.SetPollDatePreference();
		
		this.SetCurrentSound();
	
		var objMenuItemsMailAccounts	= this.GetMenuItemsMailAccounts();
		var objMenuItemMailAccount		= null;
		var objAccountData				= null;
		
		var iLastIndex					= this.MailAccountsCollection.Arr.length - 1;
		
		//start the check from the last child(menu item mail account) and in the end of each check 
		//the current child call the prev child email check till the first and vice-verse
		objMenuItemMailAccount	= objMenuItemsMailAccounts.item(iLastIndex);
		objAccountData			= this.MailAccountsCollection.GetItem(iLastIndex);
		
		if(objMenuItemMailAccount && objAccountData)
		{
			var objIntervalFunction = function()
			{
				EBEMailNotifierToolbarManager_CT459487.CheckToolbarMenuItemMailAccount(objMenuItemMailAccount,objAccountData);
			}
			setTimeout(objIntervalFunction,100);
		}
	},
	
	CheckToolbarMenuItemMailAccount : function(objXULMenuItem,objAccountData)
	{
		var strLoginEMail			= objAccountData.EMailAddress;
		var strLoginPassword		= objAccountData.Password;
		var strPop3MailServerURL	= objAccountData.Pop3Server;
		var iPop3Port				= objAccountData.Pop3Port;
		
		var objMailAccount = EBEMailNotifierManager_CT459487.GetAccountObjectByType(objAccountData.AccountType,
																			strLoginEMail,
																			strLoginPassword,
																			strPop3MailServerURL,
																			iPop3Port);
		
		if(objMailAccount)
		{
			var objCallBackFunction = function(iNewMessages)
			{
				EBEMailNotifierToolbarManager_CT459487.CheckToolbarMenuItemMailAccountCallBack(objXULMenuItem,objAccountData,iNewMessages);
			};
			
			objMailAccount.GetNewMessagesCount(objCallBackFunction);
		}
	},
	
	IsMenuItemMailAccountChild : function(objMenuItemMailAccountChild)
	{
		var objMenuItemsMailAccounts = this.GetMenuItemsMailAccounts();
		for(var i=0;i<objMenuItemsMailAccounts.length;i++)
		{
			if(objMenuItemsMailAccounts.item(i) == objMenuItemMailAccountChild)
			{
				return true;
			}
		}
		return false;
	},
	
	CheckToolbarMenuItemMailAccountCallBack : function(objXULMenuItem,objAccountData,iNewMessages)
	{
		//check to see if the callback menuitem is still part of the 
		//email notifier dom elements - and if not terminate it
		//the check is perform due to too much reqeusts (the close dialogs,refresh toolbar)
		//so the timeouts can get out of mix - that is why i check it!
		if(!this.IsMenuItemMailAccountChild(objXULMenuItem))
		{
			return;
		}	
		
		//the changes coming back from the thread are only occur to the
		//data objects - the changes to the GUI (menu items) occur
		//in end of each cycle (and then broadcast to all browsers!
		
		iNewMessages				= parseInt(iNewMessages);
		objAccountData.NewMessages	= parseInt(objAccountData.NewMessages);
		
		var isStared = false;
		
		//flag determine if to perform new messages for this menuitem
		
		if(iNewMessages <= 0)
		{
			isStared = false;
		}
		else if(iNewMessages > objAccountData.NewMessages)
		{
			isStared = true;
			
		}
		else
		{
			//if this element was stared i don't change it
			if(objAccountData.Stared)
			{
				isStared = true;
			}
		}

		//update the object data:
		var iOldMessages = objAccountData.NewMessages;
		
		//if there is another login the data new messages is stay put
		if(iNewMessages != EBEmailAccountsConsts_CT459487.LOGIN_ANOTHER_ACCOUNT)
		{
			objAccountData.NewMessages	= iNewMessages;
		}
		objAccountData.Stared		= isStared;
		

		this.UpdateToolbarMenuItemMailAccount(objXULMenuItem,objAccountData,iOldMessages);
		
		
		//check the previous account in the list (the check is one by one!)
		this.CheckPreviousAccount(objXULMenuItem);

	},
	
	UpdateToolbarMenuItemMailAccount : function(objXULMenuItem,objAccountData,iOldMessages)
	{
		//set label and stared for this menu item:
		var isStared = objAccountData.Stared;
		var iNewMessages = objAccountData.NewMessages;
			
		var strLabel = this.GetMailAccountFullCaption(objAccountData);
		var strImage = this.GetMailAccountImage(objAccountData);
		
		
		objXULMenuItem.setAttribute('label',strLabel);
		objXULMenuItem.setAttribute('image',strImage);
		
		var isChanged = false;
		
		//update the button caption:
		if(iNewMessages != EBEmailAccountsConsts_CT459487.LOGIN_ANOTHER_ACCOUNT)
		{
			if(iNewMessages != iOldMessages)
			{
				isChanged = true;
				//check if it's failed to set the message to zero (for the subtract from the main button the old messages)
				if(iNewMessages == EBEmailAccountsConsts_CT459487.LOGIN_FAILED)
				{
					iNewMessages = 0;
				}
				else if(iOldMessages == EBEmailAccountsConsts_CT459487.LOGIN_FAILED)
				{
					iOldMessages = 0;
				}
			
				var iDiffMessages = iNewMessages - iOldMessages;
				this.UpdateButtonNewMessages(iDiffMessages);
				
			}
		}
		
		
		if(isStared)
		{
			//update image and tooltip
			this.SetToolbarButtonImageTooltip(true);
	
			//play music only if it's stared (new email)
			//and it's not the state like before 
			//only when the user got new email the first time
			if(isChanged)
			{
				//check if to play the sound
				this.CheckNewEMailPlaySound();
			}
		}
		
		if(isChanged)
		{
			//write the changes to the accounts file:
			this.AccountsCollectionToAccountsFile(this.MailAccountsCollection);
			//broadcast to all elements
			this.BroadcastChangesToAllBrowsers();
		}
		
	},
	
	
	CheckPreviousAccount : function(objXULMenuItem)
	{
		var objMenuItemsMailAccounts	= this.GetMenuItemsMailAccounts();
		var objMenuItemMailAccount		= null;
		var objAccountData				= null;
		
		var iIndex						= this.GetMenuItemAccountIndex(objXULMenuItem);
		var iAccountsLength				= this.MailAccountsCollection.Arr.length;
		
		var iPreviousIndex = iIndex - 1;
		
		if(iPreviousIndex >= 0)
		{
			objMenuItemMailAccount	= objMenuItemsMailAccounts.item(iPreviousIndex);
			objAccountData			= this.MailAccountsCollection.GetItem(iPreviousIndex);
			
			this.CheckToolbarMenuItemMailAccount(objMenuItemMailAccount,objAccountData);
		}
		else
		{
			//check if there is new message to update the button
			//if there is no new messages we also need to update the button to be
			//not stared in case it was stared before and now there is no msg and need
			//to be stared off
			var bIsToStared = this.IsThereIsNewMessages();
			this.SetToolbarButtonImageTooltip(bIsToStared);
			
		}
	},
	
	//check from all the accounts if there is one that there is new message
	IsThereIsNewMessages : function()
	{
		var oCollection = this.MailAccountsCollection;
		if(oCollection)
		{
			var arrAccounts = oCollection.Arr;
			var oAccount = null;
			for(var i=0;i<arrAccounts.length;i++)
			{
				oAccount = oCollection.GetItem(i);
				if(oAccount.Stared)
				{
					return true;
				}
			}
		}
		
		return false;
	},
	
	//set the changes from the file to all open browsers
	BroadcastChangesToAllBrowsers : function()
	{
		var objWindowsManager = Components.classes['@mozilla.org/appshell/window-mediator;1']
						.getService(Components.interfaces.nsIWindowMediator);
		
		var objEnumerator = objWindowsManager.getEnumerator('navigator:browser');	
		while(objEnumerator.hasMoreElements()) 
		{
			var objWindow = objEnumerator.getNext();
			if(objWindow != window)
			{
				if(objWindow.EBEMailNotifierToolbarManager_CT459487.RebuildMailAccountsFromFile)
				{
					//try-catch to avoid other browsers when they email notifier
					//is hidden so the xul elements not loaded and it can cause an exception
					try
					{
						objWindow.EBEMailNotifierToolbarManager_CT459487.RebuildMailAccountsFromFile();
					}
					catch(ex){}
				}
			}
		}
	},
	
	RebuildMailAccountsFromFile : function()
	{
		this.MailAccountsCollection = this.AccountsFileToAccountsCollection();
		this.RemoveToolbarMailAccounts();
		this.BuildToolbarMailAccounts();	
	},
	
	SetTimeoutAccountsCheck : function()
	{
		var iIntervalTime = this.GetCheckAccountIntervalTime();
		
		var objIntervalFunction = function()
		{
			EBEMailNotifierToolbarManager_CT459487.CheckToolbarMenuItemsMailAccounts(false);
		};
	
		this.ClearMailAccountsTimeoutID();
		
		this.TimeoutID = setTimeout(objIntervalFunction,iIntervalTime);		
	},	

	GetCheckAccountIntervalTime : function()
	{
		var iMinutes = EBEMailNotifierConsts_CT459487.DefaultIntervalMinutes;
		//check from the prefs and if there isn't take the default from the button settings definition
		var oEmailNotifierToolbarButton = EBComponentsManager_CT459487.GetEMailNotifierToolbarButton();
		if(oEmailNotifierToolbarButton)
		{
			iMinutes = oEmailNotifierToolbarButton.getAttribute(EBEMailNotifierConsts_CT459487.Attributes.CHECK_NEW_EMAIL_INTERVAL);
			var iMinutesFromPref = this.GetCheckIntervalPref();
			if(iMinutesFromPref && isFinite(iMinutesFromPref))
			{
				iMinutes = iMinutesFromPref;
			}
		}
		return iMinutes*60*1000;
	},
	
	OnCommandMenuItemMailAccount : function(event)
	{
		var objXULMenuItem = event.target;
		
		var strEMail		= objXULMenuItem.getAttribute(EBEMailNotifierConsts_CT459487.Attributes.EMAIL);
		var strPassword		= objXULMenuItem.getAttribute(EBEMailNotifierConsts_CT459487.Attributes.PASSWORD);
		var iAccountType	= objXULMenuItem.getAttribute(EBEMailNotifierConsts_CT459487.Attributes.ACCOUNT_TYPE);
		var isAutoLogin		= objXULMenuItem.getAttribute(EBEMailNotifierConsts_CT459487.Attributes.AUTO_LOGIN);
		isAutoLogin = isAutoLogin == 'true' ? true : false;
		var strPop3Server	= objXULMenuItem.getAttribute(EBEMailNotifierConsts_CT459487.Attributes.POP3_SERVER);
		var strPop3Port		= objXULMenuItem.getAttribute(EBEMailNotifierConsts_CT459487.Attributes.POP3_PORT);
		
		var objMailAccount = EBEMailNotifierManager_CT459487.GetAccountObjectByType(iAccountType,
																			strEMail,
																			strPassword,
																			strPop3Server,
																			strPop3Port);
		
		if(objMailAccount)
		{
			if(isAutoLogin)
			{
				objMailAccount.Login(event);
			}
			else
			{
				objMailAccount.Logout(event);
			}
		}
		
		
		//request usage
		this.RequestEMailNotifierUsage(EBUsageConsts_CT459487.EMAIL_NOTIFIER_OPEN_ACCOUNT,'');
		
	},
	
	GetXULToolbarMenuPopup : function()
	{
		var oEmailNotifierToolbarButton = EBComponentsManager_CT459487.GetEMailNotifierToolbarButton();
		var oXULMenuPopup = oEmailNotifierToolbarButton.firstChild;
		return oXULMenuPopup;
	},
	
	OnMainPopupShowing : function(event)
	{
		if(event.eventPhase == 2)
		{
			var iNumOfAccunts = 0;
			
			if(this.MailAccountsCollection && this.MailAccountsCollection.Arr)
			{
				iNumOfAccunts = this.MailAccountsCollection.Arr.length;
			}
			
			this.RequestEMailNotifierUsage(EBUsageConsts_CT459487.EMAIL_NOTIFIER_MENU_OPEN,iNumOfAccunts);
		}
	},
	
	RequestEMailNotifierUsage : function(strParam1,strParam2)
	{
		
		var strComponentID = EBComponentsConsts_CT459487.ComponentsID.EMailNotifier;
		
		//create the usage object
		var objUsage = new EBUsageObject_CT459487(strComponentID,
													EBUsageConsts_CT459487.EMAIL_NOTIFIER,
													strParam1,
													strParam2);
		//send the data
		objUsage.SendRequest();
	},
	
	ShowHideSeparatorCheckMenuItems : function(isHide)
	{
		var objXULToolbarSeparatorItem	= this.GetXULToolbarSeparatorItem();
		var objXULToolbarCheckMenuItem	= this.GetXULToolbarCheckForNewEMailMenuItem();
		
		if(isHide)
		{
			objXULToolbarSeparatorItem.setAttribute('style','display:none;');
			objXULToolbarCheckMenuItem.setAttribute('style','display:none;');
		}
		else
		{
			objXULToolbarSeparatorItem.removeAttribute('style');
			objXULToolbarCheckMenuItem.removeAttribute('style');
		}
	},
	
	//the separator that separates between the accounts and the configuration
	GetXULToolbarSeparatorItem : function()
	{
		var objXULMenuPopup = this.GetXULToolbarMenuPopup();
		return objXULMenuPopup.childNodes[objXULMenuPopup.childNodes.length - 3];
	},
	
	GetXULToolbarCheckForNewEMailMenuItem : function()
	{
		var objXULMenuPopup = this.GetXULToolbarMenuPopup();
		return objXULMenuPopup.childNodes[objXULMenuPopup.childNodes.length - 2];
	},
	
	UpdateButtonNewMessages : function(iNewMessages)
	{
		var iCurrentTotalNewMessages = this.GetToolbarButtonTotalNewMessages();
		iCurrentTotalNewMessages += parseInt(iNewMessages);
		
		if(iCurrentTotalNewMessages < 0)
		{
			iCurrentTotalNewMessages = 0;
		}
		this.SetToolbarButtonCaption(iCurrentTotalNewMessages);
	},
	
	SetToolbarButtonCaption : function(iNewMessages)
	{
		var oEmailNotifierToolbarButton = EBComponentsManager_CT459487.GetEMailNotifierToolbarButton();
		if(oEmailNotifierToolbarButton)
		{
			var strCaption = '[' + iNewMessages + ' new]';
			oEmailNotifierToolbarButton.setAttribute('label',strCaption);
			oEmailNotifierToolbarButton.setAttribute(EBEMailNotifierConsts_CT459487.Attributes.TOTAL_NEW_MESSAGES,iNewMessages);
		}
	},
	
	GetToolbarButtonTotalNewMessages : function()
	{
		var iTotalNewMessages = 0;
		var oEmailNotifierToolbarButton = EBComponentsManager_CT459487.GetEMailNotifierToolbarButton();
		if(oEmailNotifierToolbarButton)
		{
			var strTotalNewMessages = oEmailNotifierToolbarButton.getAttribute(EBEMailNotifierConsts_CT459487.Attributes.TOTAL_NEW_MESSAGES);
			iTotalNewMessages		= parseInt(strTotalNewMessages);
		}
		
		return iTotalNewMessages;
	},
	
	SetToolbarButtonDefaulCaption : function()
	{
		var oEmailNotifierToolbarButton = EBComponentsManager_CT459487.GetEMailNotifierToolbarButton();
		if(oEmailNotifierToolbarButton)
		{
			var strDefaultCaption = oEmailNotifierToolbarButton.getAttribute(EBEMailNotifierConsts_CT459487.Attributes.DEFAULT_CAPTION);
			oEmailNotifierToolbarButton.setAttribute('label',strDefaultCaption);
		}
	},
	
	
	SetToolbarButtonImageTooltip : function(isStared)
	{
		var oEmailNotifierToolbarButton = EBComponentsManager_CT459487.GetEMailNotifierToolbarButton();
		if(oEmailNotifierToolbarButton)
		{
			var strImage = EBEMailNotifierConsts_CT459487.Images.EMailImage;
			var strTooltip = oEmailNotifierToolbarButton.getAttribute(EBEMailNotifierConsts_CT459487.Attributes.DEFAULT_TOOLTIP);
			
			this.ButtonStared = isStared;
			if(isStared)
			{	
				var strStaredSettingsImage = oEmailNotifierToolbarButton.getAttribute(EBEMailNotifierConsts_CT459487.Attributes.STARED_ICON_URL);
				if(strStaredSettingsImage == '')
				{
					strImage = EBEMailNotifierConsts_CT459487.Images.EMailNewImage;
				}
				else
				{
					strImage = strStaredSettingsImage;
				}
				
				strTooltip = oEmailNotifierToolbarButton.getAttribute(EBEMailNotifierConsts_CT459487.Attributes.STARED_TOOLTIP);	
			}
			oEmailNotifierToolbarButton.setAttribute('image',strImage);
			
			//ask if has attribute not to ruin the  tooltip shrink 
			if(oEmailNotifierToolbarButton.hasAttribute('tooltiptext'))
			{
				oEmailNotifierToolbarButton.setAttribute('tooltiptext',strTooltip);
			}
		}
	},
	
	GetMailAccountFullCaption : function(objAccountData)
	{
		var iNewMessages	= objAccountData.NewMessages;
		var strAccountName	= objAccountData.AccountName;
		var strCaption		= strAccountName;
		
		if(iNewMessages >= 0)
		{
			strCaption += ' [' + iNewMessages + ' new] ';
		}
		else if(iNewMessages == EBEmailAccountsConsts_CT459487.LOGIN_FAILED)
		{
			strCaption = this.GetMailAccountFailedCaption(strAccountName);
		}
		return strCaption;
	},
	
	GetMailAccountFailedCaption : function(strName)
	{
		var strCaption = strName + ' [Failed]';
		return strCaption;	
	},
	
	GetMailAccountImage : function(objAccountData)
	{
		var strImage = '';
		if(objAccountData.Stared)
		{
			strImage = EBEMailNotifierConsts_CT459487.Images.StarImage;
		}
		else if(objAccountData.NewMessages == EBEmailAccountsConsts_CT459487.LOGIN_FAILED)
		{
			strImage = EBEMailNotifierConsts_CT459487.Images.X_Image;
		}
		else
		{
			strImage = EBEMailNotifierConsts_CT459487.Images.BlankImage;
		}
		
		return 	strImage;
	},

	CreateEMailNotifierToolbarFile : function(strPath)
	{
		var strEMailNotifierPath = EBEMailNotifierConsts_CT459487.EMailNotifierDirectory + EBDirIO_CT459487.sep + strPath;
		var objFile = EBIOManager_CT459487.CreateToolbarFile(strEMailNotifierPath);
		return objFile; 
	},
	
	GetToolbarAccountsXMLFile : function()
	{
		var objAccountsFile = this.CreateEMailNotifierToolbarFile(EBEMailNotifierConsts_CT459487.EMailNotifierAccountsFileName);
		return objAccountsFile;
	},
	
	CheckNewEMailPlaySound : function()
	{
		if(this.Sound && 
			this.Sound != EBEMailNotifierConsts_CT459487.Sound.NONE)
		{
			var strSoundFilePath = '';
			if(this.Sound == EBEMailNotifierConsts_CT459487.Sound.DEFAULT)
			{
				strSoundFilePath = EBEMailNotifierConsts_CT459487.Sound.DefaultWavChromePath;
			}
			else
			{
				strSoundFilePath = this.Sound;
			}
			EBGlobalManager_CT459487.PlaySound(strSoundFilePath);
		}
	},	
	
	SetCurrentSound : function()
	{
		this.Sound = this.GetSoundPref();
	},
	
	GetSoundPrefName : function()
	{
		var strPrefName = EBPreferenceConsts_CT459487.EMailNotifierSound;
		return strPrefName;	
	},
	
	SaveSoundPref : function(strSound)
	{
		var strSoundPrefName = this.GetSoundPrefName();
		EBToolbarPreferenceManager_CT459487.SetPref(strSoundPrefName,strSound);
	},
	
	GetSoundPref : function()
	{
		var strSoundPrefName = this.GetSoundPrefName();
		
		var strSound = '';
		if(!EBToolbarPreferenceManager_CT459487.HasUserValue(strSoundPrefName))
		{
			strSound = EBEMailNotifierConsts_CT459487.Sound.NONE;
		}
		else
		{
			strSound = EBToolbarPreferenceManager_CT459487.GetPref(strSoundPrefName);
		}
		
		return strSound;
	},
	
	GetCheckIntervalPrefName : function()
	{
		var strPrefName = EBPreferenceConsts_CT459487.EMailNotifierCheckInterval;
		return strPrefName;	
	},
	
	SaveCheckIntervalPref : function(iMinutesValue)
	{
		var strCheckIntervalPrefName = this.GetCheckIntervalPrefName();
		EBToolbarPreferenceManager_CT459487.SetPref(strCheckIntervalPrefName,iMinutesValue);	
	},
	
	GetCheckIntervalPref : function()
	{
		var strCheckIntervalPrefName = this.GetCheckIntervalPrefName();
		var iMinutesValue = EBToolbarPreferenceManager_CT459487.GetPref(strCheckIntervalPrefName);
		
		return iMinutesValue;
	},
	
	
	AccountsFileToAccountsCollection : function()
	{
		var objAccountsCollection	= new EBArrayCollection_CT459487();
		
		var strContent		= this.LoadAccountsFile();
		
		if(!strContent)
		{
			return objAccountsCollection;
		}
		
		var XMLDoc			= EBGlobalManager_CT459487.GetXmlDocument(strContent);
		var XMLRoot			= XMLDoc.documentElement;
	
		var objAccountData			= null;
		
		if(XMLRoot.tagName == EBEMailNotifierConsts_CT459487.XML.ACCOUNTS)
		{
			var objXMLAccounts	= XMLRoot.getElementsByTagName(EBEMailNotifierConsts_CT459487.XML.ACCOUNT);
			var objXMLAccount	= null;
			var objXMLNode		= null;
			
			var strName			= '';
			var strEMail		= '';
			var strPassword		= '';
			var strServer		= '';
			var iPort			= 0;
			var iType			= -1;
			var isAutoLogin		= true;
			var isStared		= false;
			var iNewMessages	= 0;
			
			for(var i=0;i<objXMLAccounts.length;i++)
			{
				var objXMLAccount = objXMLAccounts.item(i);
				for(var j=0;j<objXMLAccount.childNodes.length;j++)
				{
					objXMLNode = objXMLAccount.childNodes[j];
					if(objXMLNode.tagName == EBEMailNotifierConsts_CT459487.XML.NAME)
					{
						strName = EBGlobalManager_CT459487.GetXmlNodeValue(objXMLNode);
					}
					else if(objXMLNode.tagName == EBEMailNotifierConsts_CT459487.XML.EMAIL)
					{
						strEMail = EBGlobalManager_CT459487.GetXmlNodeValue(objXMLNode);
					}
					else if(objXMLNode.tagName == EBEMailNotifierConsts_CT459487.XML.PASSWORD)
					{
						strPassword = EBGlobalManager_CT459487.GetXmlNodeValue(objXMLNode);
					}
					else if(objXMLNode.tagName == EBEMailNotifierConsts_CT459487.XML.SERVER)
					{
						strServer = EBGlobalManager_CT459487.GetXmlNodeValue(objXMLNode);
					}
					else if(objXMLNode.tagName == EBEMailNotifierConsts_CT459487.XML.PORT)
					{
						iPort = EBGlobalManager_CT459487.GetXmlNodeValue(objXMLNode);
					}
					else if(objXMLNode.tagName == EBEMailNotifierConsts_CT459487.XML.TYPE)
					{
						iType = EBGlobalManager_CT459487.GetXmlNodeValue(objXMLNode);
					}
					else if(objXMLNode.tagName == EBEMailNotifierConsts_CT459487.XML.AUTO_LOGIN)
					{
						var strIsLogin = EBGlobalManager_CT459487.GetXmlNodeValue(objXMLNode);
						isAutoLogin = strIsLogin == 'true' ? true : false;
					}
					else if(objXMLNode.tagName == EBEMailNotifierConsts_CT459487.XML.STARED)
					{
						var strIsStared = EBGlobalManager_CT459487.GetXmlNodeValue(objXMLNode);
						isStared = strIsStared == 'true' ? true : false;
					}
					else if(objXMLNode.tagName == EBEMailNotifierConsts_CT459487.XML.NEW_MESSAGES)
					{
						iNewMessages = EBGlobalManager_CT459487.GetXmlNodeValue(objXMLNode);
					}
					
				}
				
				objAccountData = new EBEMailAccountDataObject_CT459487(strName,
															strEMail,
															strPassword,
															iType,
															isAutoLogin,
															isStared,
															iNewMessages,
															strServer,
															iPort);
				
				objAccountsCollection.AppendElement(objAccountData);
			}
		}
		
		return objAccountsCollection;
	},
	
	AccountsCollectionToAccountsFile : function(objAccountsCollection)
	{
		var strRootXML = '<' + EBEMailNotifierConsts_CT459487.XML.ACCOUNTS + '></' + EBEMailNotifierConsts_CT459487.XML.ACCOUNTS + '>'
		var XMLDoc = EBGlobalManager_CT459487.GetXmlDocument(strRootXML);
		
		var XMLRoot = XMLDoc.documentElement;
		
		var XMLNodeAccount		= null;
		var XMLNodeName			= null;
		var XMLNodeEMail		= null;
		var XMLNodePassword		= null;
		var XMLNodeServer		= null;
		var XMLNodePort			= null;
		var XMLNodeType			= null;
		var XMLNodeAutoLogin	= null;
		var XMLNodeStared		= null;
		var XMLNodeNewMessages	= null;
		
		var arrAccounts = objAccountsCollection.Arr;
		
		for(var i=0;i<arrAccounts.length;i++)
		{
			XMLNodeAccount		= XMLDoc.createElement(EBEMailNotifierConsts_CT459487.XML.ACCOUNT);
			
			XMLNodeName			= EBGlobalManager_CT459487.CreateXmlTextNode(XMLDoc,
																	EBEMailNotifierConsts_CT459487.XML.NAME,
																	arrAccounts[i].AccountName);
			XMLNodeEMail		= EBGlobalManager_CT459487.CreateXmlTextNode(XMLDoc,
																	EBEMailNotifierConsts_CT459487.XML.EMAIL,
																	arrAccounts[i].EMailAddress);
			XMLNodePassword		= EBGlobalManager_CT459487.CreateXmlTextNode(XMLDoc,
																	EBEMailNotifierConsts_CT459487.XML.PASSWORD,
																	arrAccounts[i].Password);												
			XMLNodeServer 		= EBGlobalManager_CT459487.CreateXmlTextNode(XMLDoc,
																	EBEMailNotifierConsts_CT459487.XML.SERVER,
																	arrAccounts[i].Pop3Server);
			XMLNodePort 		= EBGlobalManager_CT459487.CreateXmlTextNode(XMLDoc,
																	EBEMailNotifierConsts_CT459487.XML.PORT,
																	arrAccounts[i].Pop3Port);
			XMLNodeType			= EBGlobalManager_CT459487.CreateXmlTextNode(XMLDoc,
																	EBEMailNotifierConsts_CT459487.XML.TYPE,
																	arrAccounts[i].AccountType);
			XMLNodeAutoLogin	= EBGlobalManager_CT459487.CreateXmlTextNode(XMLDoc,
																	EBEMailNotifierConsts_CT459487.XML.AUTO_LOGIN,
																	arrAccounts[i].AutoLogin);
			XMLNodeStared		= EBGlobalManager_CT459487.CreateXmlTextNode(XMLDoc,
																	EBEMailNotifierConsts_CT459487.XML.STARED,
																	arrAccounts[i].Stared);
			XMLNodeNewMessages	= EBGlobalManager_CT459487.CreateXmlTextNode(XMLDoc,
																	EBEMailNotifierConsts_CT459487.XML.NEW_MESSAGES,
																	arrAccounts[i].NewMessages);
			XMLNodeAccount.appendChild(XMLNodeName);
			XMLNodeAccount.appendChild(XMLNodeEMail);
			XMLNodeAccount.appendChild(XMLNodePassword);
			XMLNodeAccount.appendChild(XMLNodeServer);
			XMLNodeAccount.appendChild(XMLNodePort);
			XMLNodeAccount.appendChild(XMLNodeType);
			XMLNodeAccount.appendChild(XMLNodeAutoLogin);
			XMLNodeAccount.appendChild(XMLNodeStared);
			XMLNodeAccount.appendChild(XMLNodeNewMessages);
			
			XMLRoot.appendChild(XMLNodeAccount);
		}
		
		var strXML = EBGlobalManager_CT459487.GetStringXml(XMLDoc);
		
		this.SaveAccountsFile(strXML);
	},
	
	SaveAccountsFile : function(strXMLContent)
	{
		var objAccountsFile = this.GetToolbarAccountsXMLFile();
		
		//encrypt the data
		var strEncryptContent = EBTEAEncryptionManager_CT459487.TEAencrypt(strXMLContent,EBEMailNotifierConsts_CT459487.EncryptionPass);
		
		//write the data to the accounts xml file
		EBFileIO_CT459487.write(objAccountsFile, strEncryptContent,"",EBGlobalConsts_CT459487.DefaultCharset);	
	},
	
	LoadAccountsFile : function()
	{
		var strXMLContent = '';
		var objAccountsFile	  = this.GetToolbarAccountsXMLFile();
		var strEncryptContent = EBFileIO_CT459487.read(objAccountsFile,EBGlobalConsts_CT459487.DefaultCharset);
		
		//check if this data is encrypted first(for older version of the toolabr - before we encrypted the data).
		if(strEncryptContent)
		{
			//try to load it to an xml first
			var XMLDoc = EBGlobalManager_CT459487.GetXmlDocument(strEncryptContent);
			var XMLRoot = XMLDoc.documentElement;
			if(XMLRoot.tagName == 'parsererror')
			{
				//try to decrypt the data
				strXMLContent = EBTEAEncryptionManager_CT459487.TEAdecrypt(strEncryptContent,EBEMailNotifierConsts_CT459487.EncryptionPass);
			}
			else if(XMLRoot.tagName == EBEMailNotifierConsts_CT459487.XML.ACCOUNTS)
			{
				strXMLContent = strEncryptContent;
			}
			
		}
		
		
		return strXMLContent;
	}
	
	
}
