//Helper functions and objects
var EBServerDataURL = 
{
	ServerRequest : function(strURL,strPostData,strUserName,strPassword,ServerResponseFunction)
	{
		var objIOService	= Components.classes["@mozilla.org/network/io-service;1"].createInstance(Components.interfaces.nsIIOService);
		var objURI			= objIOService.newURI(strURL, null, null);
		
		if(strUserName != null && strPassword != null)
		{
			objURI.username		= strUserName;
			objURI.password		= strPassword;
		}
	    
		var objChannel		= objIOService.newChannelFromURI(objURI);
		
		objChannel.QueryInterface(Components.interfaces.nsIHttpChannel).setRequestHeader('PRAGMA','NO-CACHE',false);
		objChannel.QueryInterface(Components.interfaces.nsIHttpChannel).setRequestHeader('CACHE-CONTROL','NO-CACHE',false);

	    
		if(strPostData != null) 
		{
			var objUploadStream		= Components.classes["@mozilla.org/io/string-input-stream;1"].createInstance(Components.interfaces.nsIStringInputStream);
			objUploadStream.setData(strPostData, strPostData.length);
		      
			var objUploadChannel	= objChannel.QueryInterface(Components.interfaces.nsIUploadChannel);
			objUploadChannel.setUploadStream(objUploadStream, "application/x-www-form-urlencoded", -1);
		      
			objChannel.QueryInterface(Components.interfaces.nsIHttpChannel).requestMethod = "POST";
			
			
		}
		
		
		
		
	    var objObserver = new this.Observer(ServerResponseFunction);
		objChannel.asyncOpen(objObserver, null);
	},
	
	Observer: function(ServerResponseFunction)
	{
		return ({
					Data : "",
				    
					onStartRequest: function(aRequest, aContext)
					{
						this.Data = "";
					},
				    
					onStopRequest: function(aRequest, aContext, aStatus)
					{
						if(ServerResponseFunction)
						{
							ServerResponseFunction(this.Data, aRequest);
						}
					},
					    
					onDataAvailable: function(aRequest, aContext, aStream, aSourceOffset, aLength)
					{
						var objScriptableInputStream = Components.classes["@mozilla.org/scriptableinputstream;1"].createInstance(Components.interfaces.nsIScriptableInputStream);
						objScriptableInputStream.init(aStream);
						this.Data += objScriptableInputStream.read(aLength);
					}
				});
	}
}

function decodeUtf8(utftext) 
{
    var string = "";
    var i = 0;
    var c = c1 = c2 = 0;

    while ( i < utftext.length ) 
    {

        c = utftext.charCodeAt(i);

        if (c < 128) {
            string += String.fromCharCode(c);
            i++;
        }
        else if((c > 191) && (c < 224)) {
            c2 = utftext.charCodeAt(i+1);
            string += String.fromCharCode(((c & 31) << 6) | (c2 & 63));
            i += 2;
        }
        else {
            c2 = utftext.charCodeAt(i+1);
            c3 = utftext.charCodeAt(i+2);
            string += String.fromCharCode(((c & 15) << 12) | ((c2 & 63) << 6) | (c3 & 63));
            i += 3;
        }

    }

    return string;
}

function setTimeout(objDeligate, iTimeout)
{
    var timer = Components.classes['@mozilla.org/timer;1'].
                    createInstance(Components.interfaces.nsITimer);
    timer.initWithCallback(objDeligate, iTimeout, Components.interfaces.nsITimer.TYPE_ONE_SHOT); 
}


//XPCOM
function ConduitAutoCompleteSearch() {
	this.commands = [];
}

ConduitAutoCompleteSearch.prototype = {
	lastSuggetTimestamp : '',
	searchString    : '',
	
	startSearch: function(searchString, strSuggestUrl, prevResult, listener) {
		this.requestSuggestions(searchString,listener,strSuggestUrl);
	},

	stopSearch: function() {
	},
	
	requestSuggestions : function(searchString,listener,strSuggestUrl)
	{
		//no suggestions for this engine
		this.searchString  = searchString;
		if(!strSuggestUrl || !searchString)
		{ 
		    //load local history only
		    this.setSuggestionsAndHistory(searchString,null,listener);
		    return;
		}
		
		//go get suggestions
		var now = Date.parse(Date());
		var arrSuggestUrl           = strSuggestUrl.split('!!');
		    strSuggestUrl           = arrSuggestUrl[0];
		var strSearchTermToReplace  = arrSuggestUrl[1];
		
		strSuggestUrl = strSuggestUrl.replace(strSearchTermToReplace,escape(searchString));
		var objFunc     = this;
		
		var oResponse   = function(strJSON)
		{
		    objFunc.setSuggestionsAndHistory(searchString,strJSON,listener);
		};
		
		var oRequest = 
		{
		    originalSearchString : searchString,
		    
		    notify : function(oTimer)
		    {
		        if(this.originalSearchString == objFunc.searchString)
		            this.execute();
		    },
		    
		    execute : function()
		    {
		        EBServerDataURL.ServerRequest(strSuggestUrl,null,null,null,oResponse);
		    },
		};
		
		setTimeout(oRequest,300);
	},

	setSuggestionsAndHistory: function(searchString,strJSON,listener) {
		
		var dir = null;
		var bLoadHistory = true;
		
		try 
		{
			var dir = Components.classes['@mozilla.org/file/directory_service;1']
									.createInstance(Components.interfaces.nsIProperties)
									.get('ProfD', Components.interfaces.nsIFile);
		
		    var sep = '/';
		    var path = dir.path + sep + 'EBSuggestHistory';
    		
		    try 
		    {
			    var ebDir = Components.classes['@mozilla.org/file/local;1']
						    .createInstance(Components.interfaces.nsILocalFile);
			    ebDir.initWithPath(path);
		    }
		    catch(e) 
		    { 
			    sep = '\\';
			    path = dir.path + sep + 'EBSuggestHistory';
			    try 
			    {
				    var ebDir = Components.classes['@mozilla.org/file/local;1']
							    .createInstance(Components.interfaces.nsILocalFile);
				    ebDir.initWithPath(path);
			    } catch(e) {}
		    }
    		
		    var file = Components.classes['@mozilla.org/file/local;1']
						    .createInstance(Components.interfaces.nsILocalFile);
		    
		    file.initWithPath(ebDir.path + sep + 'search_history.xml');
		    
		    var data     = new String();
    		
		    var fiStream = Components.classes['@mozilla.org/network/file-input-stream;1']
				    .createInstance(Components.interfaces.nsIFileInputStream);
    		
		    var siStream = Components.classes['@mozilla.org/scriptableinputstream;1']
				    .createInstance(Components.interfaces.nsIScriptableInputStream);

		    fiStream.init(file, 1, 0, false);
		    siStream.init(fiStream);
		    data += siStream.read(-1);
		    siStream.close();
		    fiStream.close();

		    var uniConv = Components.classes['@mozilla.org/intl/scriptableunicodeconverter']
				    .createInstance(Components.interfaces.nsIScriptableUnicodeConverter);
		    uniConv.charset = 'UTF-8';
		    data = uniConv.ConvertToUnicode(data);
		}
		catch(e) 
		{
		    bLoadHistory = false;
		}
		
		if(bLoadHistory)
		{
		    var parser = Components.classes['@mozilla.org/xmlextras/domparser;1']
						    .createInstance(Components.interfaces.nsIDOMParser);
    		
		    var xmlDoc		= parser.parseFromString(data, "text/xml");
    		
		    var xmlItems	= xmlDoc.documentElement.getElementsByTagName('ITEM');
    		
		    var result = [];
    		
		    var nodeValue = '';
    		
		    for(var i=0; i<xmlItems.length; i++)
		    {
			    if(typeof (xmlItems.item(i).childNodes[0]) != "undefined")
			    {
				    nodeValue = xmlItems.item(i).childNodes[0].nodeValue;
				    result[result.length] = nodeValue;
			    }
		    }
    		
		    var commands = Components.classes["@mozilla.org/supports-array;1"].createInstance(Components.interfaces.nsISupportsArray);
    		
		    for (var i = 0; i < result.length; i++) 
		    {
			    var string = Components.classes["@mozilla.org/supports-string;1"].createInstance(Components.interfaces.nsISupportsString);
			    string.data = result[i];
			    commands.AppendElement(string);
		    }
    		
		    var count = commands.Count();
		    this.commands = new Array(count);
		    for (var i = 0; i < count; i++)
			    this.commands[i] = commands.GetElementAt(i).QueryInterface(Components.interfaces.nsISupportsString).data;
    		
    	}
    	
		var arrSuggest = null;
		
		if (strJSON && strJSON.length > 0)
            arrSuggest = eval("(" + strJSON + ")");
            
		var result = new AutoCompleteResult(searchString, this.commands, arrSuggest);
		
		listener.onSearchResult(this, result);
	},
	
    QueryInterface: function (uuid) {
		if (uuid.equals(Components.interfaces.nsIConduitAutoCompleteSearch) ||
			uuid.equals(Components.interfaces.nsIAutoCompleteSearch) ||
			uuid.equals(Components.interfaces.nsISupports)) {
			return this;
		}
        
        Components.returnCode = Components.results.NS_ERROR_NO_INTERFACE;
        return null;
    }
}

function AutoCompleteResult(search, commands, arrSuggest) 
{
	var IsContains = function(arrArray, strString)
	{
	    for(var i=0; i<arrArray.length; i++)
	        if(arrArray[i] == strString)
	            return true;
	        
	    return false;
	};
	
	this.search = search;
	this.commands = [];
	var lsearch = search.toLowerCase();
	
	if(commands.length > 0)
	{
	    for (var i = 0; i < commands.length; i++) 
	    {
		    if (commands[i].toLowerCase().indexOf(lsearch) == 0)
		        this.commands.push(commands[i]);
	    }
	}
	
	this.HistoryStartIndex = this.commands.length;
	
	if(arrSuggest && search == decodeUtf8(arrSuggest[0]) && arrSuggest[1].length > 0)
	{
	    for(var i=0; i<arrSuggest[1].length; i++)
		{
		    if(!IsContains(this.commands ,arrSuggest[1][i])) 
		        this.commands.push(decodeUtf8(arrSuggest[1][i]));
		}
	}
}

AutoCompleteResult.prototype = {
	get defaultIndex() {
		return 0;
	},
	get errorDescription() {
		return '';
	},
	get matchCount() {
		return this.commands.length;
	},
	get searchResult() {
		return Components.interfaces.nsIAutoCompleteResult.RESULT_SUCCESS;
	},
	get searchString() {
		return this.search;
	},
	getCommentAt: function(index) {
		if(index == this.HistoryStartIndex)
		    return this.GetCaption('suggestCaption');
		else if(index == 0)
		    return this.GetCaption('historyCaption');
		else
		    return '';
	},
	getStyleAt: function(index) {
        if (!this.commands[index])
 	      return null;  // not a category label, so no special styling
 	
 	    if (index == 0)
 	      return "suggestfirst";  // category label on first line of results
 	
 	    if(index == this.HistoryStartIndex)
 	        return "suggesthint";
 	    
 	    return '';
	},
	getValueAt: function(index) {
		return this.commands[index];
	},
	
	removeValueAt: function(rowIndex, removeFromDb) {
	},
	/*
	getImageAt: function(index) {
 	    return "";
 	},
 	*/
 	GetCaption : function(strKey)
 	{
 	    var objHelper = null;
 	    
 	    try
        {
            var objHelper = Components.classes["@conduit.com/helper;1"]
                                    .getService(Components.interfaces.nsIConduit);
            
        }
        catch(e) {}
        
        if(objHelper)
            return objHelper.retrieveKey('Common',strKey);

 	},
 	
    QueryInterface: function (uuid) {
		if (uuid.equals(Components.interfaces.nsIAutoCompleteResult) ||
			uuid.equals(Components.interfaces.nsISupports)) {
			return this;
		}
        Components.returnCode = Components.results.NS_ERROR_NO_INTERFACE;
        return null;
    }
}

const COMPONENT_ID = Components.ID("{C3123F1F-59BD-477a-977D-A55C1836A21C}");

var ConduitAutoCompleteModule = {
    registerSelf: function (compMgr, fileSpec, location, type) {
        compMgr = compMgr.QueryInterface(Components.interfaces.nsIComponentRegistrar);
        compMgr.registerFactoryLocation(COMPONENT_ID,
                                        "Conduit Auto Complete with Suggest",
                                        "@mozilla.org/autocomplete/search;1?name=conduit-auto-complete-with-suggest",
                                        fileSpec,
                                        location,
                                        type);
    },

    getClassObject: function (compMgr, cid, iid) {
        if (!cid.equals(COMPONENT_ID))
            throw Components.results.NS_ERROR_NO_INTERFACE;
        if (!iid.equals(Components.interfaces.nsIFactory))
            throw Components.results.NS_ERROR_NOT_IMPLEMENTED;

		return ConduitAutoCompleteFactory;
    },

    canUnload: function(compMgr) {
        return true;
    }
};

var ConduitAutoCompleteFactory = {
	createInstance: function (outer, iid) {
		if (outer != null)
			throw Components.results.NS_ERROR_NO_AGGREGATION;
		return new ConduitAutoCompleteSearch().QueryInterface(iid);
	}
};

function NSGetModule(compMgr, fileSpec) {
    return ConduitAutoCompleteModule;
}

