//XPCOM
function ConduitHelperObject() {
	this.Data = new Array();
}

ConduitHelperObject.prototype = {
    
    storeKey : function(strCTID, strKey, strValue)
    {
        if(!this.Data[strCTID])
            this.Data[strCTID] = new Array();
            
        this.Data[strCTID][strKey] = strValue;
    },
    
    retrieveKey : function(strCTID, strKey)
    {
        return this.Data[strCTID][strKey];
    },
    
    deleteKey : function(strCTID, strKey)
    {
        delete this.Data[strCTID][strKey];
    },
    
    QueryInterface: function (uuid) {
		if (uuid.equals(Components.interfaces.nsIConduit) ||
			uuid.equals(Components.interfaces.nsISupports)) {
			return this;
		}
        
        Components.returnCode = Components.results.NS_ERROR_NO_INTERFACE;
        return null;
    }
}

const COMPONENT_ID = Components.ID("{B009C480-CA54-4483-BA59-5505DD98BE40}");

var ConduitHelperObjectModule = {
    registerSelf: function (compMgr, fileSpec, location, type) {
        compMgr = compMgr.QueryInterface(Components.interfaces.nsIComponentRegistrar);
        compMgr.registerFactoryLocation(COMPONENT_ID,
                                        "Conduit Helper Object",
                                        "@conduit.com/helper;1",
                                        fileSpec,
                                        location,
                                        type);
    },

    getClassObject: function (compMgr, cid, iid) {
        if (!cid.equals(COMPONENT_ID))
            throw Components.results.NS_ERROR_NO_INTERFACE;
        if (!iid.equals(Components.interfaces.nsIFactory))
            throw Components.results.NS_ERROR_NOT_IMPLEMENTED;

		return ConduitHelperObjectFactory;
    },

    canUnload: function(compMgr) {
        return true;
    }
};

var ConduitHelperObjectFactory = {
	createInstance: function (outer, iid) {
		if (outer != null)
			throw Components.results.NS_ERROR_NO_AGGREGATION;
		return new ConduitHelperObject().QueryInterface(iid);
	}
};

function NSGetModule(compMgr, fileSpec) {
    return ConduitHelperObjectModule;
}


