
//the xml tag names of the weather data
var EBWeatherXMLConsts_CT459487 = 
{
	//Server XML
	SEARCH					: 'SEARCH',
	SUGGESTIONS				: 'SUGGESTIONS',
	SUGGESTION				: 'SUGGESTION',
	CITY					: 'CITY',
	COUNTRY					: 'COUNTRY',
	LOCATION_ID				: 'LOCATION_ID',
	FORECAST				: 'FORECAST',
	DAYS					: 'DAYS',
	DAY						: 'DAY',
	DATE					: 'DATE',
	F_MIN					: 'F_MIN',
	F_MAX					: 'F_MAX',
	C_MIN					: 'C_MIN',
	C_MAX					: 'C_MAX',
	CONDITION_DESCRIPTION	: 'CONDITION_DESCRIPTION',
	CONDITION_ICON			: 'CONDITION_ICON',
	CURRENT_CONDITION		: 'CURRENT_CONDITION',
	TEMP_F					: 'TEMP_F',
	TEMP_C					: 'TEMP_C',
	WEATHER_TEXT			: 'WEATHER_TEXT',
	SKY						: 'SKY',
	FEELS_LIKE_F			: 'FEELS_LIKE_F',
	FEELS_LIKE_C			: 'FEELS_LIKE_C',
	ICON					: 'ICON',
	BUTTON_ICON				: 'BUTTON_ICON',
	TOOLTIP_ICON			: 'TOOLTIP_ICON',
	
	NORESULTS				: 'NORESULTS'
	
}

var EBWeatherUnits_CT459487 = 
{
	TEMPERATURE_F : 'F',
	TEMPERATURE_C : 'C'
}


//The data structure of the weather data.
//this is the same structure hierarchy as the xml have from the server
//every data class define the XMLSerialize function which makes the object
//to string xml data

/***** Search Data structure *******/
function EBWeatherSuggestion_CT459487(strCity,strCountry,strLocationID)
{
	this.City		= strCity;
	this.Country	= strCountry;
	this.LocationID	= strLocationID;
	
	this.XMLSerialize = function()
	{
		var strXMLSuggestion	= EBWeatherXMLConsts_CT459487.SUGGESTION;
		var strXMLCity			= EBWeatherXMLConsts_CT459487.CITY;
		var strXMLCountry		= EBWeatherXMLConsts_CT459487.COUNTRY;
		var strXMLLocationID	= EBWeatherXMLConsts_CT459487.LOCATION_ID;
		
		var strXML = '';
		strXML +=	 '<' + strXMLSuggestion + '>';
		strXML +=		'<' + strXMLCity+ '>' + this.City + '</' + strXMLCity+ '>';
		strXML +=		'<' + strXMLCountry+ '>' + this.Country + '</' + strXMLCountry+ '>';
		strXML +=		'<' + strXMLLocationID+ '>' + this.LocationID + '</' + strXMLLocationID+ '>';
		strXML +=	'</' + strXMLSuggestion + '>';
		
		return strXML;
		
	};
}

function EBWeatherSuggestionCollection_CT459487()
{
	this.Collection = new EBArrayCollection_CT459487();
	
	this.XMLSerialize = function()
	{
		var strXMLSuggestions	= EBWeatherXMLConsts_CT459487.SUGGESTIONS;
		var strXML = '';
		strXML += '<' + strXMLSuggestions + '>';
		
		var oWeatherSuggestion = null;
		for(var i=0;i<this.Collection.Arr.length;i++)
		{
			oWeatherSuggestion = this.Collection.GetItem(i);
			strXML += oWeatherSuggestion.XMLSerialize();
		}
		
		strXML += '</' + strXMLSuggestions + '>';
		
		return strXML;
	};
}

function EBWeatherSearch_CT459487(oSuggestionCollection)
{
	this.SuggestionCollection = oSuggestionCollection;
	
	this.XMLSerialize = function()
	{
		var strXMLSearch	= EBWeatherXMLConsts_CT459487.SEARCH;
		var strXML = '';
		
		strXML += '<' + strXMLSearch + '>';
		strXML +=	this.SuggestionCollection.XMLSerialize();
		strXML += '</' + strXMLSearch + '>';
		
		return strXML;
	};
}

/***** Forecast Data structure *******/
function EBWeatherCurrentCondition_CT459487(strTempF,
												strTempC,
												strWeatherText,
												strSky,
												strFeelsLikeF,
												strFeelsLikeC,
												strIcon,
												strButtonIcon,
												strTooltipIcon)
{
	this.TempF			= strTempF;
	this.TempC			= strTempC;
	this.WeatherText	= strWeatherText;
	this.Sky			= strSky;
	this.FeelsLikeF		= strFeelsLikeF;
	this.FeelsLikeC		= strFeelsLikeC;
	this.Icon			= strIcon;
	this.ButtonIcon		= strButtonIcon;
	this.TooltipIcon	= strTooltipIcon;
	
	this.XMLSerialize = function()
	{
		var strXMLCurrentCondition	= EBWeatherXMLConsts_CT459487.CURRENT_CONDITION;
		var strXMLTempF				= EBWeatherXMLConsts_CT459487.TEMP_F;
		var strXMLTempC				= EBWeatherXMLConsts_CT459487.TEMP_C;
		var strXMLWeatherText		= EBWeatherXMLConsts_CT459487.WEATHER_TEXT;
		var strXMLSky				= EBWeatherXMLConsts_CT459487.SKY;
		var strXMLFeelsLikeF		= EBWeatherXMLConsts_CT459487.FEELS_LIKE_F;
		var strXMLFeelsLikeC		= EBWeatherXMLConsts_CT459487.FEELS_LIKE_C;
		var strXMLIcon				= EBWeatherXMLConsts_CT459487.ICON;
		var strXMLButtonIcon		= EBWeatherXMLConsts_CT459487.BUTTON_ICON;
		var strXMLTooltipIcon		= EBWeatherXMLConsts_CT459487.TOOLTIP_ICON;
	
		var strXML = '';
		strXML +=	 '<' + strXMLCurrentCondition + '>';
		strXML +=		'<' + strXMLTempF+ '>' + this.TempF + '</' + strXMLTempF+ '>';
		strXML +=		'<' + strXMLTempC+ '>' + this.TempC + '</' + strXMLTempC+ '>';
		strXML +=		'<' + strXMLWeatherText+ '>' + this.WeatherText + '</' + strXMLWeatherText+ '>';
		strXML +=		'<' + strXMLSky+ '>' + this.Sky + '</' + strXMLSky+ '>';
		strXML +=		'<' + strXMLFeelsLikeF+ '>' + this.FeelsLikeF + '</' + strXMLFeelsLikeF+ '>';
		strXML +=		'<' + strXMLFeelsLikeC+ '>' + this.FeelsLikeC + '</' + strXMLFeelsLikeC+ '>';
		strXML +=		'<' + strXMLIcon+ '>' + this.Icon + '</' + strXMLIcon+ '>';
		strXML +=		'<' + strXMLButtonIcon+ '>' + this.ButtonIcon + '</' + strXMLButtonIcon+ '>';
		strXML +=		'<' + strXMLTooltipIcon+ '>' + this.TooltipIcon + '</' + strXMLTooltipIcon+ '>';
		strXML +=	'</' + strXMLCurrentCondition + '>';
		
		return strXML;
	};
}


function EBWeatherDay_CT459487(iDayIndex,
									strDate,
									strDay,
									strFMin,
									strFMax,
									strCMin,
									strCMax,
									strConditionDescription,
									strConditionIcon)
{
	
	this.DayIndex				= iDayIndex;
	this.Date					= strDate;
	this.Day					= strDay;
	this.FMin					= strFMin;
	this.FMax					= strFMax;
	this.CMin					= strCMin;
	this.CMax					= strCMax;
	this.ConditionDescription	= strConditionDescription;
	this.ConditionIcon			= strConditionIcon;
	
	this.XMLSerialize = function()
	{
		var strXMLMainDayFullTagName	= EBWeatherXMLConsts_CT459487.DAY + this.DayIndex;
		var strXMLDate					= EBWeatherXMLConsts_CT459487.DATE;
		var strXMLDay					= EBWeatherXMLConsts_CT459487.DAY;
		var strXMLFMin					= EBWeatherXMLConsts_CT459487.F_MIN;
		var strXMLFMax					= EBWeatherXMLConsts_CT459487.F_MAX;
		var strXMLCMin					= EBWeatherXMLConsts_CT459487.C_MIN;
		var strXMLCMax					= EBWeatherXMLConsts_CT459487.C_MAX;
		var strXMLConditionDescription	= EBWeatherXMLConsts_CT459487.CONDITION_DESCRIPTION;
		var strXMLConditionIcon			= EBWeatherXMLConsts_CT459487.CONDITION_ICON;
	
		var strXML = '';
		strXML +=	 '<' + strXMLMainDayFullTagName + '>';
		strXML +=		'<' + strXMLDate+ '>' + this.Date + '</' + strXMLDate+ '>';
		strXML +=		'<' + strXMLDay+ '>' + this.Day + '</' + strXMLDay+ '>';
		strXML +=		'<' + strXMLFMin+ '>' + this.FMin + '</' + strXMLFMin+ '>';
		strXML +=		'<' + strXMLFMax+ '>' + this.FMax + '</' + strXMLFMax+ '>';
		strXML +=		'<' + strXMLCMin+ '>' + this.CMin + '</' + strXMLCMin+ '>';
		strXML +=		'<' + strXMLCMax+ '>' + this.CMax + '</' + strXMLCMax+ '>';
		strXML +=		'<' + strXMLConditionDescription+ '>' + this.ConditionDescription + '</' + strXMLConditionDescription+ '>';
		strXML +=		'<' + strXMLConditionIcon+ '>' + this.ConditionIcon + '</' + strXMLConditionIcon+ '>';
		strXML +=	'</' + strXMLMainDayFullTagName + '>';
		
		return strXML;
	};
}


function EBWeatherDayCollection_CT459487()
{
	this.Collection = new EBArrayCollection_CT459487();
	
	this.XMLSerialize = function()
	{
		var strXMLDays	= EBWeatherXMLConsts_CT459487.DAYS;
		var strXML = '';
		strXML += '<' + strXMLDays + '>';
		
		var oWeatherDay = null;
		for(var i=0;i<this.Collection.Arr.length;i++)
		{
			oWeatherDay = this.Collection.GetItem(i);
			strXML += oWeatherDay.XMLSerialize();
		}
		
		strXML += '</' + strXMLDays + '>';
		
		return strXML;
	};
}


function EBWeatherForecast_CT459487(strLocationID,oWeatherDayCollection,oWeatherCurrentCondition)
{
	this.LocationID			= strLocationID;
	this.DayCollection		= oWeatherDayCollection;
	this.CurrentCondition	= oWeatherCurrentCondition;
	
	this.XMLSerialize = function()
	{	
		var strXMLForecast		= EBWeatherXMLConsts_CT459487.FORECAST;
		var strXMLLocationID	= EBWeatherXMLConsts_CT459487.LOCATION_ID;
		var strXML = '';
		strXML += '<' + strXMLForecast + '>';
		strXML +=		'<' + strXMLLocationID+ '>' + this.LocationID + '</' + strXMLLocationID+ '>';
		strXML +=		this.DayCollection.XMLSerialize();
		strXML +=		this.CurrentCondition.XMLSerialize();
		strXML += '</' + strXMLForecast + '>';
		
		return strXML;
	};	
}

//manager class that responsible to convert string xml to the 
//weather data object correspondingly
var EBWeatherDataFactory_CT459487 = 
{
	XMLToWeatherSearch : function(XMLDoc)
	{
		var oWeatherSearch			= null;
		var oSuggestionCollection	= null;
		var strXMLSearch			= EBWeatherXMLConsts_CT459487.SEARCH;
		var strXMLSuggestions		= EBWeatherXMLConsts_CT459487.SUGGESTIONS;
		
		
		var XMLRoot			= XMLDoc.documentElement;
		var XMLChildNode	= null;
		if(XMLRoot.tagName == strXMLSearch)
		{
			for(var i=0;i<XMLRoot.childNodes.length;i++)
			{
				XMLChildNode = XMLRoot.childNodes[i];
				if(XMLChildNode.tagName == strXMLSuggestions)
				{
					oSuggestionCollection = this.XMLToWeatherSuggestionCollection(XMLChildNode);
				}
			}
			
			if(oSuggestionCollection)
			{
				oWeatherSearch = new EBWeatherSearch_CT459487(oSuggestionCollection)
			}
		}
		
		return oWeatherSearch;
	},	
	
	XMLToWeatherSuggestionCollection : function(XMLNode)
	{
		var oWeatherSuggestionCollection	= null;
		var oWeatherSuggestion				= null;
		
		var strXMLSuggestions				= EBWeatherXMLConsts_CT459487.SUGGESTIONS;
		
		//get the correct root node (depends in this is the xml document or a regular dom node)
		var XMLRoot			= XMLNode.ownerDocument ? XMLNode : XMLNode.documentElement;
		var XMLChildNode	= null;
		if(XMLRoot.tagName == strXMLSuggestions)
		{
			oWeatherSuggestionCollection = new EBWeatherSuggestionCollection_CT459487();
			for(var i=0;i<XMLRoot.childNodes.length;i++)
			{
				XMLChildNode = XMLRoot.childNodes[i];
				oWeatherSuggestion = this.XMLToWeatherSuggestion(XMLChildNode);
				if(oWeatherSuggestion)
				{
					oWeatherSuggestionCollection.Collection.AppendElement(oWeatherSuggestion);
				}
			}
		}
		
		return oWeatherSuggestionCollection;
	},
	
	XMLToWeatherSuggestion : function(XMLNode)
	{
		var oWeatherSuggestion	= null;
		var strCity				= '';
		var strCountry			= '';
		var strLocationID		= '';
		
		var strXMLSuggestion	= EBWeatherXMLConsts_CT459487.SUGGESTION;
		var strXMLCity			= EBWeatherXMLConsts_CT459487.CITY;
		var strXMLCountry		= EBWeatherXMLConsts_CT459487.COUNTRY;
		var strXMLLocationID	= EBWeatherXMLConsts_CT459487.LOCATION_ID;
		
		//get the correct root node (depends in this is the xml document or a regular dom node)
		var XMLRoot			= XMLNode.ownerDocument ? XMLNode : XMLNode.documentElement;
		var XMLChildNode	= null;
		if(XMLRoot.tagName == strXMLSuggestion)
		{
			for(var i=0;i<XMLRoot.childNodes.length;i++)
			{
				XMLChildNode = XMLRoot.childNodes[i];
				if(XMLChildNode.tagName == strXMLCity)
				{
					strCity = EBGlobalManager_CT459487.GetXmlNodeValue(XMLChildNode);
				}
				else if(XMLChildNode.tagName == strXMLCountry)
				{
					strCountry = EBGlobalManager_CT459487.GetXmlNodeValue(XMLChildNode);
				}
				else if(XMLChildNode.tagName == strXMLLocationID)
				{
					strLocationID = EBGlobalManager_CT459487.GetXmlNodeValue(XMLChildNode);
				}
			}
			
			oWeatherSuggestion = new EBWeatherSuggestion_CT459487(strCity,strCountry,strLocationID);
		}
		
		return oWeatherSuggestion;
	},
	
	XMLToWeatherForecast : function(XMLDoc)
	{
		var oWeatherForecast		= null;
		
		var strLocationID				= '';
		var oWeatherDayCollection		= null;
		var oWeatherCurrentCondition	= null;
		
		var strXMLForecast				= EBWeatherXMLConsts_CT459487.FORECAST;
		var strXMLLocationID			= EBWeatherXMLConsts_CT459487.LOCATION_ID;
		var strXMLDays					= EBWeatherXMLConsts_CT459487.DAYS;
		var strXMLCurrentCondition		= EBWeatherXMLConsts_CT459487.CURRENT_CONDITION;
		
		
		var XMLRoot			= XMLDoc.documentElement;
		var XMLChildNode	= null;
		if(XMLRoot.tagName == strXMLForecast)
		{
			for(var i=0;i<XMLRoot.childNodes.length;i++)
			{
				XMLChildNode = XMLRoot.childNodes[i];
				if(XMLChildNode.tagName == strXMLLocationID)
				{
					strLocationID = EBGlobalManager_CT459487.GetXmlNodeValue(XMLChildNode);
				}
				else if(XMLChildNode.tagName == strXMLDays)
				{
					oWeatherDayCollection = this.XMLToWeatherDayCollection(XMLChildNode);
				}
				else if(XMLChildNode.tagName == strXMLCurrentCondition)
				{
					oWeatherCurrentCondition = this.XMLToWeatherCurrentCondition(XMLChildNode);
				}
			}
			
			if(strLocationID && oWeatherDayCollection && oWeatherCurrentCondition)
			{
				oWeatherForecast = new EBWeatherForecast_CT459487(strLocationID,
															oWeatherDayCollection,
															oWeatherCurrentCondition)
			}
		}
		
		return oWeatherForecast;
		
	},
	
	XMLToWeatherDayCollection : function(XMLNode)
	{
		var oWeatherDayCollection		= null;
		var oWeatherDay					= null;
		var strXMLDays					= EBWeatherXMLConsts_CT459487.DAYS;
		
		var XMLRoot			= XMLNode.ownerDocument ? XMLNode : XMLNode.documentElement;
		var XMLChildNode	= null;
		
		if(XMLRoot.tagName == strXMLDays)
		{
			oWeatherDayCollection = new EBWeatherDayCollection_CT459487();
			for(var i=0;i<XMLRoot.childNodes.length;i++)
			{
				XMLChildNode = XMLRoot.childNodes[i];
				oWeatherDay = this.XMLToWeatherDay(XMLChildNode);
				if(oWeatherDay)
				{
					oWeatherDayCollection.Collection.AppendElement(oWeatherDay);
				}
			}
		}
		
		return oWeatherDayCollection;
	},
	
	XMLToWeatherDay : function(XMLNode)
	{
		var oWeatherDay = null;
		
		var iDayIndex				= 0;
		var strDate					= '';
		var strDay					= '';
		var strFMin					= '';
		var strFMax					= '';
		var strCMin					= '';
		var strCMax					= '';
		var strConditionDescription = '';
		var strConditionIcon		= '';
		
		var strXMLDate					= EBWeatherXMLConsts_CT459487.DATE;
		var strXMLDay					= EBWeatherXMLConsts_CT459487.DAY;
		var strXMLFMin					= EBWeatherXMLConsts_CT459487.F_MIN;
		var strXMLFMax					= EBWeatherXMLConsts_CT459487.F_MAX;
		var strXMLCMin					= EBWeatherXMLConsts_CT459487.C_MIN;
		var strXMLCMax					= EBWeatherXMLConsts_CT459487.C_MAX;
		var strXMLConditionDescription	= EBWeatherXMLConsts_CT459487.CONDITION_DESCRIPTION;
		var strXMLConditionIcon			= EBWeatherXMLConsts_CT459487.CONDITION_ICON;

		var XMLRoot			= XMLNode.ownerDocument ? XMLNode : XMLNode.documentElement;
		var XMLChildNode	= null;
		
		var strXMLRootTagName = XMLRoot.tagName;
		if(EBGlobalManager_CT459487.BeginsWith(strXMLRootTagName,strXMLDay))
		{
			//extricate the number from the DAY[number] pattern
			iDayIndex = strXMLRootTagName.substring(strXMLDay.length);
			for(var i=0;i<XMLRoot.childNodes.length;i++)
			{
				XMLChildNode = XMLRoot.childNodes[i];
				if(XMLChildNode.tagName == strXMLDate)
				{
					strDate = EBGlobalManager_CT459487.GetXmlNodeValue(XMLChildNode);
				}
				else if(XMLChildNode.tagName == strXMLDay)
				{
					strDay = EBGlobalManager_CT459487.GetXmlNodeValue(XMLChildNode);
				}
				else if(XMLChildNode.tagName == strXMLFMin)
				{
					strFMin = EBGlobalManager_CT459487.GetXmlNodeValue(XMLChildNode);
				}
				else if(XMLChildNode.tagName == strXMLFMax)
				{
					strFMax = EBGlobalManager_CT459487.GetXmlNodeValue(XMLChildNode);
				}
				else if(XMLChildNode.tagName == strXMLCMin)
				{
					strCMin = EBGlobalManager_CT459487.GetXmlNodeValue(XMLChildNode);
				}
				else if(XMLChildNode.tagName == strXMLCMax)
				{
					strCMax = EBGlobalManager_CT459487.GetXmlNodeValue(XMLChildNode);
				}
				else if(XMLChildNode.tagName == strXMLConditionDescription)
				{
					strConditionDescription = EBGlobalManager_CT459487.GetXmlNodeValue(XMLChildNode);
				}
				else if(XMLChildNode.tagName == strXMLConditionIcon)
				{
					strConditionIcon = EBGlobalManager_CT459487.GetXmlNodeValue(XMLChildNode);
				}
			}
			
			
			oWeatherDay = new EBWeatherDay_CT459487(iDayIndex,
												strDate,
												strDay,
												strFMin,
												strFMax,
												strCMin,
												strCMax,
												strConditionDescription,
												strConditionIcon)
		}
		
		return oWeatherDay;
		
	},
	
	XMLToWeatherCurrentCondition : function(XMLNode)
	{
		var oWeatherCurrentCondition = null;
		
		var strTempF		= '';
		var strTempC		= '';
		var strWeatherText	= '';
		var strSky			= '';
		var strFeelsLikeF	= '';
		var strFeelsLikeC	= '';
		var strIcon			= '';
		var strButtonIcon	= '';
		var strTooltipIcon	= '';
	
	
		var strXMLCurrentCondition	= EBWeatherXMLConsts_CT459487.CURRENT_CONDITION;
		var strXMLTempF				= EBWeatherXMLConsts_CT459487.TEMP_F;
		var strXMLTempC				= EBWeatherXMLConsts_CT459487.TEMP_C;
		var strXMLWeatherText		= EBWeatherXMLConsts_CT459487.WEATHER_TEXT;
		var strXMLSky				= EBWeatherXMLConsts_CT459487.SKY;
		var strXMLFeelsLikeF		= EBWeatherXMLConsts_CT459487.FEELS_LIKE_F;
		var strXMLFeelsLikeC		= EBWeatherXMLConsts_CT459487.FEELS_LIKE_C;
		var strXMLIcon				= EBWeatherXMLConsts_CT459487.ICON;
		var strXMLButtonIcon		= EBWeatherXMLConsts_CT459487.BUTTON_ICON;
		var strXMLTooltipIcon		= EBWeatherXMLConsts_CT459487.TOOLTIP_ICON;
	
		var XMLRoot			= XMLNode.ownerDocument ? XMLNode : XMLNode.documentElement;
		var XMLChildNode	= null;
		if(XMLRoot.tagName == strXMLCurrentCondition)
		{
			for(var i=0;i<XMLRoot.childNodes.length;i++)
			{
				XMLChildNode = XMLRoot.childNodes[i];
				if(XMLChildNode.tagName == strXMLTempF)
				{
					strTempF = EBGlobalManager_CT459487.GetXmlNodeValue(XMLChildNode);
				}
				else if(XMLChildNode.tagName == strXMLTempC)
				{
					strTempC = EBGlobalManager_CT459487.GetXmlNodeValue(XMLChildNode);
				}
				else if(XMLChildNode.tagName == strXMLWeatherText)
				{
					strWeatherText = EBGlobalManager_CT459487.GetXmlNodeValue(XMLChildNode);
				}
				else if(XMLChildNode.tagName == strXMLSky)
				{
					strSky = EBGlobalManager_CT459487.GetXmlNodeValue(XMLChildNode);
				}
				else if(XMLChildNode.tagName == strXMLFeelsLikeF)
				{
					strFeelsLikeF = EBGlobalManager_CT459487.GetXmlNodeValue(XMLChildNode);
				}
				else if(XMLChildNode.tagName == strXMLFeelsLikeC)
				{
					strFeelsLikeC = EBGlobalManager_CT459487.GetXmlNodeValue(XMLChildNode);
				}
				else if(XMLChildNode.tagName == strXMLIcon)
				{
					strIcon = EBGlobalManager_CT459487.GetXmlNodeValue(XMLChildNode);
				}
				else if(XMLChildNode.tagName == strXMLButtonIcon)
				{
					strButtonIcon = EBGlobalManager_CT459487.GetXmlNodeValue(XMLChildNode);
				}
				else if(XMLChildNode.tagName == strXMLTooltipIcon)
				{
					strTooltipIcon = EBGlobalManager_CT459487.GetXmlNodeValue(XMLChildNode);
				}
			}
			
			
			oWeatherCurrentCondition = new EBWeatherCurrentCondition_CT459487(strTempF,
												strTempC,
												strWeatherText,
												strSky,
												strFeelsLikeF,
												strFeelsLikeC,
												strIcon,
												strButtonIcon,
												strTooltipIcon);
		}
		
		return oWeatherCurrentCondition;
		
	}
	
	
	
}




var EBWeatherDialogConsts_CT459487 = 
{
	XULFileName			  : 'weather.xul',
	XULOldAPIFileName	  : 'oldapi/weather_oldapi.xul',
	DialogName			  : 'weatherDialogName_CT459487',
	DialogType			  : 'EBWeatherDialog_CT459487',
	DefaultSearchBoxValue : 'Search for location or U.S. zip code',
	SearchCaption		  : 'Search',
	SelectCaption		  : 'Select',
	DialogWidth			  : 458,
	DialogHeight		  : 279,
	
	Attributes :
	{
		LocationID	: 'EB_WEATHER_LOCATION_ID'
	},
	
	Panels :
	{
		SearchSelectPanel	: 1,
		SelectPanel			: 2,
		ForecastPanel		: 3,
		ErrorPanel			: 4
	}
}

var EBWeatherDialogManager_CT459487 = 
{	
	//instance to save the weather search after a search has been made
	CurrentWeatherSearch		: null,
	
	//instance to save the weather forecast
	CurrentWeatherForecast		: null,
	
	//instance to save the weather current city
	CurrentWeatherSuggestion	: null,
	
	//instance of the http request object to abort it on close 
	//of the dialog
	XMLHTTPRequest				: null,
	
	Open : function(iX,iY)
	{
		var strChromePath = '';
			
		if(EBGlobalManager_CT459487.IsNewestBrowserAPI())
		{
			strChromePath = EBGlobalConsts_CT459487.ChromeContentPath + EBWeatherDialogConsts_CT459487.XULFileName;
		}
		else
		{
			strChromePath = EBGlobalConsts_CT459487.ChromeContentPath + EBWeatherDialogConsts_CT459487.XULOldAPIFileName;
		}
		
		window.openDialog(strChromePath,
							EBWeatherDialogConsts_CT459487.DialogName,
							'chrome,dependent,resizable=no,titlebar=no,screenX=' + iX + ',screenY=' + iY);
		
	},

	OnLoadDialog : function()
	{	
		this.SetDefaultElements();
		//check which panel to load - forecast or search-select
		var oWeatherForecast			= EBWeatherManager_CT459487.LoadWeatherForecast();
		var oWeatherSuggestionCurrent	= EBWeatherManager_CT459487.LoadWeatherCurrentCity();
		
		if(oWeatherForecast && oWeatherSuggestionCurrent && !EBWeatherManager_CT459487.IsTimeElapsed())
		{
			this.LoadForecastPanel(oWeatherForecast,oWeatherSuggestionCurrent);
		}
		else
		{
			this.LoadSearchSelectPanel();
		}
		
	},
	
	SetDefaultElements : function()
	{
		this.HideSearchSelectErrorMsg();
		this.SetSearchSelectLoadingMode(false);
		this.SetSelectLoadingMode(false);
	},
	
	OnUnLoadDialog : function()
	{
		this.KillHTTPRequest();
	},
	
	KillHTTPRequest : function()
	{
		if(this.XMLHTTPRequest)
		{
			this.XMLHTTPRequest.abort();
		}
	},
	
	OnBlurDialog : function(event)
	{
		if(event.eventPhase == 2)
		{
			window.close();
		}
	},
	
	LoadSearchSelectPanel : function()
	{
		//set the default text to the search box
		var strSearchMsg	= EBWeatherDialogConsts_CT459487.DefaultSearchBoxValue;
		var oSearchBox		= document.getElementById('txtSearchBox');
		oSearchBox.value	= strSearchMsg;
		
		//load the search history and set all the radio elements according it
		this.LoadSearchData();
		
		//check if to enable the back button (if there is forecast to show)
		var oButtonBack1 = document.getElementById('btnBack1');
		oButtonBack1.disabled = this.CurrentWeatherForecast ? false : true;
	
		//switch to the first panel
		this.SwitchToPanel(EBWeatherDialogConsts_CT459487.Panels.SearchSelectPanel);
	},
	
	LoadSearchData : function()
	{
		var oRadioGroupSearchResults	= document.getElementById('radioGroupSearchResults');
		var oRadioHistoryCity3			= document.getElementById('radHistoryCity3');
		var oRadioHistoryCity2			= document.getElementById('radHistoryCity2');
		var oRadioHistoryCity1			= document.getElementById('radHistoryCity1');
		var oRadioCurrentCity			= document.getElementById('radCurrentCity');
		var oRadioSearchBox				= document.getElementById('radSearchBox');
		
		//hide first all cities radio boxes
		this.ShowHideXULObject(oRadioCurrentCity,false);
		this.ShowHideXULObject(oRadioHistoryCity1,false);
		this.ShowHideXULObject(oRadioHistoryCity2,false);
		this.ShowHideXULObject(oRadioHistoryCity3,false);
		
		var oWeatherSearchHistory =  EBWeatherManager_CT459487.LoadWeatherHistory();
		
		var bIsHistoryItems = false;
		
		if(oWeatherSearchHistory)
		{
			var oWeatherSuggestionCollection = oWeatherSearchHistory.SuggestionCollection;
			var oWeatherSuggestionCurrent    = oWeatherSuggestionCollection.Collection.GetItem(0);
			
			if(oWeatherSuggestionCurrent)
			{
				bIsHistoryItems = true;
				this.ShowHideXULObject(oRadioCurrentCity,true);
				this.SetXULWeatherSuggestionAttributes(oRadioCurrentCity,oWeatherSuggestionCurrent);
				
				this.LoadSearchHistoryData(oWeatherSuggestionCollection);
				
				oRadioGroupSearchResults.selectedItem = oRadioCurrentCity;
			}
		}
		
		//if there isn't any history items the mode is search 
		if(!bIsHistoryItems)
		{
			oRadioGroupSearchResults.selectedItem = oRadioSearchBox;
		}
	},
	
	//set to the xul the caption and the special attribute location id
	//this will made to the choises radio boxes and the search results combo items
	//cause their both have the same attributes
	SetXULWeatherSuggestionAttributes : function(oXULElement,oWeatherSuggestion)
	{
		var strCaption		= this.GetCityCountryCaption(oWeatherSuggestion);
		var strLocationID	= oWeatherSuggestion.LocationID;
		//set the full label caption
		oXULElement.setAttribute('label',strCaption);
		//set the special location id attribute
		oXULElement.setAttribute(EBWeatherDialogConsts_CT459487.Attributes.LocationID,strLocationID);
	},
	
	LoadSearchHistoryData : function(oWeatherSuggestionCollection)
	{
		var oWeatherSuggestionHistory1 = oWeatherSuggestionCollection.Collection.GetItem(1);
		var oWeatherSuggestionHistory2 = oWeatherSuggestionCollection.Collection.GetItem(2);
		var oWeatherSuggestionHistory3 = oWeatherSuggestionCollection.Collection.GetItem(3);
	
		//set the radio of the history city data 1-2-3
		//show each radio only if the previous is shown
		if(this.SetRadioHistoryCity(1,oWeatherSuggestionHistory1))
		{
			if(this.SetRadioHistoryCity(2,oWeatherSuggestionHistory2))
			{
				this.SetRadioHistoryCity(3,oWeatherSuggestionHistory3);
			}
		}
	},
	
	SetRadioHistoryCity : function(iHistoryIndex,oWeatherSuggestion)
	{
		var bVisible = false;
		var oRadioHistoryCity = document.getElementById('radHistoryCity' + iHistoryIndex);
		
		if(oWeatherSuggestion)
		{
			bVisible = true;
			this.SetXULWeatherSuggestionAttributes(oRadioHistoryCity,oWeatherSuggestion);
		}

		this.ShowHideXULObject(oRadioHistoryCity,bVisible);
		return bVisible;
	},
	
	ShowHideXULObject : function(oXUL,bShow)
	{
		var strVisibilityStyle = bShow ? 'visible' : 'hidden';
		oXUL.style.visibility = strVisibilityStyle;
	},
	
	GetCityCountryCaption : function(oWeatherSuggestion)
	{
		var strCaption = oWeatherSuggestion.City + ', ' + oWeatherSuggestion.Country;
		return strCaption;
	},
	
	OnSelectRadioGroupSearchResults : function()
	{
		//change the label of the search/select button according to the radio selection
		var oRadioGroupSearchResults	= document.getElementById('radioGroupSearchResults');
		var oRadioSearchBox				= document.getElementById('radSearchBox');
		
		var oButtonSelectSearch			= document.getElementById('btnSelect1');
		
		var strCaption = '';
		
		if(oRadioGroupSearchResults.selectedItem == oRadioSearchBox)
		{
			strCaption = EBWeatherDialogConsts_CT459487.SearchCaption;
		}
		else
		{
			strCaption = EBWeatherDialogConsts_CT459487.SelectCaption;
			//hide the errors messages
			this.HideSearchSelectErrorMsg();
		}
		
		oButtonSelectSearch.setAttribute('label',strCaption);
	},

	OnFocusSearchBox : function(event)
	{	
		
		var oSearchBox = event.target;
		//check if it's readonly(meaning in the middle of search process)
		if(oSearchBox.getAttribute('readonly') == 'true')
		{
			return;
		}
		
		var strSearchMsg = EBWeatherDialogConsts_CT459487.DefaultSearchBoxValue;
		if(oSearchBox.value == strSearchMsg)
		{
			oSearchBox.value = '';
		}
		
		//select the radio search
		var oRadioGroupSearchResults	= document.getElementById('radioGroupSearchResults');
		var oRadioSearchBox				= document.getElementById('radSearchBox');
		oRadioGroupSearchResults.selectedItem = oRadioSearchBox;
		
		//hide the errors messages
		this.HideSearchSelectErrorMsg();
		
	},
	
	OnBlurSearchBox: function(event)
	{	
		if(event.eventPhase == 2)
		{
			var oSearchBox = event.target;
			//check if it's readonly(meaning in the middle of search process)
			if(oSearchBox.getAttribute('readonly') == 'true')
			{
				return;
			}
			if(document.commandDispatcher.focusedElement)
			{
				window.close();
			}
			else
			{
				var strSearchMsg = EBWeatherDialogConsts_CT459487.DefaultSearchBoxValue;
				if(oSearchBox.value == '')
				{
					oSearchBox.value = strSearchMsg;
				}
				
				//hide the errors messages
				this.HideSearchSelectErrorMsg();
			}
		}
	},
	
	OnKeyPressSearchBox : function(event)
	{
		if(event.which == 13)
		{
			this.OnCommandButtonSelectSearch();
		}
	},
	
	OnKeyPressSearchResultsCombo : function(event)
	{
		if(event.which == 13)
		{
			this.OnCommandButtonSelect();
		}	
	},
	
	OnCommandButtonSelectSearch : function()
	{
		var oRadioGroupSearchResults	= document.getElementById('radioGroupSearchResults');
		var oRadioSearchBox				= document.getElementById('radSearchBox');
		
		if(oRadioGroupSearchResults.selectedItem == oRadioSearchBox)
		{
			this.SearchCityFromTextBox();
		}
		else
		{
			this.SearchCityFromRadioBox();
		}
	},
	
	SearchCityFromRadioBox : function()
	{
		var oRadioGroupSearchResults	= document.getElementById('radioGroupSearchResults');
		var oRadioHistoryCity3			= document.getElementById('radHistoryCity3');
		var oRadioHistoryCity2			= document.getElementById('radHistoryCity2');
		var oRadioHistoryCity1			= document.getElementById('radHistoryCity1');
		var oRadioCurrentCity			= document.getElementById('radCurrentCity');
		
		var oXULSelectedRadio			= oRadioGroupSearchResults.selectedItem;
		var oWeatherSuggestion			= null;
		
		var oWeatherSearchHistory =  EBWeatherManager_CT459487.LoadWeatherHistory();
		
		var oWeatherForecast = null;
		
		if(oWeatherSearchHistory)
		{
			var oWeatherSuggestionCollection = oWeatherSearchHistory.SuggestionCollection;
			
			if(oXULSelectedRadio == oRadioCurrentCity)
			{
				oWeatherSuggestion = oWeatherSuggestionCollection.Collection.GetItem(0);
			}
			else if(oXULSelectedRadio == oRadioHistoryCity1)
			{
				oWeatherSuggestion = oWeatherSuggestionCollection.Collection.GetItem(1);
			}
			else if(oXULSelectedRadio == oRadioHistoryCity2)
			{
				oWeatherSuggestion = oWeatherSuggestionCollection.Collection.GetItem(2);
			}
			else if(oXULSelectedRadio == oRadioHistoryCity3)
			{
				oWeatherSuggestion = oWeatherSuggestionCollection.Collection.GetItem(3);
			}
		}
		
		
		if(oWeatherSuggestion)
		{	
			if(oXULSelectedRadio == oRadioCurrentCity)
			{
				oWeatherForecast = EBWeatherManager_CT459487.LoadWeatherForecast();
				if(oWeatherForecast)
				{
					this.LoadForecastPanel(oWeatherForecast,oWeatherSuggestion);
				}
				else
				{
					this.LoadErrorPanel();
				}
			}
			else//only if select a different city then the current i save the new suggestion to the file(re-arrange them) and load the forecast from the server
			{
				//load the forecast from the server
				var strLocationID		= oXULSelectedRadio.getAttribute(EBWeatherDialogConsts_CT459487.Attributes.LocationID);

				var oCallBackFunction = function(XMLDoc,o)
				{
					try
					{
						if(o.value == EBGlobalConsts_CT459487.NetworkError)
						{
							EBWeatherDialogManager_CT459487.ShowHideServerUnavailableMsg(true);
						}
						else
						{
							var oWeatherForecast = null;
							if(EBWeatherManager_CT459487.IsValidWeatherXMLDoc(XMLDoc))
							{
								oWeatherForecast = EBWeatherDataFactory_CT459487.XMLToWeatherForecast(XMLDoc);
							}
							
							if(oWeatherForecast)
							{
								//only if success coming from the server - save all to files(history & forecast)
								EBWeatherDialogManager_CT459487.SaveWeatherForecastAndWeatherHistory(oWeatherForecast,oWeatherSuggestion);
								EBWeatherDialogManager_CT459487.LoadForecastPanel(oWeatherForecast,oWeatherSuggestion);
							}
							else
							{
								EBWeatherDialogManager_CT459487.LoadErrorPanel();
							}
						}
						
						//in any case when coming back from the server 
						//go back to regular mode
						EBWeatherDialogManager_CT459487.SetSearchSelectLoadingMode(false);
						//nullify the member request object
						EBWeatherDialogManager_CT459487.XMLHTTPRequest = null;
					}
					catch(ex){}
				};
				this.SetSearchSelectLoadingMode(true);
				this.ServerRequestForecast(strLocationID,oCallBackFunction);
			}
		}	
		else
		{
			this.LoadErrorPanel();
		}	
	},
	
	SearchCityFromTextBox : function()
	{
		var oSearchBox		= document.getElementById('txtSearchBox');
		var strValue		= oSearchBox.value;
		var strDefaultValue = EBWeatherDialogConsts_CT459487.DefaultSearchBoxValue;
		
		if(EBGlobalManager_CT459487.TotalTrim(strValue) && strValue != strDefaultValue)
		{
			//make the dialog in loading mode
			this.SetSearchSelectLoadingMode(true);
			
			//make the server request and send an object to check if there was exception
			this.ServerRequestCitySearch(strValue);
		}
		else
		{
			this.ShowHideCityNotFoundMsg(true);
		}
	},
	
	//set the mode of the dialog to be loading 
	//(true - disable/hide all and show progressmeter)
	//(false - enable/show all and hide progressmeter)
	SetSearchSelectLoadingMode : function(bValue)
	{
		var oRadioGroupSearchResults	= document.getElementById('radioGroupSearchResults');
		var oRadioHistoryCity3			= document.getElementById('radHistoryCity3');
		var oRadioHistoryCity2			= document.getElementById('radHistoryCity2');
		var oRadioHistoryCity1			= document.getElementById('radHistoryCity1');
		var oRadioCurrentCity			= document.getElementById('radCurrentCity');
		var oRadioSearchBox				= document.getElementById('radSearchBox');
		var oTextSearchBox				= document.getElementById('txtSearchBox');
		
		var oButtonBack1				= document.getElementById('btnBack1');
		var oButtonSelectSearch			= document.getElementById('btnSelect1');
		
		//disable the radio and the text box
		oRadioGroupSearchResults.disabled	= bValue;	
		oRadioHistoryCity3.disabled			= bValue;	
		oRadioHistoryCity2.disabled			= bValue;	
		oRadioHistoryCity1.disabled			= bValue;
		oRadioCurrentCity.disabled			= bValue;	
		oRadioSearchBox.disabled			= bValue;
		

		//set the readonly and not the disabled cause it's causes a bug
		//with the textbox when enable it the cursor disappeared
		if(bValue)
		{
			oTextSearchBox.setAttribute('readonly','true');
		}
		else
		{
			oTextSearchBox.removeAttribute('readonly');
		}
		
		
		//hide the buttons
		this.ShowHideXULObject(oButtonBack1,!bValue);
		this.ShowHideXULObject(oButtonSelectSearch,!bValue);
		
		//handle the progressmeter
		//get the box of the progressmeter
		var oProgressMeterBox			= document.getElementById('progBox1');
		//empty it (if there is progressmeter in it)
		if(oProgressMeterBox.firstChild)
		{
			oProgressMeterBox.removeChild(oProgressMeterBox.firstChild);
		}
		var oProgressMeter = null;
		if(bValue)
		{
			oProgressMeter = this.CreateProgressMeter();
			oProgressMeterBox.appendChild(oProgressMeter);
		}
	},
	
	SetSelectLoadingMode : function(bValue)
	{
		var oSearchResultsCombo			= document.getElementById('ebWeatherSearchResultsCombo');
		
		var oButtonBack2				= document.getElementById('btnBack2');
		var oButtonSelect				= document.getElementById('btnSelect2');
		
		//disable combo
		oSearchResultsCombo.disabled	= bValue;	
		
		//hide the buttons
		this.ShowHideXULObject(oButtonBack2,!bValue);
		this.ShowHideXULObject(oButtonSelect,!bValue);
		
		//handle the progressmeter
		//get the box of the progressmeter
		var oProgressMeterBox			= document.getElementById('progBox2');
		//empty it (if there is progressmeter in it)
		if(oProgressMeterBox.firstChild)
		{
			oProgressMeterBox.removeChild(oProgressMeterBox.firstChild);
		}
		var oProgressMeter = null;
		if(bValue)
		{
			oProgressMeter = this.CreateProgressMeter();
			oProgressMeterBox.appendChild(oProgressMeter);
		}
		
	},

	CreateProgressMeter : function()
	{
		var oProgressMeter = document.createElement('progressmeter');
		oProgressMeter.setAttribute('mode','undetermined');
		return oProgressMeter;
	},
	
	ServerRequestCitySearch : function(strSearchTerm)
	{
		var oWeatherSearch = null;
		
		var strServerURL = EBWeatherManager_CT459487.GetWeatherServerURL();
		//assembley the full url
		var strFullServerURL = strServerURL + EBWeatherConsts_CT459487.URL.QS_SEARCH + strSearchTerm;
		
		var oCallBackFunction = EBWeatherDialogManager_CT459487.ServerResponseCitySearch;
		
		//get the source from the server and save the http request to this class to
		//retrieve it when closing the dialog for abortion
		this.XMLHTTPRequest = EBWeatherManager_CT459487.ServerRequest(strFullServerURL,oCallBackFunction);
	},
	
	//since this call is coming from the server all the calls
	//to this class functions is using the full name of the class
	//and not just this.
	ServerResponseCitySearch : function(XMLDoc,o)
	{
		try
		{
			//check if there was server error(no internet etc...)
			if(o.value == EBGlobalConsts_CT459487.NetworkError)
			{
				EBWeatherDialogManager_CT459487.ShowHideServerUnavailableMsg(true);
			}
			else
			{
				var oWeatherSearch = null;
				if(EBWeatherManager_CT459487.IsValidWeatherXMLDoc(XMLDoc))
				{	
					//get the object via the xml(if failed null is been returned
					oWeatherSearch = EBWeatherDataFactory_CT459487.XMLToWeatherSearch(XMLDoc);
				}
				
				if(oWeatherSearch)
				{
					EBWeatherDialogManager_CT459487.LoadSelectPanel(oWeatherSearch);
				}
				else
				{
					//show the not found msg if it's illegal term
					EBWeatherDialogManager_CT459487.ShowHideCityNotFoundMsg(true);
				}
			}
			
			//in any case remove the loading mode of the dialog at the end of the response
			EBWeatherDialogManager_CT459487.SetSearchSelectLoadingMode(false);
			//nullify the request object
			EBWeatherDialogManager_CT459487.XMLHTTPRequest = null;
		}
		catch(ex){}
	},
	
	ServerRequestForecast : function(strLocationID,oCallBackFunction)
	{
		var oWeatherForecast = null;
		
		var strServerURL = EBWeatherManager_CT459487.GetWeatherServerURL();
		//assembley the full url
		var strFullServerURL = strServerURL + EBWeatherConsts_CT459487.URL.QS_FORECAST + strLocationID;
		
		//get the source from the server and save the http request to this class to
		//retrieve it when closing the dialog for abortion
		this.XMLHTTPRequest = EBWeatherManager_CT459487.ServerRequest(strFullServerURL,oCallBackFunction);
	},
	
	HideSearchSelectErrorMsg : function()
	{
		this.ShowHideCityNotFoundMsg(false);
		this.ShowHideServerUnavailableMsg(false);
	},
	
	ShowHideCityNotFoundMsg : function(bShow)
	{
		var oLabelCityNotFound = document.getElementById('lblCityNotFound');
		this.ShowHideXULObject(oLabelCityNotFound,bShow);
	},
	
	ShowHideServerUnavailableMsg : function(bShow)
	{
		var oLabelUnavailableMsg = document.getElementById('lblServichUnavailable');
		this.ShowHideXULObject(oLabelUnavailableMsg,bShow);
	},
	
	NullifyAllAccessKey : function()
	{
		var oButtonBack1	= document.getElementById('btnBack1');
		var oButtonSelect1	= document.getElementById('btnSelect1');
		
		var oButtonBack2	= document.getElementById('btnBack2');
		var oButtonSelect2	= document.getElementById('btnSelect2');
		
		var oButtonBack4	= document.getElementById('btnBack4');
		var oButtonSelect4	= document.getElementById('btnSelect4');
		
		oButtonBack1.removeAttribute('accesskey');
		oButtonSelect1.removeAttribute('accesskey');
		
		oButtonBack2.removeAttribute('accesskey');
		oButtonSelect2.removeAttribute('accesskey');
		
		oButtonBack4.removeAttribute('accesskey');
		oButtonSelect4.removeAttribute('accesskey');
	},
	
	SwitchToPanel : function(iPanelIndex)
	{
		var oWeatherMain			= document.getElementById('weatherMain');
		var oWeatherSelectedPanel	= document.getElementById('weatherPanel' + iPanelIndex);	

		//when switching to panel we set the access key to the back-select buttons
		//we can't set the access key in the xul since it's in the same window and in the same letters('S' and 'B')
		//so the last definition override the rest
		this.NullifyAllAccessKey();
		//set the access key to the chosen panel
		var oButtonBack		= document.getElementById('btnBack' + iPanelIndex);
		var oButtonSelect	= document.getElementById('btnSelect' + iPanelIndex);
		if(oButtonBack && oButtonSelect)
		{
			oButtonBack.setAttribute('accesskey','B');
			oButtonSelect.setAttribute('accesskey','S');
		}

		oWeatherMain.selectedPanel = oWeatherSelectedPanel;

	},
	
	LoadSelectPanel : function(oWeatherSearch)
	{
		var oButtonSelect = document.getElementById('btnSelect2');
		oButtonSelect.focus();
	
		//switch the deck to panel 2
		this.SwitchToPanel(EBWeatherDialogConsts_CT459487.Panels.SelectPanel);
	
		//save the weather search data object to retrieve it in the selection
		this.CurrentWeatherSearch = oWeatherSearch;
	
		//populate the combo with the search results
		var oComboSearchResults = document.getElementById('ebWeatherSearchResultsCombo');
		var oMenuPopup = oComboSearchResults.firstChild;
		//empty the menu popup
		while(oMenuPopup.childNodes.length > 0)
		{
			oMenuPopup.removeChild(oMenuPopup.firstChild);
		}
		
		//get the collection from the search object	
		var oCollection = oWeatherSearch.SuggestionCollection.Collection;
		
		var oWeatherSuggestion	= null;
		var oXULMenuItem		= null;
		var strLabel = '';
		var strLocationID = '';
		
		for(var i=0;i<oCollection.Arr.length;i++)
		{
			oWeatherSuggestion = oCollection.GetItem(i);
			
			oXULMenuItem = document.createElement('menuitem');
			this.SetXULWeatherSuggestionAttributes(oXULMenuItem,oWeatherSuggestion);
			
			oMenuPopup.appendChild(oXULMenuItem);
		}
		
		if(oMenuPopup.childNodes.length > 0)
		{
			oComboSearchResults.selectedIndex = 0;
		}
		
		
	},
	
	OnCommandButtonBack1 : function()
	{
		//back to the forecast panel
		//this button is enabled in the first panel load only if there 
		//is a forecast to show(the this.CurrentWeatherForecast is set)
		this.SwitchToPanel(EBWeatherDialogConsts_CT459487.Panels.ForecastPanel);
	},
	
	OnCommandButtonBack2 : function()
	{
		//go back to the first dialog without loading it from the file
		//meaning back to the last situation the user left it.
		this.SwitchToPanel(EBWeatherDialogConsts_CT459487.Panels.SearchSelectPanel);
	},
	
	OnCommandButtonBack3 : function()
	{
		this.LoadSearchSelectPanel();
	},
	
	
	
	OnCommandButtonSelect : function()
	{
		var oComboSearchResults = document.getElementById('ebWeatherSearchResultsCombo');
		var oMenuItem			= oComboSearchResults.selectedItem;
		var iSelectedIndex		= oComboSearchResults.selectedIndex;
		
		//get the location id from the special attribute:
		var strLocationID		= oMenuItem.getAttribute(EBWeatherDialogConsts_CT459487.Attributes.LocationID);
		
		var oCallBackFunction = function(XMLDoc,o)
		{
			try
			{
				if(o.value == EBGlobalConsts_CT459487.NetworkError)
				{
					EBWeatherDialogManager_CT459487.LoadErrorPanel();
				}
				else
				{
					var oWeatherForecast = null;
					if(EBWeatherManager_CT459487.IsValidWeatherXMLDoc(XMLDoc))
					{
						oWeatherForecast = EBWeatherDataFactory_CT459487.XMLToWeatherForecast(XMLDoc);
					}
					if(oWeatherForecast)
					{
						//get the chosen search suggestion
						var oWeatherSearch		= EBWeatherDialogManager_CT459487.CurrentWeatherSearch;
						var oCollection			= oWeatherSearch.SuggestionCollection.Collection;
						var oWeatherSuggestion	= oCollection.GetItem(iSelectedIndex);
					
						if(oWeatherSuggestion)
						{
							EBWeatherDialogManager_CT459487.SaveWeatherForecastAndWeatherHistory(oWeatherForecast,oWeatherSuggestion);
							//load the forecast panel
							EBWeatherDialogManager_CT459487.LoadForecastPanel(oWeatherForecast,oWeatherSuggestion);
						}
						else
						{
							EBWeatherDialogManager_CT459487.LoadErrorPanel();
						}
					}
					else
					{
						EBWeatherDialogManager_CT459487.LoadErrorPanel();
					}
					//in any case when coming back from the server 
					//go back to regular mode
					EBWeatherDialogManager_CT459487.SetSelectLoadingMode(false);
					//nullify the member request object
					EBWeatherDialogManager_CT459487.XMLHTTPRequest = null;
				}
			}
			catch(ex){}
		};
		this.SetSelectLoadingMode(true);
		this.ServerRequestForecast(strLocationID,oCallBackFunction);
	},
	
	//save the weather forecast and history from the dialog:
	//1.save the suggestions history (re-arrange them if needed)
	//2.save the forecast to the file
	//3.update the poll date
	//4.broadcast cahnges to browsers
	SaveWeatherForecastAndWeatherHistory : function(oWeatherForecast,oWeatherSuggestionCurrent)
	{
		//save the new suggestion
		EBWeatherManager_CT459487.SaveSuggestionsHistory(oWeatherSuggestionCurrent);
		//save the forecast to the file
		EBWeatherManager_CT459487.SaveWeatherForecast(oWeatherForecast);
		//update the polldate to now:
		EBWeatherPreferencesManager_CT459487.SetWeatherPollDate();
		//broadcast changes to all browsers
		EBWeatherManager_CT459487.Broadcast(EBWeatherStateConsts_CT459487.FORECAST,oWeatherForecast,oWeatherSuggestionCurrent);
					
	},
	
	OnClickLabelChangeTo : function()
	{
		var strUnitValueToSet = '';
		var strPrefUnit = EBWeatherPreferencesManager_CT459487.GetWeatherUnits();
		var strUnitTemperatureF = EBWeatherUnits_CT459487.TEMPERATURE_F;
		var strUnitTemperatureC = EBWeatherUnits_CT459487.TEMPERATURE_C;
		
		if(strPrefUnit == strUnitTemperatureC)
		{
			strUnitValueToSet = strUnitTemperatureF;
		}
		else
		{
			strUnitValueToSet = strUnitTemperatureC;
		}
		
		EBWeatherPreferencesManager_CT459487.SetWeatherUnit(strUnitValueToSet);
		
		this.SetTemperatureUnitElements();
		
		//broadcast changes to the button in all browsers
		EBWeatherManager_CT459487.Broadcast(EBWeatherStateConsts_CT459487.FORECAST,this.CurrentWeatherForecast,this.CurrentWeatherSuggestion);
	},
	
	OnClickLabelChangeLocation : function()
	{
		this.LoadSearchSelectPanel();
	},
	
	ExtendedForecast : function(event)
	{
		window.close();
		EBWeatherManager_CT459487.LoadWeatherWebSearch(event,this.CurrentWeatherForecast,this.CurrentWeatherSuggestion);
	},
	
	LoadForecastPanel : function(oWeatherForecast,oWeatherSuggestion)
	{
		this.CurrentWeatherForecast		= oWeatherForecast;
		this.CurrentWeatherSuggestion	= oWeatherSuggestion;
		
		//set the caption of the city,country
		var oLabelCityCountryCaption = document.getElementById('lblCityCountryCaption');
		var strLabel = this.GetCityCountryCaption(oWeatherSuggestion);
		//validate if it's too long string we present only the city
		if(strLabel.length > 25)
		{
			strLabel = oWeatherSuggestion.City;
		}
		
		oLabelCityCountryCaption.setAttribute('value',strLabel);
		
		//set the current condition elements
		this.SetCurrentConditionElements(oWeatherForecast);
		//set the days elements
		this.SetDaysElements(oWeatherForecast);
		//set the units elements
		this.SetTemperatureUnitElements();
	
		this.SwitchToPanel(EBWeatherDialogConsts_CT459487.Panels.ForecastPanel);
			
		
	},
	
	SetCurrentConditionElements : function(oWeatherForecast)
	{
		var oLabelCCSky				= document.getElementById('lblCurrentConditionSky');
		var oImageCCConditionIcon	= document.getElementById('imgCurrentConditionIcon');
	
		var oWeatherCurrentCondition = oWeatherForecast.CurrentCondition;
		
		var strSky			= oWeatherCurrentCondition.Sky;
		var strIcon			= oWeatherCurrentCondition.Icon;
		
		oLabelCCSky.setAttribute('value',strSky);
		oImageCCConditionIcon.setAttribute('src',strIcon);
	
	},
	
	SetDaysElements : function(oWeatherForecast)
	{
		var oLabelDay1		= document.getElementById('lblDay1');
		var oImageDay1Icon	= document.getElementById('imgDay1Icon');
		var oLabelDay1CD	= document.getElementById('lblDay1ConditionDescription');
		
		var oLabelDay2		= document.getElementById('lblDay2');
		var oImageDay2Icon	= document.getElementById('imgDay2Icon');
		var oLabelDay2CD	= document.getElementById('lblDay2ConditionDescription');
		
		var oLabelDay3		= document.getElementById('lblDay3');
		var oImageDay3Icon	= document.getElementById('imgDay3Icon');
		var oLabelDay3CD	= document.getElementById('lblDay3ConditionDescription');
		
		var strDay1		= '';
		var strDay1Icon = '';
		var strDay1CD	= '';
		
		var strDay2		= '';
		var strDay2Icon = '';
		var strDay2CD	= '';
		
		var strDay3		= '';
		var strDay3Icon = '';
		var strDay3CD	= '';
		
		var oWeatherDaysCollection = oWeatherForecast.DayCollection;
		
		var oWeatherDay1 = oWeatherDaysCollection.Collection.GetItem(0);
		var oWeatherDay2 = oWeatherDaysCollection.Collection.GetItem(1);
		var oWeatherDay3 = oWeatherDaysCollection.Collection.GetItem(2);
		
		if(oWeatherDay1)
		{
			strDay1		= oWeatherDay1.Day;
			strDay1Icon	= oWeatherDay1.ConditionIcon;
			strDay1CD	= oWeatherDay1.ConditionDescription;
		}
		
		if(oWeatherDay2)
		{
			strDay2		= oWeatherDay2.Day;
			strDay2Icon	= oWeatherDay2.ConditionIcon;
			strDay2CD	= oWeatherDay2.ConditionDescription;
		}
		
		if(oWeatherDay3)
		{
			strDay3		= oWeatherDay3.Day;
			strDay3Icon	= oWeatherDay3.ConditionIcon;
			strDay3CD	= oWeatherDay3.ConditionDescription;
		}
		
		oLabelDay1.setAttribute('value',strDay1);
		oImageDay1Icon.setAttribute('src',strDay1Icon);
		oLabelDay1CD.setAttribute('value',strDay1CD);
		
		oLabelDay2.setAttribute('value',strDay2);
		oImageDay2Icon.setAttribute('src',strDay2Icon);
		oLabelDay2CD.setAttribute('value',strDay2CD);
		
		oLabelDay3.setAttribute('value',strDay3);
		oImageDay3Icon.setAttribute('src',strDay3Icon);
		oLabelDay3CD.setAttribute('value',strDay3CD);
		
	},
	
	SetTemperatureUnitElements : function()
	{
		var oWeatherForecast = this.CurrentWeatherForecast;
		
		var strDegreeSymbol = EBGlobalConsts_CT459487.DegreeSymbol;
		
		var strPrefUnit = EBWeatherPreferencesManager_CT459487.GetWeatherUnits();
		var strUnitTemperatureF = EBWeatherUnits_CT459487.TEMPERATURE_F;
		var strUnitTemperatureC = EBWeatherUnits_CT459487.TEMPERATURE_C;
		
		var strCahngeTo				= '';
		var strCCFeelsLike			= '';
		var strCCTemperature		= '';
		var strCCTemperatureText	= '';
		
		var strDay1TempMax			= '';
		var strDay1TempMin			= '';
		
		var strDay2TempMax			= '';
		var strDay2TempMin			= '';
		
		var strDay3TempMax			= '';
		var strDay3TempMin			= '';
		
		
		var oLabelChangeTo			= document.getElementById('lblChangeTo');
		var oLabelCCFeelsLike		= document.getElementById('lblCurrentConditionFeelsLike');
		var oLabelCCTemperature		= document.getElementById('lblCurrentConditionTemperature');
		var oLabelCCTemperatureText = document.getElementById('lblCurrentConditionTemperatureText');
		
		var oLabelDay1TempMax = document.getElementById('lblDay1TemperatureMax');
		var oLabelDay1TempMin = document.getElementById('lblDay1TemperatureMin');
		
		var oLabelDay2TempMax = document.getElementById('lblDay2TemperatureMax');
		var oLabelDay2TempMin = document.getElementById('lblDay2TemperatureMin');
	
		var oLabelDay3TempMax = document.getElementById('lblDay3TemperatureMax');
		var oLabelDay3TempMin = document.getElementById('lblDay3TemperatureMin');
	
		var oWeatherCurrentCondition = oWeatherForecast.CurrentCondition;
		
		var oWeatherDaysCollection = oWeatherForecast.DayCollection;
		
		var oWeatherDay1 = oWeatherDaysCollection.Collection.GetItem(0);
		var oWeatherDay2 = oWeatherDaysCollection.Collection.GetItem(1);
		var oWeatherDay3 = oWeatherDaysCollection.Collection.GetItem(2);
		
		if(strPrefUnit == strUnitTemperatureC)
		{
			strCahngeTo = 'Change to ' + strUnitTemperatureF + strDegreeSymbol;
			
			strCCFeelsLike			= oWeatherCurrentCondition.FeelsLikeC + strDegreeSymbol;
			strCCTemperature		= oWeatherCurrentCondition.TempC + strDegreeSymbol;
			strCCTemperatureText	= strUnitTemperatureC.toLowerCase();
			
			if(oWeatherDay1)
			{
				strDay1TempMax			= oWeatherDay1.CMax + strDegreeSymbol;
				strDay1TempMin			= oWeatherDay1.CMin + strDegreeSymbol;
			}
			
			if(oWeatherDay2)
			{
				strDay2TempMax			= oWeatherDay2.CMax + strDegreeSymbol;
				strDay2TempMin			= oWeatherDay2.CMin + strDegreeSymbol;
			}
			
			if(oWeatherDay3)
			{
				strDay3TempMax			= oWeatherDay3.CMax + strDegreeSymbol;
				strDay3TempMin			= oWeatherDay3.CMin + strDegreeSymbol;
			}
		}
		else
		{
			strCahngeTo = 'Change to ' + strUnitTemperatureC + strDegreeSymbol;
			
			strCCFeelsLike			= oWeatherCurrentCondition.FeelsLikeF + strDegreeSymbol;
			strCCTemperature		= oWeatherCurrentCondition.TempF + strDegreeSymbol;
			strCCTemperatureText	= strUnitTemperatureF.toLowerCase();
			
			if(oWeatherDay1)
			{
				strDay1TempMax			= oWeatherDay1.FMax + strDegreeSymbol;
				strDay1TempMin			= oWeatherDay1.FMin + strDegreeSymbol;
			}
			
			if(oWeatherDay2)
			{
				strDay2TempMax			= oWeatherDay2.FMax + strDegreeSymbol;
				strDay2TempMin			= oWeatherDay2.FMin + strDegreeSymbol;
			}
			
			if(oWeatherDay3)
			{
				strDay3TempMax			= oWeatherDay3.FMax + strDegreeSymbol;
				strDay3TempMin			= oWeatherDay3.FMin + strDegreeSymbol;
			}
		}
		
		oLabelChangeTo.setAttribute('value',strCahngeTo);
		oLabelCCFeelsLike.setAttribute('value',strCCFeelsLike);
		oLabelCCTemperature.setAttribute('value',strCCTemperature);
		oLabelCCTemperatureText.setAttribute('value',strCCTemperatureText);
		
		oLabelDay1TempMax.setAttribute('value',strDay1TempMax);
		oLabelDay1TempMin.setAttribute('value',strDay1TempMin);
		
		oLabelDay2TempMax.setAttribute('value',strDay2TempMax);
		oLabelDay2TempMin.setAttribute('value',strDay2TempMin);
	
		oLabelDay3TempMax.setAttribute('value',strDay3TempMax);
		oLabelDay3TempMin.setAttribute('value',strDay3TempMin);
		
		
	},
	
	LoadErrorPanel : function()
	{	
		//set the focus on the back
		var oButtonBack4 = document.getElementById('btnBack4');
		oButtonBack4.focus();
		
		this.SwitchToPanel(EBWeatherDialogConsts_CT459487.Panels.ErrorPanel);	
	},
	
	GetDialog : function()
	{
		var strWeatherDialogType = EBWeatherDialogConsts_CT459487.DialogType;
		var strWeatherDialogName = EBWeatherDialogConsts_CT459487.DialogName;
		
		var oWeatherDialog = EBGlobalManager_CT459487.GetXULWindowByTypeAndName(strWeatherDialogType,strWeatherDialogName);
			
		return oWeatherDialog;
	},
	
	Close : function()
	{
		var oWeatherDialog = this.GetDialog();
		if(oWeatherDialog)
		{
			oWeatherDialog.close();
		}
	}

}
var EBWeatherConsts_CT459487 = 
{
	DefaultInterval : 20,
	
	URL	: 
	{
		DefaultServer		: 'http://services.conduit.com/weatherrequest.ctp',
		QS_SEARCH			: '?type=search&platform=fx&cityname=',
		QS_FORECAST			: '?type=forecast&imagetype=DEFAULT&locationid=',
		DefaultWebSearch	: 'http://search.conduit.com/'
	}
	
}

var EBWeatherStateConsts_CT459487 = 
{
	UNAVAILABLE : -1,
	START		: 0,
	FORECAST	: 1
}


var EBWeatherGUIConsts_CT459487 = 
{
	Caption					: 'Weather',
	ForecastTooltipID		: 'EBWeatherForecastTooltip_CT459487',
	Image					: 'chrome://folkoteka.com/skin/weather.png',
	ImageNA					: 'chrome://folkoteka.com/skin/weather_na.png',
	CaptionNA				: 'No Data'
}

//manager of the weather data.
//each load function is load the data from a file and return it object data
//each save function is the opposite - from an object back to the file
var EBWeatherManager_CT459487 = 
{
	TimeoutID				: null,
	
	//timeout interval set to one minute
	TimeoutInterval			: 60000,
	
	ActivateTimeoutInterval : 1000,

	Initialize : function()
	{
		this.Start();
	},
	
	Terminate : function()
	{
		this.ClearTimeoutID();
	},
	
	ClearTimeoutID : function()
	{
		if(this.TimeoutID)
		{
			clearTimeout(this.TimeoutID);
			this.TimeoutID = null;
		}
	},
	
	//when the toolbar loads there is a check if there is 
	//current city suggestion - this is the indication that the toolbar
	//made search and need to activated the check mechanism
	//if not - the toolbarbutton displays regular weather button
	Start : function()
	{
		var oWeatherSuggestionCurrent	= this.LoadWeatherCurrentCity();
		if(oWeatherSuggestionCurrent)
		{
			var oWeatherForecast = this.LoadWeatherForecast();
			if(oWeatherForecast && !this.IsTimeElapsed())
			{
				this.SetToolbarButtonForecast(oWeatherForecast,oWeatherSuggestionCurrent);
			}
			
			this.ActivateTimeoutCheck();
			
		}
		else
		{
			this.SetToolbarButtonStart();
		}
	},
	
	ActivateTimeoutCheck : function()
	{
		setTimeout('EBWeatherManager_CT459487.TimeoutCheck();',EBWeatherManager_CT459487.ActivateTimeoutInterval);
	},
	
	//check every minute if need to go to the server
	TimeoutCheck : function()
	{
		if(this.IsTimeElapsed() || this.IsWeatherNetworkError())
		{
			var oWeatherSuggestionCurrent	= this.LoadWeatherCurrentCity();
			if(oWeatherSuggestionCurrent)
			{
				this.CheckFromServer(oWeatherSuggestionCurrent);
			}
		}
		
		this.TimeoutID = setTimeout('EBWeatherManager_CT459487.TimeoutCheck();',EBWeatherManager_CT459487.TimeoutInterval);
	},
	
	IsTimeElapsed : function()
	{
		var bRetVal = true;
		var strPrefWeatherPollDate = EBWeatherPreferencesManager_CT459487.GetWeatherPollDate();	
		if(strPrefWeatherPollDate)
		{
			var iIntervalMinutes = this.GetWeatherInterval();
			
			var oDateCurrent	= new Date();
			var oDatePollDate	= new Date(strPrefWeatherPollDate);
			
			var iCheckIntervalTime	= 1000*60*iIntervalMinutes;
			
			var iDateDiff = oDateCurrent - oDatePollDate;
			
			bRetVal = iDateDiff > iCheckIntervalTime;
		}
		
		return bRetVal;
	
	},
	
	CheckFromServer : function(oWeatherSuggestionCurrent)
	{
		//update the poll date to now
		EBWeatherPreferencesManager_CT459487.SetWeatherPollDate();
		
		var strLocationID	 = oWeatherSuggestionCurrent.LocationID;
		
		var strServerURL		= this.GetWeatherServerURL();
		var strFullServerURL	= strServerURL + EBWeatherConsts_CT459487.URL.QS_FORECAST + strLocationID;
		
		var oCallBackFunction = function(XMLDoc,o)
		{
			EBWeatherManager_CT459487.ServerResponse(XMLDoc,o,oWeatherSuggestionCurrent);
		};
		this.ServerRequest(strFullServerURL,oCallBackFunction);
	},
	
	
	//when the server callback activate we check if there was network error
	//to mark it in the prefs or the xml is not valid - UNAVAILABLE state
	//if the xmldoc is valid the state is FORECAST
	//after the check broadcast changes to all browsers
	ServerResponse : function(XMLDoc,o,oWeatherSuggestionCurrent)
	{
		var oWeatherForecast = null;
		var iState	= null;
		if(o.value == EBGlobalConsts_CT459487.NetworkError)
		{
			//mark server error in prefs:
			EBWeatherPreferencesManager_CT459487.SetWeatherNetwork(EBGlobalConsts_CT459487.NetworkError);
			iState = EBWeatherStateConsts_CT459487.UNAVAILABLE;
		}
		else
		{
			//mark no server error
			EBWeatherPreferencesManager_CT459487.SetWeatherNetwork('');
		
			//check if it's legal forecast xml from the server
			if(this.IsValidWeatherXMLDoc(XMLDoc))
			{
				oWeatherForecast = EBWeatherDataFactory_CT459487.XMLToWeatherForecast(XMLDoc);
			}
			if(oWeatherForecast)
			{
				iState = EBWeatherStateConsts_CT459487.FORECAST;
				//save it to file
				this.SaveWeatherForecast(oWeatherForecast);
			}
			else
			{
				iState = EBWeatherStateConsts_CT459487.UNAVAILABLE;
			}
		}
		
		if(iState == EBWeatherStateConsts_CT459487.UNAVAILABLE)
		{
			//nullify the file
			this.NullifyWeatherForecast();
		}
		
		
		//put here the broadcast call
		this.Broadcast(iState,oWeatherForecast,oWeatherSuggestionCurrent);
			
	},
	
	OnCommandWeatherToolbarButton : function(event)
	{
		//get the x position from the element
		var oXULElement			= event.target;
		var iDialogWidth		= EBWeatherDialogConsts_CT459487.DialogWidth;
		
		var oCoordinates		= EBActionManager_CT459487.GetToolbarDialogOpeningCoordinates(oXULElement,iDialogWidth);

		EBWeatherDialogManager_CT459487.Open(oCoordinates.X,oCoordinates.Y);
		
		//send usage
		this.RequestWeatherUsage();
	},
	
	RequestWeatherUsage : function()
	{
		var strComponentID		= EBComponentsConsts_CT459487.ComponentsID.Weather;
		var strComponentType	= EBUsageConsts_CT459487.WEATHER;
		
		//create the usage object
		var objUsage = new EBUsageObject_CT459487(strComponentID,
													strComponentType,
													'',
													'');
		//send the data
		objUsage.SendRequest();	
	},
	
	LoadWeatherWebSearch : function(event,oWeatherForecast,oWeatherSuggestionCurrent)
	{
		var strWebSearchURL = this.GetWeatherWebSearchURL();
		
		//get the data for the url
		var strCityName		= oWeatherSuggestionCurrent.City;
		var strCountry		= oWeatherSuggestionCurrent.Country;
		var strCityCountry	= strCityName + ',' + strCountry;
		var strLocationID	= oWeatherForecast.LocationID;
		var strCTID			= EBGlobalConsts_CT459487.ToolbarCTID;
		
		var strWeatherUnit = '';
		var strPrefUnit = EBWeatherPreferencesManager_CT459487.GetWeatherUnits();
		if(strPrefUnit == EBWeatherUnits_CT459487.TEMPERATURE_C)
		{
			strWeatherUnit = EBWeatherUnits_CT459487.TEMPERATURE_C;
		}
		else
		{
			strWeatherUnit = EBWeatherUnits_CT459487.TEMPERATURE_F;
		}
		strWeatherUnit = strWeatherUnit.toLowerCase();
		
		//assembly the url
		var strFullWebSearchURL = strWebSearchURL + 
								'Results.aspx' +
								'?q=Weather:' + strCityName + 
								'&wbl=1' +
								'&WeatherLocationId=' + strLocationID + 
								'&WeatherCityLocation=' + strCityCountry + 
								'&ctid=' + strCTID + 
								'&wunits=' + strWeatherUnit;
		
		//since the search called from dialog i bring the last browser window
		var oBrowserWindow = EBGlobalManager_CT459487.GetMostRecentBrowserWindow();
		oBrowserWindow.EBLinkManager_CT459487.LoadLinkURL(event,strFullWebSearchURL,false,null);
			
	},
	
	
	//the weather history is a search objects that hold in the 
	//suggestion collection the current and the 1-2-3 history cities
	LoadWeatherHistory : function()
	{
		var oWeatherSearch = null;
		
		var strXML = EBWeatherIOManager_CT459487.ReadHistory();
		
		if(strXML)
		{
			var XMLDoc = EBGlobalManager_CT459487.GetXmlDocument(strXML);
			oWeatherSearch = EBWeatherDataFactory_CT459487.XMLToWeatherSearch(XMLDoc);
		}
		
		return oWeatherSearch;
	},
	
	SaveWeatherHistory : function(oWeatherSearch)
	{
		var strXML = oWeatherSearch.XMLSerialize();
		EBWeatherIOManager_CT459487.WriteHistory(strXML);			
	},
	
	LoadWeatherCurrentCity : function()
	{
		var oWeatherSuggestion = null;
		var oWeatherSearch = this.LoadWeatherHistory();
		if(oWeatherSearch)
		{
			oWeatherSuggestion = oWeatherSearch.SuggestionCollection.Collection.GetItem(0);
		}
		
		return oWeatherSuggestion;
	},
	
	LoadWeatherForecast : function()
	{
		var oWeatherForecast = null;
		
		var strXML = EBWeatherIOManager_CT459487.ReadForecast();
		
		if(strXML)
		{
			var XMLDoc = EBGlobalManager_CT459487.GetXmlDocument(strXML);
			oWeatherForecast = EBWeatherDataFactory_CT459487.XMLToWeatherForecast(XMLDoc);
		}
		
		return oWeatherForecast;
	},
	
	SaveWeatherForecast : function(oWeatherForecast)
	{
		var strXML = oWeatherForecast.XMLSerialize();
		EBWeatherIOManager_CT459487.WriteForecast(strXML);
	},
	
	//save the suggestion whether it a new one (from the combo selection)
	//of if it's change from the history. 
	SaveSuggestionsHistory : function(oNewWeatherSuggestionCurrent)
	{
		var oWeatherSearchHistory =  this.LoadWeatherHistory();
		
		var oWeatherSuggestionCollection = null;
		
		
		var oNewWeatherSuggestionHistory1ToSet = null;
		var oNewWeatherSuggestionHistory2ToSet = null;
		var oNewWeatherSuggestionHistory3ToSet = null;
		
		if(oWeatherSearchHistory)
		{
			oWeatherSuggestionCollection = oWeatherSearchHistory.SuggestionCollection;
		
			//load all the suggestions history
			var oWeatherSuggestionCurrent	= oWeatherSuggestionCollection.Collection.GetItem(0);
			var oWeatherSuggestionHistory1	= oWeatherSuggestionCollection.Collection.GetItem(1);
			var oWeatherSuggestionHistory2	= oWeatherSuggestionCollection.Collection.GetItem(2);
			var oWeatherSuggestionHistory3	= oWeatherSuggestionCollection.Collection.GetItem(3);
		
			var strNewLocationID		= '';
			var strCurrentLocationID	= '';
			var strHistory1LocationID	= '';
			var strHistory2LocationID	= '';
			
			var bIsSaveHistory1			= false;
			var bIsSaveHistory2			= false;
			
			//get all the locations id of the suggestions
			strNewLocationID			= oNewWeatherSuggestionCurrent.LocationID;
			if(oWeatherSuggestionCurrent)
			{
				strCurrentLocationID	= oWeatherSuggestionCurrent.LocationID;
			}
			if(oWeatherSuggestionHistory1)
			{
				strHistory1LocationID	= oWeatherSuggestionHistory1.LocationID;
			}
			if(oWeatherSuggestionHistory2)
			{
				strHistory2LocationID	= oWeatherSuggestionHistory2.LocationID;
			}
			
			//check if to save the current city to history1 (if it's exists and if it's not like the new current)
			if(oWeatherSuggestionCurrent && strCurrentLocationID != strNewLocationID)
			{
				bIsSaveHistory1 = true;
				oNewWeatherSuggestionHistory1ToSet = oWeatherSuggestionCurrent;
			}
			else
			{
				oNewWeatherSuggestionHistory1ToSet = oWeatherSuggestionHistory1;
			}
			
			//check the rest of the saves history items.
			//only if saves the previous object and it's not like the new current i save the previous object 
			//to the next spot (history1 to history2)
			if(bIsSaveHistory1  && oWeatherSuggestionHistory1 && strHistory1LocationID != strNewLocationID)
			{
				bIsSaveHistory2 = true;
				oNewWeatherSuggestionHistory2ToSet = oWeatherSuggestionHistory1;
			}
			else
			{
				oNewWeatherSuggestionHistory2ToSet = oWeatherSuggestionHistory2;
			}
			
			//check to save history2 to history3
			if(bIsSaveHistory2 && oWeatherSuggestionHistory2 && strHistory2LocationID != strNewLocationID) 
			{
				oNewWeatherSuggestionHistory3ToSet = oWeatherSuggestionHistory2;
			}
			else
			{
				oNewWeatherSuggestionHistory3ToSet = oWeatherSuggestionHistory3;
			}
			
		}
		
		
		//make the search object and save it to file
		oWeatherSuggestionCollection = new EBWeatherSuggestionCollection_CT459487();
		//add the elements to the suggestion:
		oWeatherSuggestionCollection.Collection.AppendElement(oNewWeatherSuggestionCurrent);
		if(oNewWeatherSuggestionHistory1ToSet)
		{	
			oWeatherSuggestionCollection.Collection.AppendElement(oNewWeatherSuggestionHistory1ToSet);
		}
		if(oNewWeatherSuggestionHistory2ToSet)
		{	
			oWeatherSuggestionCollection.Collection.AppendElement(oNewWeatherSuggestionHistory2ToSet);
		}
		if(oNewWeatherSuggestionHistory3ToSet)
		{	
			oWeatherSuggestionCollection.Collection.AppendElement(oNewWeatherSuggestionHistory3ToSet);
		}
		
		oWeatherSearchHistory = new EBWeatherSearch_CT459487(oWeatherSuggestionCollection);
		
		//save it to file
		this.SaveWeatherHistory(oWeatherSearchHistory);
	},
	
	
	NullifyWeatherForecast : function()
	{
		EBWeatherIOManager_CT459487.WriteForecast('');
	},
	
	IsNoResultsResponse : function(XMLDoc)
	{
		var XMLRoot = XMLDoc.documentElement;
		var strNodeValue = EBGlobalManager_CT459487.GetXmlNodeValue(XMLRoot);
		
		return strNodeValue == EBWeatherXMLConsts_CT459487.NORESULTS ? true : false;
	},
	
	//the server call which try to retrieve XML
	ServerRequest : function(strURL,oCallBackFunction)
	{
		//return the object
		return EBGlobalManager_CT459487.HTTPServerRequest(strURL,null,true,oCallBackFunction);
	},
	
	IsValidWeatherXMLDoc : function(XMLDoc)
	{
		if(XMLDoc && !this.IsNoResultsResponse(XMLDoc))
		{
			return true;
		}
		else
		{
			return false;
		}
	},
	
	//check if there was network problem that mark in the prefs
	IsWeatherNetworkError : function()
	{
		var strWeatherNetwork = EBWeatherPreferencesManager_CT459487.GetWeatherNetwork();	
		
		return strWeatherNetwork == EBGlobalConsts_CT459487.NetworkError ? true : false;
	},
	
	//all the date from the component calling using the GetMostRecentBrowserWindow
	//function cause this function calling from the dialog as well which
	//the data(toolbar components) not define there but only in the browsers window
	GetWeatherServerURL : function()
	{
		var oBrowserWindow = EBGlobalManager_CT459487.GetMostRecentBrowserWindow();
		var strServerURL = '';	
		var oWeatherComponent = oBrowserWindow.EBComponentsManager_CT459487.GetWeatherComponent();
		if(oWeatherComponent)
		{
			strServerURL = oWeatherComponent.ComponentItem.ServerURL;
		}
		
		if(!strServerURL)
		{
			strServerURL = EBWeatherConsts_CT459487.URL.DefaultServer;
		}
		
		return strServerURL;
	},
	
	GetWeatherWebSearchURL : function()
	{
		var oBrowserWindow = EBGlobalManager_CT459487.GetMostRecentBrowserWindow();
		var strWebSearchURL = '';	
		var oWeatherComponent = oBrowserWindow.EBComponentsManager_CT459487.GetWeatherComponent();
		if(oWeatherComponent)
		{
			strWebSearchURL = oWeatherComponent.ComponentItem.WebSearchURL;
		}
		
		if(!strWebSearchURL)
		{
			strWebSearchURL = EBWeatherConsts_CT459487.URL.DefaultWebSearch;
		}
		
		return strWebSearchURL;
	},
	
	GetWeatherInterval : function()
	{
		var oBrowserWindow = EBGlobalManager_CT459487.GetMostRecentBrowserWindow();
		var iInterval = null;
		var oWeatherComponent = oBrowserWindow.EBComponentsManager_CT459487.GetWeatherComponent();
		if(oWeatherComponent)
		{
			iInterval = oWeatherComponent.ComponentItem.Interval;
		}
		
		if(!iInterval)
		{
			iInterval = EBWeatherConsts_CT459487.DefaultInterval;	
		}
		
		return iInterval;
	},
	
	GetWeatherDefaultCation : function()
	{
		var oBrowserWindow = EBGlobalManager_CT459487.GetMostRecentBrowserWindow();
		var strCaption = '';
		var oWeatherComponent = oBrowserWindow.EBComponentsManager_CT459487.GetWeatherComponent();
		if(oWeatherComponent)
		{
			strCaption = oWeatherComponent.ComponentItem.Button.text;
		}
		
		if(!strCaption)
		{
			strCaption = EBWeatherGUIConsts_CT459487.Caption;	
		}
		
		return strCaption;	
	},
	
	//this function is not calling using the last browser opened
	//cause it's calling from the broadcast per browser
	GetWeatherToolbarButton : function()
	{
		var oXULToolbarButton = null;
		var oWeatherComponent = EBComponentsManager_CT459487.GetWeatherComponent();
		if(oWeatherComponent)
		{
			oXULToolbarButton = oWeatherComponent.XULElement;
		}
		
		return oXULToolbarButton;
	},
	
	SetToolbarButtonCaptionImage : function(strLabel,strImage)
	{
		var oXULToolbarButton = this.GetWeatherToolbarButton();
		if(oXULToolbarButton)
		{
			oXULToolbarButton.setAttribute('label',strLabel);
			oXULToolbarButton.setAttribute('image',strImage);
		}	
	},
	
	SetToolbarButtonForecastTooltip : function()
	{
		var oXULToolbarButton = this.GetWeatherToolbarButton();
		if(oXULToolbarButton)
		{
			var strForecastTooltipID = EBWeatherGUIConsts_CT459487.ForecastTooltipID;
			oXULToolbarButton.setAttribute('tooltip',strForecastTooltipID);
			oXULToolbarButton.removeAttribute('tooltiptext');
		}
	},
	
	SetToolbarButtonDefaultTooltip : function()
	{
		var oXULToolbarButton = this.GetWeatherToolbarButton();
		if(oXULToolbarButton)
		{
			oXULToolbarButton.removeAttribute('tooltip');
			var strWeatherCompID = EBComponentsConsts_CT459487.ComponentsID.Weather;
			//set the tooltip according to the state of the toolbar
			if(EBActionManager_CT459487.IsToolbarShrink())
			{
				EBToolbarDesignManager_CT459487.SetTooltipShrink(strWeatherCompID,oXULToolbarButton);
			}
			else
			{
				EBToolbarDesignManager_CT459487.SetTooltipUnShrink(oXULToolbarButton);
			}
		}
	},
	
	SetToolbarButtonUnavailable : function()
	{
		var strLabel = EBWeatherGUIConsts_CT459487.CaptionNA;
		var strImage = EBWeatherGUIConsts_CT459487.ImageNA;
		this.SetToolbarButtonCaptionImage(strLabel,strImage);
		this.SetToolbarButtonDefaultTooltip();
	},
	
	SetToolbarButtonStart : function()
	{
		var strLabel = this.GetWeatherDefaultCation();
		var strImage = EBWeatherGUIConsts_CT459487.Image;
		this.SetToolbarButtonCaptionImage(strLabel,strImage);
		this.SetToolbarButtonDefaultTooltip();
	},
	
	SetToolbarButtonForecast : function(oWeatherForecast,oWeatherSuggestionCurrent)
	{
		var oCurrentCondition = oWeatherForecast.CurrentCondition;
		var strImage = 	oCurrentCondition.ButtonIcon;
		
		var strTemperature	= null;
		var strFeelsLike	= null;
 		var strWeatherUnit = '';
		var strPrefUnit = EBWeatherPreferencesManager_CT459487.GetWeatherUnits();
		if(strPrefUnit == EBWeatherUnits_CT459487.TEMPERATURE_C)
		{
			strWeatherUnit = EBWeatherUnits_CT459487.TEMPERATURE_C;
			strTemperature = oCurrentCondition.TempC;
			strFeelsLike   = oCurrentCondition.FeelsLikeC;
		}
		else
		{
			strWeatherUnit = EBWeatherUnits_CT459487.TEMPERATURE_F;
			strTemperature = oCurrentCondition.TempF;
			strFeelsLike   = oCurrentCondition.FeelsLikeF;
		}
		
		var strLabel =  strTemperature + EBGlobalConsts_CT459487.DegreeSymbol + strWeatherUnit;
		this.SetToolbarButtonCaptionImage(strLabel,strImage);
		
		var strCityCountryCaption	= EBWeatherDialogManager_CT459487.GetCityCountryCaption(oWeatherSuggestionCurrent);
		var strSky					= oCurrentCondition.Sky;
		var strTooltipIcon			= oCurrentCondition.TooltipIcon;
		
		//set the tooltip elements
		var oLabelTooltipCaption	= document.getElementById('lblWeatherTooltipCaption_CT459487');
		var oImageTooltipIcon		= document.getElementById('imgWeatherTooltipIcon_CT459487');
		var oLabelTooltipFeelsLike	= document.getElementById('lblWeatherTooltipFeelsLike_CT459487');
		var oLabelTooltipSky		= document.getElementById('lblWeatherTooltipSky_CT459487');
		
		var strTooltipCaption		= 'The weather in ' + strCityCountryCaption;
		var strTooltipFeelsLike		= 'Feels like: ' + strFeelsLike + EBGlobalConsts_CT459487.DegreeSymbol + strWeatherUnit;
		var strTooltipSky			= 'Sky: ' + strSky;
		
		oLabelTooltipCaption.setAttribute('value',strTooltipCaption);
		oImageTooltipIcon.setAttribute('src',strTooltipIcon);
		oLabelTooltipFeelsLike.setAttribute('value',strTooltipFeelsLike);
		oLabelTooltipSky.setAttribute('value',strTooltipSky);
		
		this.SetToolbarButtonForecastTooltip();
		
		
	},
	
	SetToolbarWeather : function(iState,oWeatherForecast,oWeatherSuggestionCurrent)
	{
		if(iState == EBWeatherStateConsts_CT459487.UNAVAILABLE)
		{
			this.SetToolbarButtonUnavailable();
		}
		else if(iState == EBWeatherStateConsts_CT459487.FORECAST && oWeatherForecast && oWeatherSuggestionCurrent)
		{
			this.SetToolbarButtonForecast(oWeatherForecast,oWeatherSuggestionCurrent);
		}
		else
		{
			this.SetToolbarButtonStart();
		}
		
		
		//since the broadcast can come from the dialog as well 
		//i check if this browser activated the thread check and if not activate it
		if(!this.TimeoutID)
		{
			this.ActivateTimeoutCheck();
		}
		
	},
	
	Broadcast : function(iState,oWeatherForecast,oWeatherSuggestionCurrent)
	{
	
		var oWindowsManager = Components.classes['@mozilla.org/appshell/window-mediator;1']
						.getService(Components.interfaces.nsIWindowMediator);
		
		var oEnumerator = oWindowsManager.getEnumerator('navigator:browser');	
		while(oEnumerator.hasMoreElements()) 
		{
			var oWindow = oEnumerator.getNext();
			if(oWindow.EBWeatherManager_CT459487.SetToolbarWeather)
			{
				try
				{
					oWindow.EBWeatherManager_CT459487.SetToolbarWeather(iState,oWeatherForecast,oWeatherSuggestionCurrent);
				}
				catch(ex){}
			}
		}
	}
	
}
var EBWeatherIOConsts_CT459487 = 
{
	FolderName					: 'weather',
	HistoryFileName				: 'history.xml',
	ForecastFileName			: 'forecast.xml'
}


var EBWeatherIOManager_CT459487 = 
{
	GetWeatherFullPath : function(strFileName)
	{
		var strWeatherFolderName = EBWeatherIOConsts_CT459487.FolderName;
		
		var strWeatherFullPath = strWeatherFolderName + EBDirIO_CT459487.sep + strFileName;
		
		return strWeatherFullPath;
	},
	
	GetWeatherFile : function(strFileName)
	{
		var strWeatherFullPath = this.GetWeatherFullPath(strFileName);
		var oFile = EBIOManager_CT459487.CreateToolbarFile(strWeatherFullPath);	
		
		return oFile;
	},

	WriteWeatherFile : function(strFileName,strContent)
	{
		var bSuccess = false;
		var oFile = this.GetWeatherFile(strFileName);
		if(oFile)
		{
			bSuccess = EBFileIO_CT459487.write(oFile,strContent,"",EBGlobalConsts_CT459487.DefaultCharset);
		}
		
		return bSuccess;
	},
	
	ReadWeatherFile : function(strFileName)
	{
		var strContent = '';
		var oFile = this.GetWeatherFile(strFileName);
		if(oFile)
		{	
			strContent = EBFileIO_CT459487.read(oFile,EBGlobalConsts_CT459487.DefaultCharset);
		}
		
		return strContent;
	},

	
	GetHistoryFileName : function()
	{
		var strFileName = EBWeatherIOConsts_CT459487.HistoryFileName;
		return strFileName;
	},
	
	ReadHistory : function()
	{
		var strFileName = this.GetHistoryFileName();
		
		var strContent = this.ReadWeatherFile(strFileName);
		
		return strContent;
	},
	
	WriteHistory : function(strContent)
	{
		var strFileName = this.GetHistoryFileName();
		this.WriteWeatherFile(strFileName,strContent);
	},
	
	
	GetForecastFileName : function()
	{	
		var strFileName = EBWeatherIOConsts_CT459487.ForecastFileName;
		return strFileName;
	},
	
	
	ReadForecast : function()
	{
		var strFileName = this.GetForecastFileName();
		
		var strContent = this.ReadWeatherFile(strFileName);
		
		return strContent;
	},
	
	WriteForecast : function(strContent)
	{
		var strFileName = this.GetForecastFileName();
		this.WriteWeatherFile(strFileName,strContent);
	}
	
}



var EBWeatherPreferencesManager_CT459487 = 
{
	GetWeatherUnitPrefName : function()
	{
		var strWeatherUnitPrefName = EBPreferenceConsts_CT459487.WeatherUnit;
		return 	strWeatherUnitPrefName;
	},
	
	GetWeatherPollDatePrefName : function()
	{
		var strWeatherPollDatePrefName = EBPreferenceConsts_CT459487.WeatherPollDate;
		return 	strWeatherPollDatePrefName;
	},
	
	GetWeatherNetworkPrefName : function()
	{
		var strWeatherNetworkPrefName = EBPreferenceConsts_CT459487.WeatherNetwork;	
		return strWeatherNetworkPrefName;
	},

	GetWeatherUnits : function()
	{
		var strWeatherUnit = '';
		
		var strWeatherUnitPrefName = this.GetWeatherUnitPrefName();
		
		strWeatherUnit = EBToolbarPreferenceManager_CT459487.GetPref(strWeatherUnitPrefName);
		
		if(!strWeatherUnit)
		{
			//save default value
			strWeatherUnit = EBWeatherUnits_CT459487.TEMPERATURE_F;
			this.SetWeatherUnit(strWeatherUnit);
		}
		
		return strWeatherUnit;
		
	},
	
	SetWeatherUnit : function(strWeatherUnit)
	{
		var strWeatherUnitPrefName = this.GetWeatherUnitPrefName();
		EBToolbarPreferenceManager_CT459487.SetPref(strWeatherUnitPrefName,strWeatherUnit);
	},
	
	GetWeatherPollDate : function()
	{
		var strWeatherPollDate = '';
		var strWeatherPollDatePrefName = this.GetWeatherPollDatePrefName();
		strWeatherPollDate = EBToolbarPreferenceManager_CT459487.GetPref(strWeatherPollDatePrefName);
		
		return strWeatherPollDate;
	},
	
	SetWeatherPollDate : function()
	{
		var oDate = new Date();
		var strWeatherPollDateValue = oDate.toString();
		var strWeatherPollDatePrefName = this.GetWeatherPollDatePrefName();
		EBToolbarPreferenceManager_CT459487.SetPref(strWeatherPollDatePrefName,strWeatherPollDateValue);
	},
	
	GetWeatherNetwork : function()
	{
		var strWeatherNetwork = '';
		var strWeatherNetworkPrefName = this.GetWeatherNetworkPrefName();
		strWeatherNetwork = EBToolbarPreferenceManager_CT459487.GetPref(strWeatherNetworkPrefName);
		
		return strWeatherNetwork;
	},
	
	SetWeatherNetwork : function(strWeatherNetwork)
	{
		var strWeatherNetworkPrefName = this.GetWeatherNetworkPrefName();
		EBToolbarPreferenceManager_CT459487.SetPref(strWeatherNetworkPrefName,strWeatherNetwork);
	}
	
}



