
var EBGenericXMLConsts_CT459487 = 
{
	GENERIC			: 'GENERIC',
	TOOLBAR			: 'TOOLBAR',
	LOGO			: 'LOGO',
	NAME			: 'NAME',
	CTID			: 'CTID'
}

function EBGenericData_CT459487(oGenericToolbarDataArrayHash)
{
	this.ArrayHash = oGenericToolbarDataArrayHash;
	
	this.XMLSerialize = function()
	{
		var strXMLGeneric	= EBGenericXMLConsts_CT459487.GENERIC;
		var strXML = '';
		strXML += '<' + strXMLGeneric + '>';
		
		var oGenericToolbarData = null;
		var iCount = this.ArrayHash.Count();
		
		for(var i=0;i<iCount;i++)
		{
			oGenericToolbarData = this.ArrayHash.GetByIndex(i);
			strXML += oGenericToolbarData.XMLSerialize();
		}
		
		strXML += '</' + strXMLGeneric + '>';
		return strXML;
	};
}


function EBGenericToolbarData_CT459487(strCTID,strName,strLogo)
{
	this.CTID	= strCTID;
	this.Name	= strName;
	this.Logo	= strLogo;
	
	this.XMLSerialize = function()
	{
		var strXMLToolbar	= EBGenericXMLConsts_CT459487.TOOLBAR;
		var strXMLCTID		= EBGenericXMLConsts_CT459487.CTID;
		var strXMLName		= EBGenericXMLConsts_CT459487.NAME;
		var strXMLLogo		= EBGenericXMLConsts_CT459487.LOGO;
		
		var strXML = '';
		strXML +=	 '<' + strXMLToolbar + '>';
		strXML +=		'<' + strXMLCTID+ '>' + this.CTID + '</' + strXMLCTID+ '>';
		strXML +=		'<' + strXMLName+ '>' + this.Name + '</' + strXMLName+ '>';
		strXML +=		'<' + strXMLLogo+ '>' + this.Logo + '</' + strXMLLogo+ '>';
		strXML +=	'</' + strXMLToolbar + '>';
		
		return strXML;
	};
}

var EBGenericDataFactory_CT459487 = 
{
	XMLToGenericData : function(XMLDoc)
	{
		var oGenericData					= null;
		var oGenericToolbarDataArrayHash	= null;
		var oGenericToolbarData				= null;
		
		var strXMLGeneric	= EBGenericXMLConsts_CT459487.GENERIC;
		var strXMLToolbar	= EBGenericXMLConsts_CT459487.TOOLBAR;
		
		var XMLRoot			= XMLDoc.documentElement;
		var XMLChildNode	= null;
		
		if(XMLRoot.tagName == strXMLGeneric)
		{
			oGenericToolbarDataArrayHash = new EBArrayHashObject_CT459487();
			for(var i=0;i<XMLRoot.childNodes.length;i++)
			{
				XMLChildNode = XMLRoot.childNodes[i];
				if(XMLChildNode.tagName == strXMLToolbar)
				{
					oGenericToolbarData = this.XMLToGenericToolbarData(XMLChildNode);
					if(oGenericToolbarData)
					{
						oGenericToolbarDataArrayHash.Add(oGenericToolbarData.CTID,oGenericToolbarData);
					}
				}
			}
			
			if(oGenericToolbarDataArrayHash.Count() > 0)
			{
				oGenericData = new EBGenericData_CT459487(oGenericToolbarDataArrayHash);
			}
		}
		
		return oGenericData;
		
	},
	
	XMLToGenericToolbarData : function(XMLNode)
	{
		var oGenericToolbarData = null;
		
		var strXMLToolbar	= EBGenericXMLConsts_CT459487.TOOLBAR;
		var strXMLLogo		= EBGenericXMLConsts_CT459487.LOGO;
		var strXMLName		= EBGenericXMLConsts_CT459487.NAME;
		var strXMLCTID		= EBGenericXMLConsts_CT459487.CTID;
		
		//get the correct root node (depends in this is the xml document or a regular dom node)
		var XMLRoot			= XMLNode.ownerDocument ? XMLNode : XMLNode.documentElement;	
		var XMLChildNode	= null;
		
		if(XMLRoot.tagName == strXMLToolbar)
		{
			var strLogo = '';
			var strName = '';
			var strCTID	= '';
			for(var i=0;i<XMLRoot.childNodes.length;i++)
			{
				XMLChildNode = XMLRoot.childNodes[i];
				if(XMLChildNode.tagName == strXMLCTID)
				{
					strCTID = EBGlobalManager_CT459487.GetXmlNodeValue(XMLChildNode);
				}
				else if(XMLChildNode.tagName == strXMLName)
				{
					strName = EBGlobalManager_CT459487.GetXmlNodeValue(XMLChildNode);
				}
				else if(XMLChildNode.tagName == strXMLLogo)
				{
					strLogo = EBGlobalManager_CT459487.GetXmlNodeValue(XMLChildNode);
				} 
			}

			if(strCTID)
			{
				oGenericToolbarData = new EBGenericToolbarData_CT459487(strCTID,strName,strLogo);
			}
		}
		
		return oGenericToolbarData;
	}
}






var EBGenericDialogConsts_CT459487 = 
{
	XULFileName			  : 'generic.xul',
	DialogName			  : 'genericDialogName_CT459487',
	DialogType			  : 'EBGenericDialog_CT459487',
	
	Attributes : 
	{
		CTID	: 'EBAttributeCTID'
	}
}

var EBGenericDialogManager_CT459487 = 
{
	GetDialog : function()
	{
		var strDialogType = EBGenericDialogConsts_CT459487.DialogType;
		var strDialogName = EBGenericDialogConsts_CT459487.DialogName;
		
		var oGenericDialog = EBGlobalManager_CT459487.GetXULWindowByTypeAndName(strDialogType,strDialogName);
			
		return oGenericDialog;
	},

	Open : function()
	{
		var oGenericDialog = this.GetDialog();
		if(oGenericDialog)
		{
			oGenericDialog.focus();
		}
		else
		{
	
			var strChromePath = EBGlobalConsts_CT459487.ChromeContentPath + EBGenericDialogConsts_CT459487.XULFileName;	
		
			window.openDialog(strChromePath,
							EBGenericDialogConsts_CT459487.DialogName,
							'modal,centerscreen,chrome,resizable=no');
		}
	},
	
	OnLoad : function(event)
	{
		this.LoadToolbars();
	},
	
	LoadToolbars : function()
	{
		var oGenericData = EBGenericManager_CT459487.LoadGeneric();
		if(oGenericData)
		{
			var oGenericToolbarDataArrayHash = oGenericData.ArrayHash;
			var iCount = oGenericToolbarDataArrayHash.Count();
			var oGenericToolbarData = null;
			for(var i=0;i<iCount;i++)
			{
				oGenericToolbarData = oGenericToolbarDataArrayHash.GetByIndex(i);
				this.BuildTreeItemByToolbarData(oGenericToolbarData);
			}
		}	
	},
	
	BuildTreeItemByToolbarData : function(oGenericToolbarData)
	{
		var oTreeChildrenGeneric = document.getElementById('tcGeneric');
	
		var oXULTreeItem	= this.GenericToolbarDataToTreeItem(oGenericToolbarData);
		oTreeChildrenGeneric.appendChild(oXULTreeItem);
	},
	
	OnSelectTreeGeneric : function(event)
	{
		var oXULTree = event.target;
		var oSelectedTreeItem = this.GetSelectedTreeItem(oXULTree);
		if(oSelectedTreeItem)
		{
			var oGenericToolbarData = this.TreeItemToGenericToolbarData(oSelectedTreeItem);
			if(oGenericToolbarData)
			{
				var strCTID = oGenericToolbarData.CTID;
				if(EBGenericManager_CT459487.IsOriginalToolbar(strCTID))
				{
					this.SetButtonDeleteDisabled(true);
				}
				else
				{
					this.SetButtonDeleteDisabled(false);
				}
				document.getElementById('txtCTID').value = strCTID;
			}
		}
	},
	
	GenericToolbarDataToTreeItem : function(oGenericToolbarData)
	{
		var strCTID = oGenericToolbarData.CTID;
		var strName = oGenericToolbarData.Name;	
		var strLogo = oGenericToolbarData.Logo;
	
		var oXULTreeItem	= document.createElement('treeitem');
		var oXULTreeRow		= document.createElement('treerow');
		
		
		var oXULTreeCellCTID = document.createElement('treecell');
		var oXULTreeCellLogo = document.createElement('treecell');
		var oXULTreeCellName = document.createElement('treecell');
		
		oXULTreeCellCTID.setAttribute('label',strCTID.toUpperCase());
		oXULTreeCellLogo.setAttribute('src',strLogo);
		oXULTreeCellName.setAttribute('label',strName);
		
		oXULTreeRow.appendChild(oXULTreeCellCTID);
		oXULTreeRow.appendChild(oXULTreeCellLogo);
		oXULTreeRow.appendChild(oXULTreeCellName);
		
		oXULTreeItem.appendChild(oXULTreeRow);
		
		return oXULTreeItem;
	},
	
	TreeItemToGenericToolbarData : function(oTreeItem)
	{
		var oGenericToolbarData = null;
		var strCTID = oTreeItem.firstChild.childNodes[0].getAttribute('label');
		var strLogo = oTreeItem.firstChild.childNodes[1].getAttribute('src');
		var strName = oTreeItem.firstChild.childNodes[2].getAttribute('label');
		
		if(strCTID)
		{
			oGenericToolbarData = new EBGenericToolbarData_CT459487(strCTID,strName,strLogo);
		}
		return oGenericToolbarData;
	},
	
	OnDoubleClickTreeGeneric : function(event)
	{
		var oTreeGeneric = document.getElementById('treeGeneric');
		var iIndex = oTreeGeneric.treeBoxObject.getRowAt(event.clientX,event.clientY);
		if(iIndex > -1)
		{
			this.RequestNewToolbar(document.getElementById('txtCTID').value);
			window.close();
		}
	},
	
	OnButtonSetOriginal : function(event)
	{
		this.RequestNewToolbar(EBGlobalConsts_CT459487.ToolbarCTID);
		window.close();
	},
	
	GetSelectedTreeItem : function(oTree)
	{
		var oTreeItem = null;
		var iIndex = oTree.currentIndex;
		if(iIndex != -1)
		{
			oTreeItem = oTree.contentView.getItemAtIndex(iIndex);
		}
		return oTreeItem;
	},
	
	SetButtonDeleteDisabled : function(bDisabled)
	{
		var oButtonDelete = document.getElementById('btnDelete');
		oButtonDelete.disabled = bDisabled;
	},
	
	OnAccept : function(event)
	{
		if(this.IsLegalRequest())
		{
			this.SaveData();
			this.RequestNewToolbar(document.getElementById('txtCTID').value);
			return true;
		}
		
		return false;
	},
	
	SaveData : function()
	{
		var oTreeChildrenGeneric = document.getElementById('tcGeneric');
		
		var oTreeItemsCollection = oTreeChildrenGeneric.getElementsByTagName('treeitem');
		
		if(oTreeItemsCollection.length > 0)
		{
			var oGenericData = null;
			var oGenericToolbarDataArrayHash = new EBArrayHashObject_CT459487();
			var oGenericToolbarData = null;
			var oTreeItem = null;
			for(var i=0;i<oTreeItemsCollection.length;i++)
			{
				oTreeItem = oTreeItemsCollection.item(i);
				oGenericToolbarData = this.TreeItemToGenericToolbarData(oTreeItem);
				if(oGenericToolbarData)
				{
					oGenericToolbarDataArrayHash.Add(oGenericToolbarData.CTID,oGenericToolbarData);
				}	
			}
			if(oGenericToolbarDataArrayHash.Count() > 0)
			{
				oGenericData = new EBGenericData_CT459487(oGenericToolbarDataArrayHash);
			}
			
			if(oGenericData)
			{
				EBGenericManager_CT459487.SaveGeneric(oGenericData);
			}
		}
		
		
		
	},
	
	OnButtonDelete : function(event)
	{
		var oXULTree = document.getElementById('treeGeneric');
		var oSelectedTreeItem = this.GetSelectedTreeItem(oXULTree);
		if(oSelectedTreeItem)
		{
			oSelectedTreeItem.parentNode.removeChild(oSelectedTreeItem);
			document.getElementById('txtCTID').value = '';
			this.SetButtonDeleteDisabled(true);
		}
	},
	
	IsLegalRequest : function()
	{
		var oTextBoxCTID = document.getElementById('txtCTID');
		var strCTID = oTextBoxCTID.value;
		
		if(strCTID && !EBGlobalManager_CT459487.IsLegalCTID(strCTID))
		{
			EBGlobalManager_CT459487.Alert(window,'CTID','Illegal CTID!');
			oTextBoxCTID.focus();
			return false;
		}
		
		return true;
	},
	
	RequestNewToolbar : function(strCTID)
	{
		var oRecentBrowserWindow = EBGlobalManager_CT459487.GetMostRecentBrowserWindow();
		
		oRecentBrowserWindow.EBGenericManager_CT459487.RequestToolbar(strCTID);
	}
	
	
}

var EBGenericIOConsts_CT459487 = 
{
	FolderName				: 'generic',
	FileName				: 'generic.xml'
}


var EBGenericIOManager_CT459487 = 
{
	GetGenericFullPath : function()
	{
		var strGenericFolderName	= EBGenericIOConsts_CT459487.FolderName;
		var strGenericFileName		= EBGenericIOConsts_CT459487.FileName;
		
		var strGenericFullPath		= strGenericFolderName + EBDirIO_CT459487.sep + strGenericFileName;
		
		return strGenericFullPath;
	},
	
	GetGenericFile : function()
	{
		var strGenericFullPath = this.GetGenericFullPath();
		var oFile = EBIOManager_CT459487.CreateToolbarFile(strGenericFullPath);	
		
		return oFile;
	},
	
	WriteGenericFile : function(strContent)
	{
		var bSuccess = false;
		var oFile = this.GetGenericFile();
		if(oFile)
		{
			bSuccess = EBFileIO_CT459487.write(oFile,strContent,"",EBGlobalConsts_CT459487.DefaultCharset);
		}
		
		return bSuccess;
	},
	
	ReadGenericFile : function()
	{
		var strContent = '';
		var oFile = this.GetGenericFile();
		if(oFile)
		{
			strContent = EBFileIO_CT459487.read(oFile,EBGlobalConsts_CT459487.DefaultCharset);
		}
		return strContent;
	}
}


var EBGenericManager_CT459487 = 
{
	LoadGeneric : function()
	{
		var oGenericData = null;
		
		var strXML = EBGenericIOManager_CT459487.ReadGenericFile();
		if(strXML)
		{
			var XMLDoc = EBGlobalManager_CT459487.GetXmlDocument(strXML);
			oGenericData = EBGenericDataFactory_CT459487.XMLToGenericData(XMLDoc);
		}	
		
		return oGenericData;
	},
	
	SaveGeneric : function(oGenericData)
	{
		var strXML = oGenericData.XMLSerialize();
		EBGenericIOManager_CT459487.WriteGenericFile(strXML);
	},
	
	RequestToolbar : function(strCTID)
	{
		if(EBGlobalManager_CT459487.IsLegalCTID(strCTID))
		{
			EBToolbarPreferenceManager_CT459487.SetPref(EBPreferenceConsts_CT459487.CTID,strCTID);
			
			//call it in a thread cause it's comes from a different window(the generic dialog)
			setTimeout(function(){EBSpecialCommands_CT459487.REFRESH_TOOLBAR_VIEW();},1);
		}
	},
	
	SettingsServerResponse : function()
	{
		var strCTID = EBActionManager_CT459487.GetCTID();

		var oArrayHash	 = null;
		var oGenericData = this.LoadGeneric();
		if(!oGenericData)
		{
			oArrayHash		= new EBArrayHashObject_CT459487();
			oGenericData	= new EBGenericData_CT459487(oArrayHash);	
		}
		else
		{
			oArrayHash			= oGenericData.ArrayHash;
		}

		var strToolbarLogo		= EBComponentsManager_CT459487.GetMainMenuToolbarLogo();
		var oGenericToolbarData = oArrayHash.GetByID(strCTID);
		if(oGenericToolbarData)
		{
			oGenericToolbarData.Logo = strToolbarLogo;
		}
		else
		{
			oGenericToolbarData = new EBGenericToolbarData_CT459487('','','');
			oGenericToolbarData.CTID = strCTID;
			oGenericToolbarData.Logo = strToolbarLogo;
			oArrayHash.Add(oGenericToolbarData.CTID,oGenericToolbarData);
		}
		
		var bIsOriginalToolbar = this.IsOriginalToolbar(strCTID);
		
		if(bIsOriginalToolbar)
		{
			oGenericToolbarData.Name = EBGlobalConsts_CT459487.ToolbarName;
		}
		
		//save the data
		this.SaveGeneric(oGenericData);
		
		if(!bIsOriginalToolbar)
		{
			//only if it's not the original toolbar request the toolbar name
			this.RequestToolbarName(strCTID);
		}

	},
	
	IsOriginalToolbar : function(strCTID)
	{
		return strCTID.toUpperCase() ==  EBGlobalConsts_CT459487.ToolbarCTID.toUpperCase();
	},
	
	GetSetupTXTURL : function(strCTID)
	{
		var strWebServerURL = EBActionManager_CT459487.GetWebServerURL();
		var strSetupTXTURL	= strWebServerURL + 'download/' + strCTID + '/setup.txt';
		return strSetupTXTURL;
	},
	
	RequestToolbarName : function(strCTID)
	{
		var strURL = this.GetSetupTXTURL(strCTID);
		
		var oCallBackFunction = function(strText,o)
		{
			EBGenericManager_CT459487.ResponseToolbarName(strCTID,strText);
		};
		
		EBGlobalManager_CT459487.HTTPServerRequest(strURL,null,false,oCallBackFunction);
	},
	
	ResponseToolbarName : function(strCTID,strContent)
	{
		var strToolbarName = '';
		//search real toolbar name
		var arrMatches = strContent.match(/_REALTOOLBARNAME_=([^\n|^\r]+)/i);
		if(arrMatches)
		{
			strToolbarName = arrMatches[1];
		}
		
		if(!strToolbarName)
		{
			arrMatches = strContent.match(/_BRANDTOOLBARNAME_=([^\n|^\r]+)/i);
			if(arrMatches)
			{
				strToolbarName = arrMatches[1];
			}
		}
		
		if(strToolbarName)
		{
			var oGenericData = this.LoadGeneric();
			if(oGenericData)
			{
				var oArrayHash			= oGenericData.ArrayHash;
				var oGenericToolbarData = oArrayHash.GetByID(strCTID);
				if(oGenericToolbarData)
				{
					oGenericToolbarData.Name = strToolbarName;
					this.SaveGeneric(oGenericData);
				}
			}
		}
	},
	
	CheckLandingPage : function(strURL)
	{
		//get the ctid
		var strCTID = '';
		var arrMatches = strURL.match(/.*\/landingpage.aspx\/([^\s]+)/i);
		
		if(arrMatches)
		{
			strCTID = arrMatches[1];
		}
		
		if(strCTID)
		{
			this.RequestToolbar(strCTID);
		}
		
	}
	
	
}