
var EBFeedXMLConsts_CT459487 = 
{
	FEED			: 'FEED',
	DATA			: 'DATA',
	TITLE			: 'TITLE',
	LINK			: 'LINK',
	STARED			: 'STARED',
	ITEMS			: 'ITEMS',
	ITEM			: 'ITEM',
	TOOLTIP			: 'TOOLTIP',
	STATUS			: 'STATUS',
	VISITED			: 'VISITED',
	HISTORY			: 'HISTORY',
	TRUE			: 'TRUE',
	FALSE			: 'FALSE',
	READ			: 'READ',
	UNREAD			: 'UNREAD'
}

function EBHistoryData_CT459487(oHistoryItemDataArrayHash)
{
	this.ArrayHash = oHistoryItemDataArrayHash;
	
	this.XMLSerialize = function()
	{
		var strXMLHistory		= EBFeedXMLConsts_CT459487.HISTORY;
		
		var strXML = '';
		strXML += '<' + strXMLHistory + '>';
		
		var oHistoryItemData = null;
		var iCount = this.ArrayHash.Count();	
		for(var i=0;i<iCount;i++)
		{
			oHistoryItemData = this.ArrayHash.GetByIndex(i);
			strXML += oHistoryItemData.XMLSerialize();
		}
		
		strXML += '</' + strXMLHistory + '>';
		return strXML;
	};
}

function EBHistoryItemData_CT459487(strLink)
{
	this.Link = strLink;
	
	this.XMLSerialize = function()
	{
		var strXML = '';
		var strXMLLink		= EBFeedXMLConsts_CT459487.LINK;
		strXML +=	'<' + strXMLLink+ '>' +  EBGlobalManager_CT459487.ToLegalXML(this.Link) + '</' + strXMLLink+ '>';
		return strXML;
	};
}

function EBFeedData_CT459487(oFeedDataData,oFeedItemArrayHashData)
{
	this.Data		= oFeedDataData;
	this.Items		= oFeedItemArrayHashData;
	
	this.XMLSerialize = function()
	{
		var strXMLFeed		= EBFeedXMLConsts_CT459487.FEED;
		var strXML = '';
		strXML +=	 '<' + strXMLFeed + '>';
		strXML +=		this.Data.XMLSerialize();
		strXML +=		this.Items.XMLSerialize();
		strXML +=	 '</' + strXMLFeed + '>';
	
		return strXML;
	};
}

function EBFeedDataData_CT459487(strTitle,strLink,bIsStared)
{
	this.Title	= strTitle;
	this.Link	= strLink;
	this.Stared	= bIsStared;
	
	this.XMLSerialize = function()
	{
		var strXMLData		= EBFeedXMLConsts_CT459487.DATA;
		var strXMLTitle		= EBFeedXMLConsts_CT459487.TITLE;
		var strXMLLink		= EBFeedXMLConsts_CT459487.LINK;
		var strXMLStared	= EBFeedXMLConsts_CT459487.STARED;
		
		var strXML = '';
		strXML +=	 '<' + strXMLData + '>';
		strXML +=		'<' + strXMLTitle + '>' + EBGlobalManager_CT459487.ToLegalXML(this.Title) + '</' + strXMLTitle + '>';
		strXML +=		'<' + strXMLLink + '>' + EBGlobalManager_CT459487.ToLegalXML(this.Link) + '</' + strXMLLink + '>';
		
		var strStared = this.Stared ? 
									EBFeedXMLConsts_CT459487.TRUE 
									: 
									EBFeedXMLConsts_CT459487.FALSE;
		
		strXML +=		'<' + strXMLStared + '>' + strStared + '</' + strXMLStared + '>';
		strXML +=	'</' + strXMLData + '>';
		
		return strXML;
	};
}

function EBFeedItemArrayHashData_CT459487()
{
	this.ArrayHash = new EBArrayHashObject_CT459487();
	
	this.XMLSerialize = function()
	{
		var strXMLItems		= EBFeedXMLConsts_CT459487.ITEMS;
		
		var strXML = '';
		strXML += '<' + strXMLItems + '>';
		
		var oFeedItemData = null;
		var iCount = this.ArrayHash.Count();	
		for(var i=0;i<iCount;i++)
		{
			oFeedItemData = this.ArrayHash.GetByIndex(i);
			strXML += oFeedItemData.XMLSerialize();
		}
		
		strXML += '</' + strXMLItems + '>';
		return strXML;
	};
}

function EBFeedItemData_CT459487(strTitle,strLink,strTooltip,strStatus,bVisited)
{
	this.Title		= strTitle;
	this.Link		= strLink;
	this.Tooltip	= strTooltip;
	this.Status		= strStatus;
	this.Visited	= bVisited;
	
	this.XMLSerialize = function()
	{
		var strXMLItem		= EBFeedXMLConsts_CT459487.ITEM;
		var strXMLTitle		= EBFeedXMLConsts_CT459487.TITLE;
		var strXMLLink		= EBFeedXMLConsts_CT459487.LINK;
		var strXMLTooltip	= EBFeedXMLConsts_CT459487.TOOLTIP;
		var strXMLStatus	= EBFeedXMLConsts_CT459487.STATUS;
		var strXMLVisited	= EBFeedXMLConsts_CT459487.VISITED;
		
		var strXML = '';
		strXML +=	 '<' + strXMLItem + '>';
		strXML +=		'<' + strXMLTitle + '>' + EBGlobalManager_CT459487.ToLegalXML(this.Title)+ '</' + strXMLTitle + '>';
		strXML +=		'<' + strXMLLink + '>' + EBGlobalManager_CT459487.ToLegalXML(this.Link) + '</' + strXMLLink + '>';
		strXML +=		'<' + strXMLTooltip + '>' + this.Tooltip + '</' + strXMLTooltip + '>';
		strXML +=		'<' + strXMLStatus + '>' + this.Status + '</' + strXMLStatus + '>';
		
		var strVisited = this.Visited ? 
								EBFeedXMLConsts_CT459487.TRUE 
								: 
								EBFeedXMLConsts_CT459487.FALSE;
		
		strXML +=		'<' + strXMLVisited + '>' + strVisited + '</' + strXMLVisited + '>';
		strXML +=	'</' + strXMLItem + '>';
		
		return strXML;
	};
}


var EBFeedDataFactory_CT459487 = 
{
	XMLToHistoryData : function(XMLDoc)
	{
		var oHistoryData				= null;
		var oHistoryItemDataArrayHash	= null;
		var oHistoryItemData			= null;
		
		var strXMLHistory		= EBFeedXMLConsts_CT459487.HISTORY;
		
		var XMLRoot			= XMLDoc.documentElement;
		var XMLChildNode	= null;
		
		if(XMLRoot.tagName == strXMLHistory)
		{
			oHistoryItemDataArrayHash = new EBArrayHashObject_CT459487();
			for(var i=0;i<XMLRoot.childNodes.length;i++)
			{
				XMLChildNode = XMLRoot.childNodes[i];
				oHistoryItemData = this.XMLToHistoryItemData(XMLChildNode);
				
				if(oHistoryItemData)
				{
					oHistoryItemDataArrayHash.Add(oHistoryItemData.Link,oHistoryItemData);
				}
			}
			oHistoryData = new EBHistoryData_CT459487(oHistoryItemDataArrayHash);
		}
		
		return oHistoryData;
	},
	
	XMLToHistoryItemData : function(XMLNode)
	{
		var oHistoryItemData = null;
		
		var strXMLLink		= EBFeedXMLConsts_CT459487.LINK;
		
		//get the correct root node (depends in this is the xml document or a regular dom node)
		var XMLRoot			= XMLNode.ownerDocument ? XMLNode : XMLNode.documentElement;	
		var XMLChildNode	= null;
		var strLink = '';
		if(XMLRoot.tagName == strXMLLink)
		{
			strLink = EBGlobalManager_CT459487.GetXmlNodeValue(XMLRoot);
			if(strLink)
			{
				oHistoryItemData = new EBHistoryItemData_CT459487(strLink);
			}
		}
		
		return oHistoryItemData;
	},
	
	XMLToFeedData : function(XMLDoc)
	{
		var oFeedData				= null;
		var oFeedDataData			= null;
		var oFeedItemArrayHashData	= null;
		
		var strXMLFeed		= EBFeedXMLConsts_CT459487.FEED;
		var strXMLData		= EBFeedXMLConsts_CT459487.DATA;
		var strXMLItems		= EBFeedXMLConsts_CT459487.ITEMS;
		
		var XMLRoot			= XMLDoc.documentElement;
		var XMLChildNode	= null;
		
		if(XMLRoot.tagName == strXMLFeed)
		{
			for(var i=0;i<XMLRoot.childNodes.length;i++)
			{
				XMLChildNode = XMLRoot.childNodes[i];
				if(XMLChildNode.tagName == strXMLData)
				{
					oFeedDataData = this.XMLToFeedDataData(XMLChildNode);
				}
				else if(XMLChildNode.tagName == strXMLItems)
				{
					oFeedItemArrayHashData = this.XMLToFeedItemArrayHashData(XMLChildNode);
				}
			}
			
			if(oFeedDataData && oFeedItemArrayHashData)
			{
				oFeedData = new EBFeedData_CT459487(oFeedDataData,oFeedItemArrayHashData);
			}
			
		}
		
		return oFeedData;
		
	},
	
	XMLToFeedDataData : function(XMLNode)
	{
		var oFeedDataData = null;
		
		var strXMLData		= EBFeedXMLConsts_CT459487.DATA;
		var strXMLTitle		= EBFeedXMLConsts_CT459487.TITLE;
		var strXMLLink		= EBFeedXMLConsts_CT459487.LINK;
		var strXMLStared	= EBFeedXMLConsts_CT459487.STARED;
		
		//get the correct root node (depends in this is the xml document or a regular dom node)
		var XMLRoot			= XMLNode.ownerDocument ? XMLNode : XMLNode.documentElement;	
		var XMLChildNode	= null;
		
		if(XMLRoot.tagName == strXMLData)
		{
			var strTitle	= '';
			var strLink		= '';
			var strStared	= '';
			var bIsStared	= false;
			
			for(var i=0;i<XMLRoot.childNodes.length;i++)
			{
				XMLChildNode = XMLRoot.childNodes[i];
				if(XMLChildNode.tagName == strXMLTitle)
				{
					strTitle = EBGlobalManager_CT459487.GetXmlNodeValue(XMLChildNode);
				}
				else if(XMLChildNode.tagName == strXMLLink)
				{
					strLink = EBGlobalManager_CT459487.GetXmlNodeValue(XMLChildNode);
				}
				else if(XMLChildNode.tagName == strXMLStared)
				{
					strStared = EBGlobalManager_CT459487.GetXmlNodeValue(XMLChildNode);
				
					bIsStared = strStared == EBFeedXMLConsts_CT459487.TRUE
												?
												true
												:
												false;
				}
			}

			oFeedDataData = new EBFeedDataData_CT459487(strTitle,strLink,bIsStared);
		}
		
		return oFeedDataData;
	},
	
	XMLToFeedItemArrayHashData : function(XMLNode)
	{
		var oFeedItemArrayHashData = null;
		
		
		var strXMLItems		= EBFeedXMLConsts_CT459487.ITEMS;
		
		//get the correct root node (depends in this is the xml document or a regular dom node)
		var XMLRoot			= XMLNode.ownerDocument ? XMLNode : XMLNode.documentElement;	
		var XMLChildNode	= null;
		
		if(XMLRoot.tagName == strXMLItems)
		{
			var oFeedItemData = null;
				
			oFeedItemArrayHashData = new EBFeedItemArrayHashData_CT459487();
			for(var i=0;i<XMLRoot.childNodes.length;i++)
			{
				XMLChildNode = XMLRoot.childNodes[i];
				oFeedItemData = this.XMLToFeedItemData(XMLChildNode);
				if(oFeedItemData)
				{
					oFeedItemArrayHashData.ArrayHash.Add(oFeedItemData.Link,oFeedItemData);
				}
			}
			
		}
		
		return oFeedItemArrayHashData;
	},
	
	XMLToFeedItemData : function(XMLNode)
	{
		var oFeedItemData = null;
		
		var strXMLItem		= EBFeedXMLConsts_CT459487.ITEM;
		var strXMLTitle		= EBFeedXMLConsts_CT459487.TITLE;
		var strXMLLink		= EBFeedXMLConsts_CT459487.LINK;
		var strXMLTooltip	= EBFeedXMLConsts_CT459487.TOOLTIP;
		var strXMLStatus	= EBFeedXMLConsts_CT459487.STATUS;
		var strXMLVisited	= EBFeedXMLConsts_CT459487.VISITED;
		
		//get the correct root node (depends in this is the xml document or a regular dom node)
		var XMLRoot			= XMLNode.ownerDocument ? XMLNode : XMLNode.documentElement;	
		var XMLChildNode	= null;
		
		if(XMLRoot.tagName == strXMLItem)
		{
			var strTitle	= '';
			var strLink		= '';
			var strTooltip	= '';
			var strStatus	= '';
			var strVisited	= '';
			var bVisited	= false;
			
			for(var i=0;i<XMLRoot.childNodes.length;i++)
			{
				XMLChildNode = XMLRoot.childNodes[i];
				if(XMLChildNode.tagName == strXMLTitle)
				{
					strTitle = EBGlobalManager_CT459487.GetXmlNodeValue(XMLChildNode);
				}
				else if(XMLChildNode.tagName == strXMLLink)
				{
					strLink = EBGlobalManager_CT459487.GetXmlNodeValue(XMLChildNode);
				}
				else if(XMLChildNode.tagName == strXMLTooltip)
				{
					strTooltip = EBGlobalManager_CT459487.GetXmlNodeValue(XMLChildNode);
				}
				else if(XMLChildNode.tagName == strXMLStatus)
				{
					strStatus = EBGlobalManager_CT459487.GetXmlNodeValue(XMLChildNode);
				}
				else if(XMLChildNode.tagName == strXMLVisited)
				{
					strVisited = EBGlobalManager_CT459487.GetXmlNodeValue(XMLChildNode);
					
					bVisited = strVisited == EBFeedXMLConsts_CT459487.TRUE
												?
												true
												:
												false;
				}
			}

			if(strLink)
			{
				oFeedItemData = new EBFeedItemData_CT459487(strTitle,strLink,strTooltip,strStatus,bVisited);
			}
		}
		
		return oFeedItemData;
	}
}


var EBFeedDialogConsts_CT459487 = 
{
	XULFileName			  : 'feed.xul',
	XULMACFileName		  : 'feed_mac.xul',
	XULOldAPIFileName	  : 'oldapi/feed_oldapi.xul',
	DialogName			  : 'FeedDialogName_CT459487',
	DialogType			  : 'EBFeedDialog_CT459487',
	DialogWidth			  : 276,
	DialogHeight		  : 274,
	
	Attributes : 
	{
		Link	: 'EBAttributeFeedLink'
	},
	
	Images :
	{
		EnvRead		: 'chrome://folkoteka.com/skin/feed_env_read.png',
		EnvUnread	: 'chrome://folkoteka.com/skin/feed_env_unread.png'
	},
	
	Style : 
	{									
		BoxFeedItemFixedStyle			: 'margin-left:5px;margin-right:5px;height:20px;width:220px;min-width:220px;',
		BoxFeedItemDefaultStyle			: 'border:1px solid transparent;',
		BoxFeedItemHoverStyle			: 'background-color:#C6D3EF;border:1px solid #316AC5;cursor:pointer;',
		BoxFeedItemDownStyle			: 'padding-top:2px;padding-left:2px;',
		ImageFeedItemDownStyle			: 'padding-top:1px;padding-left:1px;',
		LabelFeedItemFixedStyle			: 'font-size:11px;margin-left:1px;width:215px;min-width:215px;',
		LabelFeedItemHoverStyle			: 'cursor:pointer;',
		LabelTextUnVisitedStyleColor	: 'color:black;',
		LabelTextVisitedStyleColor		: 'color:#800080;'
	}
}

var EBFeedDialogManager_CT459487 = 
{
	
	GetDialog : function()
	{
		var strDialogType = EBFeedDialogConsts_CT459487.DialogType;
		var strDialogName = EBFeedDialogConsts_CT459487.DialogName;
		
		var oFeedDialog = EBGlobalManager_CT459487.GetXULWindowByTypeAndName(strDialogType,strDialogName);
			
		return oFeedDialog;
	},

	Open : function(iX,iY,oFeedComponent)
	{
		var strChromePath = '';
		
		if(EBGlobalManager_CT459487.IsNewestBrowserAPI())
		{
			if(EBGlobalManager_CT459487.IsMacintoshPlatform())
			{
				//with macintosh set a file without the unique scrollbars
				strChromePath = EBGlobalConsts_CT459487.ChromeContentPath + EBFeedDialogConsts_CT459487.XULMACFileName;
			}
			else
			{
				strChromePath = EBGlobalConsts_CT459487.ChromeContentPath + EBFeedDialogConsts_CT459487.XULFileName;
			}
		}
		else
		{
			strChromePath = EBGlobalConsts_CT459487.ChromeContentPath + EBFeedDialogConsts_CT459487.XULOldAPIFileName;
		}	
		
		
		window.openDialog(strChromePath,
						EBFeedDialogConsts_CT459487.DialogName,
						'chrome,dependent,resizable=no,titlebar=no,screenX=' + iX + ',screenY=' + iY,
						oFeedComponent);
	},
	
	OnLoadDialog : function(event)
	{
		var strFeedURL = m_oFeedComponent.ComponentItem.FeedURL;
		var oRecentBrowserWindow = EBGlobalManager_CT459487.GetMostRecentBrowserWindow();
		this.RequestFeedUsage(oRecentBrowserWindow.EBUsageConsts_CT459487.RSS_MENU_OPEN,strFeedURL);
		
		this.LoadDialogData(true);
	},
	
	LoadDialogData : function()
	{
		this.LoadHeaderData();
		this.LoadFeedItemsData();
	},
	
	LoadHeaderData : function()
	{
		var oLabelTitle = document.getElementById('lblTitle');
		
		var strFeedTitle	= m_oFeedComponent.FeedData.Data.Title;
		strFeedTitle = EBGlobalManager_CT459487.FromLegalXml(strFeedTitle);
		oLabelTitle.setAttribute('value',strFeedTitle);
	},
	
	OnClickLabelTitle : function(event)
	{
		var strFeedLink		= m_oFeedComponent.FeedData.Data.Link;
		
		this.NavigateToURL(event,strFeedLink);
	},
	
	NullifyFeedItemsContainer : function()
	{
		var oContainer = document.getElementById('rowsItems');
		
		while(oContainer.childNodes.length > 0)
		{
			oContainer.removeChild(oContainer.firstChild);
		}
	},
	
	LoadFeedItemsData : function()
	{	
		this.NullifyFeedItemsContainer();
		
		m_oFeedComponent.NumOfNew = 0;
		
		var oHistoryItemDataArrayHash = m_oFeedComponent.HistoryData.ArrayHash;
		
		var oFeedItemDataArrayHash = m_oFeedComponent.FeedData.Items.ArrayHash;
		var oFeedItemData = null;
		var strHashKey	  = '';
		var iCount = oFeedItemDataArrayHash.Count();
		for(var i=0;i<iCount;i++)
		{
			oFeedItemData = oFeedItemDataArrayHash.GetByIndex(i);
			strHashKey	  = oFeedItemData.Link;
			
			//only if it's not in the history loads it
			if(!oHistoryItemDataArrayHash.Contains(strHashKey))
			{
				if(oFeedItemData.Status == EBFeedXMLConsts_CT459487.UNREAD)
				{
					m_oFeedComponent.NumOfNew++;
				}
				this.LoadFeedItemData(oFeedItemData);
			}
		}
		
		//set the scroll top
		document.getElementById('divContainer').scrollTop = m_oFeedComponent.ContainerScrollTop;
	},
	
	LoadFeedItemData : function(oFeedItemData)
	{
		var strTitle	= oFeedItemData.Title;
		var strLink		= oFeedItemData.Link;
		var strTooltip	= oFeedItemData.Tooltip;
		var strStatus	= oFeedItemData.Status;
		var bVisited	= oFeedItemData.Visited;
		
		var oEnvImage				= document.createElement('image');
		var strImage				= '';
		
		if(strStatus == EBFeedXMLConsts_CT459487.READ)
		{
			strImage = EBFeedDialogConsts_CT459487.Images.EnvRead;
		}
		else
		{
			strImage = EBFeedDialogConsts_CT459487.Images.EnvUnread;
		}
		
		var strLabelTextStyleColor	= '';
		if(bVisited)
		{
			strLabelTextStyleColor = EBFeedDialogConsts_CT459487.Style.LabelTextVisitedStyleColor;
		}
		else
		{
			strLabelTextStyleColor = EBFeedDialogConsts_CT459487.Style.LabelTextUnVisitedStyleColor;
		}
		
		oEnvImage.setAttribute('src',strImage);
		oEnvImage.setAttribute('width','24');
		oEnvImage.setAttribute('height','20');
		
		
		var oBoxLabel = document.createElement('box');
		oBoxLabel.setAttribute('align','center');
		oBoxLabel.setAttribute('style',EBFeedDialogConsts_CT459487.Style.BoxFeedItemFixedStyle + EBFeedDialogConsts_CT459487.Style.BoxFeedItemDefaultStyle);
		oBoxLabel.setAttribute('onmouseover','EBFeedDialogManager_CT459487.OnMouseOverBoxFeedItem(event,this);');
		oBoxLabel.setAttribute('onmouseout','EBFeedDialogManager_CT459487.OnMouseOutBoxFeedItem(event,this);');
		oBoxLabel.setAttribute('onmousedown','EBFeedDialogManager_CT459487.OnMouseDownBoxFeedItem(event,this);');
		oBoxLabel.setAttribute('onmouseup','EBFeedDialogManager_CT459487.OnMouseUpBoxFeedItem(event,this);');
		
		
		//add link special attribute
		oBoxLabel.setAttribute(EBFeedDialogConsts_CT459487.Attributes.Link,strLink);
		
		oBoxLabel.setAttribute('onclick','EBFeedDialogManager_CT459487.OnClickBoxFeedItem(event,this);');
		oBoxLabel.setAttribute('context','mnuContextDelete');
		
		var oLabel = document.createElement('label');
		strTitle = EBGlobalManager_CT459487.FromLegalXml(strTitle);
		oLabel.setAttribute('value',strTitle);
		
		oLabel.setAttribute('tooltiptext',strTooltip);
		oLabel.setAttribute('style',EBFeedDialogConsts_CT459487.Style.LabelFeedItemFixedStyle + strLabelTextStyleColor);
		oLabel.setAttribute('onmouseover','EBFeedDialogManager_CT459487.OnMouseOverLabelFeedItem(event,this,\''+strLabelTextStyleColor+'\');');
		oLabel.setAttribute('onmouseout','EBFeedDialogManager_CT459487.OnMouseOutLabelFeedItem(event,this,\''+strLabelTextStyleColor+'\');');
		
		oBoxLabel.appendChild(oLabel);
		
		//create the hbox container:
		var oRow = document.createElement('hbox');
		oRow.setAttribute('align','center');
		oRow.setAttribute('height','20');
		
		//add the elements to the hbox
		oRow.appendChild(oEnvImage);
		oRow.appendChild(oBoxLabel);
		
		//add to the main container
		var oRowsItems = document.getElementById('rowsItems');
		oRowsItems.appendChild(oRow);
	},
	
	OnPopupShowingDeleteMessage : function(event)
	{
		//to get rid of the focus to the grid when context menu set the focus to the title element
		document.getElementById('lblTitle').focus();
	},
	
	OnCommandDeleteMessage : function(event)
	{
		//find the element associated with the popup menu:
		var oElement = document.popupNode;
		var oBoxLabel	= null;
		var oRow		= null;
		
		if(oElement.tagName == 'label')
		{
			oBoxLabel	= oElement.parentNode;
		}
		else
		{
			oBoxLabel = oElement;
		}
		
		var strLink = oBoxLabel.getAttribute(EBFeedDialogConsts_CT459487.Attributes.Link);
		
		var oFeedItemDataArrayHash = m_oFeedComponent.FeedData.Items.ArrayHash;
		//check to update num of new
		var oFeedItemData = oFeedItemDataArrayHash.GetByID(strLink);
		if(oFeedItemData)
		{
			if(oFeedItemData.Status == EBFeedXMLConsts_CT459487.UNREAD)
			{
				m_oFeedComponent.NumOfNew--;
			}
			
			var iIndex = oFeedItemDataArrayHash.GetIndexByObjectValue(oFeedItemData);
			
			//remove it from feed data
			oFeedItemDataArrayHash.Remove(iIndex,strLink);
			
			//add it to the history data:
			var oHistoryItemDataArrayHash = m_oFeedComponent.HistoryData.ArrayHash;
			var oHistoryItemData = new EBHistoryItemData_CT459487(strLink);
			oHistoryItemDataArrayHash.Add(oHistoryItemData.Link,oHistoryItemData);
			
			//remove the element from the main rows
			oRow	 = oBoxLabel.parentNode;
			var oContainer = document.getElementById('rowsItems');
			oContainer.removeChild(oRow);
			
			//broadcast changes
			this.BrodcastGUIChanges();
		}
	},	
	
	SetFeedItemsImages : function(strStatus)
	{
		var strImage = '';
		if(strStatus == EBFeedXMLConsts_CT459487.READ)
		{
			strImage = EBFeedDialogConsts_CT459487.Images.EnvRead;
		}
		else
		{
			strImage = EBFeedDialogConsts_CT459487.Images.EnvUnread;
		}
	
		var oContainer = document.getElementById('rowsItems');
		var oImages = oContainer.getElementsByTagName('image');
		var oImage	= null;
		
		for(var i=0;i<oImages.length;i++)
		{
			oImage = oImages[i];
			oImage.setAttribute('src',strImage);
		}
		
	},
	
	OnClickBoxFeedItem : function(event,oElement)
	{
		if(event.button != 2)
		{
			//get the specail attribute to recieve this item from the hash
			var strLinkHashKey = oElement.getAttribute(EBFeedDialogConsts_CT459487.Attributes.Link);
			var oFeedItemData = m_oFeedComponent.FeedData.Items.ArrayHash.GetByID(strLinkHashKey);
			
			if(oFeedItemData)
			{
				//set not stared:
				m_oFeedComponent.FeedData.Data.Stared = false;
			
				if(oFeedItemData.Status == EBFeedXMLConsts_CT459487.UNREAD)
				{
					//update the num of new
					m_oFeedComponent.NumOfNew--;
					oFeedItemData.Status = EBFeedXMLConsts_CT459487.READ;
				}
				
				oFeedItemData.Visited = true;
				
				this.BrodcastGUIChanges();
				
				var oRecentBrowserWindow = EBGlobalManager_CT459487.GetMostRecentBrowserWindow();
				this.RequestFeedUsage(oRecentBrowserWindow.EBUsageConsts_CT459487.RSS_ITEM,oFeedItemData.Link);
				
				this.NavigateToURL(event,oFeedItemData.Link);
			}
		}
	},
	
	NavigateToURL : function(event,strURL)
	{
		strURL = EBGlobalManager_CT459487.FromLegalXml(strURL);
		
		var oMostRecentBrowserWindow = EBGlobalManager_CT459487.GetMostRecentBrowserWindow();	
		oMostRecentBrowserWindow.EBLinkManager_CT459487.LoadLinkURL(event,
										strURL,
										false,
										null);
		
		//check to close multi feed dialog
		var oMultiFeedDialog = oMostRecentBrowserWindow.EBMultiFeedDialogManager_CT459487.GetDialog();
		if(oMultiFeedDialog)
		{
			oMultiFeedDialog.close();
		}
		//close current window
		window.close();	
	},
	
	OnMouseOverLabelFeedItem : function(event,oElement,strLabelTextStyleColor)
	{

		var strStyle = EBFeedDialogConsts_CT459487.Style.LabelFeedItemFixedStyle + strLabelTextStyleColor
						+
					EBFeedDialogConsts_CT459487.Style.LabelFeedItemHoverStyle;
					
		oElement.setAttribute('style',strStyle);
	},
	
	OnMouseOutLabelFeedItem : function(event,oElement,strLabelTextStyleColor)
	{
		var strStyle = EBFeedDialogConsts_CT459487.Style.LabelFeedItemFixedStyle + strLabelTextStyleColor;
		oElement.setAttribute('style',strStyle);
	},
	
	OnMouseOverBoxFeedItem : function(event,oElement)
	{
		var strStyle = EBFeedDialogConsts_CT459487.Style.BoxFeedItemFixedStyle 
						+
					EBFeedDialogConsts_CT459487.Style.BoxFeedItemHoverStyle;
				
		oElement.setAttribute('style',strStyle);
	},
	
	OnMouseOutBoxFeedItem : function(event,oElement)
	{
		var strStyle = EBFeedDialogConsts_CT459487.Style.BoxFeedItemFixedStyle 
						+
					EBFeedDialogConsts_CT459487.Style.BoxFeedItemDefaultStyle;
		
		//clear the image style
		oElement.parentNode.firstChild.setAttribute('style','');
		oElement.setAttribute('style',strStyle);
	},
	
	OnMouseDownBoxFeedItem : function(event,oElement)
	{
		if(event.button == 0)
		{
			var strStyle = EBFeedDialogConsts_CT459487.Style.BoxFeedItemFixedStyle 
							+
						EBFeedDialogConsts_CT459487.Style.BoxFeedItemHoverStyle
							+
						EBFeedDialogConsts_CT459487.Style.BoxFeedItemDownStyle;
				
			//set the image to be click style as well
			oElement.parentNode.firstChild.setAttribute('style',EBFeedDialogConsts_CT459487.Style.ImageFeedItemDownStyle);
						
			oElement.setAttribute('style',strStyle);
		}
	},
	
	OnMouseUpBoxFeedItem : function(event,oElement)
	{
		if(event.button == 0)
		{
			var strStyle = EBFeedDialogConsts_CT459487.Style.BoxFeedItemFixedStyle 
							+
						EBFeedDialogConsts_CT459487.Style.BoxFeedItemHoverStyle;
			
			//clear the image style
			oElement.parentNode.firstChild.setAttribute('style','');
			
			oElement.setAttribute('style',strStyle);
		}
	},
	
	OnClickRefresh : function(event)
	{
		var oRecentBrowserWindow = EBGlobalManager_CT459487.GetMostRecentBrowserWindow();
		if(oRecentBrowserWindow)
		{
			oRecentBrowserWindow.EBFeedPreferencesManager_CT459487.NullifyFeedPollDate(m_oFeedComponent);
			oRecentBrowserWindow.EBFeedManager_CT459487.CheckServerRequest(m_oFeedComponent);
		}
	},
	
	OnClickDeleteAll : function(event)
	{
		//add all items in structured data to the history data:
		var oHistoryItemDataArrayHash = m_oFeedComponent.HistoryData.ArrayHash;
		var oHistoryItemData		   = null;
		
		var oFeedItemDataArrayHash = m_oFeedComponent.FeedData.Items.ArrayHash;
		var oFeedItemData = null;
		var iCount = oFeedItemDataArrayHash.Count();
		var strLink	= '';
		for(var i=0;i<iCount;i++)
		{
			oFeedItemData = oFeedItemDataArrayHash.GetByIndex(i);
			strLink = oFeedItemData.Link;
			if(!oHistoryItemDataArrayHash.Contains(strLink))
			{
				oHistoryItemData = new EBHistoryItemData_CT459487(strLink);
				oHistoryItemDataArrayHash.Add(oHistoryItemData.Link,oHistoryItemData);
			}
		}
		//clear the feed items hash array
		oFeedItemDataArrayHash.Clear();
		m_oFeedComponent.FeedData.Data.Stared = false;
		
		
		this.NullifyFeedItemsContainer();
		
		m_oFeedComponent.NumOfNew = 0;
		
		//broadcast changes
		this.BrodcastGUIChanges();
	},
	
	OnClickMarkRead : function(event)
	{
		//set all images read
		this.SetFeedItemsImages(EBFeedXMLConsts_CT459487.READ);
	
		//set data
		var oHistoryItemDataArrayHash = m_oFeedComponent.HistoryData.ArrayHash;
		var oFeedItemDataArrayHash = m_oFeedComponent.FeedData.Items.ArrayHash;
		var oFeedItemData = null;
		var iCount = oFeedItemDataArrayHash.Count();
		for(var i=0;i<iCount;i++)
		{
			oFeedItemData = oFeedItemDataArrayHash.GetByIndex(i);
			if(!oHistoryItemDataArrayHash.Contains(oFeedItemData.Link))
			{
				oFeedItemData.Status = EBFeedXMLConsts_CT459487.READ;
			}
		}
		m_oFeedComponent.NumOfNew = 0;
		m_oFeedComponent.FeedData.Data.Stared = false;
		
		//broadcast changes
		this.BrodcastGUIChanges();
	},
	
	OnClickMarkUnRead : function(event)
	{
		//set all images unread
		this.SetFeedItemsImages(EBFeedXMLConsts_CT459487.UNREAD);
	
		//set data
		m_oFeedComponent.NumOfNew = 0;
		var oHistoryItemDataArrayHash = m_oFeedComponent.HistoryData.ArrayHash;
		var oFeedItemDataArrayHash = m_oFeedComponent.FeedData.Items.ArrayHash;
		var oFeedItemData = null;
		var iCount = oFeedItemDataArrayHash.Count();
		for(var i=0;i<iCount;i++)
		{
			oFeedItemData = oFeedItemDataArrayHash.GetByIndex(i);
			if(!oHistoryItemDataArrayHash.Contains(oFeedItemData.Link))
			{
				m_oFeedComponent.NumOfNew++;
				oFeedItemData.Status = EBFeedXMLConsts_CT459487.UNREAD;
			}
		}
		
		//broadcast changes
		this.BrodcastGUIChanges();
	},
	
	OnMouseOverVBox : function(event)
	{
		if(!EBGlobalManager_CT459487.IsWindowsPlatform() && m_oFeedComponent.IsMultiFeed)
		{
			var oRecentBrowserWindow = EBGlobalManager_CT459487.GetMostRecentBrowserWindow();
		
			//check to hide chevron
			var oChevron = oRecentBrowserWindow.EBActionManager_CT459487.GetToolbarChevron();
			if(oChevron && oChevron.firstChild)
			{
				oChevron.firstChild.hidePopup();
			}
		
			//check to the toolbarbutton popupmenu
			var strMultiCompID = m_oFeedComponent.MultiFeedCompID;
			var oMultiFeedComponent = oRecentBrowserWindow.EBComponentsManager_CT459487.GetComponentByCompID(strMultiCompID);
			if(oMultiFeedComponent)
			{
				var oXULPopupMenu = oMultiFeedComponent.XULElement.firstChild;
				if(oXULPopupMenu)
				{
					oXULPopupMenu.hidePopup();
				}
			}
		}
		
	},
	
	OnBlurDialog : function(event)
	{
		if(event.eventPhase == 2)
		{
			var bIsToClose = true;
			//check if this is multi feed that is already active from the multi feed dialog 
			//to no close it(solves problem when the feed dialog looses focus when clicking on the row
			//elements in the multi feed dialog)
			//also check if to close the multi feed dialog in case it doesnt point to any feed element(IsActive = false)
			if(m_oFeedComponent.IsMultiFeed)
			{
				var oMultiFeedDialog = EBMultiFeedDialogManager_CT459487.GetDialog();
				if(oMultiFeedDialog)
				{
					if(oMultiFeedDialog.EBMultiFeedDialogManager_CT459487.ActiveFeedElementIndex == m_oFeedComponent.MultiFeedChildIndex)
					{
						bIsToClose = false;
					}
					
					
					//check to close the multi feed dialog
					if(!oMultiFeedDialog.EBMultiFeedDialogManager_CT459487.IsActive)
					{
						oMultiFeedDialog.close();
					}
					
				}
			}
			
			if(bIsToClose)
			{
				window.close();
			}
		}
	},
	
	OnUnLoadDialog : function(event)
	{
		try
		{
			//check to set the button to be not pressed
			if(!m_oFeedComponent.IsMultiFeed)
			{
				var oXULToolbarButton = m_oFeedComponent.XULElement;
				oXULToolbarButton.removeAttribute('open');
			}
		
			//save the scroll top
			m_oFeedComponent.ContainerScrollTop = document.getElementById('divContainer').scrollTop;
			//set the strared to false
			m_oFeedComponent.FeedData.Data.Stared = false;
			
			//empty container
			this.NullifyFeedItemsContainer();
			
			//save the data to the files
			this.SaveData();
			
			this.BrodcastGUIChanges();
			
			this.BroadcastData();
		}
		catch(ex){}
	},
	
	//call all EBFeedManager_ reference with the browser window to avoid error when the 
	//dialog is closed and those functions no longer exists in its scope
	SaveData : function()
	{
		var oRecentBrowserWindow = EBGlobalManager_CT459487.GetMostRecentBrowserWindow();
		if(oRecentBrowserWindow)
		{
			oRecentBrowserWindow.EBFeedManager_CT459487.SaveFeedDataStructured(m_oFeedComponent);
			oRecentBrowserWindow.EBFeedManager_CT459487.SaveFeedDataHistory(m_oFeedComponent);
		}
	},
		
	BrodcastGUIChanges : function()
	{
		this.CallBroadcastGUI();
		
		if(m_oFeedComponent.IsMultiFeed)
		{
			this.UpdateMultiFeedDialog();
		}
	},
	
	CallBroadcastGUI : function()
	{
		var oRecentBrowserWindow = EBGlobalManager_CT459487.GetMostRecentBrowserWindow();
		if(oRecentBrowserWindow)
		{
			oRecentBrowserWindow.EBFeedManager_CT459487.CallBroadcastGUI(m_oFeedComponent);
		}
	},
	
	UpdateMultiFeedDialog : function()
	{
		var oRecentBrowserWindow = EBGlobalManager_CT459487.GetMostRecentBrowserWindow();
		oRecentBrowserWindow.EBFeedManager_CT459487.UpdateMultiFeedItemData(m_oFeedComponent);
	},
	
	BroadcastData : function()
	{
		var oRecentBrowserWindow = EBGlobalManager_CT459487.GetMostRecentBrowserWindow();
		if(oRecentBrowserWindow)
		{	
			oRecentBrowserWindow.EBFeedManager_CT459487.BroadcastData(m_oFeedComponent);
		}
	},
	
	RequestFeedUsage : function(strGeneralParam1,strGeneralParam2)
	{
		//call usage
		var oRecentBrowserWindow = EBGlobalManager_CT459487.GetMostRecentBrowserWindow();
		var strCompID = m_oFeedComponent.ComponentItem.UniqueCompID;
		oRecentBrowserWindow.EBFeedManager_CT459487.RequestFeedUsage(strCompID,
							oRecentBrowserWindow.EBUsageConsts_CT459487.RSS,
							strGeneralParam1,
							strGeneralParam2);
	}
		
	
		
}
var EBFeedIOConsts_CT459487 = 
{
	FolderName					: 'feed',
	StructuredFileNameSuffix	: '_structured.xml',
	HistoryFileNameSuffix		: '_history.xml',
	LiveFileNameSuffix			: '_live_structured.xml'
}


var EBFeedIOManager_CT459487 = 
{
	GetLegalFeedFileNamePrefix : function(strURL)
	{
		var strFileNamePrefix = EBGlobalManager_CT459487.ToLegalFileName(strURL);
		return strFileNamePrefix;
	},

	GetFeedFullPath : function(strFullFileName)
	{
		var strFeedFolder = EBFeedIOConsts_CT459487.FolderName;
		
		var strFeedFullPath = strFeedFolder + EBDirIO_CT459487.sep + strFullFileName;
		
		return strFeedFullPath;
	},
	
	GetFeedFile : function(strFileName)
	{
		var strFeedFullPath = this.GetFeedFullPath(strFileName);
		var oFile = EBIOManager_CT459487.CreateToolbarFile(strFeedFullPath);	
		
		return oFile;
	},
	
	WriteFeedFile : function(strFileName,strContent)
	{
		var bSuccess = false;
		var oFile = this.GetFeedFile(strFileName);
		if(oFile)
		{
			bSuccess = EBFileIO_CT459487.write(oFile,strContent,"",EBGlobalConsts_CT459487.DefaultCharset);
		}
		return bSuccess;
	},
	
	ReadFeedFile : function(strFileName)
	{
		var strContent = '';
		var oFile = this.GetFeedFile(strFileName);
		if(oFile)
		{	
			strContent = EBFileIO_CT459487.read(oFile,EBGlobalConsts_CT459487.DefaultCharset);
		}
		
		return strContent;
	},
	
	GetFullStructuredFileName : function(strURL)
	{
		var strFileNamePrefix = this.GetLegalFeedFileNamePrefix(strURL);
		var strStructuredFileName = strFileNamePrefix + EBFeedIOConsts_CT459487.StructuredFileNameSuffix;
		return strStructuredFileName;
	},
	
	GetFullHistoryFileName : function(strURL)
	{
		var strFileNamePrefix = this.GetLegalFeedFileNamePrefix(strURL);
		var strHistoryFileName = strFileNamePrefix + EBFeedIOConsts_CT459487.HistoryFileNameSuffix;
		return strHistoryFileName;
	},
	
	GetFullLiveFileName : function(strURL)
	{
		var strFileNamePrefix = this.GetLegalFeedFileNamePrefix(strURL);
		var strLiveFileName = strFileNamePrefix + EBFeedIOConsts_CT459487.LiveFileNameSuffix;
		return strLiveFileName;
	},
	
	WriteStructured : function(strURL,strContent)
	{
		var strStructuredFileName = this.GetFullStructuredFileName(strURL);
		this.WriteFeedFile(strStructuredFileName,strContent);
	},
	
	WriteHistory : function(strURL,strContent)
	{
		var strHistoryFileName = this.GetFullHistoryFileName(strURL);
		this.WriteFeedFile(strHistoryFileName,strContent);
	},
	
	WriteLive : function(strURL,strContent)
	{
		var strLiveFileName = this.GetFullLiveFileName(strURL);
		this.WriteFeedFile(strLiveFileName,strContent);
	},
	
	ReadStructured : function(strURL)
	{
		var strStructuredFileName = this.GetFullStructuredFileName(strURL);
		var strContent = this.ReadFeedFile(strStructuredFileName);
		return strContent;
	},
	
	ReadHistory : function(strURL)
	{
		var strHistoryFileName = this.GetFullHistoryFileName(strURL);
		var strContent = this.ReadFeedFile(strHistoryFileName);
		return strContent;
	},
	
	ReadLive : function(strURL)
	{
		var strLiveFileName = this.GetFullLiveFileName(strURL);
		var strContent = this.ReadFeedFile(strLiveFileName);
		return strContent;
	}
}


var EBFeedPreferencesManager_CT459487 = 
{
	GetFeedPollDateFullPrefName : function(oFeedComponent)
	{
		var strPrefName = EBPreferenceConsts_CT459487.FeedPollDatePrefix + oFeedComponent.ComponentItem.UniqueCompID;
		return strPrefName;
	},
	
	GetFeedPollDate : function(oFeedComponent)
	{
		var strPrefName = this.GetFeedPollDateFullPrefName(oFeedComponent);
		var strPrefValue = EBToolbarPreferenceManager_CT459487.GetPref(strPrefName);
		return strPrefValue;
	},
	
	SetFeedPollDate : function(oFeedComponent)
	{
		var strPrefName = this.GetFeedPollDateFullPrefName(oFeedComponent);
		var oDate = new Date();
		var strPrefValue = oDate.toString();
		EBToolbarPreferenceManager_CT459487.SetPref(strPrefName,strPrefValue);
	},
	
	NullifyFeedPollDate : function(oFeedComponent)
	{
		var strPrefName = this.GetFeedPollDateFullPrefName(oFeedComponent);	
		EBToolbarPreferenceManager_CT459487.SetPref(strPrefName,null);
	}
}


var EBFeedConsts_CT459487 = 
{
	DefaultInterval				: 60,
	MaxStructuredItems			: 50,
	MaxHistoryItems				: 200,
	NoTitleCaption				: '(no title)',
	NoItemsCaption				: 'No Items',
	Timeout						: 30000
}

var EBFeedManager_CT459487 = 
{
	LoadFeedStructured : function(oFeedComponent,strXML)
	{
		var oFeedData = null;
		if(strXML)
		{
			var XMLDoc = EBGlobalManager_CT459487.GetXmlDocument(strXML);
			oFeedData = EBFeedDataFactory_CT459487.XMLToFeedData(XMLDoc);
		}
		
		if(!oFeedData) //if it's not succeed load blank feed data
		{
			//nullify the poll date time
			EBFeedPreferencesManager_CT459487.NullifyFeedPollDate(oFeedComponent);
			oFeedData = this.CreateBlankFeedData();
		}
		
		oFeedComponent.FeedData = oFeedData;
	},

	//the load functions load the data into the object! (as oppose to return the object);
	LoadEditableFeedStructured : function(oFeedComponent)
	{
		var strURL = oFeedComponent.ComponentItem.FeedURL;
		var strXML = EBFeedIOManager_CT459487.ReadStructured(strURL);
		this.LoadFeedStructured(oFeedComponent,strXML);

	},
	
	LoadLiveFeedStructured : function(oFeedComponent)
	{
		var strURL = oFeedComponent.ComponentItem.FeedURL;
		var strXML = EBFeedIOManager_CT459487.ReadLive(strURL);
		this.LoadFeedStructured(oFeedComponent,strXML);
	},
	
	LoadFeedHistory : function(oFeedComponent)
	{
		var strURL = oFeedComponent.ComponentItem.FeedURL;
		var oHistoryData = null;
		var strXML = EBFeedIOManager_CT459487.ReadHistory(strURL);
		if(strXML)
		{
			var XMLDoc = EBGlobalManager_CT459487.GetXmlDocument(strXML);
			oHistoryData = EBFeedDataFactory_CT459487.XMLToHistoryData(XMLDoc);
		}
		
		if(!oHistoryData)
		{
			oHistoryData = this.CreateBlankHistoryData();
		}
		
		oFeedComponent.HistoryData = oHistoryData;
	},
	
	CreateBlankFeedData : function()
	{
		var oFeedDataData			= new EBFeedDataData_CT459487('','',false);
		var oFeedItemArrayHashData	= new EBFeedItemArrayHashData_CT459487();
		var oFeedData = new EBFeedData_CT459487(oFeedDataData,oFeedItemArrayHashData);
		return oFeedData;
	},
	
	CreateBlankHistoryData : function()
	{	
		var	oHistoryItemDataArrayHash = new EBArrayHashObject_CT459487();
		var oHistoryData = new EBHistoryData_CT459487(oHistoryItemDataArrayHash);
		return oHistoryData;
	},
	
	SaveStructured : function(oFeedComponent)
	{
		var oFeedData = oFeedComponent.FeedData;
		var strURL = oFeedComponent.ComponentItem.FeedURL;
		var strXML = oFeedData.XMLSerialize();
		EBFeedIOManager_CT459487.WriteStructured(strURL,strXML);
		
	},
	
	SaveHistory : function(oFeedComponent)
	{
		var oHistoryData = oFeedComponent.HistoryData;
		var strURL = oFeedComponent.ComponentItem.FeedURL;
		var strXML = oHistoryData.XMLSerialize();
		EBFeedIOManager_CT459487.WriteHistory(strURL,strXML);	
	},
	
	SaveLive : function(oFeedComponent)
	{
		var oFeedData = oFeedComponent.FeedData;
		var strURL = oFeedComponent.ComponentItem.FeedURL;
		var strXML = oFeedData.XMLSerialize();
		EBFeedIOManager_CT459487.WriteLive(strURL,strXML);
	},
	
	OnLoadFeedItem : function(oFeedComponent)
	{
		this.LoadComponentData(oFeedComponent);
		this.CheckServerRequest(oFeedComponent);
	},
	
	OnUnloadFeedItem : function(oFeedComponent)
	{
		this.ClearTimeoutID(oFeedComponent);
	},
	
	ClearTimeoutID : function(oFeedComponent)
	{
		if(oFeedComponent.TimeoutID)
		{
			clearTimeout(oFeedComponent.TimeoutID);
		}
	},
	
	CheckServerRequest : function(oFeedComponent)
	{
		if(this.IsTimeElapsed(oFeedComponent))
		{
			//save poll date to now
			EBFeedPreferencesManager_CT459487.SetFeedPollDate(oFeedComponent);
			this.ServerRequest(oFeedComponent);
		}
		else
		{
			//if time not elapsed in live mode we build the items and in regular mode
			//we update the button state
			if(oFeedComponent.IsLiveMode)
			{
				this.BroadcastLiveGUI(oFeedComponent.ComponentItem.UniqueCompID);
			}
			else
			{
				this.UpdateFeedData(oFeedComponent);
			}
		}
		
		this.SetTimeoutCheck(oFeedComponent);
	},
	
	SetTimeoutCheck : function(oFeedComponent)
	{
		var oFunction = function()
		{
			EBFeedManager_CT459487.CheckServerRequest(oFeedComponent);	
		};
		var iIntervalMinutes		= this.GetFeedInterval(oFeedComponent);
		var iMillisecondInterval	= iIntervalMinutes*60*1000;
		
		oFeedComponent.TimeoutID	= setTimeout(oFunction,iMillisecondInterval);	
	},
	
	LoadComponentData : function(oFeedComponent)
	{
		if(oFeedComponent.IsLiveMode)
		{
			this.LoadLiveFeedStructured(oFeedComponent);
		}
		else
		{
			this.LoadEditableFeedStructured(oFeedComponent);
			this.LoadFeedHistory(oFeedComponent);
		}
	},
	
	ServerRequest : function(oFeedComponent)
	{
		var strURL = oFeedComponent.ComponentItem.FeedURL;
		
		//set the flag of the loading from server:
		oFeedComponent.LoadingFromServer = true;
		var oCallBackFunction = function(strXML,o)
		{
			EBFeedManager_CT459487.ServerResponse(oFeedComponent,strXML,o);
		};
		var oRequest = EBGlobalManager_CT459487.HTTPServerRequest(strURL,null,false,oCallBackFunction);
	
		this.CheckServerTimeout(oFeedComponent,oRequest);
	},
	
	CheckServerTimeout : function(oFeedComponent,oRequest)
	{
		var oThreadFunction = function()
		{	
			if(oFeedComponent.LoadingFromServer)
			{
				oRequest.abort();
				EBFeedManager_CT459487.ServerResponse(oFeedComponent,'',null);
			}
		};
		setTimeout(oThreadFunction,EBFeedConsts_CT459487.Timeout);
	},
	
	ServerResponse : function(oFeedComponent,strXML,o)
	{	
		//the request is back so set the flag that it's not loading nomore:
		oFeedComponent.LoadingFromServer = false;
		
		if(o && o.value == EBGlobalConsts_CT459487.NetworkError)
		{
			EBFeedPreferencesManager_CT459487.NullifyFeedPollDate(oFeedComponent);
		}

		if(oFeedComponent.IsLiveMode)
		{
			this.ParseLiveFeed(oFeedComponent,strXML);
		}
		else
		{
			this.ParseEditableFeed(oFeedComponent,strXML);
		}

	},
	
	ParseEditableFeed : function(oFeedComponent,strXML)
	{
		var XMLDoc = null;
		if(strXML)
		{
			XMLDoc = EBGlobalManager_CT459487.GetXmlDocument(strXML);
		}
	
		var bIsNewItemsFromServer = false;
	
		var oFeedParser = new EBFeedParser_CT459487(XMLDoc,EBFeedConsts_CT459487.MaxStructuredItems);
		var oFeedElementArrayHash = oFeedParser.ArrayHash;
		
		
		var oHistoryItemDataArrayHash = oFeedComponent.HistoryData.ArrayHash;

		var oFeedItemDataArrayHash = oFeedComponent.FeedData.Items.ArrayHash;
		
		//update feeddata data from server
		var strFeedTitle	= oFeedParser.Title;
		var strFeedLink		= oFeedParser.Link;
		if(strFeedTitle)
		{
			oFeedComponent.FeedData.Data.Title		= strFeedTitle;
		}
		else //if there isn't title take the title from the settings
		{
			oFeedComponent.FeedData.Data.Title		= oFeedComponent.ComponentItem.Title;
		}
		
		if(strFeedLink)
		{
			oFeedComponent.FeedData.Data.Link		= strFeedLink;
		}
		else //if there isn't link from the feed take the feed URL
		{
			oFeedComponent.FeedData.Data.Link		= oFeedComponent.ComponentItem.FeedURL;
		}
		
		//compare between the items from the server to the items in the history and the structured
		if(oFeedElementArrayHash.Count() > 0)
		{
			var strTitle	= '';
			var strLink		= '';
			var strTooltip	= '';
			var strStatus	= '';
			var bVisited    = false;
		
			//run on the items from the server
			var iCount = oFeedElementArrayHash.Count();
			var oFeedElement = null;
			var bIsItemInStructured = false;
			var bIsItemInHistory	= false;
			var strHashKey			= '';
			
			var oFeedItemData	= null;
			//go backwards in the server items to add the newset items in the feed to the top of the structured ArrayHash
			for(var i=iCount - 1;i>=0;i--)
			{
				oFeedElement	= oFeedElementArrayHash.GetByIndex(i);
				strHashKey		= oFeedElement.Link;
			
				
				//check structured
				bIsItemInStructured = oFeedItemDataArrayHash.Contains(strHashKey);
				//check history
				bIsItemInHistory = oHistoryItemDataArrayHash.Contains(strHashKey);

				//check to add this item to the structured if it's not in structured or in history
				if(!bIsItemInStructured && !bIsItemInHistory)
				{
					bIsNewItemsFromServer = true;
					//insert the new item to the structured hasharray
					strTitle	= this.GetTitle(oFeedElement.Title);
					strLink		= oFeedElement.Link;
					strTooltip	= this.GetTooltipCaption(oFeedElement.Date);
					strStatus	= EBFeedXMLConsts_CT459487.UNREAD;
					
					oFeedItemData = new EBFeedItemData_CT459487(strTitle,
													strLink,
													strTooltip,
													strStatus,
													bVisited);
													
					//insert to the top
					oFeedItemDataArrayHash.Insert(0,oFeedItemData.Link,oFeedItemData);
				}
			}
		}
		
		//check to save the data
		if(bIsNewItemsFromServer)
		{
			oFeedComponent.FeedData.Data.Stared = true;
			this.SaveFeedDataStructured(oFeedComponent);
			
			//check if there is dialog open with this component to refill it with the new data
			this.CheckToRefillDialog(oFeedComponent);
			
			//after server response broadcast data to all browsers if changed
			this.BroadcastData(oFeedComponent);
		}
		
		//change the button and from there broadcast gui to all browsers
		this.UpdateFeedData(oFeedComponent);
		
		//check to see if there is the multi dialog open to update it with the new data
		//after call to UpdateFeedData which collects the num of new
		if(oFeedComponent.IsMultiFeed)
		{
			this.UpdateMultiFeedItemData(oFeedComponent);
		}
	},
	
	ParseLiveFeed : function(oFeedComponent,strXML)
	{
		var XMLDoc = null;
		if(strXML)
		{
			XMLDoc = EBGlobalManager_CT459487.GetXmlDocument(strXML);
		}
		var oFeedParser = new EBFeedParser_CT459487(XMLDoc,EBFeedConsts_CT459487.MaxStructuredItems);
		var oFeedElementArrayHash = oFeedParser.ArrayHash;

		var oFeedItemDataArrayHash = oFeedComponent.FeedData.Items.ArrayHash;
		
		//check first if there is something new from the server:
		var bIsNewItems = false;
		var iCount = oFeedElementArrayHash.Count();
		var oFeedElement = null;
		for(var i=0;i<iCount;i++)
		{
			oFeedElement	= oFeedElementArrayHash.GetByIndex(i);
			strHashKey		= oFeedElement.Link;
			
			//check if exists:
			if(!oFeedItemDataArrayHash.Contains(strHashKey))
			{
				bIsNewItems = true;
				break;
			}
		}
		
		//if there is new items - clear all the existing ones and add what comes from the server
		if(bIsNewItems)
		{
			//clear all the items in the feed item data array hash:
			oFeedItemDataArrayHash.Clear();
			
			var strTitle	= '';
			var strLink		= '';
			var strTooltip	= '';
			var strStatus	= '';
			var bVisited    = false;
			
			var oFeedItemData = null;
			for(var i=0;i<iCount;i++)
			{
				oFeedElement	= oFeedElementArrayHash.GetByIndex(i);
				//in the live mode there isn't any need for tooltip and status 
				//but i keep them in case this live mode will become regular mode and becasue 
				//the live and editable mode save in the same data structure type
				strTitle	= this.GetTitle(oFeedElement.Title);
				strLink		= oFeedElement.Link;
				strTooltip	= this.GetTooltipCaption(oFeedElement.Date);
				strStatus	= EBFeedXMLConsts_CT459487.UNREAD;
				
				oFeedItemData = new EBFeedItemData_CT459487(strTitle,
												strLink,
												strTooltip,
												strStatus,
												bVisited);
												
				//insert to the top
				oFeedItemDataArrayHash.Add(oFeedItemData.Link,oFeedItemData);
			}
			
			
			//save the data and boradcast
			oFeedComponent.FeedData.Data.Stared = true;
			this.SaveFeedDataStructured(oFeedComponent);
			this.BroadcastData(oFeedComponent);
		}

	
		this.BroadcastLiveGUI(oFeedComponent.ComponentItem.UniqueCompID);
	},
	
	BuildLiveFeedItemsMenu : function(strCompID)
	{
		var oFeedComponent = EBComponentsManager_CT459487.GetComponentByCompID(strCompID);
		if(oFeedComponent)
		{
			var oXULElement	= oFeedComponent.XULElement;
			//set the xul element title and image
			var strLabel = oFeedComponent.GetFeedTitle();
			var strImage = oFeedComponent.GetFeedImage();
			oXULElement.setAttribute('label',strLabel);
			oXULElement.setAttribute('image',strImage);
			
			
			var oMenuPopup  = oXULElement.firstChild;
			//nullify menupopup
			while(oMenuPopup.childNodes.length > 0)
			{
				oMenuPopup.removeChild(oMenuPopup.firstChild);
			}
			
			var oMenuItem	= null;
			
			var strLabel	= '';
			var strLink		= '';
			var strCommand	= '';
			
			var oFeedItemDataArrayHash = oFeedComponent.FeedData.Items.ArrayHash;
			var oFeedItemData = null;
			var iCount = oFeedItemDataArrayHash.Count();
			
			if(iCount == 0)
			{
				strLabel	= EBFeedConsts_CT459487.NoItemsCaption;
				oMenuItem   = EBXULFactory_CT459487.CreateMenuItem(strLabel,'','','','',null);
				oMenuPopup.appendChild(oMenuItem);
			}
			else
			{
				for(var i=0;i<iCount;i++)
				{
					oFeedItemData = oFeedItemDataArrayHash.GetByIndex(i);
					strLabel	= oFeedItemData.Title;
					strLink		= oFeedItemData.Link;
					strCommand	= 'EBFeedManager_CT459487.OnCommandLiveMenuItem(event,\'' + strCompID + '\',\'' + strLink + '\');';
					
					oMenuItem   = EBXULFactory_CT459487.CreateMenuItem(strLabel,'','',strCommand,'',null);
					
					oMenuPopup.appendChild(oMenuItem);
				}
			}
		}
	},
	
	OnCommandLiveMenuItem : function(event,strCompID,strURL)
	{
		this.RequestFeedUsage(strCompID,
								EBUsageConsts_CT459487.RSS,
								EBUsageConsts_CT459487.RSS_ITEM,
								strURL);
	
		EBLinkManager_CT459487.LoadLinkURL(event,
										strURL,
										false,
										null);
	},
	
	CheckToRefillDialog : function(oFeedComponent)
	{
		var oFeedDialog = EBFeedDialogManager_CT459487.GetDialog();
		if(oFeedDialog && oFeedDialog.m_oFeedComponent == oFeedComponent)
		{
			oFeedComponent.ContainerScrollTop = 0;
			oFeedDialog.EBFeedDialogManager_CT459487.LoadDialogData();
		}
	},
	
	SaveFeedDataStructured : function(oFeedComponent)
	{
		this.ValidateMaxStructuredItems(oFeedComponent.FeedData);
		if(oFeedComponent.IsLiveMode)
		{
			this.SaveLive(oFeedComponent);
		}
		else
		{
			this.SaveStructured(oFeedComponent);
		}
	},
	
	ValidateMaxStructuredItems : function(oFeedData)
	{
		var oFeedItemDataArrayHash = oFeedData.Items.ArrayHash;
		var oFeedItemData		   = null;
		var iCount = oFeedItemDataArrayHash.Count();
		var iLastIndex = 0;
		while(iCount > EBFeedConsts_CT459487.MaxStructuredItems)
		{
			//remove the last element
			iLastIndex = iCount - 1;
			oFeedItemData = oFeedItemDataArrayHash.GetByIndex(iLastIndex);
			if(oFeedItemData)
			{	
				oFeedItemDataArrayHash.Remove(iLastIndex,oFeedItemData.Link);
				iCount = oFeedItemDataArrayHash.Count();
			}
			else
			{
				//if there isn't item in that index for some reason break the loop!
				break;
			}
		}
		
	},
	
	SaveFeedDataHistory : function(oFeedComponent)
	{
		this.ValidateMaxHistoryItems(oFeedComponent.HistoryData);
		this.SaveHistory(oFeedComponent);
	},
	
	ValidateMaxHistoryItems : function(oHistoryData)
	{
		var oHistoryItemDataArrayHash = oHistoryData.ArrayHash;
		
		var oHistoryItemData		   = null;
		var iCount = oHistoryItemDataArrayHash.Count();
		var iLastIndex = 0;
		while(iCount > EBFeedConsts_CT459487.MaxHistoryItems)
		{
			//remove the last element
			iLastIndex = iCount - 1;
			oHistoryItemData = oHistoryItemDataArrayHash.GetByIndex(iLastIndex);
			if(oHistoryItemData)
			{	
				oHistoryItemDataArrayHash.Remove(iLastIndex,oHistoryItemData.Link);
				iCount = oHistoryItemDataArrayHash.Count();
			}
			else
			{
				//if there isn't item in that index for some reason break the loop!
				break;
			}
		}
		
	},
	
	//update the NumOfNew of the feed component and then set the button label to the current new messages
	UpdateFeedData : function(oFeedComponent)
	{
		var iNumOfNew = 0;
		
		var oFeedItemDataArrayHash = oFeedComponent.FeedData.Items.ArrayHash;
		
		var oHistoryItemDataArrayHash = oFeedComponent.HistoryData.ArrayHash;
			
		//go through all the items - check that they are not in history 
		//and they are not read to increase the counter
		var oFeedItemData = null;
		var iCount = oFeedItemDataArrayHash.Count();
		for(var i=0;i<iCount;i++)
		{
			oFeedItemData = oFeedItemDataArrayHash.GetByIndex(i);
			//check that the item is not in the history
			if(!oHistoryItemDataArrayHash.Contains(oFeedItemData.Link))
			{
				//check if it's unread
				if(oFeedItemData.Status == EBFeedXMLConsts_CT459487.UNREAD)
				{
					iNumOfNew++;
				}
			}
		}
		
		//update the object data
		oFeedComponent.NumOfNew = iNumOfNew;
		
		this.CallBroadcastGUI(oFeedComponent);
	},
	
	//this function prepare the brodcast to the regular and multi feed data
	CallBroadcastGUI : function(oFeedComponent)
	{
		var strLabel	= '';
		var strImage	= '';
		var strCompID	= '';
		
		if(oFeedComponent.IsMultiFeed)
		{
			strCompID = oFeedComponent.MultiFeedCompID;
			var oMultiFeedComponent = EBComponentsManager_CT459487.GetComponentByCompID(strCompID);
			if(oMultiFeedComponent)
			{
				strLabel	= oMultiFeedComponent.GetMultiFeedTitle();
				strImage	= oMultiFeedComponent.GetMultiFeedImage();
			}
		}
		else
		{
			strCompID = oFeedComponent.ComponentItem.UniqueCompID;
			strLabel	= oFeedComponent.GetFeedTitle();
			strImage	= oFeedComponent.GetFeedImage();
		}
		
		this.BroadcastGUIButton(strCompID,strLabel,strImage);
	},
	
	SetXULElementLabelImage : function(strCompID,strLabel,strImage)
	{
		//this function call for the regular feed and the multi data feed
		var oComponent = EBComponentsManager_CT459487.GetComponentByCompID(strCompID);
		if(oComponent)
		{
			var oXULElement	= oComponent.XULElement;
			
			oXULElement.setAttribute('label',strLabel);
			oXULElement.setAttribute('image',strImage);
		}	
	},
	
	//check if the time has passed to check again from the server
	IsTimeElapsed : function(oFeedComponent)
	{
		var bRetVal = true;
		
		var strPollDatePrefValue = EBFeedPreferencesManager_CT459487.GetFeedPollDate(oFeedComponent);
		//check if that it's not empty
		if(strPollDatePrefValue)
		{
			//check difference between times:
			var iIntervalMinutes	= this.GetFeedInterval(oFeedComponent);
			var oDateCurrent		= new Date();
			var oDatePollDate		= new Date(strPollDatePrefValue);
			
			var iCheckIntervalTime	= 1000*60*iIntervalMinutes;
			
			var iDateDiff = oDateCurrent - oDatePollDate;
			
			bRetVal = iDateDiff > iCheckIntervalTime;
			
		}
		return bRetVal;
	},
	
	GetFeedInterval : function(oFeedComponent)
	{
		var iInterval = oFeedComponent.ComponentItem.Interval;
		if(!iInterval || !isFinite(iInterval))
		{
			iInterval = EBFeedConsts_CT459487.DefaultInterval;
		}
		return iInterval;
	},
	
	GetTitle : function(strTitle)
	{
		if(!strTitle)
		{
			strTitle = EBFeedConsts_CT459487.NoTitleCaption;
		}
		else
		{
			strTitle = strTitle.replace(/\n/g,'');
			strTitle = strTitle.replace(/\r/g,'');
			strTitle = EBGlobalManager_CT459487.TrimToOne(strTitle);
			strTitle = EBGlobalManager_CT459487.ToStripHTML(strTitle);
		}
		
		return strTitle;
	},
	
	GetTooltipCaption : function(strDate)
	{
		var strTooltip = 'Posted ' + strDate;
		return strTooltip;
	},
		
	OnToolbarFeedPopupShowing : function(event,strCompID,iMultiIndex)
	{
		if(event.eventPhase == 2)
		{
			var	oFeedComponent = null;
			if(iMultiIndex == -1)
			{
				oFeedComponent = EBComponentsManager_CT459487.GetComponentByCompID(strCompID);
			}
			else
			{
				var oMultiFeedComponent = EBComponentsManager_CT459487.GetComponentByCompID(strCompID);
				oFeedComponent			= oMultiFeedComponent.FeedComponents[iMultiIndex];
			}
			
			if(oFeedComponent)
			{
				//check to see if the dialog is open(meaning second click on that button) to close it
				var oFeedDialog = EBFeedDialogManager_CT459487.GetDialog();
				if(oFeedDialog && oFeedDialog.m_oFeedComponent == oFeedComponent)
				{
					oFeedDialog.close();
				}
				else
				{
					var oXULElement		= event.target.parentNode;
					
					var iDialogWidth	= EBFeedDialogConsts_CT459487.DialogWidth;
					var oCoordinates	= EBActionManager_CT459487.GetToolbarDialogOpeningCoordinates(oXULElement,iDialogWidth);
		
					EBFeedDialogManager_CT459487.Open(oCoordinates.X,oCoordinates.Y,oFeedComponent);
				}
			}
			
			return false;
		}
		
		return true;
	},
	
	OnClickToolbarFeedFromChevron : function(event,strCompID,iMultiIndex)
	{
		if(event.button == 0)
		{
			var	oFeedComponent = null;
			if(iMultiIndex == -1)
			{
				oFeedComponent = EBComponentsManager_CT459487.GetComponentByCompID(strCompID);
			}
			else
			{
				var oMultiFeedComponent = EBComponentsManager_CT459487.GetComponentByCompID(strCompID);
				oFeedComponent = oMultiFeedComponent.FeedComponents[iMultiIndex];
			}
			
			if(oFeedComponent)
			{
				var oXULElement			= event.target;
					
				var iDialogWidth		= EBFeedDialogConsts_CT459487.DialogWidth;
				var oCoordinates		= EBActionManager_CT459487.GetToolbarDialogOpeningCoordinates(oXULElement,iDialogWidth);
		
				EBFeedDialogManager_CT459487.Open(oCoordinates.X,oCoordinates.Y,oFeedComponent);
			}
		}
	},
	
	OnMultiFeedMainPopupShowing : function(event,strCompID)
	{
		if(event.eventPhase == 2)
		{
			var oMultiFeedComponent = EBComponentsManager_CT459487.GetComponentByCompID(strCompID);
			if(oMultiFeedComponent)
			{
				//check if this multi is open(for the second click of the button)
				var oMultiFeedDialog = EBMultiFeedDialogManager_CT459487.GetDialog();
				if(oMultiFeedDialog && oMultiFeedDialog.m_oMultiFeedComponent == oMultiFeedComponent)
				{
	
					oMultiFeedDialog.close();
				}
				else
				{
					//call usage
					EBFeedManager_CT459487.RequestFeedUsage(strCompID,
								EBUsageConsts_CT459487.MULTI_RSS,
								'',
								'');
				
					var oXULElement			= event.target.parentNode;
					var iDialogWidth		= EBFeedDialogConsts_CT459487.DialogWidth;
			
					var oCoordinates		= EBActionManager_CT459487.GetToolbarDialogOpeningCoordinates(oXULElement,iDialogWidth);

					EBMultiFeedDialogManager_CT459487.Open(oCoordinates.X,oCoordinates.Y,oMultiFeedComponent);
				}
			}
			
			return false;
		}
		
		return true;
	},
	
	//in mac-linux there isn't the multi feed dialog but regular popmenu cause 
	//the problem that the feed dialog close the xul popupmenu does not exists in linux-mac
	OnMultiFeedMainPopupShowingMacLinux : function(event,strCompID)
	{
		if(event.eventPhase == 2)
		{
			var oMultiFeedComponent = EBComponentsManager_CT459487.GetComponentByCompID(strCompID);
			if(oMultiFeedComponent)
			{
				var oXULMainMenuPopup = event.target;
				//nullify popup
				while(oXULMainMenuPopup.childNodes.length > 0)
				{
					oXULMainMenuPopup.removeChild(oXULMainMenuPopup.firstChild);
				}
				
				//take the components array from the multi feed component and build the feed items as XUL menu:
				var strLabel			= '';
				var strImage			= '';
				var oXULMenu			= null;
				var oXULMenuPopup		= null;
				var strOnPopupShowing	= '';
				
				var oFeedComponents = oMultiFeedComponent.FeedComponents;
				var oFeedComponent	= null;
				for(var i=0;i<oFeedComponents.length;i++)
				{
					oFeedComponent	= oFeedComponents[i];
					strLabel		= oFeedComponent.GetFeedTitle();
					strImage		= oFeedComponent.GetFeedImage();
					
					oXULMenu = EBXULFactory_CT459487.CreateMenu(strLabel,
																		strImage,
																		'');

					strOnPopupShowing = 'return EBFeedManager_CT459487.OnToolbarFeedPopupShowingMacLinux(event,this,\'' + strCompID + '\',' + i + ');';
					oXULMenuPopup = EBXULFactory_CT459487.CreateMenuPopup('',strOnPopupShowing,'');
					oXULMenu.appendChild(oXULMenuPopup);
					
					oXULMainMenuPopup.appendChild(oXULMenu);
				}
				
			}
			
			
		}	
	},
	
	OnToolbarFeedPopupShowingMacLinux : function(event,oElement,strMultiCompID,iIndex)
	{
		if(event.eventPhase == 2)
		{
			var iDialogWidth	= EBFeedDialogConsts_CT459487.DialogWidth;
			var iDialogHeight	= EBFeedDialogConsts_CT459487.DialogHeight;
			var oRecentBrowserWindow = EBGlobalManager_CT459487.GetMostRecentBrowserWindow();
			var oMenuElement = oElement.parentNode;
			var oCoordinates = oRecentBrowserWindow.EBActionManager_CT459487.GetItemDialogOpeningCoordintates(oMenuElement,iDialogWidth,iDialogHeight);

			var oFeedComponent = null;
			var oMultiFeedComponent = EBComponentsManager_CT459487.GetComponentByCompID(strMultiCompID);
			if(oMultiFeedComponent)
			{
				oFeedComponent = oMultiFeedComponent.FeedComponents[iIndex];
			}
		
			if(oFeedComponent)
			{
				var oFeedDialog = EBFeedDialogManager_CT459487.GetDialog();
				if(oFeedDialog)
				{
					if(oFeedDialog.m_oFeedComponent != oFeedComponent)
					{
						oFeedDialog.close();
					}
				}
				EBFeedDialogManager_CT459487.Open(oCoordinates.X,oCoordinates.Y,oFeedComponent);
			}
			
			return false;
		}
		
		return true;
	},
	
	UpdateMultiFeedItemData : function(oFeedComponent)
	{
		if(EBGlobalManager_CT459487.IsWindowsPlatform())
		{
			var oMultiFeedDialog = EBMultiFeedDialogManager_CT459487.GetDialog();
			if(oMultiFeedDialog)
			{
				oMultiFeedDialog.EBMultiFeedDialogManager_CT459487.UpdateMultiFeedItemData(oFeedComponent.MultiFeedChildIndex);
			}
		}
		else
		{
			this.UpdateMultiFeedItemDataMacLinux(oFeedComponent);
		}	
	},
	
	UpdateMultiFeedItemDataMacLinux : function(oFeedComponent)
	{
		var strMultiCompID = oFeedComponent.MultiFeedCompID;
		var oMultiFeedComponent = EBComponentsManager_CT459487.GetComponentByCompID(strMultiCompID);
		if(oMultiFeedComponent)
		{
			var strFeedTitle = oFeedComponent.GetFeedTitle();
			var strFeedImage = oFeedComponent.GetFeedImage();

			var oXULPopupMenuChevron	= null;
			var oXULMenuChevron			= null;
			
			var oXULPopupMenu			= null;
			var oXULMenu				= null;
			
			//check if it's chevron first
			var oChevron = EBActionManager_CT459487.GetToolbarChevron();
			if(oChevron)
			{
				if(oMultiFeedComponent.XULChevronElement)
				{
					oXULPopupMenuChevron = oMultiFeedComponent.XULChevronElement.firstChild;
				}
			}
			
			if(oXULPopupMenuChevron)
			{
				oXULMenuChevron = oXULPopupMenuChevron.childNodes[oFeedComponent.MultiFeedChildIndex];
				if(oXULMenuChevron)
				{
					oXULMenuChevron.setAttribute('label',strFeedTitle);
					oXULMenuChevron.setAttribute('image',strFeedImage);
				}
			}
			
			//check the toolbarbutton:
			if(oMultiFeedComponent.XULElement)
			{
				oXULPopupMenu = oMultiFeedComponent.XULElement.firstChild;
			}
			
			if(oXULPopupMenu)
			{
				oXULMenu = oXULPopupMenu.childNodes[oFeedComponent.MultiFeedChildIndex];
			}
			
			if(oXULMenu)
			{
				oXULMenu.setAttribute('label',strFeedTitle);
				oXULMenu.setAttribute('image',strFeedImage);
			}
		}
	},
	
	OnMultiFeedMainPopupShowingFromChevron : function(event,strCompID)
	{
		if(event.eventPhase == 2)
		{
			//call usage
			EBFeedManager_CT459487.RequestFeedUsage(strCompID,
								EBUsageConsts_CT459487.MULTI_RSS,
								'',
								'');
		}
	},
	
	OnToolbarFeedLivePopupShowing : function(event,strCompID,strFeedURL)
	{
		if(event.eventPhase == 2)
		{
			this.RequestFeedUsage(strCompID,
									EBUsageConsts_CT459487.RSS,
									EBUsageConsts_CT459487.LIVE_RSS_MENU_OPEN,
									strFeedURL);
		}
	},
	
	OnToolbarFeedLivePopupHiding : function(event,strCompID)
	{
		if(event.eventPhase == 2)
		{
			var oFeedComponent = EBComponentsManager_CT459487.GetComponentByCompID(strCompID);
			if(oFeedComponent.FeedData.Data.Stared)
			{
				oFeedComponent.FeedData.Data.Stared = false;
				//save the data
				this.SaveFeedDataStructured(oFeedComponent);
				this.BroadcastData(oFeedComponent);
				this.BroadcastLiveGUI(strCompID);
			}
		}
	},
	
	RequestFeedUsage : function(strComponentID,strType,strParam1,strParam2)
	{
		var objUsage = new EBUsageObject_CT459487(strComponentID,
													strType,
													strParam1,
													strParam2);
	
		//send the data
		objUsage.SendRequest();
	},
	
	
	//broadcast all browser and load the gui of the xul element
	BroadcastGUIButton : function(strCompID,strLabel,strImage)
	{
		var objWindowsManager = Components.classes['@mozilla.org/appshell/window-mediator;1']
						.getService(Components.interfaces.nsIWindowMediator);
		
		var objEnumerator = objWindowsManager.getEnumerator('navigator:browser');	
		while(objEnumerator.hasMoreElements()) 
		{
			var objWindow = objEnumerator.getNext();
			if(objWindow.EBFeedManager_CT459487.SetXULElementLabelImage)
			{
				try
				{
					objWindow.EBFeedManager_CT459487.SetXULElementLabelImage(strCompID,strLabel,strImage);
				}
				catch(ex){}
			}
		}
	},
	
	BroadcastLiveGUI : function(strCompID)
	{
		var objWindowsManager = Components.classes['@mozilla.org/appshell/window-mediator;1']
						.getService(Components.interfaces.nsIWindowMediator);
		
		var objEnumerator = objWindowsManager.getEnumerator('navigator:browser');	
		while(objEnumerator.hasMoreElements()) 
		{
			var objWindow = objEnumerator.getNext();
			if(objWindow.EBFeedManager_CT459487.BuildLiveFeedItemsMenu)
			{
				try
				{
					objWindow.EBFeedManager_CT459487.BuildLiveFeedItemsMenu(strCompID);
				}
				catch(ex){}
			}
		}
	},
	
	//broadcast all browser and load the data from the file for each component
	//except from the current component which is already updated
	BroadcastData : function(oFeedComponentMain)
	{
		var objWindowsManager = Components.classes['@mozilla.org/appshell/window-mediator;1']
						.getService(Components.interfaces.nsIWindowMediator);
		
		var objEnumerator = objWindowsManager.getEnumerator('navigator:browser');	
		while(objEnumerator.hasMoreElements()) 
		{
			var objWindow = objEnumerator.getNext();
			try
			{
				
				var oFeedComponent	= null;
				if(oFeedComponentMain.IsMultiFeed)
				{
					//if it's multi feed get the component from the array of the feed components in the multi feed component
					var strMultiFeedCompID	= oFeedComponentMain.MultiFeedCompID;
					var oMultiFeedComponent = objWindow.EBComponentsManager_CT459487.GetComponentByCompID(strMultiFeedCompID);
					if(oMultiFeedComponent)
					{
						var iIndex		= oFeedComponentMain.MultiFeedChildIndex;
						oFeedComponent	= oMultiFeedComponent.FeedComponents[iIndex];
					}
				}
				else
				{
					//get the component of that window scope
					var strCompID = oFeedComponentMain.ComponentItem.UniqueCompID;
					//get the component from that window scope
					oFeedComponent = objWindow.EBComponentsManager_CT459487.GetComponentByCompID(strCompID);
				}
				
				if(oFeedComponent)
				{
					//only if it's not the original component that set the broacast
					//set it to reload the data:
					if(oFeedComponentMain != oFeedComponent)
					{
						objWindow.EBFeedManager_CT459487.LoadComponentData(oFeedComponent);
						//set the NumOfNew of that component to the current NumOfNew
						oFeedComponent.NumOfNew = oFeedComponentMain.NumOfNew;
					}
				}
			}
			catch(ex){}
		}
	}
	
}
var FeedParserConsts_CT459487 =
{
	TYPE : 
	{
		RSS		: 'RSS',
		ATOM	: 'ATOM' 	
	},

	RSS : 
	{
		CHANNEL		: 'channel',
		ITEM		: 'item',
		TITLE		: 'title',
		LINK		: 'link',
		GUID		: 'guid',
		PUBDATE		: 'pubdate',
		DCDATE		: 'dc:date',
		ISPERMALINK : 'isPermaLink',
		TRUE		: 'true',
		FALSE		: 'false'
	},
	
	ATOM : 
	{
		ENTRY		: 'entry',
		TITLE		: 'title',
		LINK		: 'link',
		HREF		: 'href',
		MODIFIED	: 'modified',
		TYPE		: 'type',
		TEXTHTML	: 'text/html'
	}
}

function EBFeedElement_CT459487(strTitle,strLink,strDate)
{
	this.Title	= strTitle;
	this.Link	= strLink;
	this.Date	= strDate;
}

function EBFeedParser_CT459487(XMLDoc,iMaxElements)
{
	this.Type			= '';
	
	this.Title			= '';
	this.Link			= '';
	this.ArrayHash		= new EBArrayHashObject_CT459487();
	this.MaxElements	= iMaxElements;

	this.Init = function(XMLDoc)
	{
		if(XMLDoc)
		{
			var XMLRoot = XMLDoc.documentElement;
			if(XMLRoot.tagName != 'parsererror')
			{
				this.BuildFeed(XMLRoot);
			}
		}
	};
	
	this.BuildFeed = function(XMLRoot)
	{
		var XMLFeedItems = this.GetFeedItems(XMLRoot);
		
		if(XMLFeedItems)
		{
			if(this.Type == FeedParserConsts_CT459487.TYPE.RSS)
			{
				this.SetRSSFeedTitleLink(XMLRoot);
				this.BuildRSSFeedItems(XMLFeedItems);
			}
			else if(this.Type == FeedParserConsts_CT459487.TYPE.ATOM)
			{
				this.SetATOMFeedTitleLink(XMLRoot);
				this.BuildATOMFeedItems(XMLFeedItems);
			}
		}
	};
	
	this.BuildRSSFeedItems = function(XMLFeedItems)
	{
		var strTitle	= '';
		var strLink		= '';
		var strDate		= '';
		
		var strURLFromLinkNode			= '';
		var strURLFromGUIDPermaLinkNode = '';
		
		var strTagName		= '';
		
		var XMLFeedItem		= null;
		var XMLChildNode	= null;
		for(var i=0;i<XMLFeedItems.length;i++)
		{
			XMLFeedItem = XMLFeedItems.item(i);
			for(var j=0;j<XMLFeedItem.childNodes.length;j++)
			{
				XMLChildNode = XMLFeedItem.childNodes[j];
				strTagName = XMLChildNode.tagName;
				if(typeof(strTagName) == 'string')
				{
					strTagName = strTagName.toLowerCase();
				}
				
				if(strTagName == FeedParserConsts_CT459487.RSS.TITLE)
				{
					strTitle = EBGlobalManager_CT459487.GetXmlNodeValue(XMLChildNode);
				} 
				else if(strTagName == FeedParserConsts_CT459487.RSS.LINK)
				{
					strURLFromLinkNode = EBGlobalManager_CT459487.GetXmlNodeValue(XMLChildNode);
				}
				else if(strTagName == FeedParserConsts_CT459487.RSS.GUID)
				{
					strURLFromGUIDPermaLinkNode = this.GetRSSLinkFromXMLGUIDNode(XMLChildNode);
				}
				else if(strTagName == FeedParserConsts_CT459487.RSS.PUBDATE)
				{
					strDate = EBGlobalManager_CT459487.GetXmlNodeValue(XMLChildNode);
				}
				else if(strTagName == FeedParserConsts_CT459487.RSS.DCDATE)
				{
					strDate = EBGlobalManager_CT459487.GetXmlNodeValue(XMLChildNode);
				}
			}
			
			strLink = strURLFromLinkNode ? strURLFromLinkNode : strURLFromGUIDPermaLinkNode;
			
			if(strLink)
			{
				this.AddFeedElement(strTitle,strLink,strDate);
			}
			
			if(this.IsMaxElements())
			{
				break;
			}
		}
	};
	
	this.BuildATOMFeedItems = function(XMLFeedItems)
	{
		var strTitle	= '';
		var strLink		= '';
		var strDate		= '';
		
		var strURLFromLinkNodeTextHTML	= '';
		var strURLFromLinkNode			= '';
		
		var strTagName		= '';
		
		var XMLFeedItem		= null;
		var XMLChildNode	= null;
		for(var i=0;i<XMLFeedItems.length;i++)
		{
			XMLFeedItem = XMLFeedItems.item(i);
			for(var j=0;j<XMLFeedItem.childNodes.length;j++)
			{
				XMLChildNode = XMLFeedItem.childNodes[j];
				strTagName = XMLChildNode.tagName;
				if(typeof(strTagName) == 'string')
				{
					strTagName = strTagName.toLowerCase();
				}
				
				if(strTagName == FeedParserConsts_CT459487.ATOM.TITLE)
				{
					strTitle = EBGlobalManager_CT459487.GetXmlNodeValue(XMLChildNode);
				}
				else if(strTagName == FeedParserConsts_CT459487.ATOM.LINK)
				{
					strURLFromLinkNodeTextHTML = this.GetATOMLinkFromXMLLinkNodeTextHTML(XMLChildNode);
					if(!strURLFromLinkNodeTextHTML)
					{
						strURLFromLinkNode = this.GetATOMLinkFromXMLLink(XMLChildNode);
					}
				}
				else if(strTagName == FeedParserConsts_CT459487.ATOM.MODIFIED)
				{
					strDate = EBGlobalManager_CT459487.GetXmlNodeValue(XMLChildNode);
				}
			}
			
			strLink = strURLFromLinkNodeTextHTML ? strURLFromLinkNodeTextHTML : strURLFromLinkNode;
			
			if(strLink)
			{
				this.AddFeedElement(strTitle,strLink,strDate);
			}
			
			if(this.IsMaxElements())
			{
				break;
			}
		}
	};
	
	this.AddFeedElement = function(strTitle,strLink,strDate)
	{
		var oFeedElement = new EBFeedElement_CT459487(strTitle,strLink,strDate);
		this.ArrayHash.Add(oFeedElement.Link,oFeedElement);
	};
	
	this.IsMaxElements = function()
	{
		var bRetVal = false;
		
		if(this.MaxElements && this.ArrayHash.Count() >= this.MaxElements)
		{
			bRetVal = true;
		}		
		
		return bRetVal;
	};
	
	this.GetFeedItems = function(XMLRoot)
	{
		var XMLFeedItems = null;
		//check rss
		XMLFeedItems = XMLRoot.getElementsByTagName(FeedParserConsts_CT459487.RSS.ITEM);
		if(XMLFeedItems.length > 0)
		{
			this.Type	= FeedParserConsts_CT459487.TYPE.RSS;
			return XMLFeedItems;
		}
		
		//check atom
		XMLFeedItems = XMLRoot.getElementsByTagName(FeedParserConsts_CT459487.ATOM.ENTRY);
		if(XMLFeedItems.length > 0)
		{
			this.Type	= FeedParserConsts_CT459487.TYPE.ATOM;
			return XMLFeedItems;
		}
		
		return null;
		
	};
	
	this.SetRSSFeedTitleLink = function(XMLRoot)
	{
		var strFeedTitle	= '';
		var strFeedLink		= '';
		var XMLChildNode	= null;
		var XMLChannelNode	= null;
		var strTagName		= '';
		
		for(var i=0;i<XMLRoot.childNodes.length;i++)
		{
			XMLChildNode = XMLRoot.childNodes[i];
			
			strTagName	 = XMLChildNode.tagName;
			if(typeof(strTagName) == 'string')
			{
				strTagName = strTagName.toLowerCase();
			}
			
			if(strTagName == FeedParserConsts_CT459487.RSS.CHANNEL)
			{
				XMLChannelNode = XMLChildNode;
				break;
			}
		}
		
		if(XMLChannelNode)
		{
			for(var i=0;i<XMLChannelNode.childNodes.length;i++)
			{
				XMLChildNode = XMLChannelNode.childNodes[i];
				strTagName	 = XMLChildNode.tagName;
				if(typeof(strTagName) == 'string')
				{
					strTagName = strTagName.toLowerCase();
				}
				
				if(strTagName == FeedParserConsts_CT459487.RSS.TITLE)
				{
					strFeedTitle = EBGlobalManager_CT459487.GetXmlNodeValue(XMLChildNode);
				}
				else if(strTagName == FeedParserConsts_CT459487.RSS.LINK)
				{
					strFeedLink	= EBGlobalManager_CT459487.GetXmlNodeValue(XMLChildNode);
				}
				
				if(strFeedTitle && strFeedLink)
				{
					break;
				}
			}
		}
		this.Title		= strFeedTitle;
		this.Link		= strFeedLink;
	};
	
	this.SetATOMFeedTitleLink = function(XMLRoot)
	{
		var strFeedTitle	= '';
		var strFeedLink		= '';
		var XMLChildNode	= null;
		var strTagName		= '';
		
		for(var i=0;i<XMLRoot.childNodes.length;i++)
		{
			XMLChildNode = XMLRoot.childNodes[i];
			strTagName	 = XMLChildNode.tagName;
			if(typeof(strTagName) == 'string')
			{
				strTagName = strTagName.toLowerCase();
			}
			
			if(strTagName == FeedParserConsts_CT459487.ATOM.TITLE)
			{
				strFeedTitle = EBGlobalManager_CT459487.GetXmlNodeValue(XMLChildNode);
			}
			else if(strTagName == FeedParserConsts_CT459487.ATOM.LINK)
			{
				strFeedLink = this.GetATOMLinkFromXMLLinkNodeTextHTML(XMLChildNode);
				if(!strFeedLink)
				{
					strFeedLink =  this.GetATOMLinkFromXMLLink(XMLChildNode);
				}
			}
			
			if(strFeedTitle && strFeedLink)
			{
				break;
			}
		}
		
		this.Title		= strFeedTitle;
		this.Link		= strFeedLink;
	};
	
	this.GetATOMLinkFromXMLLinkNodeTextHTML = function(XMLLinkNode)
	{
		var strLink = '';
	
		var oAttributes		= null;
		var oAttType		= null;
		var oAttHref		= null;
		
		oAttributes = XMLLinkNode.attributes;
		oAttHref	= oAttributes.getNamedItem(FeedParserConsts_CT459487.ATOM.HREF);
		oAttType	= oAttributes.getNamedItem(FeedParserConsts_CT459487.ATOM.TYPE);
		if(oAttHref && oAttType && oAttType.nodeValue.toLowerCase() == FeedParserConsts_CT459487.ATOM.TEXTHTML)
		{
			strLink = oAttHref.nodeValue;
		}
		
		return strLink;
	};
	
	this.GetATOMLinkFromXMLLink = function(XMLLinkNode)
	{
		var strLink = '';
	
		var oAttributes		= null;
		var oAttHref		= null;
		
		oAttributes = XMLLinkNode.attributes;
		oAttHref	= oAttributes.getNamedItem(FeedParserConsts_CT459487.ATOM.HREF);
		if(oAttHref)
		{
			strLink = oAttHref.nodeValue;
		}
		
		return strLink;
	};	
	
	this.GetRSSLinkFromXMLGUIDNode = function(XMLGUIDNode)
	{
		var strLink = '';
		var oAttributes		= null;
		var oAttIsPermaLink	= null;
		
		oAttributes		= XMLGUIDNode.attributes;
		oAttIsPermaLink	= oAttributes.getNamedItem(FeedParserConsts_CT459487.RSS.ISPERMALINK);
	
		if(!oAttIsPermaLink || oAttIsPermaLink.nodeValue.toLowerCase() == FeedParserConsts_CT459487.RSS.TRUE)
		{
			strLink = EBGlobalManager_CT459487.GetXmlNodeValue(XMLGUIDNode);
		}
		
		return strLink;
	};
	
	this.Init(XMLDoc);
}

var EBMultiFeedDialogConsts_CT459487 = 
{
	XULFileName				: 'multi_feed.xul',
	XULOldAPIFileName		: 'oldapi/multi_feed_oldapi.xul',
	DialogName				: 'MultiFeedDialogName_CT459487',
	DialogType				: 'EBMultiFeedDialog_CT459487',
	OpenFeedDialogInterval	: 50,
	
	Style : 
	{									
		RowMultiFeedItemFixedStyle		: 'height:20px;min-height:20px;',
		RowMultiFeedItemDefaultStyle	: 'border:1px solid transparent;',
		RowMultiFeedItemHoverStyle		: 'background-color:#C6D3EF;border:1px solid #316AC5;',
		LabelMultiFeedItemFixedStyle	: 'font-size:11px;',
		ImageMultiFeedItemFixedStyle	: 'max-width:20px',
		ImagesSumWidth					: 44
	}
}


var EBMultiFeedDialogManager_CT459487 = 
{
	//timeout id of the open dialog call
	TimeoutID : null,
	
	//indicates if the multi feed is active(the user mouse over it)
	IsActive  : false,
	
	//this index of the feed element that is now active
	ActiveFeedElementIndex : -1,

	GetDialog : function()
	{
		var strDialogType = EBMultiFeedDialogConsts_CT459487.DialogType;
		var strDialogName = EBMultiFeedDialogConsts_CT459487.DialogName;
		
		var oMultiFeedDialog = EBGlobalManager_CT459487.GetXULWindowByTypeAndName(strDialogType,strDialogName);
			
		return oMultiFeedDialog;
	},
	
	Open : function(iX,iY,oMultiFeedComponent)
	{
		var strChromePath = '';
			
		if(EBGlobalManager_CT459487.IsNewestBrowserAPI())
		{
			strChromePath = EBGlobalConsts_CT459487.ChromeContentPath + EBMultiFeedDialogConsts_CT459487.XULFileName;
		}
		else
		{
			strChromePath = EBGlobalConsts_CT459487.ChromeContentPath + EBMultiFeedDialogConsts_CT459487.XULOldAPIFileName;
		}
		
		window.openDialog(strChromePath,
						EBMultiFeedDialogConsts_CT459487.DialogName,
						'chrome,dependent,resizable=no,titlebar=no,screenX=' + iX + ',screenY=' + iY,
						oMultiFeedComponent);
	},
	
	OnLoadDialog : function(event)
	{
		this.LoadMultiFeedItemsData();
	},
	
	LoadMultiFeedItemsData : function()
	{
		//empty container
		var oRowsContainer = document.getElementById('rowsMultiItems');
		while(oRowsContainer.childNodes.length > 0)
		{
			oRowsContainer.removeChild(oRowsContainer.firstChild);
		}
	
		var oFeedComponentsArray = m_oMultiFeedComponent.FeedComponents;
		var oFeedComponent	= null;
		for(var i=0;i<oFeedComponentsArray.length;i++)
		{
			oFeedComponent = oFeedComponentsArray[i];
			this.LoadMultiFeedItemData(oFeedComponent);
		}

		this.SetWidth();
	},
	
	
	SetWidth : function()
	{
		var iWidthToSet		= 0;
		var iLabelWidth		= 0;
		var oRowsContainer = document.getElementById('rowsMultiItems');
		var oLables = oRowsContainer.getElementsByTagName('label');
		var oLabel = null;
		for(var i=0;i<oLables.length;i++)
		{
			oLabel = oLables[i];
			iLabelWidth = oLabel.boxObject.width;
			
			if(iLabelWidth > iWidthToSet)
			{
				iWidthToSet = iLabelWidth;
			}
		}
		iWidthToSet += EBMultiFeedDialogConsts_CT459487.Style.ImagesSumWidth;
		oRowsContainer.setAttribute('style','width:' + iWidthToSet + 'px;');

	},

	LoadMultiFeedItemData : function(oFeedComponent)
	{
		var strFeedTitle = oFeedComponent.GetFeedTitle();
		var strFeedImage = oFeedComponent.GetFeedImage();
		
		var oFeedImage = document.createElement('image');
		oFeedImage.setAttribute('src',strFeedImage);
		oFeedImage.setAttribute('style',EBMultiFeedDialogConsts_CT459487.Style.ImageMultiFeedItemFixedStyle);
		var oBoxImage = document.createElement('box');
		oBoxImage.setAttribute('align','center');
		oBoxImage.appendChild(oFeedImage);
		
		var oLabel = document.createElement('label');
		oLabel.setAttribute('value',strFeedTitle);
		oLabel.setAttribute('style',EBMultiFeedDialogConsts_CT459487.Style.LabelMultiFeedItemFixedStyle);
		
		
		
		var oFeedArrowImage = document.createElement('image');
		oFeedArrowImage.setAttribute('src','chrome://global/skin/arrow/arrow-rit-sharp.gif');
		var oBoxArrowImage = document.createElement('box');
		oBoxArrowImage.appendChild(oFeedArrowImage);
		
		var oRow = document.createElement('row');
		oRow.setAttribute('align','center');
		oRow.setAttribute('style',EBMultiFeedDialogConsts_CT459487.Style.RowMultiFeedItemFixedStyle + EBMultiFeedDialogConsts_CT459487.Style.RowMultiFeedItemDefaultStyle);
		oRow.setAttribute('onmouseover','EBMultiFeedDialogManager_CT459487.OnMouseOverRowFeedItem(event,this,' + oFeedComponent.MultiFeedChildIndex + ');');
		oRow.setAttribute('onmouseout','EBMultiFeedDialogManager_CT459487.OnMouseOutRowFeedItem(event,this);');
		
		oRow.appendChild(oBoxImage);
		oRow.appendChild(oLabel);
		oRow.appendChild(oBoxArrowImage);
		
		var oRowsContainer = document.getElementById('rowsMultiItems');
		oRowsContainer.appendChild(oRow);
	},
	
	UpdateMultiFeedItemData : function(iIndex)
	{
		var oFeedComponent = m_oMultiFeedComponent.FeedComponents[iIndex];
		var oRowsContainer = document.getElementById('rowsMultiItems');
		var oRow = oRowsContainer.childNodes[iIndex];
		
		if(oFeedComponent && oRow)
		{
			var oFeedImage	= oRow.childNodes[0].firstChild;//box->image
			var oLabel		= oRow.childNodes[1];
			
			var strFeedTitle = oFeedComponent.GetFeedTitle();
			var strFeedImage = oFeedComponent.GetFeedImage();
			
			oLabel.setAttribute('value',strFeedTitle);
			oFeedImage.setAttribute('src',strFeedImage);
		}
	},
	
	OnMouseOverRowFeedItem : function(event,oElement,iIndex)
	{
		this.ActiveFeedElementIndex = iIndex;
		this.SetRowStyleOver(oElement);
		
		this.CheckOpenFeedDialog(event,oElement,iIndex);
	},
	
	SetRowStyleOver : function(oElement)
	{
		var strStyle = EBMultiFeedDialogConsts_CT459487.Style.RowMultiFeedItemFixedStyle
						+
					EBMultiFeedDialogConsts_CT459487.Style.RowMultiFeedItemHoverStyle;
					
		oElement.setAttribute('style',strStyle);
	},
	
	OnMouseOutRowFeedItem : function(event,oElement)
	{
		this.SetRowStyleOut(oElement);
		this.KillTimeoutID();
	},
	
	SetRowStyleOut : function(oElement)
	{
		var strStyle = EBMultiFeedDialogConsts_CT459487.Style.RowMultiFeedItemFixedStyle + EBMultiFeedDialogConsts_CT459487.Style.RowMultiFeedItemDefaultStyle;
		oElement.setAttribute('style',strStyle);
	},
	
	CheckOpenFeedDialog : function(event,oElement,iIndex)
	{
		var iDialogWidth	= EBFeedDialogConsts_CT459487.DialogWidth;
		var iDialogHeight	= EBFeedDialogConsts_CT459487.DialogHeight;
		var oRecentBrowserWindow = EBGlobalManager_CT459487.GetMostRecentBrowserWindow();
		var oCoordinates = oRecentBrowserWindow.EBActionManager_CT459487.GetItemDialogOpeningCoordintates(oElement,iDialogWidth,iDialogHeight);

		var oFeedComponent = m_oMultiFeedComponent.FeedComponents[iIndex];
	
		if(oFeedComponent)
		{
			
			var oThreadFunction = function()
			{
				var oFeedDialog = EBFeedDialogManager_CT459487.GetDialog();
				if(oFeedDialog)
				{
					if(oFeedDialog.m_oFeedComponent != oFeedComponent)
					{
						oFeedDialog.close();
					}
				}
				EBFeedDialogManager_CT459487.Open(oCoordinates.X,oCoordinates.Y,oFeedComponent);
			}
			
			var iInterval = EBMultiFeedDialogConsts_CT459487.OpenFeedDialogInterval;
			this.TimeoutID = setTimeout(oThreadFunction,iInterval);
		}
	},
	
	KillTimeoutID : function()
	{
		if(this.TimeoutID)
		{
			clearTimeout(this.TimeoutID);
		}	
	},
	
	OnUnLoadDialog : function(event)
	{
		try
		{
			//set the button to appear not clicked
			var oXULToolbarButton = m_oMultiFeedComponent.XULElement;
			oXULToolbarButton.removeAttribute('open');
		}
		catch(ex){}
	},
	
	OnBlurDialog : function(event)
	{
		if(event.eventPhase == 2)
		{
			if(!this.IsActive)
			{
				window.close();
			}
		}
	},
	
	OnMouseOverVBox : function(event)
	{
		this.IsActive = true;
	},
	
	OnMouseOutVBox : function(event)
	{
		this.IsActive = false;
	}
	
	
}


