
var EBToolbarOptionsPreferenceConsts_CT459487 = 
{
	PrefPrefix : 'components'
}


var EBToolbarOptionsPreferenceManager_CT459487 = 
{
	GetBasePrefName : function()
	{
		var strBasePrefName = EBToolbarOptionsPreferenceConsts_CT459487.PrefPrefix + '.';
		
		return strBasePrefName;
	},
	
	GetFullPrefName : function(strComponentID)
	{
		var strBasePrefName = this.GetBasePrefName();
		
		var strFullPrefName = strBasePrefName + strComponentID;
		
		return strFullPrefName;
	},
	
	SetPref : function(strComponentID,bValue)
	{
		var strFullPrefName = this.GetFullPrefName(strComponentID);
		
		EBToolbarPreferenceManager_CT459487.SetPref(strFullPrefName,bValue);
	},
	
	IsShowComponent : function(oToolbarComponent)
	{
		var oMostRecentBrowserWindow = EBGlobalManager_CT459487.GetMostRecentBrowserWindow();
	
		var strComponentID = oToolbarComponent.ComponentItem.UniqueCompID;
		
		if(this.IsMustHaveComponent(strComponentID))
		{
			return true;
		}
		
		if(this.IsUserSettingsComponent(strComponentID))
		{
			return this.IsShowUserSettingsComponent(strComponentID);
		}
		
		//check which type of component is it 
		//if it's regular settings component the default of showing it is true
		//if it's third party component the default is false
		var bValue = true;
		if(oToolbarComponent.ComponentItem.CompType == oMostRecentBrowserWindow.EBComponentsConsts_CT459487.ComponentsType.ThirdParty)
		{
			bValue = false;
		}
		
		var strFullPrefName = this.GetFullPrefName(strComponentID);
		
		if(EBToolbarPreferenceManager_CT459487.HasUserValue(strFullPrefName))
		{
			bValue = EBToolbarPreferenceManager_CT459487.GetPref(strFullPrefName);
		}
		return bValue;
	},
	
	
	//in the user settings components we check if there isn't any 
	//user value in the prefs we check again from the general info UserComponentsState
	//to see if by default is on the toolbar or not
	IsShowUserSettingsComponent : function(strComponentID)
	{
		var strFullPrefName = this.GetFullPrefName(strComponentID);
		
		//the default for components in the pref is true
		var bValue = true;
		
		if(EBToolbarPreferenceManager_CT459487.HasUserValue(strFullPrefName))
		{
			bValue = EBToolbarPreferenceManager_CT459487.GetPref(strFullPrefName);
		}
		else
		{
			bValue = this.GetUserSettingsGeneralInfoComponentsState(strComponentID);
		}
		
		
		return bValue;
	},
	
	GetUserSettingsGeneralInfoComponentsState : function(strComponentID)
	{
		//get those value using the window object of the last browser 
		//cause this function calls also from the toolbar options which is 
		//another overlay
		var objWindow = EBGlobalManager_CT459487.GetMostRecentBrowserWindow();
		
		var bValue = true;
		if(strComponentID == objWindow.EBComponentsConsts_CT459487.ComponentsID.EMailNotifier)
		{
			bValue = objWindow.EBToolbarData_CT459487.GeneralToolbarInfo.UserComponentsState.EMailNotifier;
		}
		else if(strComponentID == objWindow.EBComponentsConsts_CT459487.ComponentsID.Privacy)
		{
			bValue = objWindow.EBToolbarData_CT459487.GeneralToolbarInfo.UserComponentsState.Privacy;
		}
		else if(strComponentID == objWindow.EBComponentsConsts_CT459487.ComponentsID.Weather)
		{
			bValue = objWindow.EBToolbarData_CT459487.GeneralToolbarInfo.UserComponentsState.Weather;
		}
		
		
		return bValue;
	},
	
	IsUserSettingsComponent : function(strComponentID)
	{
		var oRecentBrowserWindow = EBGlobalManager_CT459487.GetMostRecentBrowserWindow();
		
		if(strComponentID == oRecentBrowserWindow.EBComponentsConsts_CT459487.ComponentsID.EMailNotifier
			||
			strComponentID == oRecentBrowserWindow.EBComponentsConsts_CT459487.ComponentsID.Privacy
			||
			strComponentID == oRecentBrowserWindow.EBComponentsConsts_CT459487.ComponentsID.Weather
			)
		{
			return true;
		}
		else
		{
			return false;
		}
	},
	
	IsMustHaveComponent : function(strComponentID)
	{
		var oRecentBrowserWindow = EBGlobalManager_CT459487.GetMostRecentBrowserWindow();
	
		if(strComponentID == oRecentBrowserWindow.EBComponentsConsts_CT459487.ComponentsID.MainMenu
			||
			strComponentID == oRecentBrowserWindow.EBComponentsConsts_CT459487.ComponentsID.SearchBox)
		{
			return true;
		}
		else
		{
			return false;
		}
	}
}



var EBToolbarOptionsDialogConsts_CT459487 = 
{
	FileName						: 'options.xul',
	DialogName						: 'optionsDialogName_CT459487',
	DialogType						: 'EBOptionsDialog_CT459487',
	EditableCheckBoxPrefixID		: 'checkBoxEditableComponent',
	EditableCheckBoxAttributeCompID	: 'EB_EDITABLE_CHECK_BOX_COMP_ID',
	PersonalComponentsTabIndex		: 0,
	PredefinedComponentsTabIndex	: 1,
	ThirdPartyComponentsTabIndex	: 2
}




var EBToolbarOptionsDialogManager_CT459487 = 
{
	//array that holds the comps when the dialog loads
	PreCompArr	: null,
	//array that holds the comps when the dialog pressed OK
	PostCompArr : null,
	
	OnLoad : function(event)
	{
		this.PreDialogLoad();
	
		//since the toolbar options can be open from the extension manager as well
		//we check if the toolbar is seen (not uncheck at the context-menu)
		if(this.IsToolbarShown())
		{
			this.PreCompArr = new Array();
		
			//read from the prefs(if any) and set the check box according to it
			var objCheckBoxEMailNotifier		= document.getElementById('checkEMailNotifier');
			//add event to the checkbox
			objCheckBoxEMailNotifier.addEventListener("CheckboxStateChange",
											EBToolbarOptionsDialogManager_CT459487.OnCheckBoxEMailNotifierChange,
											false);
			
			var objButtonEMailNotifer			= document.getElementById('btnEMailNotifier');
			var objCheckBoxPrivacy				= document.getElementById('checkPrivacy');
			var objCheckBoxWeather				= document.getElementById('checkWeather');
			
			var oRecentBrowserWindow			= EBGlobalManager_CT459487.GetMostRecentBrowserWindow();
			
			var strEMailNotifierComponentID		= oRecentBrowserWindow.EBComponentsConsts_CT459487.ComponentsID.EMailNotifier;
			var strPrivacyComponentID			= oRecentBrowserWindow.EBComponentsConsts_CT459487.ComponentsID.Privacy;
			var strWeatherComponentID			= oRecentBrowserWindow.EBComponentsConsts_CT459487.ComponentsID.Weather;
			
			var oEMailNotifierComponent			= oRecentBrowserWindow.EBComponentsManager_CT459487.GetComponentByCompID(strEMailNotifierComponentID);
			var oPrivacyComponent				= oRecentBrowserWindow.EBComponentsManager_CT459487.GetComponentByCompID(strPrivacyComponentID);
			var oWeatherComponent				= oRecentBrowserWindow.EBComponentsManager_CT459487.GetComponentByCompID(strWeatherComponentID);
			
			var bEMailNotifierValue				= false;
			var bPrivacyValue					= false;
			var bWeatherValue					= false;
			
			if(oEMailNotifierComponent)
			{
				bEMailNotifierValue				= EBToolbarOptionsPreferenceManager_CT459487.IsShowComponent(oEMailNotifierComponent);
			}
			if(oPrivacyComponent)
			{
				bPrivacyValue					= EBToolbarOptionsPreferenceManager_CT459487.IsShowComponent(oPrivacyComponent);
			}
			if(oWeatherComponent)
			{
				bWeatherValue					= EBToolbarOptionsPreferenceManager_CT459487.IsShowComponent(oWeatherComponent);
			}
			
		
			
			objCheckBoxEMailNotifier.checked	= bEMailNotifierValue;
			
			
			objButtonEMailNotifer.disabled		= !bEMailNotifierValue;
			objCheckBoxPrivacy.checked			= bPrivacyValue;
			objCheckBoxWeather.checked			= bWeatherValue;
			
			//add this components to this dialog comp array:
			this.PreCompArr[strEMailNotifierComponentID]	= bEMailNotifierValue;
			this.PreCompArr[strPrivacyComponentID]			= bPrivacyValue;
			this.PreCompArr[strWeatherComponentID]			= bWeatherValue;
			
			this.FillEditableComponents();
			
			//check if it's from email notifier dialog to disable the notifier elements
			var isFromEMailNotifier = null;
			try
			{
				isFromEMailNotifier = window.arguments[0];
			}
			catch(ex)
			{
				isFromEMailNotifier = null;
			}
			
			if(isFromEMailNotifier)
			{
				objButtonEMailNotifer.disabled		= true;
				objCheckBoxEMailNotifier.disabled	= true;
			}
		}
		else
		{
			this.DisableAll();
		}
		
	},
	
	PreDialogLoad : function()
	{
		//check to remove the third party tab if there is no
		//third party components(meanwhile in linux-mac) case
		if(this.IsNoThirdPartyComponents())
		{
			//remove the third party tab panel
			var oTabThirdPartyComponents = document.getElementById('tabThirdPartyComponents');
			oTabThirdPartyComponents.parentNode.removeChild(oTabThirdPartyComponents);
		}
	},
	
	IsNoThirdPartyComponents : function()
	{
		var oRecentBrowserWindow = EBGlobalManager_CT459487.GetMostRecentBrowserWindow();
	
		var oToolbarComponents = EBToolbarOptionsManager_CT459487.GetToolbarComponents();	
		var oToolbarComponent  = null;
		var iCount	= oToolbarComponents.Count();

		for(var i=0;i<iCount;i++)
		{
			oToolbarComponent = oToolbarComponents.GetByIndex(i);
			if(oToolbarComponent.ComponentItem.CompType == oRecentBrowserWindow.EBComponentsConsts_CT459487.ComponentsType.ThirdParty)
			{
				return false;
			}
		}
		
		return true;
	
	},
	
	DisableAll : function()
	{
		var objCheckBoxEMailNotifier		= document.getElementById('checkEMailNotifier');
		var objButtonEMailNotifer			= document.getElementById('btnEMailNotifier');
		var objCheckBoxPrivacy				= document.getElementById('checkPrivacy');
		var objCheckBoxWeather				= document.getElementById('checkWeather');	
		
		objCheckBoxEMailNotifier.disabled	= true;
		objButtonEMailNotifer.disabled		= true;
		objCheckBoxPrivacy.disabled			= true;
		objCheckBoxWeather.disabled			= true;
	},	
	
	
	OnCheckBoxEMailNotifierChange : function(event)
	{
		var objCheckBoxEMailNotifier		= document.getElementById('checkEMailNotifier');
		var objButtonEMailNotifer			= document.getElementById('btnEMailNotifier');

		var bChecked = objCheckBoxEMailNotifier.checked;
		objButtonEMailNotifer.disabled		= !bChecked;
	},
	
	FillEditableComponents : function()
	{
		var oRecentBrowserWindow = EBGlobalManager_CT459487.GetMostRecentBrowserWindow();
	
		var objSettingsHTMLDiv		= document.getElementById('divSettingsComponents');
		var objThirdPartyHTMLDiv	= document.getElementById('divThirdPartyComponents');
		
		//nullify all first
		while(objSettingsHTMLDiv.childNodes.length > 0)
		{
			objSettingsHTMLDiv.removeChild(objSettingsHTMLDiv.firstChild);
		}
		while(objThirdPartyHTMLDiv.childNodes.length > 0)
		{
			objThirdPartyHTMLDiv.removeChild(objThirdPartyHTMLDiv.firstChild);
		}
		
		
		var objToolbarComponents = EBToolbarOptionsManager_CT459487.GetToolbarComponents();
		
		var objToolbarComponent		= null;
		var iCount	= objToolbarComponents.Count();
		var objHTMLDivToAdd = null;		

		for(var i=0;i<iCount;i++)
		{
			objToolbarComponent = objToolbarComponents.GetByIndex(i);
			if(oRecentBrowserWindow.EBComponentsManager_CT459487.IsEditableComponent(objToolbarComponent))
			{
				if(objToolbarComponent.ComponentItem.CompType == oRecentBrowserWindow.EBComponentsConsts_CT459487.ComponentsType.ThirdParty)
				{
					objHTMLDivToAdd = objThirdPartyHTMLDiv;
				}
				else
				{
					objHTMLDivToAdd = objSettingsHTMLDiv;
				}
				this.AppendEditableComponentRow(objHTMLDivToAdd,objToolbarComponent);
			}
		}
		
	},
	
	OnSelectTabs : function(event)
	{
		var oTabs = event.target;
		var bIsSetFocus = false;
		var arrCheckBox = null;
		if(oTabs.selectedIndex == EBToolbarOptionsDialogConsts_CT459487.PredefinedComponentsTabIndex)
		{
			bIsSetFocus = true;
			arrCheckBox = this.GetArrEditableCheckBox('divSettingsComponents');
			
		}
		else if(oTabs.selectedIndex == EBToolbarOptionsDialogConsts_CT459487.ThirdPartyComponentsTabIndex)
		{
			bIsSetFocus = true;
			arrCheckBox = this.GetArrEditableCheckBox('divThirdPartyComponents');
		}
		
		if(bIsSetFocus)
		{
			if(arrCheckBox && arrCheckBox[0])
			{
				var objFunc = function()
				{
					arrCheckBox[0].focus();
				};
				setTimeout(objFunc,0);
			}
		}
	},
	
	AppendEditableComponentRow : function(objHTMLDiv,objToolbarComponent)
	{
		var strDisplayText	= objToolbarComponent.ComponentItem.DisplayText;
		var strDisplayIcon	= objToolbarComponent.ComponentItem.DisplayIcon;
		var strCompID		= objToolbarComponent.ComponentItem.UniqueCompID;
		var strCheckBoxID	= EBToolbarOptionsDialogConsts_CT459487.EditableCheckBoxPrefixID + strCompID;
		
		var objVBox = document.createElement("vbox");
		objVBox.setAttribute('style','width:99%;');
		
		var objCheckBox = document.createElement("checkbox");
		
		objCheckBox.setAttribute('id',strCheckBoxID);
		objCheckBox.setAttribute('src',strDisplayIcon);
		objCheckBox.setAttribute('label',strDisplayText);

		//save the component id:
		var strAttributeCompIDName = EBToolbarOptionsDialogConsts_CT459487.EditableCheckBoxAttributeCompID;
		objCheckBox.setAttribute(strAttributeCompIDName,strCompID);
		
		
		var isChecked = EBToolbarOptionsPreferenceManager_CT459487.IsShowComponent(objToolbarComponent);
		objCheckBox.setAttribute('checked',isChecked.toString());
		
		objVBox.appendChild(objCheckBox);
		
		var objHTMLBR = document.createElement('html:br');
		
		
		objHTMLDiv.appendChild(objVBox);
		objHTMLDiv.appendChild(objHTMLBR);
		
		//add to the dialog comp array:
		this.PreCompArr[strCompID]	= isChecked;
	},
	
	GetArrEditableCheckBox : function(strHTMLDivID)
	{
		var objHTMLDiv = document.getElementById(strHTMLDivID);
		var arrCheckBox = objHTMLDiv.getElementsByTagName('checkbox');
		
		return arrCheckBox;
	},
	
	OnDialogAccept : function(event)
	{
		//check if the toolbar is not in collapsed mode
		if(this.IsToolbarShown())
		{
			//save in the post comp array:
			this.FillComponents();
			
			if(this.IsComponentsChanged())
			{
				this.AcceptComponents();

				this.BroadcastChanges();
			}
		}
	},
	
	IsComponentsChanged : function()
	{
		//equal between the post and pre array to see if to accept the changes
		var strCompID		= '';
		var bIsCheckedPre	= null;
		var bIsCheckedPost	= null;
		
		for(strCompID in this.PreCompArr)
		{
			bIsCheckedPre	= this.PreCompArr[strCompID];
			bIsCheckedPost	= this.PostCompArr[strCompID];
			if(bIsCheckedPre != bIsCheckedPost)
			{
				return true;
			}
		}
		
		return false;
	},
	
	FillComponents : function()
	{
		this.PostCompArr = new Array();
		
		this.FillPersonalComponents();
		this.FillPredefinedComponents();
	},
	
	FillPersonalComponents : function()
	{
		var oRecentBrowserWindow = EBGlobalManager_CT459487.GetMostRecentBrowserWindow();
		
		var objCheckBoxEMailNotifier	= document.getElementById('checkEMailNotifier');
		var objCheckBoxPrivacy			= document.getElementById('checkPrivacy');
		var objCheckWeather				= document.getElementById('checkWeather');
		
		var strEMailNotifierComponentID = oRecentBrowserWindow.EBComponentsConsts_CT459487.ComponentsID.EMailNotifier;
		var strPrivacyComponentID		= oRecentBrowserWindow.EBComponentsConsts_CT459487.ComponentsID.Privacy;
		var strWeatherComponentID		= oRecentBrowserWindow.EBComponentsConsts_CT459487.ComponentsID.Weather;
		
		
		var bEMailNotifierValue			= objCheckBoxEMailNotifier.checked;
		var bPrivacyValue				= objCheckBoxPrivacy.checked;
		var bWeatherValue				= objCheckWeather.checked;
		
		this.PostCompArr[strEMailNotifierComponentID]	= bEMailNotifierValue;
		this.PostCompArr[strPrivacyComponentID]			= bPrivacyValue;
		this.PostCompArr[strWeatherComponentID]			= bWeatherValue;
	},
	
	FillPredefinedComponents : function()
	{
		var arrCheckBoxSettings		= this.GetArrEditableCheckBox('divSettingsComponents');
		var arrCheckBoxThirdParty	= this.GetArrEditableCheckBox('divThirdPartyComponents');
		
		var objCheckBox			= null;
		var strCompID			= '';
		var bCheckedValue		= true;
		var strAttributeCompIDName = EBToolbarOptionsDialogConsts_CT459487.EditableCheckBoxAttributeCompID;
		
		for(var i=0;i<arrCheckBoxSettings.length;i++)
		{
			objCheckBox		= arrCheckBoxSettings[i];
			bCheckedValue	= objCheckBox.checked;
			strCompID		= objCheckBox.getAttribute(strAttributeCompIDName);
			
			if(strCompID)
			{
				this.PostCompArr[strCompID]	= bCheckedValue;
			}
		}
		
		for(var i=0;i<arrCheckBoxThirdParty.length;i++)
		{
			objCheckBox		= arrCheckBoxThirdParty[i];
			bCheckedValue	= objCheckBox.checked;
			strCompID		= objCheckBox.getAttribute(strAttributeCompIDName);
			
			if(strCompID)
			{
				this.PostCompArr[strCompID]	= bCheckedValue;
			}
		}
		
	},
	
	AcceptComponents : function()
	{
		var strCompID = '';
		var bIsCheked = true;
		
		for(strCompID in this.PostCompArr)
		{
			bIsCheked = this.PostCompArr[strCompID];
			EBToolbarOptionsPreferenceManager_CT459487.SetPref(strCompID,bIsCheked);
		}
	},
	
	OnCommandEMailNotifier : function(event)
	{			
		//get the last browser window active(this is actually it parent
		var objWindow = EBGlobalManager_CT459487.GetMostRecentBrowserWindow();	
		if(objWindow)
		{
			objWindow.EBEMailNotifierDialogsManager_CT459487.OpenSettingsDialog(window,true);
		}
		
	},
	
	//check if the toolbar collapsed or no (shown or no)
	IsToolbarShown : function()
	{
		var objWindow = EBGlobalManager_CT459487.GetMostRecentBrowserWindow();
		return objWindow.EBActionManager_CT459487.IsToolbarShown();
	},
	
	BroadcastChanges : function()
	{
		var objWindowsManager = Components.classes['@mozilla.org/appshell/window-mediator;1']
						.getService(Components.interfaces.nsIWindowMediator);
		
		var objEnumerator = objWindowsManager.getEnumerator('navigator:browser');	
		while(objEnumerator.hasMoreElements()) 
		{
			var objWindow = objEnumerator.getNext();
			
			if(objWindow.EBActionManager_CT459487.ExternalReBuildToolbar)
			{
				try
				{
					objWindow.EBActionManager_CT459487.ExternalReBuildToolbar();
				}
				catch(ex){}
			}
		}
	},
	
	OpenDialog : function(objParentWindow,isFromEMailNotifier)
	{
		//check if the dialog exsits to focus on it
		var oOptionsDialog = this.GetDialog();
		if(oOptionsDialog)
		{
			oOptionsDialog.focus();	
		}
		else
		{
			var strChromePath = EBGlobalConsts_CT459487.ChromeContentPath + EBToolbarOptionsDialogConsts_CT459487.FileName;
		
			objParentWindow.openDialog(strChromePath,
							EBToolbarOptionsDialogConsts_CT459487.DialogName,
							'modal,centerscreen,chrome,resizable=no',
							isFromEMailNotifier);
		}
	},
	
	GetDialog : function()
	{
		var strOptionsDialogType = EBToolbarOptionsDialogConsts_CT459487.DialogType;
		var strOptionsDialogName = EBToolbarOptionsDialogConsts_CT459487.DialogName;
		
		var oOptionsDialog = EBGlobalManager_CT459487.GetXULWindowByTypeAndName(strOptionsDialogType,strOptionsDialogName);
			
		return oOptionsDialog;
	}
}

var EBToolbarOptionsManager_CT459487 = 
{
	GetToolbarComponents : function()
	{
		var objToolbarComponents	= null;
		
		var objRecentBrowserWindow  = EBGlobalManager_CT459487.GetMostRecentBrowserWindow();	
		
		if(objRecentBrowserWindow.EBToolbarData_CT459487.ToolbarComponents)
		{
			objToolbarComponents = objRecentBrowserWindow.EBToolbarData_CT459487.ToolbarComponents;
		}
		
		return objToolbarComponents;
	}
}