
var EBGlobalManager_CT459487 = 
{ 
	NSISound : Components.classes["@mozilla.org/sound;1"].createInstance(Components.interfaces.nsISound),
	
	Initialize : function()
	{
		if(this.NSISound)
		{
			this.NSISound.init();
		}
	},
	
	LegalizeEBXML : function (strXml)
	{
		strXml = strXml.replace(/&amp;/g, '&');
		strXml = strXml.replace(/&apos;/g, '\'');
		
		strXml = strXml.replace(/&/g, "&amp;");
		strXml = strXml.replace(/\'/g, "&apos;");
		
		return strXml;
	},
	
	FromLegalXml : function(strXml)
	{
		strXml = strXml.replace(/&amp;/g, '&');
		strXml = strXml.replace(/&lt;/g, '<');
		strXml = strXml.replace(/&gt;/g, '>');
		strXml = strXml.replace(/&quot;/g, '\"');
		strXml = strXml.replace(/&apos;/g, '\'');
		strXml = strXml.replace(/&#39;/g, '\'');
		strXml = strXml.replace(/&#039;/g, '\'');
		strXml = strXml.replace(/&#33;/g, '!');
		strXml = strXml.replace(/&#033;/g, '!');
		strXml = strXml.replace(/&Uuml;/g, '');
		strXml = strXml.replace(/&#220;/g, '');
		strXml = strXml.replace(/&Ouml;/g, '');
		strXml = strXml.replace(/&#214;/g, '');
		return strXml;
	},
	
	ToLegalXML : function(strXML)
	{
		strXML = strXML.replace(/&/g, '&amp;');
		strXML = strXML.replace(/</g, '&lt;');
		strXML = strXML.replace(/>/g, '&gt;');
		strXML = strXML.replace(/\'/g, '&apos;');
		strXML = strXML.replace(/\"/g, '&quot;');
		
		return strXML;
	},
	
	ToStripHTML : function(strText)
	{
		strText = this.FromLegalXml(strText);
		
		var FLAG_SKIP	= 0;
		var FLAG_WRITE	= 1;
		
		var iFlagState	= FLAG_WRITE;
		var strClean	= '';
		var chr			= '';
		for(var i=0;i<strText.length;i++)
		{
			chr = strText[i];
			if(chr == '<')
			{
				iFlagState = FLAG_SKIP;
			}
			else if(chr == '>')
			{
				iFlagState = FLAG_WRITE;
			}
			else if(iFlagState == FLAG_WRITE)
			{
				strClean += chr;
			}
		}
		
		return strClean;
		
		
	},
	
	LoadURL : function(strURL)
	{
		window._content.document.location = strURL;
		window.content.focus();
	},
	
	LoadURLInNewTab : function(strURL)
	{
		var oNewTab = getBrowser().addTab(strURL);
        getBrowser().selectedTab = oNewTab;
	},
	
	LoadURLInNewWindow : function(strURL)
	{
		window.open(strURL, "EBNewWindow" + new Date().getTime(), 'toolbar=yes,directories=yes,location=yes,menubar=yes,resizable=yes,scrollbars=yes,status=yes');
	},
	
	IsLegalCTID : function(strCTID)
	{
		var oRegTemplate = /^CT\d+$/i;
		return oRegTemplate.test(strCTID);
	},
	
	//cehck validation of url if it starts with http:// or https:// or ftp://
	//and there is characters after it
	IsLegalURL : function(strURL)
	{
		var strRegex = /^(http:\/\/|https:\/\/|ftp:\/\/).+/i;
		return strRegex.test(strURL);
	},
	
	IsDomainExists : function(strDomain)
	{
		var arrDomains = EBGlobalConsts_CT459487.Domains;
		for(var i=0;i<arrDomains.length;i++)
		{
			if(arrDomains[i] == strDomain.toLowerCase())
			{
				return true;
			}
		}
		
		return false;
	},
	
	LegalizeLinkUrl : function (strLinkUrl)
	{
		//convert every "\" to "\\"
		strLinkUrl = strLinkUrl.replace(/\\/g,"\\\\");
		//convert every "'" to "\'"
		strLinkUrl = strLinkUrl.replace(/'/g,"\\'");
		
		//check for bookmarklet:
		strLinkUrl = this.LegalizeBoolmarkletURL(strLinkUrl);
		return strLinkUrl;
	},
	
	LegalizeBoolmarkletURL : function(strURL)
	{
		var strBookmarkletPrefix = EBGlobalConsts_CT459487.BookmarkletPrefix;
		if(this.BeginsWith(strURL,strBookmarkletPrefix))
		{
			strURL = this.FromLegalXml(strURL);
		}
		
		return strURL;
	},
	
	GetBaseUrl : function(strURL)
	{
		//get the protocol in the first cell in the array - 
		//and the url (till the querystring) in the second cell of the array
		var arrMatches = strURL.match(/^(http:\/\/|https:\/\/|ftp:\/\/)?([^\/^\?^:]+)/i);
		var strProtocol = '';
		var strBaseUrl  = '';
		
		if(arrMatches)
		{
			strProtocol = arrMatches[1];
			strBaseUrl	= arrMatches[2];
			
			if(strProtocol)
			{
				strBaseUrl = strProtocol + strBaseUrl;
			}
		}
		
		if(!strBaseUrl)
		{
			strBaseUrl = strURL;
		}
		
		return strBaseUrl;
	},
	
	IsCharWhitespace : function(ch) 
	{
		return/^\s$/.test(ch);
	},
	
	IsCharPunctuation : function(ch) 
	{
		return/[`~!@#$%^&\*()-+={}\[\]|\\:;\"<>,\.\?\/]/.test(ch);
	},
	
	IsValidEMail : function(strEMail)
	{
		return 	/^([0-9a-zA-Z]([-.\w_])*@([0-9a-zA-Z][-\w]*[0-9a-zA-Z]\.)+[a-zA-Z]{2,9})$/.test(strEMail);
	},

	IsWordCharacter : function(ch) 
	{
		if(ch == null || (typeof ch != "string" || ch.length != 1)) 
		{
			return false;
		}
		var code = ch.charCodeAt(0);
		return code >= 48 && code <= 57 || (code >= 65 && code <= 90 || (code >= 97 && code <= 122 || (code >= 138 && code <= 142 || (code >= 154 && code <= 159 || code >= 192 && code <= 255))))
	},

	BeginsWith : function(str, pref) 
	{
		return str.substring(0, pref.length).toUpperCase() == pref.toUpperCase();
	},
	
	EndsWith : function(str, pref)
	{
		var iIndex = str.length - pref.length;
		return str.substring(iIndex).toLowerCase() == pref.toLowerCase();
	},
	
	TotalTrim : function(str)
	{
		str = str.replace(/\s/g,'');
		return str;
	},
	
	TrimToOne : function(str) 
	{
		 // Return empty if nothing was passed in
		if (!str) return "";
	    
		str = this.Trim(str);
	    
		// Replace any multiple whitespace characters with a single space
		str = str.replace(/\s+/g, ' ');
	    
		// Return the altered string
		return str;
	},
	
	Trim : function(str)
	{
		if (!str) return "";
		str = str.replace(/^\s+/, '');
		str = str.replace(/\s+$/, '');
		
		return str;
	},
	
	IsPathExists : function(strPath)
	{
		var bExists = false;
		
		try
		{
			var oFile = Components.classes["@mozilla.org/file/local;1"]
									.createInstance(Components.interfaces.nsILocalFile);                 
			oFile.initWithPath(strPath);
	
			bExists = oFile.exists();
		}
		catch(ex)
		{
			bExists = false;
		}
		
		return bExists;
	},
	
	OpenApplication : function(strAppPath)
	{
		var bSuccess = false;
		try 
		{
			var oFile = Components.classes["@mozilla.org/file/local;1"]
									.createInstance(Components.interfaces.nsILocalFile);
		                            
			oFile.initWithPath(strAppPath);
		
			if(oFile.exists())
			{
				// create an nsIProcess
				var oProcess = Components.classes["@mozilla.org/process/util;1"]
									.createInstance(Components.interfaces.nsIProcess);
		                            
				oProcess.init(oFile);
		
				// Run the process.
				// If first param is true, calling process will be blocked until
				// called process terminates. 
				// Second and third params are used to pass command-line arguments
				// to the process.
				oProcess.run(false, null, 0);
				bSuccess = true;
			}
		}
		catch(ex)
		{
			bSuccess = false;
		}
		
		return bSuccess;
		
	},
	
	GetWindowsMediaPath : function()
    {
		var strWindowsMediaPath = '';
		try
		{
			strWindowsMediaPath = EBRegistryManager_CT459487.GetRegistryEntry(EBRegistryManager_CT459487.HKEY_LOCAL_MACHINE,
														'SOFTWARE\\Microsoft\\Windows\\CurrentVersion',
														'MediaPath');
		}
		catch(ex)
		{
			strWindowsMediaPath = '';
		}
		
		return strWindowsMediaPath;
    },
    
    GetEnvironmentArg : function(strAlias)
    {
		var oEnvironment = Components.classes["@mozilla.org/process/environment;1"]
									.getService(Components.interfaces.nsIEnvironment);
		var strArg = oEnvironment.get(strAlias);
		
		return strArg;
    },
    
    ConvertWindowsSpecialPath : function(strPath)
    {
		//get the system special path
		var strWindowsSystemRoot   = this.GetEnvironmentArg('SYSTEMROOT');
		var strWindowsProgramFiles = this.GetEnvironmentArg('PROGRAMFILES');
		
		//clear first all "
		strPath = strPath.replace(/\"/g,'');
		//convert system root path
		strPath = strPath.replace(/%SystemRoot%/gi,strWindowsSystemRoot);
		//convert program files path
		strPath = strPath.replace(/%ProgramFiles%/gi,strWindowsProgramFiles);
		
		//add another system specail alias path here...
		
		return 	strPath;
    },
    
    GetWindowsEnvironmentArrayPath : function()
    {	
		var strPaths = this.GetEnvironmentArg('PATH');
		var arrPath = strPaths.split(';');
		return arrPath;
    },
    
    //shell execute of windows - try to load/check application 
    //from the registry first and then from the system path array
    //bIsExecute - if true try to load application - else - check if this application exists
    WindowsShellExecute : function(strAppExeName,bIsExecute)
    {
		var bSuccess = false;
		if(this.IsWindowsPlatform())
		{
			var strAppFullPath		= '';	
			try
			{
				//first try from registry
				var strAppRegKeyPath	= EBGlobalConsts_CT459487.RegistryShellExecutePath + strAppExeName;
				//load the default key name:
				strAppFullPath = EBRegistryManager_CT459487.GetRegistryEntry(EBRegistryManager_CT459487.HKEY_LOCAL_MACHINE,
															strAppRegKeyPath,
															'');
															
				strAppFullPath	= this.ConvertWindowsSpecialPath(strAppFullPath);
				if(bIsExecute)
				{
					bSuccess = this.OpenApplication(strAppFullPath);		
				}
				else
				{
					bSuccess = this.IsPathExists(strAppFullPath);
				}
			}
			catch(ex)
			{
				bSuccess = false;
			}
			
			try
			{
				//second try from system path
				if(!bSuccess)
				{	
					var arrPath = this.GetWindowsEnvironmentArrayPath();
					for(var i=0;i<arrPath.length;i++)
					{
						strAppFullPath = arrPath[i] + EBDirIO_CT459487.sep + strAppExeName;
						if(bIsExecute)
						{
							bSuccess = this.OpenApplication(strAppFullPath);
						}
						else
						{
							bSuccess = this.IsPathExists(strAppFullPath);
						}
						if(bSuccess)
						{
							break;
						}
					}
				}
			}
			catch(ex)
			{
				bSuccess = false;
			}
		}
		
		return bSuccess;
    },
    
    
	PlaySound : function(strAudioFilePath)
	{
		try
		{
			var objURI			= null;
			var objIOService	= Components.classes["@mozilla.org/network/io-service;1"].createInstance(Components.interfaces.nsIIOService);
			var objFile			= EBFileIO_CT459487.open(strAudioFilePath);
			if(objFile)
			{
				objURI = objIOService.newFileURI(objFile);
			}
			else
			{
				objURI = objIOService.newURI(strAudioFilePath, null, null);
			}
			this.NSISound.play(objURI);
		}
		catch(ex)
		{
			
		}
		
	},
	
	
	ToLegalFileName : function(strText)
	{
		strText = strText.replace(/\.|\\|\/|\:|\*|\?|\&amp\;|\&|\"|\<|\>|\|/g,'_');
		return strText;
	},
	

	GetXmlDocument	: function(strXml)
	{
		var parser = new DOMParser();
		return  parser.parseFromString(strXml, "text/xml");
	},
	
	GetStringXml : function(xmlNode)
	{
		var serializer = new XMLSerializer();
		return serializer.serializeToString(xmlNode);
	},
	
	CreateXmlTextNode : function(xmlDoc,strTagName,strValue)
	{
		var XML_NODE = xmlDoc.createElement(strTagName);
		var XML_VALUE = this.CreateXmlTextValue(xmlDoc,strValue);
		XML_NODE.appendChild(XML_VALUE);
		return XML_NODE;
	},
	
	CreateXmlTextValue : function(xmlDoc,strValue)
	{
		var XML_VALUE = xmlDoc.createTextNode(strValue);
		return XML_VALUE;
	},
	
	GetXmlNodeValue : function(xmlNode)
	{

		var iTextNodeType = Components.interfaces.nsIDOMNode.TEXT_NODE;
		var iCDataNodeType = Components.interfaces.nsIDOMNode.CDATA_SECTION_NODE;
		if(xmlNode.childNodes.length == 1 && 
		(xmlNode.childNodes[0].nodeType == iTextNodeType
		|| xmlNode.childNodes[0].nodeType == iCDataNodeType) )
		{
			return xmlNode.childNodes[0].nodeValue;
		}
		return "";
	},
	
	Alert : function(objWindow,strTitle,strMsg)
	{
		var objPromptService = Components.classes["@mozilla.org/embedcomp/prompt-service;1"]
							.getService(Components.interfaces.nsIPromptService);

		objPromptService.alert(objWindow,strTitle,strMsg);
	},
	
	//setup mime stream for post calling using the built-in loadURI function
	SetupMimeStream : function(strPostData)
	{
		var objInputStream = Components.classes["@mozilla.org/io/string-input-stream;1"].createInstance(Components.interfaces.nsIStringInputStream);
		objInputStream.setData(strPostData, strPostData.length);
	    
		var objMimeStream = Components.classes["@mozilla.org/network/mime-input-stream;1"].createInstance(Components.interfaces.nsIMIMEInputStream);
		objMimeStream.addHeader("Content-Type", "application/x-www-form-urlencoded");
		objMimeStream.addHeader("Content-Length", strPostData.length);
		objMimeStream.setData(objInputStream);
	    
		return objMimeStream;
	},
	
	NavigationWithCallBack : function(strURLNavigation,objCallBackFunction)
	{
		var objServerResponseFunction = function(strData,objRequest)
		{
			objCallBackFunction();
		};
	
		EBServerDataURL_CT459487.ServerRequest(strURLNavigation,
													null,
													null,
													null,
													objServerResponseFunction);
	},
	
	OpenDefaultMailClient : function()
	{
		var objShell = getShellService();
		if(objShell)
		{
			var iAppToOpen = Components.interfaces.nsIShellService.APPLICATION_MAIL;
			if(objShell.openApplication)
			{
				objShell.openApplication(iAppToOpen);
			}
			else if(objShell.openPreferredApplication)
			{
				objShell.openPreferredApplication(iAppToOpen);
			}
		}
	},
	
	GetEndOfLine : function() 
	{
		return '\r\n';
    },
    
    GetBrowserName : function()
    {
		var strBrowserName = '';
		
		if("@mozilla.org/windows-registry-key;1" in Components.classes) //1.5
		{
			var objXULApp	= Components.classes["@mozilla.org/xre/app-info;1"].getService(Components.interfaces.nsIXULAppInfo);
			strBrowserName	= objXULApp.name;
		}
		else //1.0.x
		{
			strBrowserName = navigator.vendor;
		}
		
		return strBrowserName;
    },
    
    GetBrowserVersion : function()
    {
		var strBrowserVersion = '';
		if("@mozilla.org/windows-registry-key;1" in Components.classes) //1.5
		{
			var objXULApp	= Components.classes["@mozilla.org/xre/app-info;1"].getService(Components.interfaces.nsIXULAppInfo);
			strBrowserVersion	= objXULApp.version;
		}
		else //1.0.x
		{
			strBrowserVersion = navigator.vendorSub;
		}
		
		return strBrowserVersion;
    },
    
    IsFirefoxBrowser : function()
    {
		var strBrowserName = this.GetBrowserName();
		return strBrowserName.toLowerCase() == 'firefox';
    },
    
    IsNewestBrowserAPI : function()
    {
		return this.GetBrowserVersion() >= '1.5' || !this.IsFirefoxBrowser();
    },
    
    GetMostRecentBrowserWindow : function()
    {
		var objWindowsManager = Components.classes['@mozilla.org/appshell/window-mediator;1']
						.getService(Components.interfaces.nsIWindowMediator);
		
		//get the last browser window active(this is actually it parent
		var objRecentBrowserWindow = objWindowsManager.getMostRecentWindow('navigator:browser');	
		
		return 	objRecentBrowserWindow;
    },
    
    GetXULWindowByTypeAndName : function(strWindowType,strWindowName)
    {
		var oWindowsManager = Components.classes["@mozilla.org/appshell/window-mediator;1"]
						.getService(Components.interfaces.nsIWindowMediator);
		
		var oEnumerator = oWindowsManager.getEnumerator(strWindowType);	
		while(oEnumerator.hasMoreElements()) 
		{
			var oWindow = oEnumerator.getNext();
			if(oWindow.name == strWindowName)
			{
				return oWindow;
			}
		}
		
		return null;		
    },
    
    GetWebPageJavascriptObject : function(oContentWindow)
    {
		var oJavascript = oContentWindow.wrappedJSObject ? oContentWindow.wrappedJSObject : oContentWindow;
		return oJavascript;
    },
    
    IsWindowsPlatform : function()
    {
		var strPlatform = navigator.platform.toLowerCase();
		return strPlatform.indexOf('win') != -1 ? true : false;
    },
    
    IsLinuxPlatform : function()
    {
		var strPlatform = navigator.platform.toLowerCase();
		return strPlatform.indexOf('linux') != -1 ? true : false;	
    },
    
    IsMacintoshPlatform : function()
    {
		var strPlatform = navigator.platform.toLowerCase();
		return strPlatform.indexOf('mac') != -1 ? true : false;
    },
    
    IsInArray : function(arr,strText)
    {
		for(var i=0;i<arr.length;i++)
		{
			if(arr[i] == strText)
			{
				return i;
			}
		}
		
		return -1;
    },	
    
    //get the index of a dom element referring to it's parent
    GetDOMElementIndex : function(objDOMElement)
    {
		var objDOMParentElement = 	objDOMElement.parentNode;
		if(objDOMParentElement)
		{
			for(var i=0;i<objDOMParentElement.childNodes.length;i++)
			{
				if(objDOMParentElement.childNodes[i] == objDOMElement)
				{
					return i;
				}
			}
		}
		
		return -1;
    },
    
    GenerateRandomNumber : function()
    {
		var iNum = Math.ceil(Math.random()*10000000000000);	
		
		return iNum;
    },
    
    IsElementInScreenCoordinates : function(objElement)
    {
		var iElementX		= objElement.boxObject.screenX;
		var iElementY		= objElement.boxObject.screenY;
		var iElementWidth	= objElement.boxObject.width;
		var iElementHeight	= objElement.boxObject.height;

	
		//get the global screen coordinates
		var iScreenX		= EBGlobalVariables_CT459487.ScreenCoordinateX;
		var iScreenY		= EBGlobalVariables_CT459487.ScreenCoordinateY;
		
		if(iScreenX >= iElementX &&
			iScreenX <= (iElementX + iElementWidth) &&
			iScreenY >= iElementY &&
			iScreenY <= (iElementY + iElementHeight))
		{
			return true;
		}
		else
		{
			return false;
		}
    },
    
    HTTPServerRequest : function(strURL,strPostParams,bIsResponseXML,oCallBackFunction)
    {
		var oResponseData	= null;
		var strNetworkError = EBGlobalConsts_CT459487.NetworkError;
		var oRequest		= new XMLHttpRequest();
		var strMethod		= strPostParams ? 'POST' : 'GET';
		
		oRequest.open(strMethod, strURL, true);
		
		oRequest.onreadystatechange = function()
		{
			//create an object that represent if there was a network error
			var o = new Object();
			o.value = '';
			var bComplete = false;
			try
			{
  				if(oRequest.readyState == 4 && oRequest.status == 200)
  				{
  					bComplete = true;
  					if(bIsResponseXML)
  					{
	  					oResponseData = oRequest.responseXML;
	  				}
	  				else
	  				{
	  					oResponseData = oRequest.responseText;
	  				}
 	 			}
 	 		}
 	 		catch(ex)
 	 		{	
 	 			oResponseData	= null;
 	 			o.value			= strNetworkError;
 	 			bComplete		= true;
 	 		}
 	 		
 	 		if(bComplete)
 	 		{
 	 			if(oCallBackFunction)
 	 			{
 	 				oCallBackFunction(oResponseData,o);
 	 			}
 	 		}
 		};
 		
 		oRequest.setRequestHeader('PRAGMA','NO-CACHE');
		oRequest.setRequestHeader('CACHE-CONTROL','NO-CACHE');
 		
 		if(strPostParams)
 		{
 			oRequest.setRequestHeader('Content-Type','application/x-www-form-urlencoded');
 		}
		oRequest.send(strPostParams);
		
		//return the request object
		return oRequest;
    }
	
}


/*********************************************************/
/*     this TEAencrypt code taken from					 */
/* http://www.movable-type.co.uk/scripts/TEAblock.html   */
/*********************************************************/
var EBTEAEncryptionManager_CT459487 = 
{
	TEAencrypt : function(plaintext, password)
	{
		 if (plaintext.length == 0) return('');  // nothing to encrypt
		// 'escape' plaintext so chars outside ISO-8859-1 work in single-byte packing, but  
		// keep spaces as spaces (not '%20') so encrypted text doesn't grow too long, and 
		// convert result to longs
		var v = this.strToLongs(escape(plaintext).replace(/%20/g,' '));
		if (v.length == 1) v[1] = 0;  // algorithm doesn't work for n<2 so fudge by adding nulls
		var k = this.strToLongs(password.slice(0,16));  // simply convert first 16 chars of password as key
		var n = v.length;

		var z = v[n-1], y = v[0], delta = 0x9E3779B9;
		var mx,p, e, q = Math.floor(6 + 52/n), sum = 0;
		
		var kp3e;
		
		while (q-- > 0) {  // 6 + 52/n operations gives between 6 & 32 mixes on each word
			sum += delta;
			e = sum>>>2 & 3;
			for (p = 0; p < n-1; p++) {
				y = v[p+1];
				kp3e = k[p&3 ^ e];
				if(!kp3e)
				{
					kp3e = 0;
				}
				mx = (z>>>5 ^ y<<2) + (y>>>3 ^ z<<4) ^ (sum^y) + (kp3e ^ z);
				z = v[p] += mx;
			}
			y = v[0];
			kp3e = k[p&3 ^ e];
			if(!kp3e)
			{
				kp3e = 0;
			}
			mx = (z>>>5 ^ y<<2) + (y>>>3 ^ z<<4) ^ (sum^y) + (kp3e ^ z);
			z = v[n-1] += mx;
		}
		// note use of >>> in place of >> due to lack of 'unsigned' type in JavaScript 

		var ciphertext = this.longsToStr(v);

		return this.escCtrlCh(ciphertext);	
	},
	
	TEAdecrypt : function(ciphertext, password)
	{
		if (ciphertext.length == 0) return('');
		var v = this.strToLongs(this.unescCtrlCh(ciphertext));
		var k = this.strToLongs(password.slice(0,16)); 
		var n = v.length;

		var z = v[n-1], y = v[0], delta = 0x9E3779B9;
		var mx,p, e, q = Math.floor(6 + 52/n), sum = q*delta;
		
		var kp3e;
		
		while (sum != 0) {
			e = sum>>>2 & 3;
			for (p = n-1; p > 0; p--) {
				z = v[p-1];
				kp3e = k[p&3 ^ e];
				if(!kp3e)
				{
					kp3e = 0;
				}
				mx = (z>>>5 ^ y<<2) + (y>>>3 ^ z<<4) ^ (sum^y) + (kp3e ^ z);
				y = v[p] -= mx;
			}
			z = v[n-1];
			kp3e = k[p&3 ^ e];
			if(!kp3e)
			{
				kp3e = 0;
			}
			mx = (z>>>5 ^ y<<2) + (y>>>3 ^ z<<4) ^ (sum^y) + (kp3e ^ z);
			y = v[0] -= mx;
			sum -= delta;
		}

		var plaintext = this.longsToStr(v);

		// strip trailing null chars resulting from filling 4-char blocks:
		plaintext = plaintext.replace(/0+$/,'');

		return unescape(plaintext);	
	},
	
	strToLongs : function(s)
	{
		// convert string to array of longs, each containing 4 chars
		// note chars must be within ISO-8859-1 (with Unicode code-point < 256) to fit 4/long
		var l = new Array(Math.ceil(s.length/4));
		for (var i=0; i<l.length; i++) {
			// note little-endian encoding - endianness is irrelevant as long as 
			// it is the same in this.longsToStr() 
			l[i] = s.charCodeAt(i*4) + (s.charCodeAt(i*4+1)<<8) + 
				(s.charCodeAt(i*4+2)<<16) + (s.charCodeAt(i*4+3)<<24);
		}
		return l;  // note running off the end of the string generates nulls since 
				// bitwise operators treat NaN as 0
	},
	
	longsToStr : function(l)
	{
		// convert array of longs back to string
		var a = new Array(l.length);
		for (var i=0; i<l.length; i++) {
			a[i] = String.fromCharCode(l[i] & 0xFF, l[i]>>>8 & 0xFF, 
									l[i]>>>16 & 0xFF, l[i]>>>24 & 0xFF);
		}
		return a.join('');  // use Array.join() rather than repeated string appends for efficiency	
	},
	
	escCtrlCh : function(str)
	{
		// escape control chars which might cause problems with encrypted texts
		return str.replace(/[\0\t\n\v\f\r\xa0!]/g, function(c) { return '!' + c.charCodeAt(0) + '!'; });
	},
	
	unescCtrlCh : function(str)
	{
		// unescape potentially problematic nulls and control characters
		return str.replace(/!\d\d?\d?!/g, function(c) { return String.fromCharCode(c.slice(1,-1)); });
	}
}





//class call url with response anonymous function
//the request as oppose to the xmlhttprequest object is set backstage(it's not like an actual navigation - its more low level)
var EBServerDataURL_CT459487 = 
{
	ServerRequest : function(strURL,strPostData,strUserName,strPassword,ServerResponseFunction)
	{
		var objIOService	= Components.classes["@mozilla.org/network/io-service;1"].createInstance(Components.interfaces.nsIIOService);
		var objURI			= objIOService.newURI(strURL, null, null);
		
		if(strUserName != null && strPassword != null)
		{
			objURI.username		= strUserName;
			objURI.password		= strPassword;
		}
	    
		var objChannel		= objIOService.newChannelFromURI(objURI);
		
		objChannel.QueryInterface(Components.interfaces.nsIHttpChannel).setRequestHeader('PRAGMA','NO-CACHE',false);
		objChannel.QueryInterface(Components.interfaces.nsIHttpChannel).setRequestHeader('CACHE-CONTROL','NO-CACHE',false);

	    
		if(strPostData != null) 
		{
			var objUploadStream		= Components.classes["@mozilla.org/io/string-input-stream;1"].createInstance(Components.interfaces.nsIStringInputStream);
			objUploadStream.setData(strPostData, strPostData.length);
		      
			var objUploadChannel	= objChannel.QueryInterface(Components.interfaces.nsIUploadChannel);
			objUploadChannel.setUploadStream(objUploadStream, "application/x-www-form-urlencoded", -1);
		      
			objChannel.QueryInterface(Components.interfaces.nsIHttpChannel).requestMethod = "POST";
			
			
		}
		
		
		
		
	    var objObserver = new this.Observer(ServerResponseFunction);
		objChannel.asyncOpen(objObserver, null);
	},
	
	Observer: function(ServerResponseFunction)
	{
		return ({
					Data : "",
				    
					onStartRequest: function(aRequest, aContext)
					{
						this.Data = "";
					},
				    
					onStopRequest: function(aRequest, aContext, aStatus)
					{
						if(ServerResponseFunction)
						{
							ServerResponseFunction(this.Data, aRequest);
						}
					},
					    
					onDataAvailable: function(aRequest, aContext, aStream, aSourceOffset, aLength)
					{
						var objScriptableInputStream = Components.classes["@mozilla.org/scriptableinputstream;1"].createInstance(Components.interfaces.nsIScriptableInputStream);
						objScriptableInputStream.init(aStream);
						this.Data += objScriptableInputStream.read(aLength);
					}
				});
	}
}



//object represent collection holding hash and index array
//example use - the toolbar components
function EBArrayHashObject_CT459487()
{
	this.IndexerArray	= null;
	this.HashArray		= null;
	
	this.Init = function()
	{
		this.IndexerArray	= new Array();
		this.HashArray		= new Array();
	};
	
	this.Add = function(strKeyID,objValue)
	{
		//check if already exists
		if(!this.Contains(strKeyID))
		{
			strKeyID = this.LegalizeHashKey(strKeyID);
			
			//add to the indexers array to the last place
			this.IndexerArray[this.IndexerArray.length] = objValue;
			
			//add to the hash array per component id
			this.HashArray[strKeyID]					= objValue;
		}
	};
	
	this.Insert = function(iIndex,strKeyID,objValue)
	{	
		if(!this.Contains(strKeyID))
		{
			strKeyID = this.LegalizeHashKey(strKeyID);
			
			//add to the indexers array to the iIndex place
			this.IndexerArray.splice(iIndex,0,objValue);
			
			//add to the hash array per component id
			this.HashArray[strKeyID]		= objValue;
		}
	};
	
	this.Remove = function(iIndex,strKeyID)
	{
		if(this.Contains(strKeyID))
		{
			strKeyID = this.LegalizeHashKey(strKeyID);
			
			//remove from indexer array
			this.IndexerArray.splice(iIndex,1);
			
			//remove from hash
			delete this.HashArray[strKeyID];
		}
		
	};
	
	this.GetByIndex = function(iIndex)
	{
		var objValue = this.IndexerArray[iIndex];
		return objValue;
	};
	
	this.GetByID = function(strKeyID)
	{
		strKeyID = this.LegalizeHashKey(strKeyID);
		
		var objValue = this.HashArray[strKeyID];
		return objValue;
	};
	
	this.GetIndexByObjectValue = function(oValue)
	{
		for(var i=0;i<this.IndexerArray.length;i++)
		{
			if(this.GetByIndex(i) == oValue)
			{
				return i;
			}
		}
		
		return -1;
	};
	
	this.Contains = function(strKeyID)
	{
		var objValue = this.GetByID(strKeyID);
		return objValue ? true : false;
	};
	
	this.Count = function()
	{
		return this.IndexerArray.length;
	};
	
	this.LegalizeHashKey = function(strKeyID)
	{
		strKeyID = strKeyID.toString();
		strKeyID = strKeyID.toUpperCase();
		
		return strKeyID;	
	};
	
	this.Clear = function()
	{
		this.Init();
	};
	
	this.Init();
}


//global array collection object
function EBArrayCollection_CT459487()
{
	this.Arr = null;
	
	this.Init = function()
	{
		this.Arr = new Array();
	};
	
	this.AppendElement = function(objElement)
	{
		this.Arr[this.Arr.length] = objElement;
	};
	
	this.InsertElement = function(iIndex,objElement)
	{
		this.Arr.splice(iIndex,0,objElement);
	};
	
	this.RemoveElement = function(iIndex)
	{
		this.Arr.splice(iIndex,1);	
	};
	
	this.GetItem = function(iIndex)
	{
		var oItem = null;
		if(this.Arr[iIndex])
		{
			oItem = this.Arr[iIndex];
		}
		return oItem;	
	};

	
	this.Clear = function()
	{
		this.Init();	
	};
	
	
	
	this.Init();
}




//registry manager:
var EBRegistryManager_CT459487 = 
{
	HKEY_CLASSES_ROOT: 0,
	HKEY_CURRENT_CONFIG: 1,
	HKEY_CURRENT_USER: 2,
	HKEY_LOCAL_MACHINE: 3,
	HKEY_USERS: 4,
	
	GetRegistryEntry: function (regRoot, regPath, regName)
    {
		if("@mozilla.org/windows-registry-key;1" in Components.classes)
		{
			// This works in Firefox 1.5
			var nsIWindowsRegKey = Components.classes["@mozilla.org/windows-registry-key;1"].getService(Components.interfaces.nsIWindowsRegKey);
			var regRootKey = new Array(0x80000000, 0x80000005, 0x80000001, 0x80000002, 0x80000003);
			nsIWindowsRegKey.open(regRootKey[regRoot], regPath, Components.interfaces.nsIWindowsRegKey.ACCESS_READ);
        
			if(nsIWindowsRegKey.valueCount)
			{
				return nsIWindowsRegKey.readStringValue(regName);
			}
		}
		else if("@mozilla.org/browser/shell-service;1" in Components.classes) 
		{
				// This works in Firefox 1.0.x
				var nsIWindowsShellService = Components.classes["@mozilla.org/browser/shell-service;1"].getService(Components.interfaces.nsIWindowsShellService);
			
				if(nsIWindowsShellService.getRegistryEntry)
				{
					return nsIWindowsShellService.getRegistryEntry(regRoot, regPath, regName);
				}
		}
		else if("@mozilla.org/winhooks;1" in Components.classes) 
		{
				// This works in Mozilla 1.7.x
				var nsIWindowsRegistry = Components.classes["@mozilla.org/winhooks;1"].getService(Components.interfaces.nsIWindowsRegistry);
				if(nsIWindowsRegistry.getRegistryEntry)
				{
					return nsIWindowsRegistry.getRegistryEntry(regRoot, regPath, regName);
				}
		}
		
		return null;
    }
    
    
}
/**************************** global vars & constants ******************************/

var EBGlobalVariables_CT459487 = 
{
	ScreenCoordinateX : 0,
	
	ScreenCoordinateY : 0,
	
	MainFrameURL	  : ''
}



var EBGlobalConsts_CT459487 = 
{
	ToolbarId					: 'folkoteka.com',
	
	ToolbarName					: 'FolkoTeka.com',
	
	ToolbarCTID					: 'CT459487',
	
	GUID						: '{c73d73c9-1e15-4c7a-ab94-13e02d34fbde}',
	
	ToolbarVersion				: '1.0.1.25',

	ShowUninstallPage			: 'TRUE',
	
	ChromeContentPath			: 'chrome://folkoteka.com/content/',
	
	ChromeSkinPath				: 'chrome://folkoteka.com/skin/',

	Delimiter					: '||',
	
	DefaultCharset				: 'UTF-8',
	
	Domains						: ['info','biz','name','pro','museum','coop','aero','edu','gov','com','net','tv','fm','us','cc','jobs','ws','ad','ae','af','ao','aq','ar','at','au','bb','be','bg','br','ca','ch','ck','cl','cn','co','cs','cy','de','dk','dz','ec','eg','es','fi','fj','fr','gb','gl','gov','gr','hk','hr','hu','id','ie','il','in','iq','is','it','jm','jp','lb','lu','lv','ly','ma','mc','mil','mk','mo','mr','mn','mt','mu','mx','my','nc','net','nf','nl','no','np','nz','org','pa','pe','pg','ph','pk','pl','pt','ro','sa','sb','se','sg','su','td','th','to','tw','uk','us','va','vg','za','zm'],
	
	HTTP_PREFIX					: 'http://',
	
	FTP_PREFIX					: 'ftp://',
	
	BookmarkletPrefix			: 'javascript:',
	
	NetworkError				: 'EB_NETWORK_ERROR',
	
	DegreeSymbol				: '\u00BA',
	
	RegistryShellExecutePath	: 'SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\App Paths\\',
	
	ToolbarHorizontalDialogGap	: 10,
	
	ToolbarVerticalDialogGap	: 40,
	
	Attributes :
	{
		XULLabel		: 'EB_XUL_LABEL',
		XULImage		: 'EB_XUL_IMAGE',
		XULElementIndex : 'EB_XUL_ELEMENT_INDEX',
		XULTooltip		: 'EB_XUL_TOOLTIP'
		
	},
	
	Aliases :
	{
		MainFrameURL	: 'EB_MAIN_FRAME_URL',
		//ctid
		ToolbarID		: 'EB_TOOLBAR_ID',
		
		UserID			: 'EB_USER_ID',
		
		SearchTerm		: 'EB_SEARCH_TERM'
	}
}




