/********************************************/
/*		Copyright 2006 Conduit Ltd.			*/
/*           All Rights Reserved.           */
/********************************************/

//global functions related to the toolbar
var EBActionManager_CT459487 = 
{

	IsToolbarShrink : function()
	{
		//0 - shrink mode
		//1 - unshrink mode 
		//should be the opposite - i know :-S (all eyal?)
		
		var iPrefState	= EBToolbarPreferenceManager_CT459487.GetPref(EBPreferenceConsts_CT459487.ToolbarShrink);
		
		return iPrefState == 0 ? true : false;
		
	},

	ConvertAliasesUrl : function(strUrl,isWithoutSearchTerm)
	{
		var strCurrentUrl	= EBGlobalVariables_CT459487.MainFrameURL;
		var strToolbarCTID	= this.GetCTID();
		var strUserID		= EBToolbarPreferenceManager_CT459487.GetPref(EBPreferenceConsts_CT459487.UserID);
		
		if(strUserID == null)
		{
			strUserID = "";
		}
		
		//replace the aliases
		strUrl = strUrl.replace(EBGlobalConsts_CT459487.Aliases.MainFrameURL,strCurrentUrl);
		strUrl = strUrl.replace(EBGlobalConsts_CT459487.Aliases.ToolbarID,strToolbarCTID);
		strUrl = strUrl.replace(EBGlobalConsts_CT459487.Aliases.UserID,strUserID);
		
		return strUrl;
	},
	
	SetToolbarSearchTerm : function(strSearchTerm)
	{
		var XULSearchBox = 	EBComponentsManager_CT459487.GetSearchBoxMenuList();
		if(XULSearchBox && strSearchTerm && strSearchTerm != XULSearchBox.value)
		{
			XULSearchBox.value = strSearchTerm;
			this.SearchTermChanged();
			
			//call the chevron after setting the value cause the toolbar may be longer
			//set it with second interval to give the toolbar time update itself
			setTimeout(function(){EBChevronManager_CT459487.SetChevron(null);},1000);
		}
	},
	
	IsToolbarRTL : function()
	{
		var xulToolbarElement	= EBToolbarData_CT459487.ToolbarInstance;
		var strToolbarDirection = document.defaultView.getComputedStyle(xulToolbarElement, null).getPropertyValue("direction");
		return strToolbarDirection == 'rtl' ? true : false;
	},
	
	IsToolbarGeneric : function()
	{
		var strToolbarType = EBToolbarPreferenceManager_CT459487.GetPref(EBPreferenceConsts_CT459487.ToolbarType);
		return strToolbarType == 'generic' ? true : false;
	},
	
	IsToolbarShown : function()
	{
		var bRetVal = false;
		var oToolbar = EBToolbarData_CT459487.ToolbarInstance;
		if(oToolbar)
		{
			var strCollapsed =  oToolbar.getAttribute('collapsed');
			//check that the toolbar is not hidden
			if(!strCollapsed || strCollapsed.toLowerCase() != 'true')
			{
				bRetVal = true;
			}
		}
		return bRetVal;
	},
	
	GetToolbarChevron : function()
	{
		var strChevronID	= EBChevronManager_CT459487.GetToolbarChveronID();
		var oChevron		= document.getElementById(strChevronID);
		
		return oChevron;
	},
	
	GetWebServerURL : function()
	{
		var strGeneralInfoWebServerURL = EBToolbarData_CT459487.GeneralToolbarInfo.WebServerURL;
		return 	strGeneralInfoWebServerURL == '' ? EBToolbarData_CT459487.DefaultWebServerURL : strGeneralInfoWebServerURL;
	},
	
	GetMyWebServerURL : function()
	{
		var strGeneralInfoMyWebServerURL = EBToolbarData_CT459487.GeneralToolbarInfo.MyWebServerURL;
		return 	strGeneralInfoMyWebServerURL == '' ? EBToolbarData_CT459487.DefaultMyWebServerURL : strGeneralInfoMyWebServerURL;
	},
	
	//get ctid from the prefs and if there isn't so from the hard-coded(means it's the original toolbar)
	GetCTID : function()
	{
		var strCTID = EBToolbarPreferenceManager_CT459487.GetPref(EBPreferenceConsts_CT459487.CTID);    
		strCTID = strCTID ? strCTID : EBGlobalConsts_CT459487.ToolbarCTID;
		
		return strCTID;
	},
	
	ExternalReBuildToolbar : function()
	{
		//due to a bug in Firefox 1.0.* we call to each BuildToolbar with a timeout
		//(like in shrink toolbar and accept toolbar options)
		var objTimeoutFunction = function()
		{
			try
			{
				EBToolbarBuilder_CT459487.BuildToolbar(false);
			}
			catch(ex){}
		}
		setTimeout(objTimeoutFunction,1);
	},
	
	//set the main frame url from the global webProgressListener
	SetMainFrameURL : function(strURL)
	{
		EBGlobalVariables_CT459487.MainFrameURL = strURL;
		//set the main frame url for the browser component api
		EBBrowserComponentApiManager_CT459487.SetMainFrameUrl(strURL);
	},
	
	DocumentComplete : function()
	{
		//check for highlighting when the page is loaded!
		if(EBToolbarData_CT459487.IsHighlighting)
		{
			EBHighlighterManager_CT459487.Highlight();
		}
		
		//call document complete event for the browser comp api
		EBBrowserComponentApiManager_CT459487.DocumentCompleteEvent();
	},
	
	SearchTermChanged : function()
	{
		var XULSearchBoxMenuList	= EBComponentsManager_CT459487.GetSearchBoxMenuList();
		
		if(XULSearchBoxMenuList)
		{
			var strSearchTerm			= XULSearchBoxMenuList.value;
				
			//save the search term to the global object
			EBToolbarData_CT459487.SearchTerm = strSearchTerm;
			
			//set the search term of the browser api
			EBBrowserComponentApiManager_CT459487.SetSearchTerm(strSearchTerm);
			
			//activate the SearchTermChanged Event of the browser api
			EBBrowserComponentApiManager_CT459487.SearchTermChangedEvent();
			
			//set the finder highlight buttons
			EBHighlighterManager_CT459487.SetHighlightButtons(XULSearchBoxMenuList);
			
			
			EBSearchBoxManager_CT459487.IsSetSearchBGText = false;
		}
	},
	
	GetEBToolbarsCTID : function()
	{
		var arrCTID = new Array();
		var objToolbarbox = document.getElementById('navigator-toolbox');
		
		var objToolbars = objToolbarbox.getElementsByTagName('toolbar');
		var objToolbar	= null;
		var strCTIDAttributeName	= 'ebtoolbarctid';
		var strCTIDAttributeValue	= '';
		for(var i=0;i<objToolbars.length;i++)
		{
			objToolbar = objToolbars[i];
			strCTIDAttributeValue = objToolbar.getAttribute(strCTIDAttributeName);
			if(strCTIDAttributeValue)
			{
				arrCTID[arrCTID.length] = strCTIDAttributeValue;
			}
			
		}
		
		return arrCTID;
		
	},
	
	GetToolbarDialogOpeningCoordinates : function(oElement,iDialogWidth)
	{
		var oElementBoxObject	= oElement.boxObject;
		var iElementScreenX		= oElementBoxObject.screenX;
		
		//get the y position from the toolbar
		var oToolbar			= EBToolbarData_CT459487.ToolbarInstance;
		var oToolbarBoxObject	= oToolbar.boxObject;
		var iToolbarScreenY		= oToolbarBoxObject.screenY;
		var iToolbarHeight		= oToolbarBoxObject.height;
		
		var iX = iElementScreenX;
		var iY = iToolbarScreenY + iToolbarHeight;
		//in mac the y is different:
		if(EBGlobalManager_CT459487.IsMacintoshPlatform())
		{
			iY = iToolbarScreenY;
		}
		
		var iHorizontalGap = EBGlobalConsts_CT459487.ToolbarHorizontalDialogGap;
		//validate the x coordinate according to the screen:
		if(iX + iDialogWidth > screen.width)
		{
			iX = screen.width - iDialogWidth - iHorizontalGap;
		}
		else if(iX < 0)
		{
			iX = iHorizontalGap;
		}
		
		return {X:iX,Y:iY};
	},
	
	GetItemDialogOpeningCoordintates : function(oElement,iDialogWidth,iDialogHeight)
	{
		var oElementBoxObject	= oElement.boxObject;
		var iElementScreenX		= oElementBoxObject.screenX;
		var iElementScreenY		= oElementBoxObject.screenY;
		
		var iX = iElementScreenX + oElementBoxObject.width;
		var iY = iElementScreenY;
		

		var iHorizontalGap = EBGlobalConsts_CT459487.ToolbarHorizontalDialogGap;
		var iVerticalGap = EBGlobalConsts_CT459487.ToolbarVerticalDialogGap;
		
		if(iX + iDialogWidth > screen.width)
		{
			iX = iElementScreenX - iDialogWidth;
		}
		else if(iX < 0)
		{
			iX = iHorizontalGap;
		}
		
		if(iY + iDialogHeight > screen.height)
		{
			iY = screen.height - iDialogHeight - iVerticalGap;
		}
		
		return {X:iX,Y:iY};
	},
	
	//close all the special dialogs of the toolbar (weather-feed-multifeed)
	CloseToolbarDialogs : function()
	{
		var oFeedDialog = EBFeedDialogManager_CT459487.GetDialog();
		if(oFeedDialog)
		{
			oFeedDialog.close();
		}
		
		var oMultiFeedDialog = EBMultiFeedDialogManager_CT459487.GetDialog();
		if(oMultiFeedDialog)
		{
			oMultiFeedDialog.close();
		}
		
		var oWeatherDialog = EBWeatherDialogManager_CT459487.GetDialog();
		if(oWeatherDialog)
		{
			oWeatherDialog.close();
		}
	}
}
var EBBrowserComponentConsts_CT459487 =
{
	Caption	: 'Browser Component',

	Images : 
	{
		MiniBrowser : 'chrome://folkoteka.com/skin/minibrowser.png'
	}
}

var EBBrowserComponentApiManager_CT459487 =
{
	OnLoadBrowserComponent : function(strBCID)
	{
		var xulBrowserElement = document.getElementById(strBCID);
	
		xulBrowserElement.addProgressListener(EBBrowserComponentListener_CT459487);

		this.SetInitialWidth(xulBrowserElement);
	
		//save the id of the browser element in his window name 
		//to retrieve it later using the window from the progress listener events!
		xulBrowserElement.contentWindow.name = strBCID;
		
	},

	//gets all the browser element of the toolbar
	GetToolbarBrowserComponents : function()
	{
		var xulToolbarElement = EBToolbarData_CT459487.ToolbarInstance;
		var xulBrowserElements = xulToolbarElement.getElementsByTagName("browser");
			
		return xulBrowserElements;
	},
	
	//set to all the browsers in the toolbar the SearchTermChanged Event
	SearchTermChangedEvent : function()
	{
		var xulBrowserElements = this.GetToolbarBrowserComponents();
		for(var i=0;i<xulBrowserElements.length;i++)
		{
			var xulBrowserElement = xulBrowserElements[i];
			
			//call the functions of the document using the javascript object 
			//of that browser component
			var oJavascript = EBGlobalManager_CT459487.GetWebPageJavascriptObject(xulBrowserElement.contentWindow);
			//activate the searchTermChanged event
			if(oJavascript.EBSearchTermChanged)
			{
				oJavascript.EBSearchTermChanged();
			}
			
		}
		
	},
	
	DocumentCompleteEvent : function()
	{
		var xulBrowserElements = this.GetToolbarBrowserComponents();
		for(var i=0;i<xulBrowserElements.length;i++)
		{
			var xulBrowserElement = xulBrowserElements[i];
			
			var oJavascript = EBGlobalManager_CT459487.GetWebPageJavascriptObject(xulBrowserElement.contentWindow);
			if(oJavascript.EBDocumentComplete)
			{
				oJavascript.EBDocumentComplete();
			}
		}
	},
	
	NavigateCompleteEvent : function()
	{
		var xulBrowserElements = this.GetToolbarBrowserComponents();
		for(var i=0;i<xulBrowserElements.length;i++)
		{
			var xulBrowserElement = xulBrowserElements[i];
			
			var oJavascript = EBGlobalManager_CT459487.GetWebPageJavascriptObject(xulBrowserElement.contentWindow);
			if(oJavascript.EBNavigateComplete)
			{
				oJavascript.EBNavigateComplete();
			}
		}
	},
	
	SetSearchTerm : function(strSearchTerm)
	{
		var xulBrowserElements = this.GetToolbarBrowserComponents();
		for(var i=0;i<xulBrowserElements.length;i++)
		{
			var xulBrowserElement = xulBrowserElements[i];
			var oJavascript = EBGlobalManager_CT459487.GetWebPageJavascriptObject(xulBrowserElement.contentWindow);
			
			//set the search term
			if(oJavascript.EBSetSearchTerm)
			{
				oJavascript.EBSetSearchTerm(strSearchTerm);
			}
		}
	},
	
	SetMainFrameUrl : function(strMainFrameUrl)
	{
		var xulBrowserElements = this.GetToolbarBrowserComponents();
		for(var i=0;i<xulBrowserElements.length;i++)
		{
			var xulBrowserElement = xulBrowserElements[i];
			var oJavascript = EBGlobalManager_CT459487.GetWebPageJavascriptObject(xulBrowserElement.contentWindow);
			
			//set the search term
			if(oJavascript.EBSetMainFrameUrl)
			{
				oJavascript.EBSetMainFrameUrl(strMainFrameUrl);
			}
		}
	},
	
	SetInitialWidth : function(xulBrowserElement)
	{
		var oJavascript = EBGlobalManager_CT459487.GetWebPageJavascriptObject(xulBrowserElement.contentWindow);
	
		if(oJavascript.EBSetCurrentWidth)
		{
			var strInitialWidth = xulBrowserElement.getAttribute("width");
			oJavascript.EBSetCurrentWidth(strInitialWidth);
		}
	},
	
	SetWidth : function(xulBrowserElement,strNewWidth)
	{
		var oJavascript = EBGlobalManager_CT459487.GetWebPageJavascriptObject(xulBrowserElement.contentWindow);
	
		if(oJavascript.EBSetCurrentWidth)
		{
			oJavascript.EBSetCurrentWidth(strNewWidth);
		}
	},
	
	ChangeSize : function(xulBrowserElement,strNewWidth)
	{
		//set the new width to the browser
		xulBrowserElement.setAttribute("width",strNewWidth);;
		
		this.ReloadBrowser(xulBrowserElement);
		
		//set the api width
		this.SetWidth(xulBrowserElement,strNewWidth);
		
	},
	
	
	Navigate : function(xulBrowserElement,strUrl,strNewWidth)
	{

		if(strNewWidth != "-1")
		{
			this.ChangeSize(xulBrowserElement,strNewWidth);
		}
		

		xulBrowserElement.setAttribute("src",strUrl + "?#_self");
		this.ReloadBrowser(xulBrowserElement);
		
	},
	
	
	ReloadBrowser : function(xulBrowserElement)
	{
		xulBrowserElement.setAttribute("collapsed","true");
		
		//timeout so the browser will catch the action on time
		var funcTimeoutCollapsedFalse = function()
		{
			xulBrowserElement.setAttribute("collapsed","false");	
		};
		
		setTimeout(funcTimeoutCollapsedFalse,1);
	}
	
	
	
}

var EBChevronConsts_CT459487 = 
{
	PrefixID							: 'EBToolbarChevron_',
	
	Image								: 'chrome://folkoteka.com/skin/chevron.png',
	
	ImageRTL							: 'chrome://folkoteka.com/skin/chevron_rtl.png',
	
	Width								: 20,
	
	ChevronSuffixText					: '_chevron',
	
	ChevronElementDefaultBorderStyle	: 'border:1px solid transparent;',
								   	
	ChevronElementHoverStyle			: 'background-color:#C6D3EF;border:1px solid #316AC5;',
	
	ChevronElementOutStyle				: 'background-color:transparent;'
}



var EBChevronManager_CT459487 = 
{
	ChevronXULElement					: null,
	
	IndexFirstChevronComponent			: -1,
	
	//the index among the highlight buttons:
	IndexFirstChevronHighlightButton	: -1,
	
	GetToolbarChveronID : function()
	{
		var strID = EBChevronConsts_CT459487.PrefixID + EBGlobalConsts_CT459487.ToolbarCTID;
		return strID;
	},

	CreateChevronElement : function()
	{
		var strID		= this.GetToolbarChveronID();
		var strImage	= EBChevronConsts_CT459487.Image;
		
		if(EBToolbarData_CT459487.ToolbarRTL)
		{
			strImage = EBChevronConsts_CT459487.ImageRTL;
		}
		
		var XULToolbarButton = EBXULFactory_CT459487.CreateToolbarButton(strID,
																	'menu',
																	'',
																	strImage,
																	'',
																	'',
																	'');
		
		XULToolbarButton.setAttribute('class',EBToolbarDesignConsts_CT459487.ToolbarButtonChevronClass);
		XULToolbarButton.setAttribute('width',EBChevronConsts_CT459487.Width);
		var strOnPopupShowing = 'EBChevronManager_CT459487.OnMenuPopupChevronShowing(event);';
		var XULMenuPopup = 	EBXULFactory_CT459487.CreateMenuPopup('',
																	strOnPopupShowing,
																	'');
																
		XULToolbarButton.appendChild(XULMenuPopup);
		
		this.ChevronXULElement = EBXULFactory_CT459487.CreateToolbarItem();
		
		this.ChevronXULElement.setAttribute('flex','1');
		this.ChevronXULElement.setAttribute('pack','end');
		
		this.ChevronXULElement.appendChild(XULToolbarButton);
	},
	
	OnMenuPopupChevronShowing : function(event)
	{
		
		//check to see that this popupshowing event is coming from the main
		//menupopup - (this event somehow propagating to all the menupopup childs)
		if(event.eventPhase == 2)
		{
			var XULMenuPopup = event.target;
			
			//nullify the menupopup
			while(XULMenuPopup.childNodes.length > 0)
			{
				XULMenuPopup.removeChild(XULMenuPopup.firstChild);
			}
			
			//always check the component index first 
			//(because it comes before the highlight buttons on the toolbar)
			if(this.IndexFirstChevronComponent != -1)
			{
				var arrComponents = EBToolbarData_CT459487.ToolbarComponents.IndexerArray;
				var objToolbarComponent = null;
				for(var i=this.IndexFirstChevronComponent;i<arrComponents.length;i++)
				{
					objToolbarComponent = arrComponents[i];
					
					if(this.IsAddToolbarComponentToChevron(objToolbarComponent))
					{
						var XULChevronElement = objToolbarComponent.AddToChevron(XULMenuPopup);
					
						if(XULChevronElement)
						{
							this.SetChevronElementStyle(XULChevronElement);
						}
					}
				}
			}
			
			
			//check to add the highlight buttons
			if(this.IndexFirstChevronHighlightButton != -1)
			{
				var XULHighlightButtons			= EBHighlighterManager_CT459487.GetHighlightButtons();

				var objXULButton = null;
				for(var i=this.IndexFirstChevronHighlightButton;i<XULHighlightButtons.length;i++)
				{
					objXULButton = XULHighlightButtons[i];
					EBHighlighterManager_CT459487.AddHighlightButtonToChevron(objXULButton,XULMenuPopup);
				}
			
			}
			
			//send usage
			this.RequestChevronUsage(EBUsageConsts_CT459487.CHEVRON_MENU_OPEN);
			
		}
		
	},
	
	IsAddToolbarComponentToChevron : function(objToolbarComponent)
	{
		var isShowComponent = EBComponentsManager_CT459487.IsShowComponent(objToolbarComponent);
		var isShowInChevron = EBComponentsManager_CT459487.IsShowInChevron(objToolbarComponent)
		
		return isShowComponent && isShowInChevron;
	
	},
	
	RequestChevronUsage : function(strGeneralParam1)
	{
		var objUsage = new EBUsageObject_CT459487('',
													EBUsageConsts_CT459487.CHEVRON,
													strGeneralParam1,
													'');
		objUsage.SendRequest();
	},
	
	SetChevronElementStyle : function(XULChevronElement)
	{
		if(XULChevronElement.tagName != 'menuseparator')
		{
			//check to see if this element is disabled to not set it's color (from disabled grey to element black)
			var isSetColor = XULChevronElement.getAttribute('disabled') == 'true' ? false : true;
			
			XULChevronElement.setAttribute('style', EBChevronConsts_CT459487.ChevronElementDefaultBorderStyle);
			//set the style events
			XULChevronElement.setAttribute('onmouseover','EBChevronManager_CT459487.OnMouseOverChevronMenuElement(event,'+isSetColor+');');
			XULChevronElement.setAttribute('onmouseout','EBChevronManager_CT459487.OnMouseOutChevronMenuElement(event,'+isSetColor+');');
		}	
	},
	
	OnMouseOverChevronMenuElement : function(event,isSetColor)
	{
		
		//isSetColor for the browser component element where we don't
		//want to set their color to black beacuse they are disabled
	
		//prevent bubbeling the style to this chevron element's child
		if(event.eventPhase == 2)
		{
			var XULElement = event.target;
			var strColorStyle = '';
			if(isSetColor)
			{
				strColorStyle = 'color:black;';
			}
			var strStyleSet	  = strColorStyle +  EBChevronConsts_CT459487.ChevronElementHoverStyle;
			XULElement.setAttribute('style',strStyleSet);
		}
	},
	
	OnMouseOutChevronMenuElement : function(event,isSetColor)
	{
		//prevent bubbeling the style to this chevron element's child
		if(event.eventPhase == 2)
		{
			var XULElement = event.target;
			
			var strColorStyle = '';
			if(isSetColor)
			{
				strColorStyle = 'color:black;';
			}
			var strStyleSet	  = strColorStyle + EBChevronConsts_CT459487.ChevronElementDefaultBorderStyle  + EBChevronConsts_CT459487.ChevronElementOutStyle;
			XULElement.setAttribute('style',strStyleSet);
		}
	},
	
	//function that checks if this element should be in chevron
	IsInChevron : function(XULToolbarItem,isLastShownComponent)
	{
		if(XULToolbarItem && XULToolbarItem.boxObject)
		{
			var iToolbarWidth	= window.innerWidth;
			var iElementX		= XULToolbarItem.boxObject.x;
			var iElementWidth	= XULToolbarItem.boxObject.width;
			var iChevronWidth	= EBChevronConsts_CT459487.Width;
		
			//check if it's the last component so i don'e calculate the 
			//width of the chevron element itself:
			if(isLastShownComponent)
			{
				iChevronWidth = 0;
			}
			
			if(EBToolbarData_CT459487.ToolbarRTL) //right to left calculation
			{
				//i calculate it to 1 and not 0 cause i want in rtl
				//when the user drag the toolbat till the end to be collapsed
				//since the toolbar cannot be resize beyond the window width
				if(iElementX - iChevronWidth <= 1)
				{
					return true;
				}
			}
			else //left to right calculation
			{
				if((iElementX + iElementWidth) > (iToolbarWidth - iChevronWidth))
				{
					return true;
				}
			}
		}
		
		return false;
	},
	
	SetFirstChevronComponentIndex : function()
	{
		//nullify the indexes
		this.IndexFirstChevronComponent				= -1;
		this.IndexFirstChevronHighlightButton		= -1;
		
		//check for the toolbar components (get the first element index)
		this.IndexFirstChevronComponent			= this.GetFirstChevronComponentIndex();
		
		//check for the highlighter buttons chevron (get the first element index)
		this.IndexFirstChevronHighlightButton	= this.GetFirstChevronHighlightButtonIndex();
	},
	
	GetFirstChevronComponentIndex : function()
	{
		var arrComponents = EBToolbarData_CT459487.ToolbarComponents.IndexerArray;
		var objToolbarComponent = null;
		
		for(var i=0;i<arrComponents.length;i++)
		{
			objToolbarComponent = arrComponents[i];
			
			if(EBComponentsManager_CT459487.IsShowComponent(objToolbarComponent) 
				&& 
				objToolbarComponent.IsToChevron())
			{
				return i;
			}
		}
		
		return -1;	
	},
	
	GetFirstChevronHighlightButtonIndex : function()
	{	
		var XULHighlightButtons			= EBHighlighterManager_CT459487.GetHighlightButtons();
		
		var  objXULButton	= null;
		var	 isLast			= false;
		for(var i=0;i<XULHighlightButtons.length;i++)
		{
			objXULButton = XULHighlightButtons[i];
			isLast = i == XULHighlightButtons.length - 1 ? true : false;
			if(this.IsInChevron(objXULButton,isLast))
			{
				return i;
			}
		}
		
		return -1;
	},
	
	
	
	SetChevronComponentsCollapsed : function(isCollapsed)
	{
		//set the toolbar components
		if(this.IndexFirstChevronComponent != -1)
		{
			var arrComponents = EBToolbarData_CT459487.ToolbarComponents.IndexerArray;
			var objToolbarComponent = null;
			
			for(var i=this.IndexFirstChevronComponent;i<arrComponents.length;i++)
			{
				objToolbarComponent = arrComponents[i];
				
				objToolbarComponent.SetComponentCollapsed(isCollapsed);
			}
		}
		
		//set the toolbar highligh buttons
		if(this.IndexFirstChevronHighlightButton != -1)
		{
			var XULHighlightButtons			= EBHighlighterManager_CT459487.GetHighlightButtons();
				
			var objXULButton = null;
			for(var i=this.IndexFirstChevronHighlightButton;i<XULHighlightButtons.length;i++)
			{
				objXULButton = XULHighlightButtons[i];
				objXULButton.setAttribute('collapsed',isCollapsed);
			}
		}
		
	},
		
	
	SetChevronElementCollapsed : function(isCollapsed)
	{
		//if there is visible chevron element on the toolbar 
		//the last element on the toolbar (toolbaritem) should be hidden 
		//for the sizing effect to be smoothly
		if(this.ChevronXULElement)
		{
			//i collapsed each element in the chevron due to a bug in fx 1.0.*
			this.ChevronXULElement.setAttribute('collapsed',isCollapsed);
			this.ChevronXULElement.firstChild.setAttribute('collapsed',isCollapsed);
			this.ChevronXULElement.firstChild.firstChild.setAttribute('collapsed',isCollapsed);
			
			//set the opposite collapsed to the toolbar item
			if(EBToolbarBuilder_CT459487.XULPostToolbarItem)
			{
				EBToolbarBuilder_CT459487.XULPostToolbarItem.setAttribute('collapsed',!isCollapsed);
			}
		}	
	},
	
	
	//function that checks what chevron is legal start chevron element
	//from the start index - it's eliminates the components that doesn't supposed
	//to be in the chevron (the ShowInChevrom member from the settings is false)
	GetLegalStartChevronComponent : function()
	{
		var arrComponents = EBToolbarData_CT459487.ToolbarComponents.IndexerArray;
		var objToolbarComponent = null;
		for(var i=this.IndexFirstChevronComponent;i<arrComponents.length;i++)
		{
			var objToolbarComponent = arrComponents[i];
			if(this.IsAddToolbarComponentToChevron(objToolbarComponent))
			{
				return objToolbarComponent;
			}
		}
		
		return null;
	},
	
	
	SetChevronElement : function()
	{
		var objToolbarElement = EBToolbarData_CT459487.ToolbarInstance;
		
		if(!this.ChevronXULElement)
		{	
			this.CreateChevronElement();
		}
		
		//indicates if the chevron is added
		//(after all the checks - if this component is legal,in chevron etc...)
		var isChevron = false;
		
		//set the chevron into the toolbar
		//start the check from the toolbar components 
		//cause they come before the highlight buttons on the toolbar
		if(this.IndexFirstChevronComponent != -1)
		{
			var objStartChevronComponent = this.GetLegalStartChevronComponent();
			
			if(objStartChevronComponent)
			{
				var objToolbarItem = objStartChevronComponent.IsToChevron();
				
				if(objToolbarItem)
				{
					isChevron = true;
					//add the chevron to the toolbar
					objToolbarElement.insertBefore(this.ChevronXULElement,objToolbarItem);
					this.SetChevronElementCollapsed(false);
				}
			}
		}
		
		
		if(!isChevron && this.IndexFirstChevronHighlightButton != -1)
		{
			var XULHighlightButtons	= EBHighlighterManager_CT459487.GetHighlightButtons();

			var objXULButton = XULHighlightButtons[this.IndexFirstChevronHighlightButton];
			
			if(objXULButton)
			{
				objToolbarElement.insertBefore(this.ChevronXULElement,objXULButton);
				this.SetChevronElementCollapsed(false);
			}
		}
		
	},
	
	//check if the user drag the searchbox over the screen
	//so we return it to the maximum width size till the chevron is appear
	CheckLegalChevron : function(event,isFirstTime)
	{
		//only if it comes from the onmouseup event of the splitter
		if((event && event.type == 'mouseup') || isFirstTime)
		{
			var objSplitter		= null;
			var objSearchBox	= null;
			var objSearchBoxComponent = EBComponentsManager_CT459487.GetSearchBoxComponent();
			
			if(objSearchBoxComponent)
			{
				objSplitter		= objSearchBoxComponent.xulSplitter;
				objSearchBox	= objSearchBoxComponent.xulMenuList;
			}
			
			if(objSearchBox && objSplitter && objSplitter.boxObject)
			{
			
				var iToolbarWidth	= window.innerWidth;
				var iScreenWidth	= window.screen.width;
				var iChevronWidth	= EBChevronConsts_CT459487.Width;
				var iSplitterX		= objSplitter.boxObject.x;
				var iSplitterWidth	= objSplitter.boxObject.width;
				
				//if it's first time the check is compare to the all screen
				//and if not the check is compare the toolbar width
				var iCheckWidth = isFirstTime ? iScreenWidth : iToolbarWidth;
				
				var iSearchBoxGap = (iSplitterX + iSplitterWidth) - (iCheckWidth - iChevronWidth);
				
				if(iSearchBoxGap > 0)
				{
					var strWidthSet = objSearchBox.parentNode.getAttribute('width') - iSearchBoxGap;
					//if it's first time check i set the width to default
					if(isFirstTime)
					{
						strWidthSet = EBSearchBoxConsts_CT459487.SearchBoxWidth;
					}
					//set the width in timeout cause there is an event happening
					//that sets the width according to the splitter mouse up event
					var objTimeoutFunction = function()
					{
						objSearchBox.parentNode.setAttribute('width',strWidthSet);
						EBSearchBoxManager_CT459487.SetPrefMenuListWidth();
					}
					setTimeout(objTimeoutFunction,100);
					
				}
			}
		}
		
	},
		
	SetChevron	: function(event,isFirstTime)
	{
		try{
			//first hide the chevron element to calculate right
			//the elements on the toolbar
			this.SetChevronElementCollapsed(true);
			
			//show all components(collased = false)
			this.SetChevronComponentsCollapsed(false);

			//set the first index of the component that will be in the chevron
			this.SetFirstChevronComponentIndex();
			
			//add the chevron to the toolbar before the first chevron element
			this.SetChevronElement();
			
			//hide all the elemenets that supposed to be in the chevron
			this.SetChevronComponentsCollapsed(true);
			
			//check if to set the toolbar width if it's exceed the window width
			this.CheckLegalChevron(event,isFirstTime);
		
		}catch(err){}

	
	}
	
}

/*************************** Special command consts ******************************/
var EBSpecialCommands_CT459487 = 
{
	//consts:
	PRIVACY_PAGE					: "ClientPrivacy.html",
	
	HELP_PAGE						: "ClientHelp.html",
	
	TELL_A_FRIEND_PAGE				: "ClientFriend.html",
	
	TELLAFRIEND : function()
	{
		var strTellAFriendMailTo = "";
		
		if(EBToolbarData_CT459487.GeneralToolbarInfo.TellAFriendCmd == "")
		{
			//build the default tell_a_friend!
			
			//check if there is webServerUrl from the xml general info
			var strDownloadToolbarUrl = "";
			if(EBToolbarData_CT459487.GeneralToolbarInfo.WebServerURL == '')
			{
				strDownloadToolbarUrl = EBToolbarData_CT459487.DefaultWebServerURL + this.TELL_A_FRIEND_PAGE + "?ToolbarId="+EBGlobalConsts_CT459487.ToolbarCTID;
			}
			else
			{
				strDownloadToolbarUrl = EBToolbarData_CT459487.GeneralToolbarInfo.WebServerURL;
			}
			
			var strToolbarName = EBGlobalConsts_CT459487.ToolbarName;
			
			var strSubject 	= "Try " + strToolbarName + " toolbar";
			var strBody 	= "Hi,%0D%0A%0D%0AI recently installed the ";
			strBody += strToolbarName;
			strBody +=	" toolbar and thought you might also find it interesting.%0D%0AIt has lots of useful features and seems to be well-liked ";
			strBody +=	"by a large number of users (including my self).%0D%0A%0D%0A";
			strBody +=	"To find out more about this toolbar and download it, go to: %0D%0A";
			strBody +=	strDownloadToolbarUrl;
			strBody +=	"%0D%0A%0D%0A";
			
			strTellAFriendMailTo = "mailto:?subject="+strSubject+"&body="+strBody;
		}
		else
		{
			strTellAFriendMailTo = EBToolbarData_CT459487.GeneralToolbarInfo.TellAFriendCmd;
		}
		
		EBLinkManager_CT459487.LoadLinkURL(null,strTellAFriendMailTo,false,null);
	},
	
	HELP : function(event)
	{
		//get the correct web server url
		var strWebServerURL = EBActionManager_CT459487.GetWebServerURL();
		var strURL = strWebServerURL + this.HELP_PAGE+"?version="+EBGlobalConsts_CT459487.ToolbarVersion+"&&ToolbarId="+EBGlobalConsts_CT459487.ToolbarCTID;
		EBLinkManager_CT459487.LoadLinkURL(event,strURL,false,null);
	},
	
	PRIVACY : function(event)
	{
		//get the correct web server url
		var strWebServerURL = EBActionManager_CT459487.GetWebServerURL();
		var strURL = strWebServerURL + this.PRIVACY_PAGE+"?version="+EBGlobalConsts_CT459487.ToolbarVersion+"&&ToolbarId="+EBGlobalConsts_CT459487.ToolbarCTID;
		EBLinkManager_CT459487.LoadLinkURL(event,strURL,false,null);
	},
	
	HOMEPAGE : function(event)
	{
		var strToolbarHomePage = EBToolbarData_CT459487.ToolbarHomePage;
		EBLinkManager_CT459487.LoadLinkURL(event,strToolbarHomePage,false,null);
	},
	
	CONTACTUS : function()
	{
		var strMailTo = EBToolbarData_CT459487.GeneralToolbarInfo.ToolbarPublisherMailTo;
		if(strMailTo != "")
		{
			EBLinkManager_CT459487.LoadLinkURL(null,strMailTo,false,null);
		}
	},
	
	ABOUT : function()
	{
		var strAboutDialogType = 'EBAboutDialog_CT459487';
		var strAboutDialogName = 'EBAboutDialogName_CT459487';
		var oAboutDialog = EBGlobalManager_CT459487.GetXULWindowByTypeAndName(strAboutDialogType,strAboutDialogName);
		
		//check if the about window is open to set it to focus
		if(oAboutDialog)
		{
			oAboutDialog.focus();
		}
		else
		{
			var strAboutChromePath	= EBGlobalConsts_CT459487.ChromeContentPath + 'about.xul';
			
			window.openDialog(strAboutChromePath,
								strAboutDialogName,
								'chrome,modal,centerscreen,chrome,resizable=no');
		}
	},
	
	CLEAN_CACHE : function()
	{
		var cacheService = Components.classes["@mozilla.org/network/cache-service;1"].
										getService(Components.interfaces.nsICacheService);

		cacheService.evictEntries(Components.interfaces.nsICache.STORE_ON_DISK);
		cacheService.evictEntries(Components.interfaces.nsICache.STORE_IN_MEMORY);
	},
	
	CLEAN_HISTORY : function()
	{
		var historyManager = Components.classes["@mozilla.org/browser/global-history;2"].
										getService(Components.interfaces.nsIBrowserHistory);
		
		historyManager.removeAllPages();
	},
	
	CLEAR_COOKIES : function()
	{
		var cookieManager = Components.classes["@mozilla.org/cookiemanager;1"].
									getService(Components.interfaces.nsICookieManager);
									
		cookieManager.removeAll();
	},
	
	REFRESH_TOOLBAR_VIEW : function()
	{
		//empty the last update time value to get the most current settings from the server
		EBToolbarPreferenceManager_CT459487.SetPref(EBPreferenceConsts_CT459487.SettingsLastUpdateTime,null);
		
		EBServerCommunicationManager_CT459487.RequestSettings();
	},
	
	
	GENERIC : function(event)
	{
		EBGenericDialogManager_CT459487.Open();
	},
	
	DELETE_SEARCH_HISTORY : function()
	{
		EBSearchBoxManager_CT459487.ClearSearchHistory();
	},
	
	UNINSTALL : function()
	{	
		var strUninstallMsg = EBGlobalConsts_CT459487.ToolbarName + " toolbar will be uninstalled after you restart Firefox.";
		var isUninstall = false;
		var strGUID = EBGlobalConsts_CT459487.GUID;
		
		try{
			
			var objExtensionsManager = Components.classes["@mozilla.org/extensions/manager;1"].getService(Components.interfaces.nsIExtensionManager);
			
			
			if(objExtensionsManager.uninstallExtension)//Firefox 1.0+
			{
				this._dummy = objExtensionsManager.datasource;
				objExtensionsManager.uninstallExtension(strGUID);
				this._dummy = null;
				isUninstall = true;
			}
			else if(objExtensionsManager.uninstallItem)//Firefox 1.5
			{
				objExtensionsManager.uninstallItem(strGUID);
				isUninstall = true;
			}
			
			if(isUninstall)
			{
				EBGlobalManager_CT459487.Alert(window,strUninstallMsg,'Uninstallation');
			}
		
		}catch(err){}
	},
	
	SHRINK_TOOLBAR : function()
	{
		this.BroadcastActionShrink();
	},
	
	SetActionShrink : function()
	{
		//i set the class here before re-build the elements 
		//for the external component feature
		this.ShrinkUnshrinkSetToolbarButtonsStyle();
		
		this.ShrinkUnshrinkReDrawToggleCommandElement();
		
		if(EBToolbarData_CT459487.ToolbarRTL)
		{
			EBActionManager_CT459487.ExternalReBuildToolbar();
		}
		else
		{
			//call the chevron after unshrink
			EBChevronManager_CT459487.SetChevron();	
		}
		
	},
	
	BroadcastActionShrink : function()
	{	
		var objWindowsManager = Components.classes['@mozilla.org/appshell/window-mediator;1']
						.getService(Components.interfaces.nsIWindowMediator);
		
		var objEnumerator = objWindowsManager.getEnumerator('navigator:browser');	
		while(objEnumerator.hasMoreElements()) 
		{
			var objWindow = objEnumerator.getNext();
			
			if(objWindow.EBSpecialCommands_CT459487.SetActionShrink)
			{
				try
				{
					objWindow.EBSpecialCommands_CT459487.SetActionShrink();
				}
				catch(ex){}
			}
		}
	},
	
	UNSHRINK_TOOLBAR : function()
	{		
		this.BroadcastActionUnShrink();
	},
	
	SetActionUnShrink : function()
	{
		this.ShrinkUnshrinkSetToolbarButtonsStyle();
		
		this.ShrinkUnshrinkReDrawToggleCommandElement();
		
		//call the chevron after unshrink
		EBChevronManager_CT459487.SetChevron();
	},
	
	BroadcastActionUnShrink : function()
	{
		var objWindowsManager = Components.classes['@mozilla.org/appshell/window-mediator;1']
						.getService(Components.interfaces.nsIWindowMediator);
		
		var objEnumerator = objWindowsManager.getEnumerator('navigator:browser');	
		while(objEnumerator.hasMoreElements()) 
		{
			var objWindow = objEnumerator.getNext();
			if(objWindow.EBSpecialCommands_CT459487.SetActionUnShrink)
			{
				try
				{
					objWindow.EBSpecialCommands_CT459487.SetActionUnShrink();
				}
				catch(ex){}
			}
		}
	},
	
	ShrinkUnshrinkSetToolbarButtonsStyle : function()
	{
		var arrComponents = EBToolbarData_CT459487.ToolbarComponents.IndexerArray;
		var objToolbarComponent = null;
		
		for(var i=0;i<arrComponents.length;i++)
		{
			objToolbarComponent = arrComponents[i];
			objToolbarComponent.SetToolbarButtonClass();
		}
		
	},
	
	ShrinkUnshrinkReDrawToggleCommandElement : function()
	{
		//get the toggle command pref name value 
		var strToggleCommandPrefNameValue = EBPreferenceConsts_CT459487.ToolbarShrink;
		//get the toggle command element to change his caption
		var objShrinkUnshrinkToggleElements = EBToolbarData_CT459487.ToolbarInstance.getElementsByAttribute("EB_TC_PREF_NAME",strToggleCommandPrefNameValue);
		if(objShrinkUnshrinkToggleElements[0])
		{
			EBDynamicMenuManager_CT459487.ReDrawToggleCommandElement(objShrinkUnshrinkToggleElements[0]);
		}	
	},
	
	EMAIL_NOTIFIER_OPTIONS : function()
	{
		EBEMailNotifierDialogsManager_CT459487.OpenSettingsDialog(window,false);
	},
	
	EMAIL_NOTIFIER_CHECK_NOW : function()
	{
		EBEMailNotifierToolbarManager_CT459487.OnCommandCheckForNewEMailsButton();
	},
	
	OPTIONS : function()
	{
		EBToolbarOptionsDialogManager_CT459487.OpenDialog(window,null);
	},
	
	CALC : function()
	{
		EBGlobalManager_CT459487.WindowsShellExecute('calc.exe',true);
	},
	
	WINWORD : function()
	{
		EBGlobalManager_CT459487.WindowsShellExecute('winword.exe',true);
	},
	
	NOTEPAD : function()
	{
		EBGlobalManager_CT459487.WindowsShellExecute('notepad.exe',true);	
	},
	
	EXCEL : function()
	{
		EBGlobalManager_CT459487.WindowsShellExecute('excel.exe',true);	
	},
	
	PAINT : function()
	{
		EBGlobalManager_CT459487.WindowsShellExecute('mspaint.exe',true);		
	},
	
	NETMEETING : function()
	{
		EBGlobalManager_CT459487.WindowsShellExecute('conf.exe',true);
	},
	
	OUTLOOK : function()
	{
		EBGlobalManager_CT459487.WindowsShellExecute('outlook.exe',true);	
	},
	
	DIALER : function()
	{
		EBGlobalManager_CT459487.WindowsShellExecute('dialer.exe',true);
	},
	
	MSCONFIG : function()
	{
		EBGlobalManager_CT459487.WindowsShellExecute('msconfig.exe',true);
	},
	
	FRONTPAGE : function()
	{
		EBGlobalManager_CT459487.WindowsShellExecute('frontpg.exe',true);		
	},
	
	HELPCENTER : function()
	{
		EBGlobalManager_CT459487.WindowsShellExecute('helpctr.exe',true);	
	},
	
	HYPERTERMINAL : function()
	{
		EBGlobalManager_CT459487.WindowsShellExecute('hypertrm.exe',true);	
	},
	
	MSMOVIEMAKER : function()
	{
		EBGlobalManager_CT459487.WindowsShellExecute('moviemk.exe',true);		
	},
	
	FILETRANSFERWIZARD : function()
	{
		EBGlobalManager_CT459487.WindowsShellExecute('migwiz.exe',true);	
	},
	
	MSACCESS : function()
	{
		EBGlobalManager_CT459487.WindowsShellExecute('msaccess.exe',true);	
	},
	
	MSDEV : function()
	{
		EBGlobalManager_CT459487.WindowsShellExecute('msdev.exe',true);	
	},
	
	OUTLOOKEXPRESS : function()
	{
		EBGlobalManager_CT459487.WindowsShellExecute('msimn.exe',true);	
	},
	
	MSINFO32 : function()
	{
		EBGlobalManager_CT459487.WindowsShellExecute('msinfo32.exe',true);		
	},
	
	MSNMESSENGER : function()
	{
		EBGlobalManager_CT459487.WindowsShellExecute('msnmsgr.exe',true);		
	},
	
	WINZIP : function()
	{
		EBGlobalManager_CT459487.WindowsShellExecute('winzip.exe',true);	
	},
	
	WORDPAD : function()
	{
		EBGlobalManager_CT459487.WindowsShellExecute('wordpad.exe',true);	
	},
	
	WMPLAYER : function()
	{
		EBGlobalManager_CT459487.WindowsShellExecute('wmplayer.exe',true);		
	},
	
	IIS : function()
	{
		EBGlobalManager_CT459487.WindowsShellExecute('inetmgr.exe',true);	
	},
	
	PHOTOSHOP : function()
	{
		EBGlobalManager_CT459487.WindowsShellExecute('photoshop.exe',true);
	},
	
	POWERPOINT : function()
	{
		EBGlobalManager_CT459487.WindowsShellExecute('powerpnt.exe',true);	
	},
	
	QUICKTIMEPLAYER : function()
	{
		EBGlobalManager_CT459487.WindowsShellExecute('quicktimeplayer.exe',true);	
	},
	
	REGISTRYEDITOR : function()
	{
		EBGlobalManager_CT459487.WindowsShellExecute('regedit.exe',true);
	},
	
	ActivateSpecialCommand : function(event,strCommandId,objUsage)
	{
		strCommandId = strCommandId.toUpperCase();
		if(strCommandId == "TELLAFRIEND")
		{
			this.TELLAFRIEND();
		}
		else if(strCommandId == "HELP")
		{
			this.HELP(event);
		}
		else if(strCommandId == "PRIVACY")
		{
			this.PRIVACY(event);
		}
		else if(strCommandId == "HOMEPAGE")
		{
			this.HOMEPAGE(event);
		}
		else if(strCommandId == "ABOUT")
		{
			this.ABOUT();
		}
		else if(strCommandId == "CONTACTUS")
		{
			this.CONTACTUS();
		}
		else if(strCommandId == "CLEAN_CACHE")
		{
			this.CLEAN_CACHE();
		}
		else if(strCommandId == "CLEAN_HISTORY")
		{
			this.CLEAN_HISTORY();
		}
		else if(strCommandId == "CLEAR_COOKIES")
		{
			this.CLEAR_COOKIES();
		}
		else if(strCommandId == "REFRESH_TOOLBAR_VIEW")
		{
			this.REFRESH_TOOLBAR_VIEW();
		}
		else if(strCommandId == "DELETE_SEARCH_HISTORY")
		{
			this.DELETE_SEARCH_HISTORY();
		}
		else if(strCommandId == "UNINSTALL")
		{
			this.UNINSTALL();
		}
		else if(strCommandId == "SHRINK_TOOLBAR")
		{
			this.SHRINK_TOOLBAR();
		}
		else if(strCommandId == "UNSHRINK_TOOLBAR")
		{
			this.UNSHRINK_TOOLBAR();
		}
		else if(strCommandId == "EMAIL_NOTIFIER_CHECK_NOW")
		{
			this.EMAIL_NOTIFIER_CHECK_NOW();
			//set the command param for the email notifier
			objUsage.ComponentID	= EBComponentsConsts_CT459487.ComponentsID.EMailNotifier;
			objUsage.ComponentType	= EBUsageConsts_CT459487.EMAIL_NOTIFIER;
			objUsage.GeneralParam1	= EBUsageConsts_CT459487.EMAIL_NOTIFIER_COMMAND;
		}
		else if(strCommandId == "EMAIL_NOTIFIER_OPTIONS")
		{
			this.EMAIL_NOTIFIER_OPTIONS();
			//set the command param for the email notifier
			objUsage.ComponentID	= EBComponentsConsts_CT459487.ComponentsID.EMailNotifier;
			objUsage.ComponentType	= EBUsageConsts_CT459487.EMAIL_NOTIFIER;
			objUsage.GeneralParam1	= EBUsageConsts_CT459487.EMAIL_NOTIFIER_COMMAND;
		}
		else if(strCommandId == "OPTIONS")
		{
			this.OPTIONS();
		}
		else if(strCommandId == 'CALC')
		{
			this.CALC();
		}
		else if(strCommandId == 'WINWORD')
		{
			this.WINWORD();
		}
		else if(strCommandId == 'NOTEPAD')
		{
			this.NOTEPAD();
		}
		else if(strCommandId == 'EXCEL')
		{
			this.EXCEL();
		}
		else if(strCommandId == 'PAINT')
		{
			this.PAINT();
		}
		else if(strCommandId == 'NETMEETING')
		{
			this.NETMEETING();
		}
		else if(strCommandId == 'OUTLOOK')
		{
			this.OUTLOOK();
		}
		else if(strCommandId == 'DIALER')
		{
			this.DIALER();
		}
		else if(strCommandId == 'MSCONFIG')
		{
			this.MSCONFIG();
		}
		else if(strCommandId == 'FRONTPAGE')
		{
			this.FRONTPAGE();
		}
		else if(strCommandId == 'HELPCENTER')
		{
			this.HELPCENTER();
		}
		else if(strCommandId == 'HYPERTERMINAL')
		{
			this.HYPERTERMINAL();
		}
		else if(strCommandId == 'MSMOVIEMAKER')
		{
			this.MSMOVIEMAKER();
		}
		else if(strCommandId == 'FILETRANSFERWIZARD')
		{
			this.FILETRANSFERWIZARD();
		}
		else if(strCommandId == 'MSACCESS')
		{
			this.MSACCESS();
		}
		else if(strCommandId == 'MSDEV')
		{
			this.MSDEV();
		}
		else if(strCommandId == 'OUTLOOKEXPRESS')
		{
			this.OUTLOOKEXPRESS();
		}
		else if(strCommandId == 'MSINFO32')
		{
			this.MSINFO32();
		}
		else if(strCommandId == 'MSNMESSENGER')
		{
			this.MSNMESSENGER();
		}
		else if(strCommandId == 'WINZIP')
		{
			this.WINZIP();
		}
		else if(strCommandId == 'WORDPAD')
		{
			this.WORDPAD();
		}
		else if(strCommandId == 'WMPLAYER')
		{
			this.WMPLAYER();
		}
		else if(strCommandId == 'IIS')
		{
			this.IIS();
		}
		else if(strCommandId == 'PHOTOSHOP')
		{
			this.PHOTOSHOP();
		}
		else if(strCommandId == 'POWERPOINT')
		{
			this.POWERPOINT();
		}
		else if(strCommandId == 'QUICKTIMEPLAYER')
		{
			this.QUICKTIMEPLAYER();
		}
		else if(strCommandId == 'REGISTRYEDITOR')
		{
			this.REGISTRYEDITOR();
		}
		
		
		
		this.RequestUsageCommand(objUsage);
	},
	
	RequestUsageCommand : function(objUsage)
	{
		objUsage.SendRequest();
	},
	
	IsSupportedCommand : function(strCommandId)
	{
		strCommandId = strCommandId.toUpperCase();
	
		if(strCommandId == "TELLAFRIEND")
		{
			return true;
		}
		else if(strCommandId == "HELP")
		{
			return true;
		}
		else if(strCommandId == "PRIVACY")
		{
			return true;
		}
		else if(strCommandId == "HOMEPAGE")
		{
			return true;
		}
		else if(strCommandId == "ABOUT")
		{
			return true;
		}
		else if(strCommandId == "CONTACTUS")
		{
			return true;
		}
		else if(strCommandId == "CLEAN_CACHE")
		{
			return true;
		}
		else if(strCommandId == "CLEAN_HISTORY")
		{
			return true;
		}
		else if(strCommandId == "CLEAR_COOKIES")
		{
			return true;
		}
		else if(strCommandId == "REFRESH_TOOLBAR_VIEW")
		{
			return true;
		}
		else if(strCommandId == "DELETE_SEARCH_HISTORY")
		{
			return true;
		}
		else if(strCommandId == "UNINSTALL")
		{
			return true;
		}
		else if(strCommandId == "SHRINK_TOOLBAR")
		{
			return true;
		}
		else if(strCommandId == "UNSHRINK_TOOLBAR")
		{
			return true;
		}
		else if(strCommandId == "EMAIL_NOTIFIER_CHECK_NOW")
		{
			return true;
		}
		else if(strCommandId == "EMAIL_NOTIFIER_OPTIONS")
		{
			return true;
		}
		else if(strCommandId == "OPTIONS")
		{
			return true;
		}
		else if(strCommandId == "CALC")
		{
			//in every third component application i check if this is 
			//windows OS and if there is this application under window!
			if(EBGlobalManager_CT459487.WindowsShellExecute('calc.exe',false))
			{
				return true;
			}
			else
			{
				return false;
			}
		}
		else if(strCommandId == "WINWORD")
		{
			if(EBGlobalManager_CT459487.WindowsShellExecute('winword.exe',false))
			{
				return true;
			}
			else
			{
				return false;
			}
		}
		else if(strCommandId == "NOTEPAD")
		{
			if(EBGlobalManager_CT459487.WindowsShellExecute('notepad.exe',false))
			{
				return true;
			}
			else
			{
				return false;
			}
		}
		else if(strCommandId == "EXCEL")
		{
			if(EBGlobalManager_CT459487.WindowsShellExecute('excel.exe',false))
			{
				return true;
			}
			else
			{
				return false;
			}
		}
		else if(strCommandId == "PAINT")
		{
			if(EBGlobalManager_CT459487.WindowsShellExecute('mspaint.exe',false))
			{
				return true;
			}
			else
			{
				return false;
			}
		}
		else if(strCommandId == "NETMEETING")
		{
			if(EBGlobalManager_CT459487.WindowsShellExecute('conf.exe',false))
			{
				return true;
			}
			else
			{
				return false;
			}
		}
		else if(strCommandId == "OUTLOOK")
		{
			if(EBGlobalManager_CT459487.WindowsShellExecute('outlook.exe',false))
			{
				return true;
			}
			else
			{
				return false;
			}
		}
		else if(strCommandId == "DIALER")
		{
			if(EBGlobalManager_CT459487.WindowsShellExecute('dialer.exe',false))
			{
				return true;
			}
			else
			{
				return false;
			}
		}
		else if(strCommandId == "MSCONFIG")
		{
			if(EBGlobalManager_CT459487.WindowsShellExecute('msconfig.exe',false))
			{
				return true;
			}
			else
			{
				return false;
			}
		}
		else if(strCommandId == "FRONTPAGE")
		{
			if(EBGlobalManager_CT459487.WindowsShellExecute('frontpg.exe',false))
			{
				return true;
			}
			else
			{
				return false;
			}
		}
		else if(strCommandId == "HELPCENTER")
		{
			if(EBGlobalManager_CT459487.WindowsShellExecute('helpctr.exe',false))
			{
				return true;
			}
			else
			{
				return false;
			}
		}
		else if(strCommandId == "HYPERTERMINAL")
		{
			if(EBGlobalManager_CT459487.WindowsShellExecute('hypertrm.exe',false))
			{
				return true;
			}
			else
			{
				return false;
			}
		}
		else if(strCommandId == "MSMOVIEMAKER")
		{
			if(EBGlobalManager_CT459487.WindowsShellExecute('moviemk.exe',false))
			{
				return true;
			}
			else
			{
				return false;
			}
		}
		else if(strCommandId == "FILETRANSFERWIZARD")
		{
			if(EBGlobalManager_CT459487.WindowsShellExecute('migwiz.exe',false))
			{
				return true;
			}
			else
			{
				return false;
			}
		}
		else if(strCommandId == "MSACCESS")
		{
			if(EBGlobalManager_CT459487.WindowsShellExecute('msaccess.exe',false))
			{
				return true;
			}
			else
			{
				return false;
			}
		}
		else if(strCommandId == "MSDEV")
		{
			if(EBGlobalManager_CT459487.WindowsShellExecute('msdev.exe',false))
			{
				return true;
			}
			else
			{
				return false;
			}
		}
		else if(strCommandId == "OUTLOOKEXPRESS")
		{
			if(EBGlobalManager_CT459487.WindowsShellExecute('msimn.exe',false))
			{
				return true;
			}
			else
			{
				return false;
			}
		}
		else if(strCommandId == "MSINFO32")
		{
			if(EBGlobalManager_CT459487.WindowsShellExecute('msinfo32.exe',false))
			{
				return true;
			}
			else
			{
				return false;
			}
		}
		else if(strCommandId == "MSNMESSENGER")
		{
			if(EBGlobalManager_CT459487.WindowsShellExecute('msnmsgr.exe',false))
			{
				return true;
			}
			else
			{
				return false;
			}
		}
		else if(strCommandId == "WINZIP")
		{
			if(EBGlobalManager_CT459487.WindowsShellExecute('winzip.exe',false))
			{
				return true;
			}
			else
			{
				return false;
			}
		}
		else if(strCommandId == "WORDPAD")
		{
			if(EBGlobalManager_CT459487.WindowsShellExecute('wordpad.exe',false))
			{
				return true;
			}
			else
			{
				return false;
			}
		}
		else if(strCommandId == "WMPLAYER")
		{
			if(EBGlobalManager_CT459487.WindowsShellExecute('wmplayer.exe',false))
			{
				return true;
			}
			else
			{
				return false;
			}
		}
		else if(strCommandId == "IIS")
		{
			if(EBGlobalManager_CT459487.WindowsShellExecute('inetmgr.exe',false))
			{
				return true;
			}
			else
			{
				return false;
			}
		}
		else if(strCommandId == "PHOTOSHOP")
		{
			if(EBGlobalManager_CT459487.WindowsShellExecute('photoshop.exe',false))
			{
				return true;
			}
			else
			{
				return false;
			}
		}
		else if(strCommandId == "POWERPOINT")
		{
			if(EBGlobalManager_CT459487.WindowsShellExecute('powerpnt.exe',false))
			{
				return true;
			}
			else
			{
				return false;
			}
		}
		else if(strCommandId == "QUICKTIMEPLAYER")
		{
			if(EBGlobalManager_CT459487.WindowsShellExecute('quicktimeplayer.exe',false))
			{
				return true;
			}
			else
			{
				return false;
			}
		}
		else if(strCommandId == "REGISTRYEDITOR")
		{
			if(EBGlobalManager_CT459487.WindowsShellExecute('regedit.exe',false))
			{
				return true;
			}
			else
			{
				return false;
			}
		}
		
		return false;
	}
}


var EBComponentsConsts_CT459487 = 
{
	TRUE					: 'TRUE',
	
	FALSE					: 'FALSE',
	
	TooltipPrefix			: 'EBTooltip_',
	
	ToolbarButtonIDPrefix	: 'EBToolbarButton_',
	
	MainPopupSetID	: 'EBMainPopupSet_CT459487',
	
	Editable		:
	{
		FULL	: 'FULL',
		NONE	: 'NONE'
	}, 
	
	ComponentsID	: 
	{
		MainMenu		: '100',
		SearchBox		: '101',
		Highlighter		: '102',
		EMailNotifier	: '103',
		Privacy			: '104',
		Weather			: '105'
	},
	
	//components type to distinguish between The different type of components
	//components coming from the original settings request,components coming from the third party components request, etc..
	ComponentsType : 
	{
		Settings	: 'Settings',
		ThirdParty	: 'ThirdParty'
	},
	
	Caption :
	{
		Loading : 'Loading...'
	}
}


var EBComponentsManager_CT459487 = 
{
	ValidateComponentID : function(strCompID)
	{
		var strValidateCompID = strCompID;
		if(!strValidateCompID)
		{
			strValidateCompID = EBGlobalManager_CT459487.GenerateRandomNumber();
		}
		
		return strValidateCompID;
	},
	
	IsEditableComponent : function(objToolbarComponent)
	{
		var bRetVal = true;
		var strPermission = objToolbarComponent.ComponentItem.Permission;
		if(strPermission.toUpperCase() == EBComponentsConsts_CT459487.Editable.NONE)
		{
			bRetVal = false;
		}
		
		return bRetVal;
	},
	
	GetComponentByCompID : function(strCompID)
	{
		var oComponent = null;
		if(EBToolbarData_CT459487.ToolbarComponents)
		{
			oComponent = EBToolbarData_CT459487.ToolbarComponents.GetByID(strCompID);
		}
		
		return oComponent;
	},
	
	GetMainMenuComponent : function()
	{
		var strMainMenuCompID	= EBComponentsConsts_CT459487.ComponentsID.MainMenu;		
		var oMainMenuComponent	= this.GetComponentByCompID(strMainMenuCompID);
		return oMainMenuComponent;
	},
	
	GetSearchBoxComponent : function()
	{
		var strSearchBoxCompID = EBComponentsConsts_CT459487.ComponentsID.SearchBox;	
		var objSearchBoxComponent	= this.GetComponentByCompID(strSearchBoxCompID);
		return objSearchBoxComponent;
	},
	
	GetEMailNotifierComponent : function()
	{
		var strEMailNotifierCompID		= EBComponentsConsts_CT459487.ComponentsID.EMailNotifier;
		var objEMailNotifierComponent	= this.GetComponentByCompID(strEMailNotifierCompID);
		return objEMailNotifierComponent;
	},
	
	GetEMailNotifierToolbarButton : function()
	{
		var oXULToolbarButton = null;
		var oEMailNotifierComponent = this.GetEMailNotifierComponent();
		if(oEMailNotifierComponent)
		{
			oXULToolbarButton = oEMailNotifierComponent.XULElement;
		}
		
		return oXULToolbarButton;
	},	
	
	GetWeatherComponent : function()
	{
		var strWeatherCompID	= EBComponentsConsts_CT459487.ComponentsID.Weather;
		var oWeatherComponent	= this.GetComponentByCompID(strWeatherCompID);
		return oWeatherComponent;
	},
	
	GetMainMenuToolbarButton : function()
	{
		var oToolbarButton = null;
		var oMainMenuComponent = this.GetMainMenuComponent();
		if(oMainMenuComponent)
		{
			oToolbarButton = oMainMenuComponent.XULElement;
		}
		return oToolbarButton;
	},
	
	GetMainMenuToolbarLogo : function()
	{
		var strLogo = '';
		var oMainToolbarButton = this.GetMainMenuToolbarButton();
		if(oMainToolbarButton)
		{
			strLogo = oMainToolbarButton.getAttribute('image');
		}
		return strLogo;
	},
	
	GetWeatherComponentButton : function()
	{
		var oWeatherComponent	= this.GetWeatherComponent();
		var oXULButton			= null;
		if(oWeatherComponent)
		{
			oXULButton = oWeatherComponent.XULElement;
		}
		
		return oXULButton;
	},
	
	GetWeatherComponentChevronElement : function()
	{
		var oWeatherComponent	= this.GetWeatherComponent();
		var oXULChevronElement	= null;
		if(oWeatherComponent)
		{
			oXULChevronElement = oWeatherComponent.XULChevronElement;
		}
		
		return oXULChevronElement;
	},
	
	GetSearchBoxMenuList : function()
	{
		var XULSearchMenuList = null;
		var objSearchBoxComponent = this.GetSearchBoxComponent();
		
		if(objSearchBoxComponent)
		{
			XULSearchMenuList = objSearchBoxComponent.xulMenuList;
		}
		
		return XULSearchMenuList;
	},
	
	GetSearchBoxButton : function()
	{
		var XULSearchButton = null;
		var objSearchBoxComponent = this.GetSearchBoxComponent();
		
		if(objSearchBoxComponent)
		{
			XULSearchButton = objSearchBoxComponent.xulToolbarButton;
		}
		
		return XULSearchButton;	
	},
	
	//wrap the function from the EBToolbarOptionsPreferenceManager
	IsShowComponent : function(objToolbarComponent)
	{
		return EBToolbarOptionsPreferenceManager_CT459487.IsShowComponent(objToolbarComponent)
	},
	
	IsShowInChevron : function(objToolbarComponent)
	{
		var bRetVal = true;
		
		var strIsInChevron = objToolbarComponent.ComponentItem.ShowInChevron;
		
		if(strIsInChevron.toUpperCase() == EBComponentsConsts_CT459487.TRUE)
		{
			bRetVal = true;
		}
		else
		{
			bRetVal = false;
		}
		
		return bRetVal;
	},
	
	//check if the given component is the last shown in the array
	//(example use - for the chevron)
	IsLastShownComponent : function(objToolbarComponentToCheck)
	{
		//check if there is highligh buttons and if so this is 
		//not the last shown component
		if(EBHighlighterManager_CT459487.IsHighlightButtons())
		{
			return false;
		}
		
		var arrComponents		= EBToolbarData_CT459487.ToolbarComponents.IndexerArray;
		var objToolbarComponent = null;
		
		for(var i=arrComponents.length - 1;i >= 0;i--)
		{
			objToolbarComponent = arrComponents[i];
			if(this.IsShowComponent(objToolbarComponent))
			{
				return objToolbarComponent == objToolbarComponentToCheck ? true : false;
			}
		}
		
		return false;
	},
	
	//the toolbarbutton id is for the tooltip attach for this button
	//to the tooltip-shrink effect
	GetToolbarButtonID : function(strCompID)
	{
		var strToolbarButtonIDPrefix	= EBComponentsConsts_CT459487.ToolbarButtonIDPrefix;
	
		var strToolbarButtonID			= strToolbarButtonIDPrefix + strCompID + EBGlobalConsts_CT459487.ToolbarCTID;
		
		return strToolbarButtonID;
	},
	
	GetTooltipID : function(strCompID)
	{
		var strTooltipPrefix = EBComponentsConsts_CT459487.TooltipPrefix;
		
		var strTooltipID =  strTooltipPrefix + strCompID + EBGlobalConsts_CT459487.ToolbarCTID;
		
		return strTooltipID;
	},
	
	AddTooltip : function(strCompID,objXULToolbarButton)
	{
		var strMainPopupSetID	= EBComponentsConsts_CT459487.MainPopupSetID;
		var objMainPopupSet		= document.getElementById(strMainPopupSetID);
		
		var strTooltipID		= this.GetTooltipID(strCompID);
		var strOrient			= 'vertical';
		
		//patch to 1.0.* - send the toolbarbutton id to retrieve the label and tooltip instead of
		//the toolbarbutton object itself as a param to the onpopupshowing event
		//set addEventListener also fails to work in 1.0.*
		var strToolbarButtonID = objXULToolbarButton.getAttribute('id');
		var strOnPopupShowing = 'return EBToolbarDesignManager_CT459487.OnTooltipPopupShowing(event,\''+strToolbarButtonID+'\');event.stopPropagation();';
		var objXULTooltip = EBXULFactory_CT459487.CreateTooltip(strTooltipID,strOrient,strOnPopupShowing);
		
		objMainPopupSet.appendChild(objXULTooltip);
	}
	
	
}


/*************************** Toolbar global object ******************************/
var EBToolbarData_CT459487 =
{
	ToolbarInstance		: null,
	
	ToolbarRTL			: false,
	
	ToolbarHomePage		: '',
	
	DefaultWebServerURL		: 'http://www.conduit.com/',
	
	DefaultMyWebServerURL	: 'http://my.conduit.com/',
	
	GeneralToolbarInfo	:
	{
		ToolbarPublisherMailTo	: '',
		ToolbarButtonStyle		: '',
		WebServerURL			: '',
		MyWebServerURL			: '',
		TellAFriendCmd			: '',
		
		
		UserComponentsState		: 
		{
			Weather			: true,
			EMailNotifier	: true,
			Privacy			: false
		}
	},
	
	IsHighlighting				: false,
	
	SearchTerm					: '',
	
	
	ToolbarComponents			: null,
	
	ToolbarSuggests				: null,
	
	Initialize : function()
	{	
		this.ToolbarInstance	= document.getElementById(EBGlobalConsts_CT459487.ToolbarId);
		this.ToolbarComponents	= new EBArrayHashObject_CT459487();
		
		this.ToolbarRTL			= EBActionManager_CT459487.IsToolbarRTL();
	}
}

var EBToolbarDesignConsts_CT459487 = 
{
	SubMenuRTLClass					: 'eb-submenu-rtl_CT459487',

	ToolbarButtonHideTextClass		: 'eb-toolbarbutton-hidetext_CT459487',
	
	ToolbarButtonShowTextClass		: 'eb-toolbarbutton-showtext_CT459487',
	
	ToolbarButtonMenuButtonClass	: 'eb-toolbarbutton-menubutton_CT459487',
	
	ToolbarButtonMenuClass			: 'eb-toolbarbutton-menu_CT459487',
	
	ToolbarButtonChevronClass		: 'eb-toolbarbutton-chevron_CT459487',
	
	ToolbarMenuButtonOnlyIconClass	: 'eb-toolbarbutton-menu-onlyicon_CT459487',
	
	ToolbarButtonOnlyIconClass		: 'eb-toolbarbutton-onlyicon_CT459487',
	
	ToolbarMaxImageHeightStyle		: 'max-height:25px;'
}



var EBToolbarDesignManager_CT459487 = 
{	
	//set toolbarbuttons class - according to their type
	//or shrink unshrink state of toolbar
	SetToolbarButtonClass : function(strCompID,XULToolbarButton)
	{
		var arrClassAttribute = new Array();
		
		var strLabel	= XULToolbarButton.getAttribute('label');
		var strImage	= XULToolbarButton.getAttribute('image');
		var strType		= XULToolbarButton.getAttribute('type');
		
		if(strType == 'menu-button')
		{
			arrClassAttribute[arrClassAttribute.length] = EBToolbarDesignConsts_CT459487.ToolbarButtonMenuButtonClass;
		}
		
		//check if this button is regular button with image only
		//to set to it the special css class that reduce the gap 
		//between the image edge to the toolbar 
		//it also check that this style will be set to only icon in toolbarbutton type=menubutton
		//to reduce that bug
		if(!strLabel && strImage)
		{
			if(strType == 'menu')
			{
				arrClassAttribute[arrClassAttribute.length] = EBToolbarDesignConsts_CT459487.ToolbarMenuButtonOnlyIconClass;
			}
			else
			{
				arrClassAttribute[arrClassAttribute.length] = EBToolbarDesignConsts_CT459487.ToolbarButtonOnlyIconClass;
			}
		}
		
		
		var strClassHideText = EBToolbarDesignConsts_CT459487.ToolbarButtonHideTextClass;
		var strClassShowText = EBToolbarDesignConsts_CT459487.ToolbarButtonShowTextClass;

		
		if(EBActionManager_CT459487.IsToolbarShrink())
		{	
			if(strLabel)
			{
				arrClassAttribute[arrClassAttribute.length] = strClassHideText;
				if(strType == 'menu')
				{
					arrClassAttribute[arrClassAttribute.length] = EBToolbarDesignConsts_CT459487.ToolbarMenuButtonOnlyIconClass;
				}
				else
				{
					arrClassAttribute[arrClassAttribute.length] = EBToolbarDesignConsts_CT459487.ToolbarButtonOnlyIconClass;
				}
			}
			
			this.SetTooltipShrink(strCompID,XULToolbarButton);
		} 
		else
		{
			if(strLabel)
			{
				arrClassAttribute[arrClassAttribute.length] = strClassShowText;
				if(strType == 'menu')//if there is label then set this class(padding the text class)
				{
					arrClassAttribute[arrClassAttribute.length] = EBToolbarDesignConsts_CT459487.ToolbarButtonMenuClass;
				}
			}
			
			this.SetTooltipUnShrink(XULToolbarButton);
		}
		
		var strClass = arrClassAttribute.join(' ');
		
		XULToolbarButton.setAttribute('class',strClass);
	},

	SetToolbarButtonGlobalStyle : function(objToolbarButton)
	{
		//i set the style of the button using the getAnonymousNodes of that button
		//this method return the core elements (low-level elements) of this xul element
		//and this way we can set the style only to them - and not to their dom childs!
		//if this regular button we need to set the xul:label Anonymous Node
		//if this toolbarbutton is from type menu-button we set the xul:toolbarbutton core element
		var strStyle			= EBToolbarData_CT459487.GeneralToolbarInfo.ToolbarButtonStyle;
		var objAnonymousNodes	= document.getAnonymousNodes(objToolbarButton);
		var objNode				= null;
		
		if(objAnonymousNodes)
		{
			for(var i=0;i<objAnonymousNodes.length;i++)
			{
				objNode = objAnonymousNodes[i];
				if(objNode.tagName == 'xul:toolbarbutton' || 
					objNode.tagName == 'xul:label')
				{
					objNode.setAttribute('style',strStyle);
				}
			}
		}
	},
	
	SetToolbarSearchBoxBGColor : function(objSearchBox,strBGColor)
	{
		if(strBGColor && strBGColor.toUpperCase() != '#FFFFFF')
		{
			var objAnonymousNodes	= document.getAnonymousNodes(objSearchBox);
			if(objAnonymousNodes)
			{
				var objNode				= null;
				for(var i=0;i<objAnonymousNodes.length;i++)
				{
					objNode = objAnonymousNodes[i];
					objNode.setAttribute('style','background-color:'+strBGColor+';');
				}
			}
		}
	},
	
	SetTooltipShrink : function(strCompID,XULToolbarButton)
	{
		if(this.IsSpecialTooltip(XULToolbarButton))
		{
			return;
		}
	
		//check if this toolbar need tooltip shrink
		var strLabel = XULToolbarButton.getAttribute('label');
		if(!strLabel)
		{
			return;
		}
		
		var strTooltipID	= EBComponentsManager_CT459487.GetTooltipID(strCompID);
	
		XULToolbarButton.setAttribute('tooltip',strTooltipID);
		XULToolbarButton.removeAttribute('tooltiptext');
	},
	
	SetTooltipUnShrink : function(XULToolbarButton)
	{
		if(this.IsSpecialTooltip(XULToolbarButton))
		{
			return;
		}
		XULToolbarButton.removeAttribute('tooltip');
		var strOriginalTooltip = XULToolbarButton.getAttribute(EBGlobalConsts_CT459487.Attributes.XULTooltip);
		if(strOriginalTooltip)
		{
			XULToolbarButton.setAttribute('tooltiptext',strOriginalTooltip);
		}
	},
	
	//function that checks if the toolbarbutton element is set to 
	//special tooltip to not set to it the shrink-unshrink tooltip - like the weather forecast tooltip
	IsSpecialTooltip : function(oXULToolbarButton)
	{
		var strTooltipID = oXULToolbarButton.getAttribute('tooltip');
		
		if(strTooltipID == EBWeatherGUIConsts_CT459487.ForecastTooltipID)
		{
			return true;
		}
		
		return false;
	},
	
	OnTooltipPopupShowing : function(event,strToolbarButtonID)
	{	
		
		if(event.eventPhase == 2)
		{
			var XULTooltip = event.target;
			var XULToolbarButton = document.getElementById(strToolbarButtonID);
			
			//check to see if the mouse is hover the toolbarbutton
			//to prevent this tooltip shown on this toolbar buttons childs
			if(!EBGlobalManager_CT459487.IsElementInScreenCoordinates(XULToolbarButton))
			{
				return false;
			}
			
			
			while(XULTooltip.childNodes.length > 0)
			{
				XULTooltip.removeChild(XULTooltip.firstChild);
			}
			
			var strOriginalTooltip	= XULToolbarButton.getAttribute(EBGlobalConsts_CT459487.Attributes.XULTooltip);
			var strLabel			= XULToolbarButton.getAttribute('label');
			
			var XULLabelButtonLabel = null;
			var XULLabelButtonTooltip = null;
			
			if(strLabel)
			{
				XULLabelButtonLabel		= EBXULFactory_CT459487.CreateLabel(strLabel,'');
			}
			if(strOriginalTooltip)
			{
				XULLabelButtonTooltip	= EBXULFactory_CT459487.CreateLabel(strOriginalTooltip,'');
			}
			
			if(XULLabelButtonLabel)
			{
				XULTooltip.appendChild(XULLabelButtonLabel);
			}
			if(XULLabelButtonTooltip)
			{
				XULTooltip.appendChild(XULLabelButtonTooltip);
			}
			
			return true;
		}
		
		return false;
	}
	
}

var EBExternalComponentConsts_CT459487 = 
{
	Attributes : 
	{
		ComponentURL		: 'EB_EXTERNAL_COMPONENT_URL',
		ComponentInterval	: 'EB_EXTERNAL_COMPONENT_INTERVAL'
	}
}


var EBExternalComponentManager_CT459487 = 
{
	Initialize : function(oToolbarComponent)
	{
		if(!oToolbarComponent.TimeoutID)
		{
			this.SetTimeoutCheck(oToolbarComponent);
		}
	},
	
	Terminate : function(oToolbarComponent)
	{
		if(oToolbarComponent.TimeoutID)
		{
			clearTimeout(oToolbarComponent.TimeoutID);
			oToolbarComponent.TimeoutID = null;
		}
	},

	GetComponent : function(objToolbarComponent,isForceCheck)
	{	
		try
		{
			if(isForceCheck || this.IsElapsed(objToolbarComponent))
			{
				this.CheckFromServer(objToolbarComponent);
			}
		}
		catch(ex){}
		finally
		{
			this.SetTimeoutCheck(objToolbarComponent);
		}
	},
	
	SetTimeoutCheck : function(objToolbarComponent)
	{
		var iInterval = this.GetIntervalTime(objToolbarComponent);
		
		var objIntervalFunction = function()
		{
			EBExternalComponentManager_CT459487.GetComponent(objToolbarComponent,false);
		};
		//set the timeout to call the next time
		objToolbarComponent.TimeoutID = setTimeout(objIntervalFunction,iInterval);
	},
	
	GetIntervalTime : function(objToolbarComponent)
	{
		var XULToolbarItem		= objToolbarComponent.XULElement;
		var iIntervalInMinute	= XULToolbarItem.getAttribute(EBExternalComponentConsts_CT459487.Attributes.ComponentInterval);
		var iIntervalTime		= 1000*60*iIntervalInMinute;
		
		return iIntervalTime;
	},
	
	CheckFromServer : function(objToolbarComponent)
    {
            this.SetComponentPrefPollDate(objToolbarComponent);    

            var XULToolbarItem            = objToolbarComponent.XULElement;
            var strURL                    = XULToolbarItem.getAttribute(EBExternalComponentConsts_CT459487.Attributes.ComponentURL);            
           
            var oCallBackFunction = function(strXML,o)
            {
                  var XMLDoc = EBGlobalManager_CT459487.GetXmlDocument(strXML);
                  EBExternalComponentManager_CT459487.ParseComponent(objToolbarComponent,XMLDoc);  
            };            

            EBGlobalManager_CT459487.HTTPServerRequest(strURL,null,false,oCallBackFunction);

     },
	
	IsElapsed : function(objToolbarComponent)
	{
		var strPrefName			= this.GetFullPrefName(objToolbarComponent);
		var strPrefDateValue	= EBToolbarPreferenceManager_CT459487.GetPref(strPrefName);
		
		if(!strPrefDateValue)
		{
			return true;
		}
		
		var objCurrentDate	= new Date();
		var objPollDate		= new Date(strPrefDateValue);
		
		var iCheckIntervalTime	= this.GetIntervalTime(objToolbarComponent);
		
		var iDateDiff  = objCurrentDate - objPollDate;
		
		return iDateDiff > iCheckIntervalTime;
	},
	
	SetComponentPrefPollDate : function(objToolbarComponent)
	{
		var strPrefName = this.GetFullPrefName(objToolbarComponent);
		var objCurrentDate = new Date();
		var strDateValue = objCurrentDate.toString();
		EBToolbarPreferenceManager_CT459487.SetPref(strPrefName,strDateValue);
	},
	
	GetFullPrefName : function(objToolbarComponent)
	{ 
		var strPrefNamePrefix	= EBPreferenceConsts_CT459487.ExternalComponentPrefix;
		var strCompID			= objToolbarComponent.ComponentItem.UniqueCompID;
		
		var strFullPrefName = strPrefNamePrefix + strCompID;
		
		return strFullPrefName;
	},
	
	ParseComponent : function(objToolbarComponent,XMLDoc)
	{
		if(!XMLDoc)
		{
			return;
		}
		
		var xmlDocumentElement = XMLDoc.documentElement;
		
		var objDynamicMenuItem = EBToolbarFactoryItem_CT459487.GetInstance(xmlDocumentElement,objToolbarComponent.ComponentItem.CompType);
		
		var objDynamicMenuComponent = EBToolbarFactoryComponent_CT459487.GetInstance(objDynamicMenuItem);
	
		var	XULToolbarItem		= objToolbarComponent.XULElement;
		
		if(objDynamicMenuComponent != null && objDynamicMenuComponent.Init())
		{
			//empty toolbar item
			while(XULToolbarItem.childNodes.length > 0)
			{
				XULToolbarItem.removeChild(XULToolbarItem.firstChild);
			}
			
			
			objDynamicMenuComponent.AddToToolbar(XULToolbarItem);
			
			//set the display Text & Icon
			objToolbarComponent.SetDisplayIconText(objDynamicMenuComponent);
		}
		
		//set the component to the external class
		objToolbarComponent.DynamicMenuComponent = objDynamicMenuComponent;
		

	}
}


//this class is ment for action on the firefox browser itself
//like the context-menu etc...

var EBFirefoxBrowserManager_CT459487 = 
{
	OnLoadWindow : function()
	{
		//set the context menu 
		this.SetContextMenuPopupShowingListener();
	},	
	
	//set event listener to popupshowing so we coulde catch
	//the change for the check uncheck of the toolbar from the toolbars
	//context menu of the browser itself
	SetContextMenuPopupShowingListener : function()
	{
		var oToolbarsContextMenu = document.getElementById('toolbar-context-menu');
		
		oToolbarsContextMenu.addEventListener('popupshowing',
									EBFirefoxBrowserManager_CT459487.OnPopupShowingToolbarContextMenu,
									false);
	},
	
	OnPopupShowingToolbarContextMenu : function(event)
	{
		var oToolbarsContextMenu = event.target;
		
		//set the listener for the command on this toolbar context menu item:
		
		//get the toolbar name for comparison
		var strToolbarLabel = EBToolbarData_CT459487.ToolbarInstance.getAttribute('toolbarname');
	
		var oMenuItem = null;
		//loop all the elments in the context menu till there 
		//is a match with the toolbar name and set to this menu item 
		//element the listener for the oncommand
		for(var i=0;i<oToolbarsContextMenu.childNodes.length;i++)
		{
			oMenuItem = oToolbarsContextMenu.childNodes[i];
			
			if(oMenuItem.getAttribute('label') == strToolbarLabel)
			{
				oMenuItem.addEventListener('command',
									EBFirefoxBrowserManager_CT459487.OnCommandToolbarContextMenuItem,
									false);
				break;
			}
		}	
	},
	
	OnCommandToolbarContextMenuItem : function(event)
	{
		var oMenuItem = event.target;
		
		var strChecked = oMenuItem.getAttribute('checked');
		
		if(strChecked)
		{
			strChecked = strChecked.toLowerCase();
		}
		
		if(strChecked == 'true')
		{
			EBLoadToolbar_CT459487();
		}
		else
		{
			EBUnloadToolbar_CT459487();
		}
		
	}
}
var EBHighlighterConsts_CT459487 = 
{	
	DisplayText	: 'Highlighter',
	
	HighlightButtonsContainerID : 'EBHighlighterButtonsContainer_CT459487',
	
	Images : 
	{
		Highlighter				: 'chrome://folkoteka.com/skin/highlighter.png',
		HighlighterChevron		: 'chrome://folkoteka.com/skin/highlighter_chevron.png',
		HighlighterDisabled		: 'chrome://folkoteka.com/skin/highlighterDisabled.png',
		HighlighterSearchTerm	: 'chrome://folkoteka.com/skin/highlighterSearchTerm.png'
	},
	
	Attributes : 
	{
		HighlightButtonName		: 'EB_HIGHLIGHT_BUTTON_ATT_NAME',
		HighlightButtonValue	: 'EB_HIGHLIGHT_BUTTON_ATT_VALUE',
		IsInChevron				: 'EB_HIGHLIGHTER_IS_IN_CHEVRON'
	}
}



var EBHighlighterManager_CT459487 = 
{	
	FindRange : Components.classes['@mozilla.org/embedcomp/rangefind;1'].
					createInstance().QueryInterface(Components.interfaces.nsIFind),
	
	COLORS : ['Yellow', 'Cyan', 'Fuchsia', 'Chartreuse', 'Dodgerblue'],
	
	SPAN_ID : 'EBSpanHighlighter',
	
	ARR_TERMS : null,
	
	
	OnCommandHighlighter : function(event)
	{
		EBToolbarData_CT459487.IsHighlighting = !EBToolbarData_CT459487.IsHighlighting;
		
		//get the object from the toolbar 
		var objXULHighlighterToolbarButton = EBSearchBoxManager_CT459487.GetHighlighterButtonOnToolbar();
		
		
		if(EBToolbarData_CT459487.IsHighlighting)
		{
			objXULHighlighterToolbarButton.setAttribute("checked",true);
			this.Highlight();
		}
		else
		{
			objXULHighlighterToolbarButton.setAttribute("checked",false);
			this.UnHighlight();
		}
		
		this.RequestHighlighterUsage(EBUsageConsts_CT459487.HIGHLIGHTER_BUTTON);
	},
	
	RequestHighlighterUsage : function(strParam1)
	{
		var strComponentID = EBComponentsConsts_CT459487.ComponentsID.Highlighter;
		
		//create the usage object
		var objUsage = new EBUsageObject_CT459487(strComponentID,
													EBUsageConsts_CT459487.HIGHLIGHTER,
													strParam1,
													'');
		//send the data
		objUsage.SendRequest();	
	},
	
	Highlight : function()
	{
		//get the value from the menulist textbox
		var xulMenuList = EBComponentsManager_CT459487.GetSearchBoxMenuList();
		
		if(xulMenuList)
		{
			var strSearchQuery = xulMenuList.value;
			
			this.ARR_TERMS = null;
			this.ARR_TERMS = this.GetTermsToHighlight(strSearchQuery);
			
			for(var i=0;i<this.ARR_TERMS.length;i++)
			{
				this.HighlightWindow(null,this.ARR_TERMS[i],this.COLORS[i % this.COLORS.length]);
			}
		}
	},
	
	UnHighlight : function()
	{
		this.ClearHighlight(null);
	},
	
	GetTermsToHighlight : function(strSearchQuery) 
	{
		var tokens = [];
		tokens = this.TokenizeSearchQuery(strSearchQuery);
		tokens = this.RemoveOperators(tokens);
		tokens = this.NormalizeSpacing(tokens);
		return this.RemoveAdjacentDuplicates(tokens);
	},
	
	TokenizeSearchQuery : function(input) 
	{	
		var tokens = [];
		var state = 0;
		for(var i = 0;i < input.length; ++ i) 
		{
			var ch = input[i];
			if(state == 0) 
			{
				if(ch == '"')
				{
					tokens.push(["", true]);
					state = 2
				}
				else if(!EBGlobalManager_CT459487.IsCharWhitespace(ch) && !EBGlobalManager_CT459487.IsCharPunctuation(ch))
				{
					tokens.push([ch, false]);
					state = 1;
				}
			}
			else if(state == 1) 
			{
				if(EBGlobalManager_CT459487.IsCharWhitespace(ch) || EBGlobalManager_CT459487.IsCharPunctuation(ch)) 
				{
					state = 0;
				}
				else 
				{
					tokens[tokens.length - 1][0] += ch;
				}
			}
			else if(state == 2) 
			{
				if(ch == '"') 
				{
					state = 0;
				}
				else 
				{
					tokens[tokens.length - 1][0] += ch;
				}
			}
		}
		return tokens;
	},

    RemoveOperators : function(tokens) 
    {
		var results = [];
		for(var i = 0;i < tokens.length; ++ i) 
		{
			var token = tokens[i][0];
			if(tokens[i][1]) 
			{
				if(token.length > 0) 
				{
					results.push(token);
				}
				continue;
			}
			if(token.toUpperCase() == "OR") 
			{
				continue;
			}
			if(token[0] == "-") 
			{
				continue;
			}
			if(token == "*" || (token == "/" || (token == "^" || token == "%"))) 
			{
				continue;
			}
			if(/\d+\.\.\.\d+/.test(token)) 
			{
				continue;
			}
			if(token[0] == "~") 
			{
				token = token.substring(1);
			}
			token = token.replace(/-+/g, " ");
			results.push(token);
		}
		return results;
	},
	
	NormalizeSpacing : function(tokens) 
	{
		var results = [];
		for(var i = 0;i < tokens.length; ++ i)
		{
			var token = tokens[i];
			token = token.replace(/^\s+/, "");
			token = token.replace(/\s+$/, "");
			token = token.replace(/\s+/g, " ");
			if(token.length > 0) 
			{
				results.push(token);
			}
		}
		return results;
	},

	RemoveAdjacentDuplicates : function(list)
	{
		if(list.length == 0)
		{
			return list;
		}
		var last = 0;
		for(var i = 1;i < list.length; ++ i) 
		{
			if(list[i] != list[last]) 
			{
				list[ ++ last] = list[i];
			}
		}
		list.length = last + 1;
		return list;
	},
	
	IsNodeInputNodeOrChildOf : function(node) 
	{
		if(node.nodeName.toUpperCase() == "INPUT")
			return true;
		if(node.parentNode != null)
			return this.IsNodeInputNodeOrChildOf(node.parentNode);
		return false;
	},
	
	HighlightWindow : function(win,text,color) 
	{
		
		if(!win)
			win = window._content;

		if(win.frames != null) 
		{
			for(var i = 0;i < win.frames.length;i ++ )
			{
				this.HighlightWindow(win.frames[i], text, color);

			}
		}
		var doc = win.document;
		if(doc != null) 
		{
			var body = doc.body;
			if(body != null) 
			{
				var docRange = doc.createRange();
				docRange.selectNode(body);
				var startRange = docRange.cloneRange();
				startRange.collapse(true);
				var stopRange = docRange.cloneRange();
				stopRange.collapse(false);
				

				this.FindRange.caseSensitive = false;
				this.FindRange.findBackwards = false;
				var result = this.FindRange.Find(text, docRange, startRange, stopRange);
				while(null != result) 
				{
					if(result.endContainer != null && (result.startContainer != null && (result.endContainer.nodeType == Node.TEXT_NODE && (result.startContainer.nodeType == Node.TEXT_NODE && (!this.IsNodeInputNodeOrChildOf(result.startContainer) && !this.IsNodeInputNodeOrChildOf(result.endContainer))))))
					{
						var startChar = null;
						if(result.startOffset > 0) 
						{
							startChar = result.startContainer.nodeValue.charAt(result.startOffset - 1)
						}
						var endChar = result.endContainer.nodeValue.charAt(result.endOffset);
						if(!EBGlobalManager_CT459487.IsWordCharacter(startChar) && !EBGlobalManager_CT459487.IsWordCharacter(endChar)) 
						{
							var spanNode = this.SetHighlight(result, color, this.SPAN_ID);
							startRange.selectNode(spanNode);
						}
						else 
						{
							startRange = result
						}
					}
					else 
					{
						startRange = result
					}
				
					startRange.collapse(false);
					result = this.FindRange.Find(text, docRange, startRange, stopRange)
				}

			}
		}
		  
	},
	
	SetHighlight : function(range, color, id)
	{
		var startContainer = range.startContainer;
		var spanNode = startContainer.ownerDocument.createElement("span");
		spanNode.style.backgroundColor = color;
		spanNode.style.color = "black";
		spanNode.id = id;
		var docfrag = range.extractContents();
		spanNode.appendChild(docfrag);
		range.insertNode(spanNode);
		return spanNode;
	},

	ClearHighlight : function(win)
	{

		if(!win)
			win = window._content;

		var i=0; // Avoid multiple redeclaration warnings

		for(i=0; win.frames && i < win.frames.length; i++)
		{
			this.ClearHighlight(win.frames[i]);
		}

		var doc = win.document;
		if(!doc) { return; }
		var body = doc.body;
		if(!body) { return; }

		var count = body.childNodes.length;

		for(i=0; i < this.ARR_TERMS.length; i++)
		{
			var term = this.ARR_TERMS[i];

			var searchRange = doc.createRange();
			searchRange.setStart(body, 0);
			searchRange.setEnd(body, count);

			var startPt = doc.createRange();
			startPt.setStart(body, 0);
			startPt.setEnd(body, 0);

			var endPt = doc.createRange();
			endPt.setStart(body, count);
			endPt.setEnd(body, count);

			var retRange = null;
			while((retRange = this.FindRange.Find(term, searchRange, startPt, endPt)))
			{
				var startContainer = retRange.startContainer;
				var elem = null;
				try { elem = startContainer.parentNode; } catch (e) { }
				if(elem)
				{
					// Avoid multiple redeclaration warnings
					var docfrag = null;
					var child = null;
					var next = null;
					var parent = null;

					if(elem.getAttribute("id") == this.SPAN_ID)
					{
						docfrag = doc.createDocumentFragment();
						next = elem.nextSibling;
						parent = elem.parentNode;

						while((child = elem.firstChild)) 
						{
							docfrag.appendChild(child);
						}

						startPt = doc.createRange();
						startPt.setStartAfter(elem);

						parent.removeChild(elem);
						parent.insertBefore(docfrag, next);
					}
					else
					{
						try {
							while((elem = elem.parentNode))
							{
								if(elem.getAttribute("id") == this.SPAN_ID)
								{
									docfrag = doc.createDocumentFragment();
									next = elem.nextSibling;
									parent = elem.parentNode;

									while((child = elem.firstChild)) 
									{
										docfrag.appendChild(child);
									}

									startPt = doc.createRange();
									startPt.setStartAfter(elem);

									parent.removeChild(elem);
									parent.insertBefore(docfrag, next);
									break;
								}
							}
						} catch(e) {}
						startPt = doc.createRange();
						startPt.setStart(retRange.endContainer, retRange.endOffset);
					}
				}
				else
				{
					startPt = doc.createRange();
					startPt.setStart(retRange.endContainer, retRange.endOffset);
				}

				startPt.collapse(true);
			}
		}
	
	},
	
	OnCommandSearchTerm : function(event)
	{
		var strTerm = event.target.getAttribute("label");
		
		//if shift key is pressed the search going backwards
		this.FindSingleTerm(strTerm,!event.shiftKey);
		
		
		this.RequestHighlighterUsage(EBUsageConsts_CT459487.HIGHLIGHTER_MENU_ITEM);
	},	
	
	FindSingleTerm : function(text, forward)
	{

		
		if(getBrowser().findString == text)
		{
			if(forward)
			{
				findNext();
			}
			else 
			{
				findPrevious();
			}
		}
		else 
		{

			find(text);
			if(!forward) 
			{
				findPrevious();
			}
		}
	},
	
	AddHighlightButtonToChevron : function(objXULElement,objXULContainer)
	{
		//get the toolbarbutton
		var objXULButton = objXULElement.firstChild;
		if(objXULButton)
		{
			var strLabel	=	objXULButton.getAttribute('label');
			var strImage	= 	objXULButton.getAttribute('image');
			var strCommand	=	objXULButton.getAttribute('oncommand');
			
			//create the element of chevron
			var XULChevronElement = EBXULFactory_CT459487.CreateMenuItem(strLabel,
																		strImage,
																		'',
																		strCommand,
																		'',
																		null);
		
			objXULContainer.appendChild(XULChevronElement);
		}
	},
	
	GetHighlightButtons : function()
	{
		var strSpecialAttributeName		= EBHighlighterConsts_CT459487.Attributes.HighlightButtonName;
		var strSpecialAttributeValue	= EBHighlighterConsts_CT459487.Attributes.HighlightButtonValue;
		
		var objToolbarElement			= EBToolbarData_CT459487.ToolbarInstance;
		var XULHighlightButtons			= objToolbarElement.getElementsByAttribute(strSpecialAttributeName,strSpecialAttributeValue);
		
		return XULHighlightButtons;
	},
	
	IsHighlightButtons : function()
	{
		var XULHighlightButtons = this.GetHighlightButtons();
		
		return XULHighlightButtons.length > 0 ? true : false;
	},
	
	SetHighlightButtons : function(XULSearchBox)
	{
		var strSearchQuery = XULSearchBox.value;
		
		var XULHighlighter = EBSearchBoxManager_CT459487.GetHighlighterButtonOnToolbar();
	
		//check if the highlighter exists on the toolbar and if not return
		if(!XULHighlighter)
		{
			return;
		}
		
		//set the highlighter state
		if(EBGlobalManager_CT459487.TotalTrim(strSearchQuery) == '')
		{
			XULHighlighter.setAttribute('disabled','true');
			XULHighlighter.setAttribute('image',EBHighlighterConsts_CT459487.Images.HighlighterDisabled);
		}
		else
		{
			XULHighlighter.setAttribute('disabled','false');
			XULHighlighter.setAttribute('image',EBHighlighterConsts_CT459487.Images.Highlighter);
		}
		
		var arrSearchTerms = EBHighlighterManager_CT459487.GetTermsToHighlight(strSearchQuery);
		
		
		
		
		var objToolbarElement			= EBToolbarData_CT459487.ToolbarInstance;
		
		var XULHighlightButtons			= this.GetHighlightButtons();
		
		//empty the buttons
		while(XULHighlightButtons.length > 0)
		{
			objToolbarElement.removeChild(XULHighlightButtons[0]);
			XULHighlightButtons			= this.GetHighlightButtons();
		}
		
		var XULToolbarItem					= null;
		var XULHighlightButton				= null;
		var strCommand						= 'EBHighlighterManager_CT459487.OnCommandSearchTerm(event);';
		var strHighlighterSearchTermImage	= EBHighlighterConsts_CT459487.Images.HighlighterSearchTerm;
		var strSearchTerm					= '';
		
		var strSpecialAttributeName		= EBHighlighterConsts_CT459487.Attributes.HighlightButtonName;
		var strSpecialAttributeValue	= EBHighlighterConsts_CT459487.Attributes.HighlightButtonValue;
		
		
		
		for(var i=0;i<arrSearchTerms.length;i++)
		{
			strSearchTerm = arrSearchTerms[i];
			
			XULHighlightButton = EBXULFactory_CT459487.CreateToolbarButton('',
																	'',
																	strSearchTerm,
																	strHighlighterSearchTermImage,
																	'',
																	strCommand,
																	'');
			
			//set special attribute to identify the highligh buttons(inside the toolbaritem)
			//and retrieve only them in an array
			XULToolbarItem = EBXULFactory_CT459487.CreateToolbarItem();
			XULToolbarItem.setAttribute(strSpecialAttributeName,strSpecialAttributeValue);
			
			XULToolbarItem.appendChild(XULHighlightButton);
			
			//add this button element to the toolbar(toolbaritem -> toolbarbutton)
			//add it before the last element of the toolbar - XULPostToolbarItem
			objToolbarElement.insertBefore(XULToolbarItem,EBToolbarBuilder_CT459487.XULPostToolbarItem);
			
			//set the global style to the highlight button
			EBToolbarDesignManager_CT459487.SetToolbarButtonGlobalStyle(XULHighlightButton);
		}
		
		EBChevronManager_CT459487.SetChevron(null);
	}
}


var EBInitializeToolbarManager_CT459487 = 
{
	
	GetSetupFinishURL : function()
	{
		var strSetupFinish = EBActionManager_CT459487.GetMyWebServerURL() +
								'setupfinish.aspx' +
								'?toolbarid=' + EBGlobalConsts_CT459487.ToolbarCTID;
	
		return strSetupFinish;
	},
	
	GetInitializePrefName : function()
	{
		var strInitializePrefName = EBPreferenceConsts_CT459487.Initialize;
		return 	strInitializePrefName;
	},

	IsFirstRun : function()
	{
		var strInitializePrefName = this.GetInitializePrefName();
		//if there isn't any value in this pref it's first time load
		return !EBToolbarPreferenceManager_CT459487.HasUserValue(strInitializePrefName);
		
	},
	
	SetInitializePref : function()
	{
		var strInitializePrefName =  this.GetInitializePrefName();
		EBToolbarPreferenceManager_CT459487.SetPref(strInitializePrefName,true);
	},	
	
	Initialize : function()
	{	
		//chekc if there is any value in this pref and if not this is the first initialization
		if(this.IsFirstRun())
		{	
			//set the init pref
			this.SetInitializePref();
			
			this.LoadSetupFinishPage();
		}
	},
	
	LoadSetupFinishPage : function()
	{
		//open the setup finish page
		var strSetupFinish = EBInitializeToolbarManager_CT459487.GetSetupFinishURL();
		EBLinkManager_CT459487.LoadLinkURL(null,strSetupFinish,true,null);
	}
}





var EBLinkManager_CT459487 = 
{
	//all calls for link loads from any place should be done with this function!
	LoadLinkURL : function(oEvent,strURL,bIsInNewTab,strPostParams)
	{
		//check validation of the url
		if(!strURL || strURL.toLowerCase() == EBGlobalConsts_CT459487.HTTP_PREFIX)
		{
			return;
		}
	
	
		//check if the click is from middle button to open in a new tab
		if(oEvent && oEvent.button == 1)
		{
			bIsInNewTab = true;
		}
		
		//check for post
		if(strPostParams)
		{
			this.LoadURLPostData(strURL,strPostParams,bIsInNewTab);
		}
		else
		{
			if(bIsInNewTab)
			{
				EBGlobalManager_CT459487.LoadURLInNewTab(strURL);
			}
			else
			{
				EBGlobalManager_CT459487.LoadURL(strURL);
			}
		}
	},
	
	LoadURLPostData : function(strPostURL,strPostParams,bIsInNewTab)
	{
		
		var objMimeStream = EBGlobalManager_CT459487.SetupMimeStream(strPostParams);
		
		if(bIsInNewTab)
		{
			//first load a blank tab
			EBGlobalManager_CT459487.LoadURLInNewTab('');
		}
		
		//login to the url using the mimeStream
		getBrowser().webNavigation.loadURI(strPostURL,
											Components.interfaces.nsIWebNavigation.LOAD_FLAGS_NONE,
											null,
											objMimeStream,
											null);
	}
	
}
function EBLoadToolbar_CT459487()
{	
	
	//check if the toolbar intialized properly to activate the 
	//toolbar laod mechanism
	if(EBActionManager_CT459487.IsToolbarShown())
	{
		//add to main window progressive listener
		window.getBrowser().addProgressListener(EBMainBrowserListener_CT459487);
	
		//messaging to the server
		EBServerCommunicationManager_CT459487.OnLoadToolbar();
	}
}






//progressive listener of the main browser (actually the all toolbar)
var EBMainBrowserListener_CT459487 =
{
  QueryInterface: function(aIID)
  {
   if (aIID.equals(Components.interfaces.nsIWebProgressListener) ||
       aIID.equals(Components.interfaces.nsISupportsWeakReference) ||
       aIID.equals(Components.interfaces.nsISupports))
     return this;
   throw Components.results.NS_NOINTERFACE;
  },
  
  onStateChange: function(aProgress, aRequest, aFlag, aStatus)
  { 
	   var strURL = '';
	   if(aRequest)
	   {
			strURL = aRequest.name;
	   }
	   
	   if(aFlag & Components.interfaces.nsIWebProgressListener.STATE_IS_DOCUMENT)
	   {
			EBActionManager_CT459487.SetMainFrameURL(strURL);
	   }
	   if(aFlag & Components.interfaces.nsIWebProgressListener.STATE_START)
	   {
			EBBrowserComponentApiManager_CT459487.NavigateCompleteEvent();
	   }
	   if(aFlag & Components.interfaces.nsIWebProgressListener.STATE_STOP)
	   {
			EBActionManager_CT459487.DocumentComplete();
	   }
	
	  return 0;
  },

  onLocationChange: function(aProgress, aRequest, aURI)
  {
		// This fires when the location bar changes i.e load event is confirmed
	   // or when the user switches tabs
	  
		var strURL = aURI.spec;
		
		EBActionManager_CT459487.SetMainFrameURL(strURL);
	   
		//check suggests keywords
		EBSuggestsManager_CT459487.CheckSuggests();
		
		//check the toolbar api
		EBToolbarApiManager_CT459487.CheckPage(getBrowser());
		
		//check generic(landingpage.aspx)
		if(EBActionManager_CT459487.IsToolbarGeneric())
		{
			EBGenericManager_CT459487.CheckLandingPage(strURL);
		}
	   

	   return 0;
  },

  // For definitions of the remaining functions see XulPlanet.com
  onProgressChange: function() {return 0;},
  onStatusChange: function() {return 0;},
  onSecurityChange: function(aProgress, aRequest, aState) 
  {
		//check the toolbar api
		EBToolbarApiManager_CT459487.CheckPage(getBrowser());
		return 0;
  },
  onLinkIconAvailable: function() {return 0;}
} 










var EBObserversManager_CT459487 = 
{
	NSIObserverService	: Components.classes["@mozilla.org/observer-service;1"].getService(Components.interfaces["nsIObserverService"]),
	
	Register : function()
	{
		//add installation observer
		EBInstallationObserver_CT459487.register();
	},
	
	UnRegister : function()
	{
		//remove installation observer
		EBInstallationObserver_CT459487.unregister();
	}
}




//observe the installation process of the extensions
//trigger when:
//install extension
//uninstall extension
//enable extension
//disable extension
//upgrade extension
//cancel extension

var EBInstallationObserver_CT459487 = 
{
	ACTION_REQUESTED_TOPIC       : "em-action-requested",
	ITEM_INSTALLED               : "item-installed",
	ITEM_UPGRADED                : "item-upgraded",
	ITEM_UNINSTALLED             : "item-uninstalled",
	ITEM_ENABLED                 : "item-enabled",
	ITEM_DISABLED                : "item-disabled",
	ITEM_CANCEL                  : "item-cancel-action",
	
	
	register : function()
	{
		EBObserversManager_CT459487.NSIObserverService.addObserver(this, this.ACTION_REQUESTED_TOPIC , false);	
	},
	
	unregister : function()
	{
		EBObserversManager_CT459487.NSIObserverService.removeObserver(this, this.ACTION_REQUESTED_TOPIC);		
	},
	
	observe: function(aSubject, aTopic, aData)
	{	
		try 
		{
			if(aData == this.ITEM_UNINSTALLED)
			{
				var objExtensionItem = aSubject.QueryInterface(Components.interfaces.nsIUpdateItem); 
			
				if(objExtensionItem.id ==  EBGlobalConsts_CT459487.GUID)
				{
					EBUninstallManager_CT459487.PostUninstallToolbar();
				}
			}
			
		} 
		catch(err){}
	}
};


var EBToolbarBuilder_CT459487 = 
{
	XULPostToolbarItem : null,

	ParseToolbarXML : function(xmlToolbarSettings)
	{
		var arrXmlFloatMenuItems 	= new Array();
		var xmlLogoIcon 			= null;
		
		//collect the main menu for the additional add-ins
		var mainMenuItem			= null;

		var XMLUserSettings			= null;
		
		var arrHashToolbarItems		= new EBArrayHashObject_CT459487();
		
		//nullify the global style:
		EBToolbarData_CT459487.GeneralToolbarInfo.ToolbarButtonStyle = "";
				
		
		for(var i=0;i<xmlToolbarSettings.childNodes.length;i++)
		{
			
			if(xmlToolbarSettings.childNodes[i].tagName == "LOGOICON")
			{
				xmlLogoIcon = xmlToolbarSettings.childNodes[i];
			}
			else if(xmlToolbarSettings.childNodes[i].tagName == "MENUITEM")
			{
				arrXmlFloatMenuItems[arrXmlFloatMenuItems.length] = xmlToolbarSettings.childNodes[i];
			}
			else if(xmlToolbarSettings.childNodes[i].tagName == "GENERAL_TOOLBAR_INFO")
			{
				this.BuildToolbarGeneralInfo(xmlToolbarSettings.childNodes[i]);
			}
			else if(xmlToolbarSettings.childNodes[i].tagName == "USER_SETTINGS")
			{
				XMLUserSettings = xmlToolbarSettings.childNodes[i];
			}
			else
			{
				var objToolbarItem = EBToolbarFactoryItem_CT459487.GetInstance(xmlToolbarSettings.childNodes[i],EBComponentsConsts_CT459487.ComponentsType.Settings);
				if(objToolbarItem)
				{
					
					arrHashToolbarItems.Add(objToolbarItem.UniqueCompID,objToolbarItem);
					
					//check to save the main_menu dynamic menu:
					if(objToolbarItem instanceof EBDynamicMenuItem_CT459487)
					{
						if(objToolbarItem.button.type == "MAIN_MENU")
						{
							mainMenuItem = objToolbarItem;
						}
					}
				}
			}
		}
		
		//set the additional attributes for the main menu item
		if(mainMenuItem != null)
		{
			for(var j=0;j<xmlLogoIcon.childNodes.length;j++)
			{
				if(xmlLogoIcon.childNodes[j].tagName == "TOOLTIP")
				{
					mainMenuItem.button.tooltip	= EBGlobalManager_CT459487.GetXmlNodeValue(xmlLogoIcon.childNodes[j]);
				}
				else if(xmlLogoIcon.childNodes[j].tagName == "LINK")
				{
					mainMenuItem.link = EBGlobalManager_CT459487.GetXmlNodeValue(xmlLogoIcon.childNodes[j]);
					mainMenuItem.link = EBGlobalManager_CT459487.LegalizeLinkUrl(mainMenuItem.link);
					//set the homepage to the toolbar object
					EBToolbarData_CT459487.ToolbarHomePage = mainMenuItem.link;
				}
				else if(xmlLogoIcon.childNodes[j].tagName == "PATH")
				{
					mainMenuItem.button.image = EBGlobalManager_CT459487.GetXmlNodeValue(xmlLogoIcon.childNodes[j]);
				}
			}
			//set the float menu items
			mainMenuItem.arrXmlFloatMenuItems = arrXmlFloatMenuItems;
		}
		
		//before building the components check with the user settings 
		//to add the user settings components that won't added by the publisher to the toolbar:
		if(XMLUserSettings)
		{
			this.BuildToolbarUserSettings(XMLUserSettings,arrHashToolbarItems);
		}
		
		this.BuildToolbarThirdParty(arrHashToolbarItems);
		
		this.BuildToolbarComponents(arrHashToolbarItems.IndexerArray);
	},
	
	BuildToolbarGeneralInfo : function(XMLGeneralInfo)
	{
		for(var i=0;i<XMLGeneralInfo.childNodes.length;i++)
		{
			if(XMLGeneralInfo.childNodes[i].tagName == "WRITE_TO_US_CMD")
			{
				EBToolbarData_CT459487.GeneralToolbarInfo.ToolbarPublisherMailTo = EBGlobalManager_CT459487.GetXmlNodeValue(XMLGeneralInfo.childNodes[i]);
			}
			else if(XMLGeneralInfo.childNodes[i].tagName == "FONT")
			{
				var FONT_XML = XMLGeneralInfo.childNodes[i];
				
				var strButtonStyle = "";
				
				for(j=0;j<FONT_XML.childNodes.length;j++)
				{
					if(FONT_XML.childNodes[j].tagName == "FONT_NAME")
					{
						var strFontName = EBGlobalManager_CT459487.GetXmlNodeValue(FONT_XML.childNodes[j]);
						strFontName = strFontName.toLowerCase();
						strButtonStyle += "font-family:"+strFontName+";";
					}
					else if(FONT_XML.childNodes[j].tagName == "BOLD")
					{
						var strBold = EBGlobalManager_CT459487.GetXmlNodeValue(FONT_XML.childNodes[j]);
						if(strBold.toUpperCase() == "TRUE")
						{
							strButtonStyle += "font-weight:bold;";
						}
						
					}
					else if(FONT_XML.childNodes[j].tagName == "UNDERLINED")
					{
						var strUnderlined = EBGlobalManager_CT459487.GetXmlNodeValue(FONT_XML.childNodes[j]);
						if(strUnderlined.toUpperCase() == "TRUE")
						{
							strButtonStyle += "text-decoration:underline;";
						}
						
					}
					else if(FONT_XML.childNodes[j].tagName == "ITALIC")
					{
						var strItalic = EBGlobalManager_CT459487.GetXmlNodeValue(FONT_XML.childNodes[j]);
						if(strItalic.toUpperCase() == "TRUE")
						{
							strButtonStyle += "font-style:italic;";
						}
					}
					else if(FONT_XML.childNodes[j].tagName == "SIZE")
					{
						var strSize = EBGlobalManager_CT459487.GetXmlNodeValue(FONT_XML.childNodes[j]);
						if(strSize && isFinite(strSize))
						{
							strButtonStyle += "font-size:"+strSize+"pt;";
						}
					}
					else if(FONT_XML.childNodes[j].tagName == "COLOR")
					{
						var strColor = EBGlobalManager_CT459487.GetXmlNodeValue(FONT_XML.childNodes[j]);
						strColor = strColor.toLowerCase();
						strButtonStyle += "color:"+strColor+";";
					}
					
				}
				
				EBToolbarData_CT459487.GeneralToolbarInfo.ToolbarButtonStyle = strButtonStyle;
				 
			}
			else if(XMLGeneralInfo.childNodes[i].tagName == "WEB_SERVER_URL")
			{
				EBToolbarData_CT459487.GeneralToolbarInfo.WebServerURL = EBGlobalManager_CT459487.GetXmlNodeValue(XMLGeneralInfo.childNodes[i]);
			}
			else if(XMLGeneralInfo.childNodes[i].tagName == "MY_WEB_SERVER_URL")
			{
				EBToolbarData_CT459487.GeneralToolbarInfo.MyWebServerURL = EBGlobalManager_CT459487.GetXmlNodeValue(XMLGeneralInfo.childNodes[i]);
			}
			else if(XMLGeneralInfo.childNodes[i].tagName == "TELL_A_FRIEND")
			{
				var TELL_A_FRIEND_XML = XMLGeneralInfo.childNodes[i];
				for(var j=0;j<TELL_A_FRIEND_XML.childNodes.length;j++)
				{
					if(TELL_A_FRIEND_XML.childNodes[j].tagName == "CMD")
					{
						EBToolbarData_CT459487.GeneralToolbarInfo.TellAFriendCmd = EBGlobalManager_CT459487.GetXmlNodeValue(TELL_A_FRIEND_XML.childNodes[j]);
					}
				}
			}
			else if(XMLGeneralInfo.childNodes[i].tagName == "USER_COMPONENTS_STATE")
			{
				var XMLUserComponentsState = XMLGeneralInfo.childNodes[i];
				var strValue	= '';
				var bValue		= true;
				for(var j=0;j<XMLUserComponentsState.childNodes.length;j++)
				{
					if(XMLUserComponentsState.childNodes[j].tagName == "WEATHER")
					{
						strValue = EBGlobalManager_CT459487.GetXmlNodeValue(XMLUserComponentsState.childNodes[j]);
						if(strValue)
						{
							bValue   = strValue.toLowerCase() == 'false' ? false : true;
							EBToolbarData_CT459487.GeneralToolbarInfo.UserComponentsState.Weather = bValue;
						}
					}
					else if(XMLUserComponentsState.childNodes[j].tagName == "EMAIL_NOTIFIER")
					{
						strValue = EBGlobalManager_CT459487.GetXmlNodeValue(XMLUserComponentsState.childNodes[j]);
						if(strValue)
						{
							bValue   = strValue.toLowerCase() == 'false' ? false : true;
							EBToolbarData_CT459487.GeneralToolbarInfo.UserComponentsState.EMailNotifier = bValue;
						}
					}
					else if(XMLUserComponentsState.childNodes[j].tagName == "PRIVACY_COMPONENT")
					{
						strValue = EBGlobalManager_CT459487.GetXmlNodeValue(XMLUserComponentsState.childNodes[j]);
						if(strValue)
						{
							bValue   = strValue.toLowerCase() == 'false' ? false : true;
							EBToolbarData_CT459487.GeneralToolbarInfo.UserComponentsState.Privacy = bValue;
						}
					}
				}
			}
		}
	},
	
	//checks which component from the user settings need to be add to the 
	//items array 
	BuildToolbarUserSettings : function(XMLUserSettings,arrHashToolbarItems)
	{
		var XMLNode = null;
		for(var i=0;i<XMLUserSettings.childNodes.length;i++)
		{
			XMLNode = XMLUserSettings.childNodes[i];
			
			var objToolbarItem = EBToolbarFactoryItem_CT459487.GetInstance(XMLNode,EBComponentsConsts_CT459487.ComponentsType.Settings);
			
			if(objToolbarItem)
			{
				//check if this item is not in the arrayHash only then add it the array
				var strHashKeyID = 	objToolbarItem.UniqueCompID;
				
				if(!arrHashToolbarItems.Contains(strHashKeyID))
				{
					arrHashToolbarItems.Add(strHashKeyID,objToolbarItem);
				}
			}
		}
	},
	
	BuildToolbarThirdParty : function(arrHashToolbarItems)
	{
		var XMLThirdPartyComponents = EBServerCommunicationManager_CT459487.LoadThirdPartyComponentsXML();
	
		var XMLNode = null;
		for(var i=0;i<XMLThirdPartyComponents.childNodes.length;i++)
		{
			XMLNode = XMLThirdPartyComponents.childNodes[i];
			var oToolbarItem = EBToolbarFactoryItem_CT459487.GetInstance(XMLNode,EBComponentsConsts_CT459487.ComponentsType.ThirdParty);
			if(oToolbarItem)
			{
				arrHashToolbarItems.Add(oToolbarItem.UniqueCompID,oToolbarItem);
			}
		}
	},
	
	BuildToolbarComponents : function(arrToolbarItems)
	{
		//clear all the current toolbar components
		EBToolbarData_CT459487.ToolbarComponents.Clear();
		
		
		var objToolbarItem = null;
		var objToolbarComponent = null;
		
		for(var i=0;i<arrToolbarItems.length;i++)
		{
			
			objToolbarItem		= arrToolbarItems[i];
			
			objToolbarComponent = EBToolbarFactoryComponent_CT459487.GetInstance(objToolbarItem);

			if(objToolbarComponent != null && objToolbarComponent.Init())
			{
				EBToolbarData_CT459487.ToolbarComponents.Add(objToolbarComponent.ComponentItem.UniqueCompID,objToolbarComponent);
			}
		}
		
		this.BuildToolbar(true);
		
		//check initialization
		EBInitializeToolbarManager_CT459487.Initialize();
	},
	
	BuildToolbar : function(isFirstTime)
	{
		var objToolbarElement = EBToolbarData_CT459487.ToolbarInstance;
		if(objToolbarElement)
		{
			var objToolbarContainer = objToolbarElement;
			
			//Nullify container(empty the toolbar)
			while(objToolbarContainer.childNodes.length > 0 )
			{
				objToolbarContainer.removeChild(objToolbarContainer.firstChild);
			}
			
			var objToolbarComponent = null;
			
			var iCount = EBToolbarData_CT459487.ToolbarComponents.Count();
			

			for(var i=0;i<iCount;i++)
			{
				objToolbarComponent = EBToolbarData_CT459487.ToolbarComponents.GetByIndex(i);
				
				//check if to show this components
				if(EBComponentsManager_CT459487.IsShowComponent(objToolbarComponent))
				{
					objToolbarComponent.AddToToolbar(objToolbarContainer);
					

					if(objToolbarComponent instanceof EBBrowserComponent_CT459487)
					{
						//add the progressive listener to the browser component
						//right after this browser component added to the toolbar
						//to set on time is load event
						if(!EBGlobalManager_CT459487.IsNewestBrowserAPI())
						{
							var strBCID = objToolbarComponent.ComponentItem.strId;
							EBBrowserComponentManager_CT459487.SetProgressiveListener(strBCID);
						}
					}

				}
				else
				{
					objToolbarComponent.UnloadComponent();
				}
				
			}
			
			this.BuildPostToolbar(objToolbarContainer)
			
			//set the main frame url for the browser component api
			EBBrowserComponentApiManager_CT459487.SetMainFrameUrl(EBGlobalVariables_CT459487.MainFrameURL);
			
			//check to save search term
			EBActionManager_CT459487.SetToolbarSearchTerm(EBToolbarData_CT459487.SearchTerm);
			
			//call to set chevron in a different thread
			this.SetChevron(isFirstTime);
		}

	},
	
	BuildPostToolbar : function(objToolbarContainer)
	{
		//create the post element of the toolbar(toolbaritem)
		//this element is for sizing the toolbar(rtl toolbars mainly)
		this.XULPostToolbarItem = EBXULFactory_CT459487.CreateToolbarItem();
		this.XULPostToolbarItem.setAttribute("pack","end");
		this.XULPostToolbarItem.setAttribute("flex","1");
		
		objToolbarContainer.appendChild(this.XULPostToolbarItem);
	},
	
	SetChevron : function(isFirstTime)
	{
		var iTimeout = 100;
		if(isFirstTime)
		{
			iTimeout = 1000;
		}
		var objThreadFunction = function()
		{			
			//call the chevron calculation
			EBChevronManager_CT459487.SetChevron(null,isFirstTime);
		};
		setTimeout(objThreadFunction,iTimeout);
	}
}


var EBToolbarFactoryItem_CT459487 = 
{
	GetInstance : function(xmlSettingsNode,strCompType)
	{
		switch(xmlSettingsNode.tagName)
		{
			case "DYNAMIC_MENU":
				return new  EBDynamicMenuItem_CT459487(xmlSettingsNode,strCompType);
			case "LINK_BUTTONITEM":
				return new  EBButtonItem_CT459487(xmlSettingsNode,strCompType);
			case "SPECIAL_COMMAND_ITEM":
				return new  EBButtonItem_CT459487(xmlSettingsNode,strCompType);
			case "BROWSER_COMPONENT":
				return new  EBBrowserItem_CT459487(xmlSettingsNode,strCompType);
			case "SEARCH":
				return new  EBSearchBoxItem_CT459487(xmlSettingsNode,strCompType);
			case "HIGHLIGHTER":
				return new	EBHighlighterItem_CT459487(xmlSettingsNode,strCompType);
			case "RSS_FEED_ITEM":
				return new EBFeedItem_CT459487(xmlSettingsNode,strCompType);
			case "SEPERATORITEM":
				return new EBSeparatorItem_CT459487(xmlSettingsNode,strCompType);
			case "PRIVACY_COMPONENT":
				return new EBPrivacyItem_CT459487(xmlSettingsNode,strCompType);
			case "EXTERNAL_COMPONENT":
				return new EBExternalComponentItem_CT459487(xmlSettingsNode,strCompType);
			case "EMAIL_NOTIFIER":
				return new EBEMailNotifierItem_CT459487(xmlSettingsNode,strCompType);
			case "MULTI_RSS":
				return new EBMultiFeedItem_CT459487(xmlSettingsNode,strCompType);
			case "WEATHER":
				return new EBWeatherItem_CT459487(xmlSettingsNode,strCompType);
			
		}
		return null;
	}
}



var EBToolbarFactoryComponent_CT459487 = 
{	
	GetInstance : function(oToolbarItem)
	{
		if(oToolbarItem instanceof EBDynamicMenuItem_CT459487)
		{
			return new EBDynamicMenuComponent_CT459487(oToolbarItem);
		}
		else if(oToolbarItem instanceof EBButtonItem_CT459487)
		{
			return new EBButtonComponent_CT459487(oToolbarItem);
		}
		else if(oToolbarItem instanceof EBBrowserItem_CT459487)
		{
			return new EBBrowserComponent_CT459487(oToolbarItem);	
		}
		else if(oToolbarItem instanceof EBSearchBoxItem_CT459487)
		{
			return new EBSearchBoxComponent_CT459487(oToolbarItem);	
		}
		else if(oToolbarItem instanceof EBHighlighterItem_CT459487)
		{
			return new EBHighlighterComponent_CT459487(oToolbarItem);	
		}
		else if(oToolbarItem instanceof EBSeparatorItem_CT459487)
		{
			return new EBSeparatorComponent_CT459487(oToolbarItem);	
		}
		else if(oToolbarItem instanceof EBFeedItem_CT459487)
		{
			return new EBFeedComponent_CT459487(oToolbarItem);	
		}
		else if(oToolbarItem instanceof EBPrivacyItem_CT459487)
		{
			return new EBPrivacyComponent_CT459487(oToolbarItem);	
		}
		else if(oToolbarItem instanceof EBExternalComponentItem_CT459487)
		{
			return new EBExternalComponent_CT459487(oToolbarItem);	
		}
		else if(oToolbarItem instanceof EBEMailNotifierItem_CT459487)
		{
			return new EBEMailNotifierComponent_CT459487(oToolbarItem);	
		}
		else if(oToolbarItem instanceof EBMultiFeedItem_CT459487)
		{
			return new EBMultiFeedComponent_CT459487(oToolbarItem);
		}
		else if(oToolbarItem instanceof EBWeatherItem_CT459487)
		{
			return new EBWeatherComponent_CT459487(oToolbarItem);
		}
		
		return null;
	}
}
var EBSearchBoxConsts_CT459487 = 
{
	MaxSearchHistoryItems : 20,
	SearchHistoryFileName : 'search_history.xml',
	
	SearchButtonIDPrefix		: 'EBSearchButton',
	SearchMenuListIDPrefix		: 'EBSearchMenuList',
	SearchHighlighterIDPrefix	: 'EBSearchHighlighter',
	
	SearchBoxWidth				: '150',
	
	SearchBoxMinWidth			: '50',
	
	XML :
	{
		SearchHistoryTagName		: 'HISTORY',
		SearchHistoryItemTagName	: 'ITEM'
	},
	
	Attributes :
	{
		SearchButtonID				: 'EB_SEARCH_BUTTON_ID',
		SearchMenuListID			: 'EB_SEARCH_MENULIST_ID',
		HighlighterImageEnabled		: 'EB_HIGHLIGHTER_IMAGE_ENABLED',
		HighlighterImageDisabled	: 'EB_HIGHLIGHTER_IMAGE_DISABLED',
		IsInChevron					: 'EB_SEARCH_MENU_ITEM_IS_IN_CHEVRON'
	},
	
	Images :
	{
		DefaultSearch			: 'http://www.conduit.com/images/searchengines/search_icon.gif',
		Splitter				: 'chrome://folkoteka.com/skin/splitter.png'
	}
	
}



var EBSearchBoxManager_CT459487 = 
{
	//var to determine if the bg_text of specific search was set 
	//from the code (allow to search the bgtext value if the user write
	//the same search term as the bg_text)
	IsSetSearchBGText			: true,

	//the command of the search menulist
	MenuListSearch : function(event)
	{
		if(event.which == 13)
		{
			var strSearchTerm = event.target.value;
			
			if(this.IsSearchToNavigate(strSearchTerm))
			{
				EBLinkManager_CT459487.LoadLinkURL(event,strSearchTerm,false,null);
				
				this.RequestSearchUsage(EBUsageConsts_CT459487.NAVIGATE_FROM_SEARCH,
											'',
											'');
			}
			else
			{
				//get the search button via the string id
				var searchButton = document.getElementById(event.target.getAttribute(EBSearchBoxConsts_CT459487.Attributes.SearchButtonID));
				
				var defaultMenuItem = this.GetCurrentSearchEngineMenuItem(searchButton);
				
				if(defaultMenuItem != null)
				{
					this.SetSearch(event,defaultMenuItem,strSearchTerm,EBUsageConsts_CT459487.SEARCH_SOURCE_VK_RETURN);
				}
			}
		}
	},
	
	IsSearchToNavigate : function(strSearchTerm)
	{
		strSearchTerm = EBGlobalManager_CT459487.Trim(strSearchTerm);
		
		//chekc if it's contains spaces in the middle
		if(/\s/.test(strSearchTerm))
		{
			return false;
		}
		
		//check if it's legal URL
		if(EBGlobalManager_CT459487.IsLegalURL(strSearchTerm))
		{
			return true;
		}
		
		var strDomain = '';
		
		//get the domain suffix 
		//(say from google.co.il gets 'il' - the one before the last dot(.))
		var arrMatches = strSearchTerm.match(/.*\.([^\/^\?^:]+)/i);
		if(arrMatches)
		{
			strDomain = arrMatches[1];
			if(strDomain && EBGlobalManager_CT459487.IsDomainExists(strDomain))
			{
				return true;
			}
			
		}
		
		return false;
		
	},
	
	//the command of the search button
	ButtonSearch : function(event)
	{
		//get the menu list value
		var strSearchTerm = document.getElementById(event.target.getAttribute(EBSearchBoxConsts_CT459487.Attributes.SearchMenuListID)).value;
		
		var defaultMenuItem = this.GetCurrentSearchEngineMenuItem(event.target);
		
		if(defaultMenuItem != null)
		{
			this.SetSearch(event,defaultMenuItem,strSearchTerm,EBUsageConsts_CT459487.SEARCH_SOURCE_BUTTON);
		}
	},
	
	//the command of the search menuitem button
	MenuItemSearch : function(event)
	{
		var objXULMenuItem = event.target;
		//check if it's can_be_default to set the main search button
		var bIsCanBeDefault = this.IsSearchMenuItemCanBeDefault(objXULMenuItem);
		if(bIsCanBeDefault)
		{
			var strImage		= objXULMenuItem.getAttribute("EB_IMAGE_URL");
			var strCaption		= objXULMenuItem.getAttribute("label");
			var searchButton	= document.getElementById(objXULMenuItem.getAttribute(EBSearchBoxConsts_CT459487.Attributes.SearchButtonID));
			this.SetSearchEnginePreference(objXULMenuItem);
			this.SetSearchButton(searchButton,strImage,strCaption);
			
			
			
			//check if it's chevron element to update the  menuitem
			//of the toolbar itself (update the radio selection)
			if(this.IsInChevronMenuItemElement(objXULMenuItem))
			{
				var iIndex = EBGlobalManager_CT459487.GetDOMElementIndex(objXULMenuItem);
				if(iIndex != -1)
				{
					
					var objSearchBoxToolbarMenuItem = searchButton.firstChild.childNodes[iIndex];
					if(objSearchBoxToolbarMenuItem)
					{
						//set this menuitem to check=true and the
						//rest of the menuitems to check=false
						//if not there is double selection(Firefox bug?!)
						var objChildXULMenuItem = null;
						for(var i=0;i<searchButton.firstChild.childNodes.length;i++)
						{
							objChildXULMenuItem = searchButton.firstChild.childNodes[i];
							if(objChildXULMenuItem == objSearchBoxToolbarMenuItem)
							{
								objChildXULMenuItem.setAttribute('checked','true');
							}
							else
							{
								objChildXULMenuItem.setAttribute('checked','false');
							}
						}
					}
				}
			}
		}
		
		//checked the selected menuitem after the page loads for search
		//if the mouse button is middle
		if(event.button == 1)
		{
			if(bIsCanBeDefault)
			{
				objXULMenuItem.setAttribute('checked','true');
			}
		}
		
		
		//check to see if to set the bgtext
		if(this.IsSetSearchBGText)
		{
			this.SetSearchBoxBGText();
		}
		
		
		//get the menu list value
		var strSearchTerm = document.getElementById(objXULMenuItem.getAttribute(EBSearchBoxConsts_CT459487.Attributes.SearchMenuListID)).value;
		
		
		this.SetSearch(event,objXULMenuItem,strSearchTerm,EBUsageConsts_CT459487.SEARCH_SOURCE_FIXED);
	
		
		
		
	
	},
	
	//search from the search history menu
	MenuItemHistorySearch : function(event)
	{
		var xulSearchButton = document.getElementById(event.target.getAttribute(EBSearchBoxConsts_CT459487.Attributes.SearchButtonID));
		var defaultMenuItem =  this.GetCurrentSearchEngineMenuItem(xulSearchButton);
		if(defaultMenuItem != null)
		{
			var oMenuItemHistory = event.target;
			
			//close the parent popup menu(it's stay open on middle click)
			oMenuItemHistory.parentNode.hidePopup();	
			
			var strSearchTerm = oMenuItemHistory.getAttribute("label");
			this.SetSearch(event,defaultMenuItem,strSearchTerm,EBUsageConsts_CT459487.SEARCH_SOURCE_HISTORY);
			
			var XULSearchBoxMenuList = EBComponentsManager_CT459487.GetSearchBoxMenuList();
			if(XULSearchBoxMenuList)
			{
				XULSearchBoxMenuList.value = strSearchTerm;
			}
			
			EBActionManager_CT459487.SearchTermChanged();
			
		}
	},
	
	//this function get the current active search(menu item)
	//parse it's element and according it does the search
	SetSearch : function(event,currentMenuItem,strSearchTerm,strUsageHowSearch)
	{
		//get the stored menu item data
		var strPrefix			= currentMenuItem.getAttribute("EB_PREFIX");
		var strTermToReplace	= currentMenuItem.getAttribute("EB_SEARCH_TERM_TO_REPLACE");
		var strEmptySearchUrl	= currentMenuItem.getAttribute("EB_EMPTY_SEARCH_URL");
		
		var strSearchUrl = EBGlobalManager_CT459487.FromLegalXml(strPrefix);
		
		
		//check the strSearchTerm
		var strSearchTermTrim = EBGlobalManager_CT459487.TotalTrim(strSearchTerm);
		
		var isBlankSearch = strSearchTermTrim == '' ? true : false;
		
		//check the bgtext - if this is the auto bgtext(as oppose to the user
		//enter the same term as the bgtext) i consider it as a blank search!
		var strBGText = this.GetSearchBGText();
		if(this.IsSetSearchBGText && strSearchTerm == strBGText)
		{
			isBlankSearch = true;
		}
		
		if(isBlankSearch)
		{
			//check if there is alternative url to navigate when the search is empty
			if(strEmptySearchUrl != "")
			{
				strSearchUrl = EBActionManager_CT459487.ConvertAliasesUrl(strEmptySearchUrl);
			}
			else
			{
				strSearchUrl = EBGlobalManager_CT459487.GetBaseUrl(strSearchUrl);
			}
			EBLinkManager_CT459487.LoadLinkURL(event,strSearchUrl,false,null);
		}
		else
		{
			var xulSearchMenuList = document.getElementById(currentMenuItem.getAttribute(EBSearchBoxConsts_CT459487.Attributes.SearchMenuListID));
			this.AddTermToSearchHistory(xulSearchMenuList,strSearchTerm);
		
		
			//check to see if it's a post url
			var strType = currentMenuItem.getAttribute("EB_TYPE");
				
			var strInputCharset		= currentMenuItem.getAttribute("EB_INPUT_CHARSET");
			
			if(strType.toUpperCase() != "POST")
			{
				//convert the search term according to the given xml charset
				//only in get method! - in the post method the conversion is in the 
				//form element via accept-charset

				strSearchTerm = EBFileIO_CT459487.fromUnicode(strInputCharset,strSearchTerm);
				strSearchTerm = escape(strSearchTerm);
			}
			strSearchTerm = strSearchTerm.replace(/\+/g,"%2B");
		
			//replace the const term with the actual search term
			strSearchUrl = strSearchUrl.replace(strTermToReplace,strSearchTerm);
			
			//replace the aliases
			strSearchUrl = EBActionManager_CT459487.ConvertAliasesUrl(strSearchUrl);
			
			var strPostParams = null;
			
			if(strType.toUpperCase() == "POST")
			{
				var strPostParams = currentMenuItem.getAttribute("EB_POST_PARAMS");
	
				strSearchTerm = EBFileIO_CT459487.fromUnicode(strInputCharset,strSearchTerm);
				
				//replace the const term with the actual search term
				strPostParams = strPostParams.replace(strTermToReplace,strSearchTerm);
			}
			
			EBLinkManager_CT459487.LoadLinkURL(event,strSearchUrl,false,strPostParams);
		}
		
		//usage call
		this.RequestSearchUsage(EBUsageConsts_CT459487.SEARCH,
										strUsageHowSearch,
										strPrefix);
		
	},
	
	RequestSearchUsage : function(strComponentType,strGeneralParam1,strGeneralParam2)
	{
		var strComponentID = EBComponentsConsts_CT459487.ComponentsID.SearchBox;
		
		//create the usage object
		var objUsage = new EBUsageObject_CT459487(strComponentID,
													strComponentType,
													strGeneralParam1,
													'');
		//send the data
		objUsage.SendRequest();
	},

	SetSearchButton : function(searchButton,strImage,strCaption)
	{
		//check for default
		if(strImage == "")
		{
			//get the default image for the search button
			strImage = EBSearchBoxConsts_CT459487.Images.DefaultSearch;
		}	
		if(strCaption == "")
		{
			strCaption = "Search";
		}
		
		searchButton.setAttribute("image",strImage);
		searchButton.setAttribute("label",strCaption);
		
	},
	
	OnInputSearchBox : function(menuListObj)
	{
		EBActionManager_CT459487.SearchTermChanged();
		
	},
	
	IsInChevronMenuItemElement : function(objXULElement)
	{
		var strIsInChevron = objXULElement.getAttribute(EBSearchBoxConsts_CT459487.Attributes.IsInChevron);
		return strIsInChevron == 'true' ? true : false;
	},
	
	OnMouseUpSplitter : function(event)
	{
		this.SetPrefMenuListWidth();
		EBChevronManager_CT459487.SetChevron(event);
	},
	
	SetPrefMenuListWidth : function()
	{
		//save the toolbar menulist width
		var xulMenuList = EBComponentsManager_CT459487.GetSearchBoxMenuList();
		
		if(xulMenuList)
		{
			//save it to the about:config
			EBToolbarPreferenceManager_CT459487.SetPref(EBPreferenceConsts_CT459487.SearchBoxWidth,xulMenuList.boxObject.width);
		}

	},
	
	GetHighlighterButtonOnToolbar : function()
	{
		return  document.getElementById(EBSearchBoxConsts_CT459487.SearchHighlighterIDPrefix + EBGlobalConsts_CT459487.ToolbarCTID);
	},
	
	GetCurrentSearchEngineMenuItem : function(searchButton)
	{
		var menuItemElements = searchButton.getElementsByAttribute("checked","true");
		if(menuItemElements.length > 0)
		{
			return menuItemElements[0];
		}
		return null;
	},
	
	IsSearchMenuItemCanBeDefault : function(menuItem)
	{
		//check if all the search box can change the default via the button search
		var searchButton = document.getElementById(menuItem.getAttribute(EBSearchBoxConsts_CT459487.Attributes.SearchButtonID));
		var strSearchBoxCanChageDefault = searchButton.getAttribute("EB_CAN_CHANGE_DEFAULT");
		if(strSearchBoxCanChageDefault != "CAN_CHANGE_DEFAULT")
		{
			return false;
		}
		
		
		var strCanBeDefault = menuItem.getAttribute("EB_CAN_BE_DEFAULT");
		if(strCanBeDefault == "TRUE")
			return true;
		else
			return false;
	},
	
	//save the search engine in the about:config
	SetSearchEnginePreference : function(defaultMenuItem)
	{
		var strName			= encodeURIComponent(defaultMenuItem.getAttribute("label"));
		var strPrefix		= defaultMenuItem.getAttribute("EB_PREFIX");
		var strPrefName		= EBPreferenceConsts_CT459487.SearchEngine;
		var strPrefValue	= strName + EBGlobalConsts_CT459487.Delimiter + strPrefix;

		EBToolbarPreferenceManager_CT459487.SetPref(strPrefName,strPrefValue);
	},
	
	GetSearchHistoryMenuItem : function(xulMenuList,strLabel)
	{
		var strSearchMenuListId = xulMenuList.getAttribute("id");
		var strSearchButtonId	= xulMenuList.getAttribute(EBSearchBoxConsts_CT459487.Attributes.SearchButtonID);
		var strCommand			= 'EBSearchBoxManager_CT459487.MenuItemHistorySearch(event);'
		
		var xulMenuItem = EBXULFactory_CT459487.CreateMenuItem(strLabel,
														"",
														"",
														strCommand,
														"",
														null);
																								
		//add to all the menu items attribute reference to the search button 
		//and to the search menulist
		xulMenuItem.setAttribute(EBSearchBoxConsts_CT459487.Attributes.SearchButtonID,strSearchButtonId);
		xulMenuItem.setAttribute(EBSearchBoxConsts_CT459487.Attributes.SearchMenuListID,strSearchMenuListId);
		
		return xulMenuItem;
	},
	
	AddTermToSearchHistory : function(xulMenuList,strSearchTerm)
	{
		//check if this search term already exists
		//if so remove it from the list
		var xulMenuPopup = xulMenuList.firstChild;
		
		
		//remove the first default menu item
		if(xulMenuPopup.childNodes[0].getAttribute("label") == "")
		{
			xulMenuPopup.removeChild(xulMenuPopup.childNodes[0]);
		}
		
		
		//remove the menu item that contain this search term in case 
		//of repeating search and add it in the end (after update the rdf file!)
		var strLabel = "";
		for(var i=0;i<xulMenuPopup.childNodes.length;i++)
		{
			strLabel = xulMenuPopup.childNodes[i].getAttribute("label");
			if(strLabel == strSearchTerm)
			{
				xulMenuPopup.removeChild(xulMenuPopup.childNodes[i]);
				break;
			}
		}
		
		//create menuitem and add it to the top of the list
		var xulMenuItem =  this.GetSearchHistoryMenuItem(xulMenuList,strSearchTerm);
		xulMenuPopup.insertBefore(xulMenuItem,xulMenuPopup.firstChild);
		
		//remove the exceeded elements
		while(xulMenuPopup.childNodes.length > EBSearchBoxConsts_CT459487.MaxSearchHistoryItems)
		{
			xulMenuPopup.removeChild(xulMenuPopup.lastChild);
		}
		
		//get the xml history file
		var fileSearchHistoryXML = EBSearchBoxManager_CT459487.GetSearchHistoryFile();
		
		//create domParser
		var strXMLSearch	= EBFileIO_CT459487.read(fileSearchHistoryXML,EBGlobalConsts_CT459487.DefaultCharset);
		var xmlDocSearch	= EBGlobalManager_CT459487.GetXmlDocument(strXMLSearch);
		
		//get root nodes
		var xmlSearchRoot	= xmlDocSearch.documentElement;
		var xmlSearchItems  = xmlSearchRoot.getElementsByTagName(EBSearchBoxConsts_CT459487.XML.SearchHistoryItemTagName);
		var xmlSearchItem	= null;
		var strXMLValue		= "";
		
		//check if this search term already in the history
		for(var i=0;i<xmlSearchItems.length;i++)
		{
			xmlSearchItem	= xmlSearchItems.item(i);
			strXMLValue		= EBGlobalManager_CT459487.GetXmlNodeValue(xmlSearchItem);
			if(strXMLValue == strSearchTerm)
			{
				xmlSearchRoot.removeChild(xmlSearchItem);
				break;		
			}
		}
		
		var xmlSearchHistoryItem = EBGlobalManager_CT459487.CreateXmlTextNode(xmlDocSearch,EBSearchBoxConsts_CT459487.XML.SearchHistoryItemTagName,strSearchTerm);
		
		//insert the new value to the top of the list
		xmlSearchRoot.insertBefore(xmlSearchHistoryItem,xmlSearchRoot.firstChild);
		
		//check to remove the unnecessary items
		if(xmlSearchRoot.childNodes.length > EBSearchBoxConsts_CT459487.MaxSearchHistoryItems)
		{
			xmlSearchRoot.removeChild(xmlSearchRoot.lastChild);
		}
		
		//save the changes to the file
		EBFileIO_CT459487.write(fileSearchHistoryXML, EBGlobalManager_CT459487.GetStringXml(xmlSearchRoot),"",EBGlobalConsts_CT459487.DefaultCharset);
		
	},
	
	ClearSearchHistory : function()
	{
		var xulMenuList = EBComponentsManager_CT459487.GetSearchBoxMenuList();
		
		if(xulMenuList)
		{
			var xulMenuPopup = xulMenuList.firstChild;

			//empty all menu items
			while(xulMenuPopup.childNodes.length > 0)
			{
				xulMenuPopup.removeChild(xulMenuPopup.firstChild);
			}
			
			//place an empty menu item
			var xulMenuItem = EBXULFactory_CT459487.CreateMenuItem("",
															"",
															"",
															"",
															"",
															null);
			xulMenuItem.setAttribute("height","18");
			xulMenuPopup.appendChild(xulMenuItem);
			
			
			//nullify XML history file
			var fileSearchHistoryXML = this.GetSearchHistoryFile();
			EBFileIO_CT459487.write(fileSearchHistoryXML, "","",EBGlobalConsts_CT459487.DefaultCharset);
			
			xulMenuList.value = "";
			EBActionManager_CT459487.SearchTermChanged();
			//set the bgtext
			this.SetSearchBoxBGText();
		}
	},
	
	OnMouseDownSearchBox : function(event,XULMenuList)
	{	
		if(!XULMenuList.hasAttribute("focused")) 
		{
			XULMenuList.inputField.setSelectionRange(0,0);
		}
	},
	
	OnClickSearchBox : function(event,XULMenuList)
	{
		
	},
	
	GetSearchHistoryFile : function()
	{
		//get the search history file - if it doesn't exists - create it!
		var fileSearchHistoryXML = EBIOManager_CT459487.CreateToolbarFile(EBSearchBoxConsts_CT459487.SearchHistoryFileName);
		
		//check if what we created is an empty file
		//so we create the string of the xml
		if(!fileSearchHistoryXML.exists() || fileSearchHistoryXML.fileSize <= 0)
		{
			var strXML = this.GetDefaultSearchHistoryXMLString();
			EBFileIO_CT459487.write(fileSearchHistoryXML, strXML,"",EBGlobalConsts_CT459487.DefaultCharset);
		}
		
		return fileSearchHistoryXML;
	
	},
	
	GetDefaultSearchHistoryXMLString : function()
	{
		var strXML = "";
		
		strXML += "<"+EBSearchBoxConsts_CT459487.XML.SearchHistoryTagName+">";
		
		for(var i=0;i<EBSearchBoxConsts_CT459487.MaxSearchHistoryItems;i++)
		{
			strXML += "<" + EBSearchBoxConsts_CT459487.XML.SearchHistoryItemTagName + "/>";
		}
		
		strXML += "</" + EBSearchBoxConsts_CT459487.XML.SearchHistoryTagName + ">";
		
		return strXML;
	},
	
	SetSearchBoxBGText : function()
	{
		var strBGText = this.GetSearchBGText();
		
		//get search box
		var XULSearchBoxMenuList = EBComponentsManager_CT459487.GetSearchBoxMenuList();
		
		if(XULSearchBoxMenuList)
		{
			if(strBGText)
			{
				XULSearchBoxMenuList.value = strBGText;
				//set the var that sais that the bg text search is set
				this.IsSetSearchBGText = true;
			}
			else
			{
				XULSearchBoxMenuList.value = '';
			}
		}
	},
	
	GetSearchBGText : function()
	{
		var strBGText = '';
		
		var XULSearchButton = EBComponentsManager_CT459487.GetSearchBoxButton();
	
		if(XULSearchButton)
		{
			var XULMenuItemCurrentSearchEngine = this.GetCurrentSearchEngineMenuItem(XULSearchButton);
			
			if(XULMenuItemCurrentSearchEngine)
			{
				strBGText = XULMenuItemCurrentSearchEngine.getAttribute('EB_BG_TEXT');
			}
		}
		
		return strBGText;
	},
	
	OnSearchBoxFocus : function(event)
	{
		var XULSearchBoxMenuList	= event.target;
		
		var strBGText				= this.GetSearchBGText();
		var strSearchBoxValue		= XULSearchBoxMenuList.value;
		
		//check if set the bgtext automatically to nullify the search
		//term on focus
		if(this.IsSetSearchBGText && strSearchBoxValue == strBGText)
		{
			XULSearchBoxMenuList.value = '';
		}
		else if(strSearchBoxValue != '') //if the term is not empty select it on the focus event!
		{
			XULSearchBoxMenuList.select();
		}
		
	},
	
	OnSearchBoxBlur : function(event)
	{
		//event the occur when the search box looses the focus.
		//in this case we check to set the bgtext again
		var XULSearchBoxMenuList	= event.target;
		var strSearchBoxValue		= XULSearchBoxMenuList.value;
		if(strSearchBoxValue == '')
		{
			this.SetSearchBoxBGText();
		}
	}
}





var EBUsageConsts_CT459487 = 
{
	SEARCH						: 'SEARCH',
	SEARCH_SOURCE_BUTTON		: 'SEARCH_SOURCE_BUTTON',
	SEARCH_SOURCE_VK_RETURN		: 'SEARCH_SOURCE_VK_RETURN',
	SEARCH_SOURCE_FIXED 		: 'SEARCH_SOURCE_FIXED',
	SEARCH_SOURCE_HISTORY		: 'SEARCH_SOURCE_HISTORY',
	NAVIGATE_FROM_SEARCH		: 'NAVIGATE_FROM_SEARCH',
	
	HIGHLIGHTER					: 'HIGHLIGHTER',
	HIGHLIGHTER_BUTTON			: 'HIGHLIGHTER_BUTTON',
	HIGHLIGHTER_MENU_ITEM		: 'HIGHLIGHTER_MENU_ITEM',
	
	EMAIL_NOTIFIER				: 'EMAIL_NOTIFIER',
	EMAIL_NOTIFIER_MENU_OPEN	: 'EMAIL_NOTIFIER_MENU_OPEN',
	EMAIL_NOTIFIER_OPEN_ACCOUNT	: 'EMAIL_NOTIFIER_OPEN_ACCOUNT',
	EMAIL_NOTIFIER_COMMAND		: 'EMAIL_NOTIFIER_COMMAND',
	
	MULTI_RSS					: 'MULTI_RSS',
	RSS							: 'RSS',
	RSS_MENU_OPEN				: 'RSS_MENU_OPEN',
	RSS_ITEM					: 'RSS_ITEM',
	LIVE_RSS_MENU_OPEN			: 'LIVE_RSS_MENU_OPEN',
	
	BUTTON						: 'BUTTON',
	MENU						: 'MENU',
	OPEN_MENU					: 'OPEN_MENU',
	LINK						: 'LINK',
	COMMAND						: 'COMMAND',
	
	WEATHER						: 'WEATHER',
	
	CHEVRON						: 'CHEVRON',
	CHEVRON_MENU_OPEN			: 'CHEVRON_MENU_OPEN'
}


//object for the usage calls
function EBUsageObject_CT459487(strComponentID,
									strComponentType,
									strGeneralParam1,
									strGeneralParam2)
{
	this.ComponentID	= strComponentID;
	this.ComponentType	= strComponentType;
	this.GeneralParam1	= strGeneralParam1;
	this.GeneralParam2	= strGeneralParam2;
	
	this.SendRequest = function()
	{
		EBServerCommunicationManager_CT459487.RequestUsage(this.ComponentID,
																this.ComponentType,
																this.GeneralParam1,
																this.GeneralParam2);
	}
}



var EBServerCommunicationConsts_CT459487 = 
{
	EBXML_CT_LOGIN_REQUEST					: '<EBXML><EBMSGID>CT_LOGIN_RQ</EBMSGID><EBMSG><CT_ID></CT_ID><USERID></USERID><VERSION></VERSION><TIMESTAMP></TIMESTAMP><PLATFORM></PLATFORM><BROWSER_VERSION></BROWSER_VERSION></EBMSG></EBXML>',
	
	EBXML_CT_SETTINGS_REQUEST				: '<EBXML><EBMSGID>CT_SETTINGS_RQ</EBMSGID><EBMSG><CT_ID></CT_ID><VERSION></VERSION><XML_TYPE></XML_TYPE><PLATFORM></PLATFORM><LAST_UPDATE_TIME></LAST_UPDATE_TIME></EBMSG></EBXML>',
	
	EBXML_CT_USAGE_REQUEST					: '<EBXML><EBMSGID>CT_USAGE_RQ</EBMSGID><EBMSG><VERSION></VERSION><CT_ID></CT_ID><COMPONENT_ID></COMPONENT_ID><COMPONENT_TYPE></COMPONENT_TYPE><GENERAL_PARAM1></GENERAL_PARAM1><GENERAL_PARAM2></GENERAL_PARAM2><PLATFORM></PLATFORM></EBMSG></EBXML>',
	
	EBXML_CT_THIRD_PARTY_COMPONENTS_REQUEST	: '<EBXML><EBMSGID>CT_THIRD_PARTY_COMPONENTS_RQ</EBMSGID><EBMSG><CT_ID></CT_ID><PLATFORM></PLATFORM><LAST_UPDATE_TIME></LAST_UPDATE_TIME></EBMSG></EBXML>',
	
	EB_DEFAULT_SERVER_URL					: 'http://users.conduit.com',
	
	EB_SERVER_URL							: 'http://users.conduit.com',
	
	EB_SERVER_PAGE							: 'iis2ebs.asp',
	
	EB_POST_PARAM							: 'RequestString',
	
	USER_ID_LEGAL_LENGTH					: 19,
	
	SETTINGS_FILE_NAME						: 'LocalSettings.txt',
	
	THIRD_PARTY_COMPONENTS_FILE_NAME		: 'ThirdPartyComponents.xml',
	
	MESSAGE_XML_TYPE						: 'NORMAL'
}



var EBServerCommunicationManager_CT459487 = 
{	
	OnLoadToolbar : function()
	{
		//login server call
		this.RequestLogin();
		
		//upload settings from file
		this.ParseToolbarFromFileSettings();
		
		//call third party 
		this.RequestThirdPartyComponents();
		
		//settings server call
		this.RequestSettings();
	},
	
	ServerRequest : function(strXMLRQ,oCallBackFunction)
	{
		//get the server path from the prefs
		var strServerURL = EBToolbarPreferenceManager_CT459487.GetPref(EBPreferenceConsts_CT459487.ServerURL);

		if(!strServerURL || !EBGlobalManager_CT459487.IsLegalURL(strServerURL))
		{
			//check legal of the this.EB_SERVER_URL and if not take the hard-coded default
			strServerURL = EBGlobalManager_CT459487.IsLegalURL(EBServerCommunicationConsts_CT459487.EB_SERVER_URL) ? EBServerCommunicationConsts_CT459487.EB_SERVER_URL : EBServerCommunicationConsts_CT459487.EB_DEFAULT_SERVER_URL;
			EBToolbarPreferenceManager_CT459487.SetPref(EBPreferenceConsts_CT459487.ServerURL,strServerURL);
		}
		
		var strServerFullPath = strServerURL + '/' + EBServerCommunicationConsts_CT459487.EB_SERVER_PAGE;
		
		var strPostParams = EBServerCommunicationConsts_CT459487.EB_POST_PARAM + '=' + strXMLRQ;
		
		EBGlobalManager_CT459487.HTTPServerRequest(strServerFullPath,strPostParams,false,oCallBackFunction);
		
	},
	
	GetXMLEBMSGNodeByXMLDoc : function(XMLDoc)
	{
		var XMLEBMSG = null;
		var XMLRoot = XMLDoc.documentElement;
		
		var XMLEBMSGNodes = XMLRoot.getElementsByTagName('EBMSG');
		if(XMLEBMSGNodes.length > 0)
		{
			XMLEBMSG = XMLEBMSGNodes.item(0);
		}
		return XMLEBMSG;	
	},
	
	GetXMLEBMSGNodeByStringXML : function(strXML)
	{
		var XMLEBMSG = null;
	
		strXML = EBGlobalManager_CT459487.LegalizeEBXML(strXML);
			
		var XMLDoc	= EBGlobalManager_CT459487.GetXmlDocument(strXML);
		
		XMLEBMSG = this.GetXMLEBMSGNodeByXMLDoc(XMLDoc);
		
		return XMLEBMSG;
	},
	
	RequestSettings : function()
	{
		//get the ctid from the prefs
		var strCTID = EBToolbarPreferenceManager_CT459487.GetPref(EBPreferenceConsts_CT459487.CTID);    
		if(!EBGlobalManager_CT459487.IsLegalCTID(strCTID))
		{
			strCTID = EBGlobalConsts_CT459487.ToolbarCTID;
			EBToolbarPreferenceManager_CT459487.SetPref(EBPreferenceConsts_CT459487.CTID,strCTID);	
		}
		
		var strVersion = "";
		
		var strXmlType = EBServerCommunicationConsts_CT459487.MESSAGE_XML_TYPE;
		
		var strPlatform = EBGlobalManager_CT459487.GetBrowserName().toUpperCase();
		
		var strLastUpdateTime = this.GetLastUpdateTime();
		if(!strLastUpdateTime)
		{
			strLastUpdateTime = '';
		}
		
		var strXmlRQ = this.GetFullSettingsXmlRQ(strCTID,
												strVersion,
												strXmlType,
												strPlatform,
												strLastUpdateTime);

		//convert it before sending
		strXmlRQ = escape(strXmlRQ);
		var oCallBackFunction = function(strXML,o)
		{
			EBServerCommunicationManager_CT459487.ResponseSettings(strXML);
		};
		this.ServerRequest(strXmlRQ,oCallBackFunction);
	},
	
	ResponseSettings : function(strXMLRS)
	{
		try
		{
			var XMLEBMSG = this.GetXMLEBMSGNodeByStringXML(strXMLRS);
			if(!XMLEBMSG)
			{
				return;
			}
			
			var XMLSettings					= null;
			var strLastUpdateTimeFromServer	= '';
			var XMLNode						= null;
			for(var i=0;i<XMLEBMSG.childNodes.length;i++)
			{
				XMLNode = XMLEBMSG.childNodes[i];
				if(XMLNode.tagName == 'SETTINGS')
				{
					XMLSettings = XMLNode;
				} 
				else if(XMLNode.tagName == 'LAST_UPDATE_TIME')
				{
					strLastUpdateTimeFromServer = EBGlobalManager_CT459487.GetXmlNodeValue(XMLNode);
				}
			}
			
			//check if this is a legal settings(legal xml from the server)
			if(!XMLSettings || XMLSettings.childNodes.length == 0)
			{
				//set the ctid to be the original toolbar
				EBToolbarPreferenceManager_CT459487.SetPref(EBPreferenceConsts_CT459487.CTID,EBGlobalConsts_CT459487.ToolbarCTID);
				return;
			}
			
			//check to see if the server return a "SETTINGS_NOT_MODIFIED" value
			var strSettingsValue =  '';
			if(XMLSettings.childNodes.length == 1)
			{
				strSettingsValue = EBGlobalManager_CT459487.GetXmlNodeValue(XMLSettings);
				if(strSettingsValue == "SETTINGS_NOT_MODIFIED")
				{
					return;
				}
			}
			
			var strLastUpdateTimeCurrent = this.GetLastUpdateTime();
			
			var oFileSettings = EBIOManager_CT459487.CreateToolbarFile(EBServerCommunicationConsts_CT459487.SETTINGS_FILE_NAME);
			
			if(!strLastUpdateTimeCurrent || strLastUpdateTimeCurrent != strLastUpdateTimeFromServer)
			{
				EBToolbarPreferenceManager_CT459487.SetPref(EBPreferenceConsts_CT459487.SettingsLastUpdateTime,strLastUpdateTimeFromServer);
				var strXMLSettings = EBGlobalManager_CT459487.GetStringXml(XMLSettings);
				EBFileIO_CT459487.write(oFileSettings,strXMLSettings,"",EBGlobalConsts_CT459487.DefaultCharset);
				this.CallParseToolbar(XMLSettings);
				
				if(EBActionManager_CT459487.IsToolbarGeneric())
				{
					//call post generic to set this toolbar in the generic data
					EBGenericManager_CT459487.SettingsServerResponse();
				}
			}
		}
		catch(ex){}
	},
	
	GetLastUpdateTime : function()
	{
		var strPrefName = EBPreferenceConsts_CT459487.SettingsLastUpdateTime;
		var strLastUpdateTime = EBToolbarPreferenceManager_CT459487.GetPref(strPrefName);
		return strLastUpdateTime;
	},
	
	ParseToolbarFromFileSettings : function()
	{
		//try to load from file
		var oFileSettings = EBIOManager_CT459487.CreateToolbarFile(EBServerCommunicationConsts_CT459487.SETTINGS_FILE_NAME);
		if(!oFileSettings.exists() || oFileSettings.fileSize <= 0)
		{
			//nullify the last update time
			EBToolbarPreferenceManager_CT459487.SetPref(EBPreferenceConsts_CT459487.SettingsLastUpdateTime,null);
			return;
		}
		var strXMLSettings	= EBFileIO_CT459487.read(oFileSettings,EBGlobalConsts_CT459487.DefaultCharset);
		var XMLDocSettings	= EBGlobalManager_CT459487.GetXmlDocument(strXMLSettings);
		var XMLSettings		= XMLDocSettings.documentElement;
		this.CallParseToolbar(XMLSettings);
	},
	
	CallParseToolbar : function(XMLToolbarSettings)
	{
		EBToolbarBuilder_CT459487.ParseToolbarXML(XMLToolbarSettings);
	},
	
	RequestLogin : function()
	{

		//check if need to call login
		if(this.IsRequestLoginDone())
		{
			return;
		}
		
		//get all the parameters for the request login
		var strCTID				= EBGlobalConsts_CT459487.ToolbarCTID;
		
		var strUserId			= this.GetUserId();
		
		var strVersion			= EBGlobalConsts_CT459487.ToolbarVersion;
		
		var strTimeStamp		= this.GenerateTimeStamp();
		
		var strPlatform			= EBGlobalManager_CT459487.GetBrowserName().toUpperCase();
		
		var strBrowserVersion	= EBGlobalManager_CT459487.GetBrowserVersion();
		
		var strXmlRQ = this.GetFullLoginXmlRQ(strCTID,
											strUserId,
											strVersion,
											strTimeStamp,
											strPlatform,
											strBrowserVersion);
		
		//convert it before sending
		strXmlRQ = escape(strXmlRQ);
		
		var oCallBackFunction = function(strXML,o)
		{
			EBServerCommunicationManager_CT459487.ResponseLogin(strXML);
		};
		
		this.ServerRequest(strXmlRQ,oCallBackFunction);
	},
	
	ResponseLogin : function(strXMLRS)
	{
		try
		{
			var XMLEBMSG = this.GetXMLEBMSGNodeByStringXML(strXMLRS);
			
			if(!XMLEBMSG)
			{
				return;
			}
			
			var strUserId		= '';
			var strLoginCache	= '';
			var XMLNode			= null;
			for(var i=0;i<XMLEBMSG.childNodes.length;i++)
			{
				XMLNode = XMLEBMSG.childNodes[i];
				if(XMLNode.tagName == 'USERID')
				{
					strUserId = EBGlobalManager_CT459487.GetXmlNodeValue(XMLNode);
				} 
				else if(XMLNode.tagName == 'LOGIN_CACHE')
				{
					strLoginCache = EBGlobalManager_CT459487.GetXmlNodeValue(XMLNode);
				}
			}		
			
			if(strUserId)
			{
				EBToolbarPreferenceManager_CT459487.SetPref(EBPreferenceConsts_CT459487.UserID,strUserId);
			}
			
			//set the current login call time to the about:config
			var oDateCurrent = new Date();

			EBToolbarPreferenceManager_CT459487.SetPref(EBPreferenceConsts_CT459487.LoginCallDate,oDateCurrent.toString());
			
			//set it to the about:config
			EBToolbarPreferenceManager_CT459487.SetPref(EBPreferenceConsts_CT459487.LoginCache,strLoginCache);
		}
		catch(ex)
		{
			//if the login failed of any reason i check if this toolbar did already login
			//and if so i still update is login call date to now (to prevent burden on the server)
			var strLoginCallDate = EBToolbarPreferenceManager_CT459487.GetPref(EBPreferenceConsts_CT459487.LoginCallDate);
			if(strLoginCallDate)
			{
				var objCurrentDate = new Date();
				EBToolbarPreferenceManager_CT459487.SetPref(EBPreferenceConsts_CT459487.LoginCallDate,objCurrentDate.toString());	
			}
		}
	},
	
	IsRequestLoginDone : function()
	{
		//check if need to call to the server with login xml by the time and the 
		//login_cache saved in the about:config 
		var strLoginCallDate = EBToolbarPreferenceManager_CT459487.GetPref(EBPreferenceConsts_CT459487.LoginCallDate);

		if(!strLoginCallDate)
		{
			return false;
		}
		

		var iLoginCache = EBToolbarPreferenceManager_CT459487.GetPref(EBPreferenceConsts_CT459487.LoginCache);
		if(!iLoginCache)
		{
			return false;
		}
		
		
		
		//compare the times according to the login_cache value
		var loginCallDate = new Date(strLoginCallDate);
		var currentDate = new Date();
		
		//login cache in milliseconds(the login cache is in hours!)
		var milliLoginCache = 1000*60*60*iLoginCache;
		

		//the difference in milliseconds
		var milliDif = currentDate - loginCallDate;
		
		//check if time expires
		if(milliDif > milliLoginCache)
		{
			return false;
		}
		
		return true;

	},
	
	RequestUsage : function(strComponentID,strComponentType,strGeneralParam1,strGeneralParam2)
	{
	
		var strVersion		= EBGlobalConsts_CT459487.ToolbarVersion;
		
		var strCTID			= EBGlobalConsts_CT459487.ToolbarCTID;
		
		var strPlatform		= EBGlobalManager_CT459487.GetBrowserName().toUpperCase();
		
		
		var strXmlRQ = this.GetFullUsageXmlRQ(strVersion,
											strCTID,
											strComponentID,
											strComponentType,
											strGeneralParam1,
											strGeneralParam2,
											strPlatform);
		
		//convert it before sending
		strXmlRQ = escape(strXmlRQ);
		
		var oCallBackFunction = function(strXML,o)
		{
			EBServerCommunicationManager_CT459487.ResponseUsage(strXML);
		};	
		
		this.ServerRequest(strXmlRQ,oCallBackFunction);
	},
	
	ResponseUsage : function(strXmlRS)
	{
		
	},
	
	RequestThirdPartyComponents : function()
	{
		var isTPFileValid = this.IsThirdPartyComponentsValidFile();
		
		if(this.IsThirdPartyComponentsLastCheckElapsed() || !isTPFileValid)
		{
			var strCTID				= EBGlobalConsts_CT459487.ToolbarCTID;
			var strPlatform			= EBGlobalManager_CT459487.GetBrowserName().toUpperCase();
			var strLastUpdateTime	= this.GetThirdPartyComponentsLastUpdate();
			
			//check if the file is valid and if not force it to get the 
			//components by not send the last update
			if(!strLastUpdateTime || !isTPFileValid)
			{
				
				strLastUpdateTime = '';
			}
			
			var strXMLRQ = this.GetFullThirdPartyComponentsXMLRQ(strCTID,
															strPlatform,
															strLastUpdateTime);
			
			//convert it before sending
			strXMLRQ = escape(strXMLRQ);
			
			var oCallBackFunction = function(strXML,o)
			{
				EBServerCommunicationManager_CT459487.ResponseThirdPartyComponents(strXML);
			};	
			
			this.ServerRequest(strXMLRQ,oCallBackFunction);
		}
	},
	
	ResponseThirdPartyComponents : function(strXMLRS)
	{
		try
		{
			var XMLEBMSG = this.GetXMLEBMSGNodeByStringXML(strXMLRS);
			if(!XMLEBMSG)
			{
				return;
			}
			
			var XMLThirdPartyComponents		= null;
			var strLastUpdateTime			= '';
			var strInterval					= '';
			var XMLNode						= null;
			for(var i=0;i<XMLEBMSG.childNodes.length;i++)
			{
				XMLNode = XMLEBMSG.childNodes[i];
				if(XMLNode.tagName == 'THIRD_PARTY_COMPONENTS')
				{
					XMLThirdPartyComponents = XMLNode;
				} 
				else if(XMLNode.tagName == 'LAST_UPDATE_TIME')
				{
					strLastUpdateTime = EBGlobalManager_CT459487.GetXmlNodeValue(XMLNode);
				}
				else if(XMLNode.tagName == 'RELOAD_INTERVAL')
				{
					strInterval = EBGlobalManager_CT459487.GetXmlNodeValue(XMLNode);
				}
			}
			
			if(!XMLThirdPartyComponents)
			{
				return;
			}

			//check if not modified from the server
			if(XMLThirdPartyComponents.childNodes.length == 1)
			{
				var strXMLThirdPartyComponentsValue = EBGlobalManager_CT459487.GetXmlNodeValue(XMLThirdPartyComponents);
				if(strXMLThirdPartyComponentsValue == 'NOT_MODIFIED')
				{
					return;
				}
			}
			
			//set last update time
			if(strLastUpdateTime)
			{
				EBToolbarPreferenceManager_CT459487.SetPref(EBPreferenceConsts_CT459487.ThirdPartyComponentsLastUpdate,strLastUpdateTime);
			}
			
			//set interval
			if(strInterval && isFinite(strInterval))
			{
				EBToolbarPreferenceManager_CT459487.SetPref(EBPreferenceConsts_CT459487.ThirdPartyComponentsInterval,strInterval);
			}
			
			//set last check to now
			var oDateCurrent = new Date();
			var strCurrentDate = oDateCurrent.toString();
			EBToolbarPreferenceManager_CT459487.SetPref(EBPreferenceConsts_CT459487.ThirdPartyComponentsLastCheck,strCurrentDate);
			
			
			//write the content to the file
			var strXMLThirdPartyComponents	= EBGlobalManager_CT459487.GetStringXml(XMLThirdPartyComponents);
			var oFileThirdPartyComponents	= EBIOManager_CT459487.CreateToolbarFile(EBServerCommunicationConsts_CT459487.THIRD_PARTY_COMPONENTS_FILE_NAME);
			EBFileIO_CT459487.write(oFileThirdPartyComponents,strXMLThirdPartyComponents,'',EBGlobalConsts_CT459487.DefaultCharset);
			
		}
		catch(ex){}
	},
	
	IsThirdPartyComponentsValidFile : function()
	{
		var oFile = EBIOManager_CT459487.CreateToolbarFile(EBServerCommunicationConsts_CT459487.THIRD_PARTY_COMPONENTS_FILE_NAME);
		if(!oFile || !oFile.exists() || oFile.fileSize <= 0)
		{
			return false;
		}
		return true;
	},
	
	IsThirdPartyComponentsLastCheckElapsed : function()
	{
		var strLastCheckPrefName		= EBPreferenceConsts_CT459487.ThirdPartyComponentsLastCheck;
		var strLastCheckPrefValue		= EBToolbarPreferenceManager_CT459487.GetPref(strLastCheckPrefName);
		
		if(!strLastCheckPrefValue)
		{
			return true;
		}
		
		var strIntervalPrefName		= EBPreferenceConsts_CT459487.ThirdPartyComponentsInterval;
		var strIntervalPrefValue	= EBToolbarPreferenceManager_CT459487.GetPref(strIntervalPrefName);
		
		if(!strIntervalPrefValue || !isFinite(strIntervalPrefValue))
		{
			return true;
		}
		
		//compare between the times:
		var oDateLastCheck	= new Date(strLastCheckPrefName);
		var oDateCurrent	= new Date();
		
		var iInterval = parseInt(strIntervalPrefValue);
		//interval in milliseconds(the interval is in hours!)
		var iMilliInterval = 1000*60*60*iInterval;
		
		//the difference in milliseconds
		var iMillTimeGap = oDateCurrent - oDateLastCheck;
		
		//check if time expires
		if(iMillTimeGap > iMilliInterval)
		{
			return true;
		}
		
		return false;
	},
	
	GetThirdPartyComponentsLastUpdate : function()
	{
		var strPrefName		= EBPreferenceConsts_CT459487.ThirdPartyComponentsLastUpdate;
		var strPrefValue	= EBToolbarPreferenceManager_CT459487.GetPref(strPrefName);
		
		return strPrefValue;
	},
	
	LoadThirdPartyComponentsXML : function()
	{
		var oFileThirdPartyComponents	= EBIOManager_CT459487.CreateToolbarFile(EBServerCommunicationConsts_CT459487.THIRD_PARTY_COMPONENTS_FILE_NAME);
		var strXMLThirdPartyComponents	= EBFileIO_CT459487.read(oFileThirdPartyComponents,EBGlobalConsts_CT459487.DefaultCharset);
		var XMLDocThirdPartyComponents	= EBGlobalManager_CT459487.GetXmlDocument(strXMLThirdPartyComponents);
		var XMLThirdPartyComponents		= XMLDocThirdPartyComponents.documentElement;
		return XMLThirdPartyComponents;
	},

	GetFullSettingsXmlRQ : function(strCTID,strVersion,strXmlType,strPlatform,strLastUpdateTime)
	{
		var XMLDoc = EBGlobalManager_CT459487.GetXmlDocument(EBServerCommunicationConsts_CT459487.EBXML_CT_SETTINGS_REQUEST);
		
		var XMLEBMSG = this.GetXMLEBMSGNodeByXMLDoc(XMLDoc);
		
		if(!XMLEBMSG)
		{
			return '';
		}
		
		var XMLChildNode = null;
		for(var i=0;i<XMLEBMSG.childNodes.length;i++)
		{
			var XMLChildNode = XMLEBMSG.childNodes[i];
			
			if(XMLChildNode.tagName == "CT_ID")
			{
				XMLChildNode.appendChild(EBGlobalManager_CT459487.CreateXmlTextValue(XMLDoc,strCTID));
			}
			else if(XMLChildNode.tagName == "VERSION")
			{
				XMLChildNode.appendChild(EBGlobalManager_CT459487.CreateXmlTextValue(XMLDoc,strVersion));
			}
			else if(XMLChildNode.tagName == "XML_TYPE")
			{
				XMLChildNode.appendChild(EBGlobalManager_CT459487.CreateXmlTextValue(XMLDoc,strXmlType));
			}
			else if(XMLChildNode.tagName == "PLATFORM")
			{
				XMLChildNode.appendChild(EBGlobalManager_CT459487.CreateXmlTextValue(XMLDoc,strPlatform));
			}
			else if(XMLChildNode.tagName == "LAST_UPDATE_TIME")
			{	
				XMLChildNode.appendChild(EBGlobalManager_CT459487.CreateXmlTextValue(XMLDoc,strLastUpdateTime));
			}
		}
		
		return EBGlobalManager_CT459487.GetStringXml(XMLDoc);
	},
	
	GetFullLoginXmlRQ : function(strCTID,strUserId,strVersion,strTimeStamp,strPlatform,strBrowserVersion)
	{
		var XMLDoc = EBGlobalManager_CT459487.GetXmlDocument(EBServerCommunicationConsts_CT459487.EBXML_CT_LOGIN_REQUEST);
		
		var XMLEBMSG = this.GetXMLEBMSGNodeByXMLDoc(XMLDoc);
		
		if(!XMLEBMSG)
		{
			return '';
		}
		
		var XMLChildNode = null;
		for(var i=0;i<XMLEBMSG.childNodes.length;i++)
		{
			var XMLChildNode = XMLEBMSG.childNodes[i];
			
			if(XMLChildNode.tagName == "CT_ID")
			{
				XMLChildNode.appendChild(EBGlobalManager_CT459487.CreateXmlTextValue(XMLDoc,strCTID));
			}
			else if(XMLChildNode.tagName == "USERID")
			{
				XMLChildNode.appendChild(EBGlobalManager_CT459487.CreateXmlTextValue(XMLDoc,strUserId));
			}
			else if(XMLChildNode.tagName == "VERSION")
			{
				XMLChildNode.appendChild(EBGlobalManager_CT459487.CreateXmlTextValue(XMLDoc,strVersion));
			}
			else if(XMLChildNode.tagName == "TIMESTAMP")
			{
				XMLChildNode.appendChild(EBGlobalManager_CT459487.CreateXmlTextValue(XMLDoc,strTimeStamp));
			}
			else if(XMLChildNode.tagName == "PLATFORM")
			{
				XMLChildNode.appendChild(EBGlobalManager_CT459487.CreateXmlTextValue(XMLDoc,strPlatform));
			}
			else if(XMLChildNode.tagName == "BROWSER_VERSION")
			{
				XMLChildNode.appendChild(EBGlobalManager_CT459487.CreateXmlTextValue(XMLDoc,strBrowserVersion));
			}
		}
		
		return EBGlobalManager_CT459487.GetStringXml(XMLDoc);
	},
	
	GetFullUsageXmlRQ : function(strVersion,strCTID,strComponentID,strComponentType,strGeneralParam1,strGeneralParam2,strPlatform)
	{
		var XMLDoc = EBGlobalManager_CT459487.GetXmlDocument(EBServerCommunicationConsts_CT459487.EBXML_CT_USAGE_REQUEST);
		
		var XMLEBMSG = this.GetXMLEBMSGNodeByXMLDoc(XMLDoc);
		
		if(!XMLEBMSG)
		{
			return '';
		}
		
		var XMLChildNode = null;
		
		for(var i=0;i<XMLEBMSG.childNodes.length;i++)
		{
			var XMLChildNode = XMLEBMSG.childNodes[i];
			
			if(XMLChildNode.tagName == "VERSION")
			{
				XMLChildNode.appendChild(EBGlobalManager_CT459487.CreateXmlTextValue(XMLDoc,strVersion));
			}
			else if(XMLChildNode.tagName == "CT_ID")
			{
				XMLChildNode.appendChild(EBGlobalManager_CT459487.CreateXmlTextValue(XMLDoc,strCTID));
			}
			else if(XMLChildNode.tagName == "COMPONENT_ID")
			{
				XMLChildNode.appendChild(EBGlobalManager_CT459487.CreateXmlTextValue(XMLDoc,strComponentID));
			}
			else if(XMLChildNode.tagName == "COMPONENT_TYPE")
			{
				XMLChildNode.appendChild(EBGlobalManager_CT459487.CreateXmlTextValue(XMLDoc,strComponentType));
			}
			else if(XMLChildNode.tagName == "GENERAL_PARAM1")
			{
				XMLChildNode.appendChild(EBGlobalManager_CT459487.CreateXmlTextValue(XMLDoc,strGeneralParam1));
			}
			else if(XMLChildNode.tagName == "GENERAL_PARAM2")
			{
				XMLChildNode.appendChild(EBGlobalManager_CT459487.CreateXmlTextValue(XMLDoc,strGeneralParam2));
			}
			else if(XMLChildNode.tagName == "PLATFORM")
			{
				XMLChildNode.appendChild(EBGlobalManager_CT459487.CreateXmlTextValue(XMLDoc,strPlatform));
			}
		}
		
		return EBGlobalManager_CT459487.GetStringXml(XMLDoc);
	},
	
	GetFullThirdPartyComponentsXMLRQ : function(strCTID,strPlatform,strLastUpdateTime)
	{
		var XMLDoc = EBGlobalManager_CT459487.GetXmlDocument(EBServerCommunicationConsts_CT459487.EBXML_CT_THIRD_PARTY_COMPONENTS_REQUEST);
		
		var XMLEBMSG = this.GetXMLEBMSGNodeByXMLDoc(XMLDoc);
		
		if(!XMLEBMSG)
		{
			return '';
		}
		
		var XMLChildNode = null;
		
		for(var i=0;i<XMLEBMSG.childNodes.length;i++)
		{
			var XMLChildNode = XMLEBMSG.childNodes[i];
			
			if(XMLChildNode.tagName == "CT_ID")
			{
				XMLChildNode.appendChild(EBGlobalManager_CT459487.CreateXmlTextValue(XMLDoc,strCTID));
			}
			else if(XMLChildNode.tagName == "PLATFORM")
			{
				XMLChildNode.appendChild(EBGlobalManager_CT459487.CreateXmlTextValue(XMLDoc,strPlatform));
			}
			else if(XMLChildNode.tagName == "LAST_UPDATE_TIME")
			{
				XMLChildNode.appendChild(EBGlobalManager_CT459487.CreateXmlTextValue(XMLDoc,strLastUpdateTime));
			}
		}
		
		return EBGlobalManager_CT459487.GetStringXml(XMLDoc);
	},

	GetUserId : function()
	{

		var strUserId;
		//get it from preference
		strUserId = EBToolbarPreferenceManager_CT459487.GetPref(EBPreferenceConsts_CT459487.UserID);
		if(!strUserId || strUserId.length != EBServerCommunicationConsts_CT459487.USER_ID_LEGAL_LENGTH)
		{
			strUserId = this.GenerateUserId();
			//save it to pref
			EBToolbarPreferenceManager_CT459487.SetPref(EBPreferenceConsts_CT459487.UserID,strUserId);
		}
		
		return strUserId;
	},
	
	GenerateTimeStamp : function()
	{
		var strTimeStamp = "";
		
		var dateObj		= new Date();
		
		var strMonth = "";
		var iMonth	= dateObj.getMonth();
		iMonth++;
		strMonth = iMonth < 10 ? "0" + iMonth : iMonth;
		
		var strDay = "";
		var iDay = dateObj.getDate();
		strDay = iDay < 10 ? "0" + iDay : iDay;
		
		var strYear		= dateObj.getFullYear();
		
		var strHour = "";
		var iHour = dateObj.getHours();
		strHour = iHour < 10 ? "0" + iHour : iHour;
		
		var strMinute = "";
		var iMinute = dateObj.getMinutes();
		strMinute = iMinute < 10 ? "0" + iMinute : iMinute;
		
		var strSecond = "";
		var iSecond = dateObj.getSeconds();
		strSecond = iSecond < 10 ? "0" + iSecond : iSecond;
		
		strTimeStamp = strMonth.toString() + "-" + 
					strDay.toString() + "-" + 
					strYear.toString() + " " + 
					strHour.toString() + ":" + 
					strMinute.toString() + ":" + 
					strSecond.toString();
		
		return strTimeStamp;
		
	},
	
	GenerateUserId : function()
	{
		var strUserId = "";
		var strUserIdPrefix = "UN";
		
		var dateObj		= new Date();
		
		var strYear		= dateObj.getFullYear();
		
		var strMonth = "";
		var iMonth	= dateObj.getMonth();
		iMonth++;
		strMonth = iMonth < 10 ? "0" + iMonth : iMonth;
		
		var strDay = "";
		var iDay = dateObj.getDate();
		strDay = iDay < 10 ? "0" + iDay : iDay;
		
		var strHour = "";
		var iHour = dateObj.getHours();
		strHour = iHour < 10 ? "0" + iHour : iHour;
		
		var strMinute = "";
		var iMinute = dateObj.getMinutes();
		strMinute = iMinute < 10 ? "0" + iMinute : iMinute;
		
		var strSecond = "";
		var iSecond = dateObj.getSeconds();
		strSecond = iSecond < 10 ? "0" + iSecond : iSecond;
		
		var strMillisecond = "";
		var iMillisecond = dateObj.getMilliseconds();
		if(iMillisecond < 10)
		{
			strMillisecond = "00" + iMillisecond;
		}
		else if(iMillisecond < 100)
		{
			strMillisecond = "0" + iMillisecond;
		}
		else
		{
			strMillisecond = iMillisecond;
		}
		
		
		strUserId = strUserIdPrefix + 
					strYear.toString() +
					strMonth.toString() + 
					strDay.toString() + 
					strHour.toString() + 
					strMinute.toString() + 
					strSecond.toString() + 
					strMillisecond.toString();
					
		return strUserId;
	}
}

function EBSuggestObject_CT459487(strDomain,strSearchParam,strOutputCharset)
{
	this.domain			= strDomain;
	this.searchParam	= strSearchParam;	
	this.outputCharset	= strOutputCharset;
}


var EBSuggestsManager_CT459487 = 
{
	CheckSuggests : function()
	{
		var arrToolbarSuggests = EBToolbarData_CT459487.ToolbarSuggests;
		
		if(arrToolbarSuggests)
		{
			for(var i=0;i<arrToolbarSuggests.length;i++)
			{
				this.SetSuggest(arrToolbarSuggests[i]);
			}
		}
	},
	
	SetSuggest : function(ebSuggestObj)
	{
		var strKeyword = this.GetKeyword(ebSuggestObj)
		
		if(strKeyword)
		{
			EBActionManager_CT459487.SetToolbarSearchTerm(strKeyword);
		}
		
	},
	
	GetKeyword : function(ebSuggestObj)
	{
		var strKeyword			= "";
		
		var DELIMITER_PARAMS	= '&';
		
		var strDomain			= ebSuggestObj.domain;
		var strSearchParam		= ebSuggestObj.searchParam;
		var strOutputCharset	= ebSuggestObj.outputCharset;
		
		//get the current url
		var strCurrentUrl		= EBGlobalVariables_CT459487.MainFrameURL;
		
		//check the current url with the suggest element
		if(strCurrentUrl.indexOf(strDomain) != -1)
		{
			//get the index of the search param
			var iIndexOfParam = strCurrentUrl.indexOf(strSearchParam);
			if(iIndexOfParam != -1)
			{
				//get the url string from the search param till the end
				var strUrlFromParam = strCurrentUrl.substring(iIndexOfParam + strSearchParam.length);
				
				//check if this is the keyword by getting the next delimiter params(usually '&')
				var iIndexOfNextParam = strUrlFromParam.indexOf(DELIMITER_PARAMS);
				if(iIndexOfNextParam != -1)
				{
					strKeyword = strUrlFromParam.substring(0,iIndexOfNextParam);
				}
				else
				{
					strKeyword = strUrlFromParam;
				}
			}
		}
		
		strKeyword = this.ConvertKeyword(strKeyword,strOutputCharset);
		
		return strKeyword;
	},
	
	ConvertKeyword : function(strKeyword,strCharset)
	{
		if(strKeyword == "")
			return "";
			
		//convert the url spacing before!!! the main conversion itself.
		strKeyword = strKeyword.replace(/\+/g,' ');

		//convert the search keyword back from the url keyword to normal one
		strKeyword = unescape(strKeyword);
		strKeyword = EBFileIO_CT459487.toUnicode(strCharset,strKeyword);

		
		return strKeyword;
	}
	
	
}
var EBToolbarApiManager_CT459487 = 
{
	//check each time a page change(from the webProgressListener)
	//to set the class of the api to that html page.
	CheckPage : function(objBrowser)
	{
		var oContentWindow = objBrowser.contentWindow;
		var objJavascript = EBGlobalManager_CT459487.GetWebPageJavascriptObject(oContentWindow);
		
		if(objJavascript.EBToolbarApi)
		{
			//set the object api from the javascript web page
			//to the current object api of the extension(it's the same object hierarchy!)
			objJavascript.EBToolbarApi = EBToolbarApi_CT459487;
		}	
	},
	
	GetRefreshFunction : function(strCTID)
	{
		//important to change the strCTID to uppercase cause the code
		//in the toolbar is uppercase
		var strRefreshFunction = 'EBSpecialCommands_' + strCTID.toUpperCase() + '.REFRESH_TOOLBAR_VIEW();';
		return strRefreshFunction;
	},
	
	IsToolbarInstalled : function(strCTID)
	{
		var arrCTID = EBActionManager_CT459487.GetEBToolbarsCTID();
		
		for(var i=0;i<arrCTID.length;i++)
		{
			if(arrCTID[i] == strCTID.toUpperCase())
			{
				return true;
			}
		}
		
		return false;
	}
	
}

//this class of the toolbarapi has the exact same structure as 
//the javascript EBToolbarApi have - this is how Firefox works.
//the IE toolbar only catch the bookmarklet 'javascript:' call.
var EBToolbarApi_CT459487 =
{
	Result : false,
	
	ResetResult : function()
	{
		this.Result = false;
	},
	
	SetResult : function(bValue)
	{
		this.Result = bValue;
	},
	
	GetResult : function()
	{
		return 	this.Result;
	},
	
	RefreshAllToolbars : function()
	{
		var bResult = false;
		var arrCTID = EBActionManager_CT459487.GetEBToolbarsCTID();
		
		var strCTID				= '';
		var strRefreshFunction	= '';
		
		for(var i=0;i<arrCTID.length;i++)
		{
			strCTID = arrCTID[i];
			strRefreshFunction = EBToolbarApiManager_CT459487.GetRefreshFunction(strCTID);
			bResult = this.ExecuteFunction(strRefreshFunction);
		}
		
		this.SetResult(bResult);
	},
	
	RefreshToolbarByCTID : function(strCTID)
	{
		var bResult = false;
		
		if(strCTID)
		{
			var strRefreshFunction = EBToolbarApiManager_CT459487.GetRefreshFunction(strCTID);
		
			if(EBToolbarApiManager_CT459487.IsToolbarInstalled(strCTID))
			{
				bResult = this.ExecuteFunction(strRefreshFunction);
			}
		}
		
		this.SetResult(bResult);
	},
	
	IsToolbarInstalled : function(strCTID)
	{
		var bResult = false;
		if(strCTID)
		{
			bResult = EBToolbarApiManager_CT459487.IsToolbarInstalled(strCTID);
		}
		this.SetResult(bResult);
	},
	
	ExecuteFunction : function(strFunction)
	{
		
		var bResult = false;
		//try to activate the function
		try
		{
			//set the call to the function in a different thread 
			//so it won't be related to the web page who defines it!!
			setTimeout(function(){eval(strFunction);},1);
			bResult = true;
		}
		catch(ex)
		{
			bResult = false;
		}
		
		return bResult;
	}
}/********************** Browser Component - Item *********************************/
function EBBrowserItem_CT459487(xmlNode,strCompType)
{
	this.width 	= "150";//default value
	this.height = "20";
	this.url 	= "";
	
	this.strId = "";
	
	this.UniqueCompID	= '';
	this.CompType		= strCompType;
	
	this.DisplayText	= '';
	this.DisplayIcon	= '';
	
	this.Permission		= EBComponentsConsts_CT459487.Editable.FULL;
	this.ShowInChevron	= EBComponentsConsts_CT459487.TRUE;
	
	this.Create = function(xmlNode)
	{
		//set the attributes
		for(var i=0;i<xmlNode.childNodes.length;i++)
		{
			if(xmlNode.childNodes[i].tagName == "WIDTH")
			{
				this.width = EBGlobalManager_CT459487.GetXmlNodeValue(xmlNode.childNodes[i]);
			}
			else if(xmlNode.childNodes[i].tagName == "URL")
			{
				this.url = EBGlobalManager_CT459487.GetXmlNodeValue(xmlNode.childNodes[i]);
				this.url = EBGlobalManager_CT459487.FromLegalXml(this.url);
			}
			else if(xmlNode.childNodes[i].tagName == "UNIQUE_COMP_ID")
			{
				this.UniqueCompID = EBGlobalManager_CT459487.GetXmlNodeValue(xmlNode.childNodes[i]);
				this.strId = "ebBrowserComponent" + EBGlobalConsts_CT459487.ToolbarCTID + this.UniqueCompID;
			}
			else if(xmlNode.childNodes[i].tagName == "DISPLAY_TEXT")
			{
				this.DisplayText = EBGlobalManager_CT459487.GetXmlNodeValue(xmlNode.childNodes[i]);
			}
			else if(xmlNode.childNodes[i].tagName == "DISPLAY_ICON")
			{
				this.DisplayIcon = EBGlobalManager_CT459487.GetXmlNodeValue(xmlNode.childNodes[i]);
			}
			else if(xmlNode.childNodes[i].tagName == "USER_ATTRIBUTES")
			{
				var XMLUserAttributes = xmlNode.childNodes[i];
				var XMLUserAttribute  = null;
				for(var j=0;j<XMLUserAttributes.childNodes.length;j++)
				{
					XMLUserAttribute = XMLUserAttributes.childNodes[j];
					if(XMLUserAttribute.tagName == "PERMISSION")
					{
						this.Permission = EBGlobalManager_CT459487.GetXmlNodeValue(XMLUserAttribute);
					}
					else if(XMLUserAttribute.tagName == "SHOW_IN_CHEVRON")
					{
						this.ShowInChevron = EBGlobalManager_CT459487.GetXmlNodeValue(XMLUserAttribute);
					}
				}
			}
		}
		
		
		//validate component id
		this.UniqueCompID = EBComponentsManager_CT459487.ValidateComponentID(this.UniqueCompID);
	
		//validate display text and icon
		this.ValidateDisplayTextIcon();
	};
	
	this.ValidateDisplayTextIcon = function()
	{
		if(!this.DisplayText)
		{
			this.DisplayText = EBBrowserComponentConsts_CT459487.Caption;
		}
		
		if(!this.DisplayIcon)
		{
			this.DisplayIcon = EBBrowserComponentConsts_CT459487.Images.MiniBrowser;
		}
	};
	
	this.Create(xmlNode);
}
function EBBrowserComponent_CT459487(browserItem)
{
	this.ComponentItem				= browserItem;
	
	this.XULElement					= null;
	
	this.XULChevronElement			= null;
	
	this.XULToolbarItemContainer	= null;

	this.Init = function()
	{
	
		//check validation of this component
		if(this.ComponentItem.url == "")
		{
			return false;
		}

		
		//replace the aliases for the browser component
		this.ComponentItem.url = EBActionManager_CT459487.ConvertAliasesUrl(this.ComponentItem.url);
		//add this url to the initial url's array to check it later 
		//in the progressive listener not to go to this page
		EBBrowserComponentManager_CT459487.AddInitialUrl(this.ComponentItem.url);
			
		//create the xul element
		this.XULElement = EBXULFactory_CT459487.CreateBrowser(this.ComponentItem.strId,
															this.ComponentItem.url,
															this.ComponentItem.width,
															this.ComponentItem.height);
								
		this.XULElement.setAttribute('onclick','EBBrowserComponentManager_CT459487.OnClick(event,\''+this.ComponentItem.UniqueCompID+'\');');
		return true;
	};
	
	
	
	this.AddToToolbar = function(objToolbarContainer)
	{
		this.XULToolbarItemContainer = EBXULFactory_CT459487.CreateToolbarItem();
		this.XULToolbarItemContainer.appendChild(this.XULElement);
		objToolbarContainer.appendChild(this.XULToolbarItemContainer);
		
		this.OnLoadElement();
		
	};
	
	this.OnLoadElement = function()
	{
		if(EBGlobalManager_CT459487.IsNewestBrowserAPI())
		{
			//in firefox new version the progress listener set here!
			var strBCID = this.ComponentItem.strId;
			EBBrowserComponentApiManager_CT459487.OnLoadBrowserComponent(strBCID);
		}	
	};
	
	this.OnUnloadElement = function()
	{
		
		try
		{
			//remoev this progress listener of this browser xul element
			this.XULElement.removeProgressListener(EBBrowserComponentListener_CT459487);
		}
		catch(ex){}
	};
	
	this.UnloadComponent = function()
	{
		this.OnUnloadElement();
	};
	
	this.SetToolbarButtonClass = function()
	{
			
	};
	
	//if this element should be in chevron return the toolbar item 
	//of this element
	this.IsToChevron = function()
	{
		var XULToolbarItem	= null;
		
		var isLastShownComponent = EBComponentsManager_CT459487.IsLastShownComponent(this);
		
		var isInChevron		=  EBChevronManager_CT459487.IsInChevron(this.XULToolbarItemContainer,isLastShownComponent);
		if(isInChevron)  
		{
			XULToolbarItem = this.XULToolbarItemContainer;
		}
		
		return XULToolbarItem;
	};
	
	this.SetComponentCollapsed = function(isCollapsed)
	{
		if(this.XULToolbarItemContainer)
		{
			this.XULToolbarItemContainer.setAttribute('collapsed',isCollapsed);
		}
	};
	
	this.AddToChevron = function(objXULContainer)
	{
		this.XULChevronElement = null;

		var strLabel	=	this.ComponentItem.DisplayText;
		var strImage	= 	this.ComponentItem.DisplayIcon;
		this.XULChevronElement = EBXULFactory_CT459487.CreateMenuItem(strLabel,
																	strImage,
																	'',
																	'',
																	'',
																	null);
		
		this.XULChevronElement.setAttribute('disabled','true');
		objXULContainer.appendChild(this.XULChevronElement);
			
	
		
		return this.XULChevronElement;
	};
}



/***********************************************************************************/


//progressive listener object to listen to the pages of the browser
var EBBrowserComponentListener_CT459487 =
{
  QueryInterface: function(aIID)
  {
   if (aIID.equals(Components.interfaces.nsIWebProgressListener) ||
       aIID.equals(Components.interfaces.nsISupportsWeakReference) ||
       aIID.equals(Components.interfaces.nsISupports))
     return this;
   throw Components.results.NS_NOINTERFACE;
  },
  
  onStateChange: function(aProgress, aRequest, aFlag, aStatus)
  {	
		var strBCID = aProgress.DOMWindow.name;

		//get the url
		var strUrl = aRequest.name;
	
		
		if(aFlag & Components.interfaces.nsIWebProgressListener.STATE_IS_DOCUMENT)
		{
			if(aFlag & Components.interfaces.nsIWebProgressListener.STATE_START)
			{
				EBBrowserComponentManager_CT459487.SetUrlNavigation(strBCID, strUrl);
			}
		}

		if(aFlag & Components.interfaces.nsIWebProgressListener.STATE_START)
		{
			
		}

		if(aFlag & Components.interfaces.nsIWebProgressListener.STATE_STOP)
		{
			
		}

		return 0;
  },

  onLocationChange: function(aProgress, aRequest, aURI)
  {
	   // This fires when the location bar changes i.e load event is confirmed
	   // or when the user switches tabs
	   return 0;
  },

  // For definitions of the remaining functions see XulPlanet.com
  onProgressChange: function() {return 0;},
  onStatusChange: function() {return 0;},
  onSecurityChange: function() {return 0;},
  onLinkIconAvailable: function() {return 0;}
}

var EBBrowserComponentManager_CT459487 = 
{
	ARR_INITIAL_URL : new Array,
	
	AddInitialUrl : function(strUrl)
	{
		this.ARR_INITIAL_URL[this.ARR_INITIAL_URL.length] = strUrl;
	},
	
	IsInitialUrlExists : function(strUrl)
	{
		for(var i=0;i<this.ARR_INITIAL_URL.length;i++)
		{
			if(strUrl.toLowerCase() == this.ARR_INITIAL_URL[i].toLowerCase())
			{
				return true;
			}
		}
		
		return false;
	},
	
	SetUrlNavigation : function(strBCID, strUrl)
	{
		var xulCurrentBrowser = document.getElementById(strBCID);
		
		if(!xulCurrentBrowser)
		{
			return;
		}
		
		//convert the eb_aliases
		strUrl = EBActionManager_CT459487.ConvertAliasesUrl(strUrl);
		
		if(this.IsInitialUrlExists(strUrl))
		{
			return;
		}
		else if(strUrl.indexOf("EBChangeSize") != -1)
		{
			xulCurrentBrowser.stop();
			
			//get the change size function name
			var strChangeSizeFunction	= strUrl.substring(strUrl.indexOf("EBChangeSize"));
			var strWidthParam			= strChangeSizeFunction.substring(strChangeSizeFunction.indexOf("(") + 1 ,strChangeSizeFunction.indexOf(")"));
			
			EBBrowserComponentApiManager_CT459487.ChangeSize(xulCurrentBrowser,strWidthParam);
			
		}
		else if(strUrl.indexOf("EBNavigate") != -1)
		{
			xulCurrentBrowser.stop();
			//get the the navigate function name
			var strEBNavigateFunction = strUrl.substring(strUrl.indexOf("EBNavigate"));
			
			var strUrlParam		= strEBNavigateFunction.substring(strEBNavigateFunction.indexOf("(") + 1 ,strEBNavigateFunction.indexOf(","));
			var strWidthParam	= strEBNavigateFunction.substring(strEBNavigateFunction.indexOf(",") + 1 ,strEBNavigateFunction.indexOf(")"));
			
			EBBrowserComponentApiManager_CT459487.Navigate(xulCurrentBrowser,strUrlParam,strWidthParam);
		}
		else if(strUrl.indexOf("EBRefreshToolbar") != -1)
		{
			xulCurrentBrowser.stop();
			EBSpecialCommands_CT459487.REFRESH_TOOLBAR_VIEW();
			
		}
		else if(strUrl.toLowerCase().indexOf("#_self") != -1)
		{
			return;
		}
		else if(strUrl.toLowerCase().indexOf("#_new") != -1)
		{
			xulCurrentBrowser.stop();
			strUrl = strUrl.replace("#_new","");
			EBGlobalManager_CT459487.LoadURLInNewWindow(strUrl);
		}
		else if(strUrl.toLowerCase().indexOf("#_tab") != -1)
		{
			xulCurrentBrowser.stop();
			strUrl = strUrl.replace("#_tab","");
			EBLinkManager_CT459487.LoadLinkURL(null,strUrl,true,null);
		}
		else if(strUrl.toLowerCase().indexOf("#_blank") != -1)
		{
			xulCurrentBrowser.stop();
			EBLinkManager_CT459487.LoadLinkURL(null,"about:blank",false,null);
		}
		else
		{
			//load the url normally and cacnel the request(stop the browser!)
			xulCurrentBrowser.stop();
			EBLinkManager_CT459487.LoadLinkURL(null,strUrl,false,null);
		}
		
		//set the width of the browser
		EBBrowserComponentApiManager_CT459487.SetInitialWidth(xulCurrentBrowser);
		
	},
	
	SetProgressiveListener : function(strBCID)
	{
		document.getElementById(strBCID).contentWindow.addEventListener("load",function(){EBBrowserComponentApiManager_CT459487.OnLoadBrowserComponent(strBCID);}, false);
	},
	
	OnClick : function(event, strBCID)
	{
		this.SendUsage(strBCID);
	},
	
	SendUsage : function(strBCID)
	{
		var objUsage = new EBUsageObject_CT459487(strBCID,
													'BROWSER_COMPONENT',
													'',
													'');
		//send the data
		objUsage.SendRequest();
	}
}

/************************ Button Item *****************************/
function EBButtonItem_CT459487(xmlNode,strCompType)
{
	this.button = new EBButton_CT459487();
	
	//special attributes to each type
	this.link 			= '';
	this.command 		= '';
	this.interval 		= '';
	
	this.UniqueCompID	= '';
	this.CompType		= strCompType;
	
	this.DisplayText	= '';
	this.DisplayIcon	= '';
	
	this.Permission		= EBComponentsConsts_CT459487.Editable.FULL;
	this.ShowInChevron	= EBComponentsConsts_CT459487.TRUE;
	
	this.Create = function(xmlNode)
	{
		//set the type
		var strTagName = xmlNode.tagName;
	
		if(strTagName == "LINK_BUTTONITEM")
		{
			this.button.type = "LINK";
		}
		else if(strTagName == "SPECIAL_COMMAND_ITEM")
		{
			this.button.type = "COMMAND";
		}
		
		//set the attributes
		for(var i=0;i<xmlNode.childNodes.length;i++)
		{
			if(xmlNode.childNodes[i].tagName == "UNIQUE_COMP_ID")
			{
				this.UniqueCompID = EBGlobalManager_CT459487.GetXmlNodeValue(xmlNode.childNodes[i]);
			}
			else if(xmlNode.childNodes[i].tagName == "BUTTON_TEXT")
			{
				this.button.text = EBGlobalManager_CT459487.GetXmlNodeValue(xmlNode.childNodes[i]);
			}
			else if(xmlNode.childNodes[i].tagName == "BUTTON_TOOLTIP")
			{
				this.button.tooltip = EBGlobalManager_CT459487.GetXmlNodeValue(xmlNode.childNodes[i]);
			}
			else if(xmlNode.childNodes[i].tagName == "BUTTON_ICON")
			{
				this.button.image = EBGlobalManager_CT459487.GetXmlNodeValue(xmlNode.childNodes[i]);
			}
			else if(xmlNode.childNodes[i].tagName == "BUTTON_LINK")
			{
				this.link = EBGlobalManager_CT459487.GetXmlNodeValue(xmlNode.childNodes[i]);
				this.link = EBGlobalManager_CT459487.LegalizeLinkUrl(this.link);
			}
			else if(xmlNode.childNodes[i].tagName == "TARGET")
			{
				this.button.target = EBGlobalManager_CT459487.GetXmlNodeValue(xmlNode.childNodes[i]);
			}
			else if(xmlNode.childNodes[i].tagName == "BUTTON_COMMAND_ID")
			{
				this.command = EBGlobalManager_CT459487.GetXmlNodeValue(xmlNode.childNodes[i]);
			}
			else if(xmlNode.childNodes[i].tagName == "DISPLAY_TEXT")
			{
				this.DisplayText = EBGlobalManager_CT459487.GetXmlNodeValue(xmlNode.childNodes[i]);
			}
			else if(xmlNode.childNodes[i].tagName == "DISPLAY_ICON")
			{
				this.DisplayIcon = EBGlobalManager_CT459487.GetXmlNodeValue(xmlNode.childNodes[i]);
			}
			else if(xmlNode.childNodes[i].tagName == "USER_ATTRIBUTES")
			{
				var XMLUserAttributes = xmlNode.childNodes[i];
				var XMLUserAttribute  = null;
				for(var j=0;j<XMLUserAttributes.childNodes.length;j++)
				{
					XMLUserAttribute = XMLUserAttributes.childNodes[j];
					if(XMLUserAttribute.tagName == "PERMISSION")
					{
						this.Permission = EBGlobalManager_CT459487.GetXmlNodeValue(XMLUserAttribute);
					}
					else if(XMLUserAttribute.tagName == "SHOW_IN_CHEVRON")
					{
						this.ShowInChevron = EBGlobalManager_CT459487.GetXmlNodeValue(XMLUserAttribute);
					}
				}
			}
			
		}
		
		
		//validate component id
		this.UniqueCompID = EBComponentsManager_CT459487.ValidateComponentID(this.UniqueCompID);
		
		//validate display text and icon
		this.ValidateDisplayTextIcon();
	};
	
	this.ValidateDisplayTextIcon = function()
	{
		if(!this.DisplayText)
		{
			this.DisplayText = this.button.text;
		}
		
		if(!this.DisplayIcon)
		{
			this.DisplayIcon = this.button.image;
		}
	};
	
	this.Create(xmlNode);

}

function EBButtonComponent_CT459487(buttonItem)
{
	this.ComponentItem				= buttonItem;
	
	this.XULElement					= null;
	
	this.XULChevronElement			= null;
	
	this.XULToolbarItemContainer	= null;
	
	this.Init = function()
	{	
		//check validation of this component
		if(this.ComponentItem.button.text == "" && this.ComponentItem.button.image == "")
		{
			return false;
		}
		
		if(this.ComponentItem.link == "" && this.ComponentItem.command == "" && this.ComponentItem.interval == "")
		{
			return false;
		}
			
		//set the command value
		var strCommand;
		if(this.ComponentItem.button.type == "LINK")
		{
			if(this.ComponentItem.button.target == "NEW")
			{
				strCommand = "EBButtonManager_CT459487.LoadLink(event,'"+this.ComponentItem.UniqueCompID+"','"+this.ComponentItem.link+"',true);";
			}
			else
			{
				strCommand = "EBButtonManager_CT459487.LoadLink(event,'"+this.ComponentItem.UniqueCompID+"','"+this.ComponentItem.link+"',false);";
			}
		}
		else if(this.ComponentItem.button.type == "COMMAND")
		{
			//check if this command is supported by Firefox :-)
			if(!EBSpecialCommands_CT459487.IsSupportedCommand(this.ComponentItem.command))
			{
				return false;
			}
			strCommand = "EBButtonManager_CT459487.LoadCommand(event,'"+this.ComponentItem.UniqueCompID+"','"+this.ComponentItem.command+"');";
		}
		
		var strLabel	= this.ComponentItem.button.text;
		var strImage	= this.ComponentItem.button.image;
		var strHint		= this.ComponentItem.button.tooltip;
		
		//create the xul element
		var strButtonID = EBComponentsManager_CT459487.GetToolbarButtonID(this.ComponentItem.UniqueCompID);
		this.XULElement = EBXULFactory_CT459487.CreateToolbarButton(strButtonID,
														"",
														strLabel,
														strImage,
														strHint,
														strCommand,
														"");								
		
		//create the tooltip element (for the shrink-unshrink tooltip)
		this.CreateTooltipShrink();
		
		return true;
	};
	
	
	this.AddToToolbar = function(objToolbarContainer)
	{
		//set toolbar button class[before adding to toolbar - important!]:
		this.SetToolbarButtonClass();
	
		this.XULToolbarItemContainer = EBXULFactory_CT459487.CreateToolbarItem();
		this.XULToolbarItemContainer.appendChild(this.XULElement);
		objToolbarContainer.appendChild(this.XULToolbarItemContainer);
		
		//set the button global style[after adding to toolbar - important!]:
		EBToolbarDesignManager_CT459487.SetToolbarButtonGlobalStyle(this.XULElement);
	};
	
	this.UnloadComponent = function()
	{
		
	};
	
	this.SetToolbarButtonClass = function()
	{
		EBToolbarDesignManager_CT459487.SetToolbarButtonClass(this.ComponentItem.UniqueCompID,this.XULElement);	
	};
	
	//if this element should be in chevron return the toolbar item 
	//of this element
	this.IsToChevron = function()
	{
		var XULToolbarItem	= null;
			
		var isLastShownComponent = EBComponentsManager_CT459487.IsLastShownComponent(this);
		
		var isInChevron		=  EBChevronManager_CT459487.IsInChevron(this.XULToolbarItemContainer,isLastShownComponent);
		if(isInChevron)  
		{
			XULToolbarItem = this.XULToolbarItemContainer;
		}

		return XULToolbarItem;
	};
	
	this.SetComponentCollapsed = function(isCollapsed)
	{
		if(this.XULToolbarItemContainer)
		{
			this.XULToolbarItemContainer.setAttribute('collapsed',isCollapsed);
		}
	};
	
	this.AddToChevron = function(objXULContainer)
	{
		this.XULChevronElement = null;
		
		var strLabel	=	this.ComponentItem.DisplayText;
		var strImage	= 	this.ComponentItem.DisplayIcon;
		var strTooltip	=	this.ComponentItem.button.tooltip;
		var strCommand	=	this.XULElement.getAttribute('oncommand');
		
		this.XULChevronElement = EBXULFactory_CT459487.CreateMenuItem(strLabel,
																	strImage,
																	strTooltip,
																	strCommand,
																	'',
																	null);
	
		objXULContainer.appendChild(this.XULChevronElement);
			
			
		
		return this.XULChevronElement;
	};
	
	this.CreateTooltipShrink = function()
	{
		EBComponentsManager_CT459487.AddTooltip(this.ComponentItem.UniqueCompID,this.XULElement);
	};
	
	
}
/*******************************************************************************************/

/***************************** Global Button ********************/
function EBButton_CT459487()
{
	this.type 				= "";
	this.text 				= "";
	this.image 				= "";
	this.tooltip 			= "";
	this.target				= "";
	this.buttonType			= "";
	
	this.InitWithXML = function(XMLNode)
	{
		var XMLRoot			= XMLNode.ownerDocument ? XMLNode : XMLNode.documentElement;
		var XMLChildNode	= null;
		for(var i=0;i<XMLRoot.childNodes.length;i++)
		{
			var XMLChildNode = XMLRoot.childNodes[i];
			if(XMLChildNode.tagName == "DEFAULT_BUTTON_TEXT")
			{
				this.text	= EBGlobalManager_CT459487.GetXmlNodeValue(XMLChildNode);
			}
			else if(XMLChildNode.tagName == "BUTTON_ICON_URL")
			{
				this.image = EBGlobalManager_CT459487.GetXmlNodeValue(XMLChildNode);
			}
			else if(XMLChildNode.tagName == "BUTTON_TOOLTIP")
			{
				this.tooltip = EBGlobalManager_CT459487.GetXmlNodeValue(XMLChildNode);
			}
			else if(XMLChildNode.tagName == "DATA")
			{
				var arrData = this.GetButtonData(XMLChildNode);
				
				//get the string data from the return hash array
				this.strButtonType = typeof(arrData["type"]) != "undefined" ? arrData["type"] : "";
				this.strButtonTypeValue = typeof(arrData["typeValue"]) != "undefined" ? arrData["typeValue"] : "";
				
				if(this.strButtonType.toUpperCase() == "COMMAND")
				{
					if(this.strButtonTypeValue != "")
					{
						if(EBSpecialCommands_CT459487.IsSupportedCommand(this.strButtonTypeValue))
						{
							this.buttonType = "COMMAND";
						}	
					}
				}
				else if(this.strButtonType.toUpperCase() == "LINK")
				{
					if(this.strButtonTypeValue != "")
					{
						this.buttonType = "LINK";
					}
				}
			}		
		}	
	};
	//handle the single node xml 'DATA' tag 
	this.GetButtonData = function(xmlMenuItemData)
	{
		var arrData = new Array();
		for(var i=0;i<xmlMenuItemData.childNodes.length;i++)
		{
			var currentNode = xmlMenuItemData.childNodes[i];
			if(currentNode.tagName == "TYPE")
			{
				arrData["type"] = EBGlobalManager_CT459487.GetXmlNodeValue(currentNode);
			}
			else if(currentNode.tagName == "COMMAND" || currentNode.tagName == "LINK")
			{
				for(var j=0;j<currentNode.childNodes.length;j++)
				{
					if(currentNode.childNodes[j].tagName == "TYPE" || currentNode.childNodes[j].tagName == "URL")
					{
						arrData["typeValue"] = EBGlobalManager_CT459487.GetXmlNodeValue(currentNode.childNodes[j]);
						break;
					}
				}
			}
		}
		return arrData;
	};
}

/******************************************************************/

var EBButtonManager_CT459487 = 
{
	LoadLink : function(event,strComponentID,strURL,isURLInNewTab)
	{
		//get the usage object and send the data
		//make it before loading the link(so the script won't stop if the link is illegal)
		var objUsage = this.GetButtonUsageObject(strComponentID,EBUsageConsts_CT459487.LINK,strURL);
		objUsage.SendRequest();

		EBLinkManager_CT459487.LoadLinkURL(event,strURL,isURLInNewTab,null);
		
	},
	
	LoadCommand : function(event,strComponentID,strCommand)
	{
		var objUsage = this.GetButtonUsageObject(strComponentID,EBUsageConsts_CT459487.COMMAND,strCommand);
		EBSpecialCommands_CT459487.ActivateSpecialCommand(event,strCommand,objUsage);
	},
	
	GetButtonUsageObject : function(strComponentID,strParam1,strParam2)
	{
		//create the usage object
		var objUsage = new EBUsageObject_CT459487(strComponentID,
													EBUsageConsts_CT459487.BUTTON,
													strParam1,
													strParam2);
		return objUsage;
		
	}
}


/*************************** Dynamic Button -Item ***********************************/
function EBDynamicMenuItem_CT459487(xmlNode,strCompType)
{
	this.button 		= new EBButton_CT459487();
	
	//default value is regular menu(when the arrow and the button are joined)
	//MAIN_MENU - the button does an event and the arrow open the menu(devided)
	this.button.type	= "BUTTON_MENU";

	this.link 			= "";
	
	//the xml of the menu of this dynamic menu
	this.menuXml 					= null;
	
	//floats menu items
	this.arrXmlFloatMenuItems		= null; 
	
	this.UniqueCompID				= '';
	this.CompType					= strCompType;
	
	this.DisplayText				= '';
	this.DisplayIcon				= '';
	
	this.Permission					= EBComponentsConsts_CT459487.Editable.FULL;
	this.ShowInChevron				= EBComponentsConsts_CT459487.TRUE;
	
	
	this.Create = function(xmlNode)
	{

		for(var i=0;i<xmlNode.childNodes.length;i++)
		{
			if(xmlNode.childNodes[i].tagName == "UNIQUE_COMP_ID")
			{
				this.UniqueCompID = EBGlobalManager_CT459487.GetXmlNodeValue(xmlNode.childNodes[i]);
			}
			else if(xmlNode.childNodes[i].tagName == "TYPE")
			{
				this.button.type = EBGlobalManager_CT459487.GetXmlNodeValue(xmlNode.childNodes[i]);
			}
			else if(xmlNode.childNodes[i].tagName == "BUTTON")
			{
				this.button.InitWithXML(xmlNode.childNodes[i]);
			}	
			else if(xmlNode.childNodes[i].tagName == "MENU")
			{
				this.menuXml = xmlNode.childNodes[i];
			}
			else if(xmlNode.childNodes[i].tagName == "DISPLAY_TEXT")
			{
				this.DisplayText = EBGlobalManager_CT459487.GetXmlNodeValue(xmlNode.childNodes[i]);
			}
			else if(xmlNode.childNodes[i].tagName == "DISPLAY_ICON")
			{
				this.DisplayIcon = EBGlobalManager_CT459487.GetXmlNodeValue(xmlNode.childNodes[i]);
			}
			else if(xmlNode.childNodes[i].tagName == "USER_ATTRIBUTES")
			{
				var XMLUserAttributes = xmlNode.childNodes[i];
				var XMLUserAttribute  = null;
				for(var j=0;j<XMLUserAttributes.childNodes.length;j++)
				{
					XMLUserAttribute = XMLUserAttributes.childNodes[j];
					if(XMLUserAttribute.tagName == "PERMISSION")
					{
						this.Permission = EBGlobalManager_CT459487.GetXmlNodeValue(XMLUserAttribute);
					}
					else if(XMLUserAttribute.tagName == "SHOW_IN_CHEVRON")
					{
						this.ShowInChevron = EBGlobalManager_CT459487.GetXmlNodeValue(XMLUserAttribute);
					}
				}
			}
		}
		
		//validate component id
		this.UniqueCompID = EBComponentsManager_CT459487.ValidateComponentID(this.UniqueCompID);
		
		//validate display text and icon
		this.ValidateDisplayTextIcon();
	
	};
	
	
	this.ValidateDisplayTextIcon = function()
	{
		if(!this.DisplayText)
		{
			this.DisplayText = this.button.text;
		}
		
		if(!this.DisplayIcon)
		{
			this.DisplayIcon = this.button.image;
		}
	}
	
	this.Create(xmlNode);
	
	
		

}
/******************************************************************************/

function EBDynamicMenuComponent_CT459487(dynamicMenuItem)
{
	this.ComponentItem				= dynamicMenuItem;
	
	this.XULElement					= null;
	
	this.XULChevronElement			= null;
	
	this.XULToolbarItemContainer	= null;
	
	this.isMainMenu					= false;
	
	this.Init = function()
	{
		//check validation
		if(this.ComponentItem.menuXml == null)
		{
			return false;
		}
		

		var strType = "";
		var strCommand = "";
		if(this.ComponentItem.button.type == "BUTTON_MENU")
		{
			strType = "menu";
			
			if (this.ComponentItem.button.buttonType == "")
			{
				strType = "menu";
			}
			else if(this.ComponentItem.button.buttonType == "LINK")
			{
				strCommand = 'EBButtonManager_CT459487.LoadLink(event,\''+this.ComponentItem.UniqueCompID+'\',\''+this.ComponentItem.button.strButtonTypeValue+'\');event.preventBubble();';
				strType = "menu-button";
			}
			else if(this.ComponentItem.button.buttonType == "COMMAND")
			{
				strCommand = 'EBButtonManager_CT459487.LoadCommand(event,\''+this.ComponentItem.UniqueCompID+'\',\''+this.ComponentItem.button.strButtonTypeValue+'\');event.preventBubble();';
				strType = "menu-button";
			}
			
		}
		else if(this.ComponentItem.button.type == "MAIN_MENU")
		{
			this.isMainMenu = true;
			
			//the main menu has a fixed ID
			this.ComponentItem.UniqueCompID = EBComponentsConsts_CT459487.ComponentsID.MainMenu;
			this.ComponentItem.CompType		= EBComponentsConsts_CT459487.ComponentsType.Settings;
			
			this.ComponentItem.Permission	= EBComponentsConsts_CT459487.Editable.NONE;
			strType = "menu-button";
		}
		
		if(this.ComponentItem.link 	!= "")
		{
			strCommand = 'EBButtonManager_CT459487.LoadLink(event,\''+this.ComponentItem.UniqueCompID+'\',\''+this.ComponentItem.link+'\',false);';
		}
		
		var strLabel	= this.ComponentItem.button.text;
		var strImage	= this.ComponentItem.button.image;
		var strHint		= this.ComponentItem.button.tooltip;
		
		//create the xul element
		var strButtonID = EBComponentsManager_CT459487.GetToolbarButtonID(this.ComponentItem.UniqueCompID);
		this.XULElement =	EBXULFactory_CT459487.CreateToolbarButton(strButtonID,
															strType,
															strLabel,
															strImage,
															strHint,
															strCommand,
															"");							
		
		//build the menu recursively						
		this.BuildDynamicMenu(this.ComponentItem.menuXml,this.XULElement,this.ComponentItem.arrXmlFloatMenuItems);
		
		
		var objMenuPopup = this.XULElement.firstChild;
		if(objMenuPopup)
		{
			//check if there are any children to this menu
			if(objMenuPopup.childNodes.length == 0)
			{
				return false;
			}
		
			//set the event to the popupmenu
			objMenuPopup.setAttribute('onpopupshowing','EBDynamicMenuManager_CT459487.OnMainPopupShowing(event,\''+this.ComponentItem.UniqueCompID+'\');');
		}
		
		if(!this.isMainMenu)
		{
			//create the tooltip element (for the shrink-unshrink tooltip)
			this.CreateTooltipShrink();
		}
		
		
		
		return true;
	};
	

	
	this.BuildDynamicMenu = function(xmlMenu,xulElementParent,arrXmlFloatMenuItems)
	{
		
		var currentXulMenuPopup = EBXULFactory_CT459487.CreateMenuPopup("","","");
		
		
		//check if there are float menu item
		if(arrXmlFloatMenuItems != null)
		{
			for(var i=0;i<arrXmlFloatMenuItems.length;i++)
			{
				this.BuildFloatMenuItem(arrXmlFloatMenuItems[i],currentXulMenuPopup);
			}
		}
		
			
		for(var i=0;i<xmlMenu.childNodes.length;i++)
		{
			if(xmlMenu.childNodes[i].tagName == "MENU_ITEM")
			{
				this.BuildXulMenuItem(xmlMenu.childNodes[i],currentXulMenuPopup);
			}
			else if(xmlMenu.childNodes[i].tagName == "SEPARATOR")
			{
				this.BuildXulMenuSeparator(currentXulMenuPopup);
			}
			else if(xmlMenu.childNodes[i].tagName == "MENU")
			{
				this.BuildXulSubMenu(xmlMenu.childNodes[i],currentXulMenuPopup);
			}
		}
		
		if(this.isMainMenu)
		{
			this.CheckGeneric(currentXulMenuPopup);
		}

		xulElementParent.appendChild(currentXulMenuPopup);
	};
	
	this.BuildXulSubMenu = function(xmlSubMenu,xulElementParent)
	{
		var strCaption = "";
		var strIconUrl = "";
		var strHint    = "";
		
		for(var i=0;i<xmlSubMenu.childNodes.length;i++)
		{
			
			if(xmlSubMenu.childNodes[i].tagName == "CAPTION")
			{
				strCaption = EBGlobalManager_CT459487.GetXmlNodeValue(xmlSubMenu.childNodes[i]);
			}
			else if(xmlSubMenu.childNodes[i].tagName == "ICON_URL")
			{
				strIconUrl = EBGlobalManager_CT459487.GetXmlNodeValue(xmlSubMenu.childNodes[i]);
			}
			else if(xmlSubMenu.childNodes[i].tagName == "HINT")
			{
				strHint = EBGlobalManager_CT459487.GetXmlNodeValue(xmlSubMenu.childNodes[i]);
			}
		}
		
		var xulSubMenu = EBXULFactory_CT459487.CreateMenu(strCaption,strIconUrl,strHint);

		this.BuildDynamicMenu(xmlSubMenu,xulSubMenu,null);
		xulElementParent.appendChild(xulSubMenu);
	};
	
	this.BuildXulMenuItem = function(xmlMenuItem,xulElementParent)
	{
		var strComponentType = this.ComponentItem.button.type;
		var strCaption = "";
		var strIconUrl = "";
		var strHint    = "";
		var strCommand = "";
		
		//check if this menu item is a special command
		//and if so check if it supported to display it or not
		var isMenuItemSupportedCommand = true;
		
		for(var i=0;i<xmlMenuItem.childNodes.length;i++)
		{
			if(xmlMenuItem.childNodes[i].tagName == "CAPTION")
			{
				strCaption = EBGlobalManager_CT459487.GetXmlNodeValue(xmlMenuItem.childNodes[i]);
			}
			else if(xmlMenuItem.childNodes[i].tagName == "ICON_URL")
			{
				strIconUrl = EBGlobalManager_CT459487.GetXmlNodeValue(xmlMenuItem.childNodes[i]);
			}
			else if(xmlMenuItem.childNodes[i].tagName == "HINT")
			{
				strHint = EBGlobalManager_CT459487.GetXmlNodeValue(xmlMenuItem.childNodes[i]);
			}
			else if(xmlMenuItem.childNodes[i].tagName == "DATA")
			{
				var arrData = this.GetMenuItemData(xmlMenuItem.childNodes[i]);
				
				//get the string data from the return hash array
				var strMenuItemType = typeof(arrData["type"]) != "undefined" ? arrData["type"] : "";
				var strMenuItemTypeValue = typeof(arrData["typeValue"]) != "undefined" ? arrData["typeValue"] : "";
				

				
				if(strMenuItemType.toUpperCase() == "COMMAND")
				{
					if(strMenuItemTypeValue.toUpperCase() == "TOGGLE_COMMAND")
					{
						this.BuildToggleCommand(xulElementParent,xmlMenuItem.childNodes[i]);
						return;
					}
					else if(strMenuItemTypeValue != "")
					{
						isMenuItemSupportedCommand = EBSpecialCommands_CT459487.IsSupportedCommand(strMenuItemTypeValue);
			
						strCommand = 'EBDynamicMenuManager_CT459487.LoadCommand(event,\''+this.ComponentItem.UniqueCompID+'\',\''+strMenuItemTypeValue+'\');event.preventBubble();';
					}
				}
				else if(strMenuItemType.toUpperCase() == "LINK")
				{
					if(strMenuItemTypeValue != "")
					{
						strMenuItemTypeValue = EBGlobalManager_CT459487.LegalizeLinkUrl(strMenuItemTypeValue);
						strCommand = 'EBDynamicMenuManager_CT459487.LoadLink(event,\''+this.ComponentItem.UniqueCompID+'\',\''+strMenuItemTypeValue+'\');event.preventBubble();';
					}	
				}
				else if(strMenuItemType.toUpperCase() == "SEPARATOR" || strMenuItemType.toUpperCase() == "SEPERATOR")
				{
					this.BuildXulMenuSeparator(xulElementParent);
					return;
				}
			}
		}
		
		//if this menu item command is not supported the menu item
		//isn't created!
		if(!isMenuItemSupportedCommand)
		{
			return;
		}
		
		var xulMenuItem = 	EBXULFactory_CT459487.CreateMenuItem(strCaption,strIconUrl,strHint,strCommand,"",null);

		xulElementParent.appendChild(xulMenuItem);
	};
	
	//handle the single node xml 'DATA' tag for each menu item
	this.GetMenuItemData = function(xmlMenuItemData)
	{
		var arrData = new Array();
		for(var i=0;i<xmlMenuItemData.childNodes.length;i++)
		{
			var currentNode = xmlMenuItemData.childNodes[i];
			if(currentNode.tagName == "TYPE")
			{
				arrData["type"] = EBGlobalManager_CT459487.GetXmlNodeValue(currentNode);
			}
			else if(currentNode.tagName == "COMMAND" || currentNode.tagName == "LINK")
			{
				for(var j=0;j<currentNode.childNodes.length;j++)
				{
					if(currentNode.childNodes[j].tagName == "TYPE" || currentNode.childNodes[j].tagName == "URL")
					{
						arrData["typeValue"] = EBGlobalManager_CT459487.GetXmlNodeValue(currentNode.childNodes[j]);
						break;
					}
				}
			}
		}
		return arrData;
	};
	
	this.BuildToggleCommand = function(xulElementParent,xmlDataNode)
	{
		var strComponentType	= this.ComponentItem.button.type;
		var strCaption			= "";
		var strIconUrl			= "";
		var strHint				= "";
		var strCommand			= "";
		
		var strToggleCommandPrefName = "";
		
		var isMenuItemSupportedCommand = true;
		
		var arrData				= new Array();
		
		
		
		var XML_STATES_0	= xmlDataNode.getElementsByTagName("STATE_0");
		var XML_STATE_0	= null;
		if(XML_STATES_0.length > 0)
		{
			XML_STATE_0 = XML_STATES_0.item(0);
		}
		
		var XML_STATES_1	= xmlDataNode.getElementsByTagName("STATE_1");
		var XML_STATE_1	= null;
		if(XML_STATES_1.length > 0)
		{
			XML_STATE_1 = XML_STATES_1.item(0);
		}
		
		if(!XML_STATE_0 || !XML_STATE_1)
		{
			return;
		}
		
		
		for(var i=0;i<XML_STATE_0.childNodes.length;i++)
		{
			if(XML_STATE_0.childNodes[i].tagName == "COMMAND")
			{
				strCommand = EBGlobalManager_CT459487.GetXmlNodeValue(XML_STATE_0.childNodes[i]);
				isMenuItemSupportedCommand = EBSpecialCommands_CT459487.IsSupportedCommand(strCommand);
				arrData["EB_TC_STATE0_COMMAND"] = strCommand;
			}
			else if(XML_STATE_0.childNodes[i].tagName == "CAPTION")
			{
				strCaption = EBGlobalManager_CT459487.GetXmlNodeValue(XML_STATE_0.childNodes[i]);
				arrData["EB_TC_STATE0_CAPTION"] = strCaption;
			}
			else if(XML_STATE_0.childNodes[i].tagName == "ICON_URL")
			{
				strIconUrl = EBGlobalManager_CT459487.GetXmlNodeValue(XML_STATE_0.childNodes[i]);
				arrData["EB_TC_STATE0_ICON_URL"] = strIconUrl;
			}
			else if(XML_STATE_0.childNodes[i].tagName == "HINT")
			{
				strHint = EBGlobalManager_CT459487.GetXmlNodeValue(XML_STATE_0.childNodes[i]);
				arrData["EB_TC_STATE0_HINT"] = strHint;
			}
		}

		if(!isMenuItemSupportedCommand)
			return;
		
		for(var i=0;i<XML_STATE_1.childNodes.length;i++)
		{
			if(XML_STATE_1.childNodes[i].tagName == "COMMAND")
			{
				strCommand = EBGlobalManager_CT459487.GetXmlNodeValue(XML_STATE_1.childNodes[i]);
				
				strToggleCommandPrefName = strCommand;
				arrData["EB_TC_PREF_NAME"] = strToggleCommandPrefName;
				
				isMenuItemSupportedCommand = EBSpecialCommands_CT459487.IsSupportedCommand(strCommand);
				arrData["EB_TC_STATE1_COMMAND"] = strCommand;
			}
			else if(XML_STATE_1.childNodes[i].tagName == "CAPTION")
			{
				strCaption = EBGlobalManager_CT459487.GetXmlNodeValue(XML_STATE_1.childNodes[i]);
				arrData["EB_TC_STATE1_CAPTION"] = strCaption;
			}
			else if(XML_STATE_1.childNodes[i].tagName == "ICON_URL")
			{
				strIconUrl = EBGlobalManager_CT459487.GetXmlNodeValue(XML_STATE_1.childNodes[i]);
				arrData["EB_TC_STATE1_ICON_URL"] = strIconUrl;
			}
			else if(XML_STATE_1.childNodes[i].tagName == "HINT")
			{
				strHint = EBGlobalManager_CT459487.GetXmlNodeValue(XML_STATE_1.childNodes[i]);
				arrData["EB_TC_STATE1_HINT"] = strHint;
			}
		}
		
		if(!isMenuItemSupportedCommand)
			return;
		
		//check here from the about:config
		var iState = EBToolbarPreferenceManager_CT459487.GetPref(strToggleCommandPrefName);
		
		if(iState == null)
		{
			//the default state of toggle command is 1
			iState = 1;
			EBToolbarPreferenceManager_CT459487.SetPref(strToggleCommandPrefName,iState);
		}
		
		if(iState == 1)
		{
			strCaption	= arrData["EB_TC_STATE1_CAPTION"];
			strIconUrl	= arrData["EB_TC_STATE1_ICON_URL"];
			strHint		= arrData["EB_TC_STATE1_HINT"];
		}
		else
		{
			strCaption	= arrData["EB_TC_STATE0_CAPTION"];
			strIconUrl	= arrData["EB_TC_STATE0_ICON_URL"];
			strHint		= arrData["EB_TC_STATE0_HINT"];
		}
		
		
		strCommand = 'EBDynamicMenuManager_CT459487.LoadToggleCommand(event,this,\''+this.ComponentItem.UniqueCompID+'\');event.preventBubble();';
		
		var xulMenuItem = 	EBXULFactory_CT459487.CreateMenuItem(strCaption
														,strIconUrl
														,strHint
														,strCommand
														,""
														,arrData);

		xulElementParent.appendChild(xulMenuItem);
		
	
	};
	
	this.BuildXulMenuSeparator = function(xulElementParent)
	{
		var xulMenuSeparator = EBXULFactory_CT459487.CreateMenuSeparator();
		xulElementParent.appendChild(xulMenuSeparator);
	};
	
	this.BuildFloatMenuItem = function(xmlMenuItem,xulElementParent)
	{
		var strComponentType = this.ComponentItem.button.type;
		var strTitle 	= "";
		var strLink 	= "";
		var strTooltip  = "";
		var strCommand 	= "";
		
		for(var i=0;i<xmlMenuItem.childNodes.length;i++)
		{
			if(xmlMenuItem.childNodes[i].tagName == "TITLE")
			{
				strTitle = EBGlobalManager_CT459487.GetXmlNodeValue(xmlMenuItem.childNodes[i]);
			}
			else if(xmlMenuItem.childNodes[i].tagName == "LINK")
			{
				strLink = EBGlobalManager_CT459487.GetXmlNodeValue(xmlMenuItem.childNodes[i]);
			}
			else if(xmlMenuItem.childNodes[i].tagName == "TOOLTIP")
			{
				strTooltip = EBGlobalManager_CT459487.GetXmlNodeValue(xmlMenuItem.childNodes[i]);
			}
		}
		
		strCommand = 'EBDynamicMenuManager_CT459487.LoadLink(event,\''+this.ComponentItem.UniqueCompID+'\',\''+strLink+'\');event.preventBubble();';
		
		var xulMenuItem =  EBXULFactory_CT459487.CreateMenuItem(strTitle,"",strTooltip,strCommand,"",null);

		xulElementParent.appendChild(xulMenuItem);
	};
	
	this.CheckGeneric = function(oXULMenuPopup)
	{
		if(EBActionManager_CT459487.IsToolbarGeneric())
		{
			var strTitle 		= 'Choose another Toolbar';
			var strCommand		= 'EBSpecialCommands_CT459487.GENERIC(event);event.preventBubble();';
			var oXULMenuItem	=  EBXULFactory_CT459487.CreateMenuItem(strTitle,'','',strCommand,'',null);
			oXULMenuPopup.appendChild(oXULMenuItem);
		}
	};
	
	
	this.AddToToolbar = function(objToolbarContainer)
	{
		//set toolbar button class [before adding to toolbar - important!]:
		this.SetToolbarButtonClass();
	
		this.XULToolbarItemContainer = EBXULFactory_CT459487.CreateToolbarItem();
		this.XULToolbarItemContainer.appendChild(this.XULElement);
		objToolbarContainer.appendChild(this.XULToolbarItemContainer);
		
		if(!this.isMainMenu)
		{
			//set the button global style[after adding to toolbar - important!]:
			EBToolbarDesignManager_CT459487.SetToolbarButtonGlobalStyle(this.XULElement);
		}
		
	};
	
	this.UnloadComponent = function()
	{
		
	};
	
	this.SetToolbarButtonClass = function()
	{
		EBToolbarDesignManager_CT459487.SetToolbarButtonClass(this.ComponentItem.UniqueCompID,this.XULElement);
	};
	
	//if this element should be in chevron return the toolbar item 
	//of this element
	this.IsToChevron = function()
	{
		var XULToolbarItem	= null;
		
		if(!this.isMainMenu)
		{
			var isLastShownComponent = EBComponentsManager_CT459487.IsLastShownComponent(this);
			
			var isInChevron		=  EBChevronManager_CT459487.IsInChevron(this.XULToolbarItemContainer,isLastShownComponent);
			if(isInChevron)  
			{
				XULToolbarItem = this.XULToolbarItemContainer;
			}
		}
		
		return XULToolbarItem;
	};
	
	this.SetComponentCollapsed = function(isCollapsed)
	{
		if(this.XULToolbarItemContainer)
		{
			this.XULToolbarItemContainer.setAttribute('collapsed',isCollapsed);
		}
	};
	
	this.AddToChevron = function(objXULContainer)
	{
		this.XULChevronElement = null;
	
		if(!this.isMainMenu)
		{
			var strLabel	= this.ComponentItem.DisplayText;
			var strImage	= this.ComponentItem.DisplayIcon
			var strTooltip	= this.ComponentItem.button.tooltip;	
			
			
			this.XULChevronElement = EBXULFactory_CT459487.CreateMenu(strLabel,
																	strImage,
																	strTooltip);
			
					
			var XULMenuPopup = this.XULElement.firstChild.cloneNode(true);
			
			if(XULMenuPopup)
			{
				this.XULChevronElement.appendChild(XULMenuPopup);
			}
			
			objXULContainer.appendChild(this.XULChevronElement);
			
		}
		
		return this.XULChevronElement;
	};
	
	this.CreateTooltipShrink = function()
	{
		EBComponentsManager_CT459487.AddTooltip(this.ComponentItem.UniqueCompID,this.XULElement);
	};

}

var EBDynamicMenuManager_CT459487 = 
{
	OnMainPopupShowing : function(event,strComponentID)
	{
		if(event.eventPhase == 2)
		{
			//call usage
			this.RequestDynamicMenuUsage(strComponentID,EBUsageConsts_CT459487.OPEN_MENU,'');
		}
	},
	
	LoadLink : function(event,strComponentID,strURL)
	{
		//send request usage data
		//make it before loading the link(so the script won't stop if the link is illegal)
		this.RequestDynamicMenuUsage(strComponentID,EBUsageConsts_CT459487.LINK,strURL);
		
		EBLinkManager_CT459487.LoadLinkURL(event,strURL,false,null);
	},
	
	LoadCommand : function(event,strComponentID,strCommand)
	{
		var objUsage = this.GetDynamicMenuUsageObject(strComponentID,EBUsageConsts_CT459487.COMMAND,strCommand);
		
		EBSpecialCommands_CT459487.ActivateSpecialCommand(event,strCommand,objUsage);
	
	},
	
	LoadToggleCommand : function(event,xulElement,strComponentID)
	{	
		var strTCPrefName       = xulElement.getAttribute("EB_TC_PREF_NAME");
		
		//false is the default value
		var bTCPrefValue		= false;
		
		//get the state from the about:config
		var iState				= EBToolbarPreferenceManager_CT459487.GetPref(strTCPrefName);
		if(iState == null)
		{
			iState = 1;
		}
		
		var strCommandState1    = xulElement.getAttribute("EB_TC_STATE1_COMMAND");	
		var strCommandState0    = xulElement.getAttribute("EB_TC_STATE0_COMMAND");
		
		if(iState == 1)
		{
			//make it zero
			EBToolbarPreferenceManager_CT459487.SetPref(strTCPrefName,0);
			//make the command of state 1
			this.LoadCommand(event,strComponentID,strCommandState1);
		}
		else
		{
			//make it one
			EBToolbarPreferenceManager_CT459487.SetPref(strTCPrefName,1);
			//make the command of state 0
			this.LoadCommand(event,strComponentID,strCommandState0);
		}
		
		//draw the toggle command captions
		this.ReDrawToggleCommandElement(xulElement);
	},
	
	ReDrawToggleCommandElement : function(xulElement)
	{
		var strTCPrefName       = xulElement.getAttribute("EB_TC_PREF_NAME");
		
		//get the state from the about:config
		var iState				= EBToolbarPreferenceManager_CT459487.GetPref(strTCPrefName);
		if(iState == null)
		{
			iState = 1;
		}
		
		var strCaptionState1	= xulElement.getAttribute("EB_TC_STATE1_CAPTION");
		var strIconUrlState1	= xulElement.getAttribute("EB_TC_STATE1_ICON_URL");
		var strHintState1		= xulElement.getAttribute("EB_TC_STATE1_HINT");
		
		var strCaptionState0	= xulElement.getAttribute("EB_TC_STATE0_CAPTION");
		var strIconUrlState0	= xulElement.getAttribute("EB_TC_STATE0_ICON_URL");
		var strHintState0		= xulElement.getAttribute("EB_TC_STATE0_HINT");
		
		if(iState == 1)
		{
			xulElement.setAttribute("label",strCaptionState1);
			xulElement.setAttribute("image",strIconUrlState1);
			xulElement.setAttribute("tooltiptext",strHintState1);
		}
		else
		{
			xulElement.setAttribute("label",strCaptionState0);
			xulElement.setAttribute("image",strIconUrlState0);
			xulElement.setAttribute("tooltiptext",strHintState0);
		}	
	},
	
	RequestDynamicMenuUsage : function(strComponentID,strParam1,strParam2)
	{
		var objUsage = this.GetDynamicMenuUsageObject(strComponentID,strParam1,strParam2);
		objUsage.SendRequest();
	},
	
	GetDynamicMenuUsageObject : function(strComponentID,strParam1,strParam2)
	{
		//create the usage object
		var objUsage = new EBUsageObject_CT459487(strComponentID,
													EBUsageConsts_CT459487.MENU,
													strParam1,
													strParam2);
		return objUsage;
		
	}
	
}



function EBEMailNotifierItem_CT459487(xmlNode,strCompType)
{
	this.dynamicMenuItem = null;
	
	//default value is 5 minutes
	this.CheckNewInterval	= 5;
	this.StaredIconURL		= '';
	this.StaredTooltip		= '';
	
	//fixed id
	this.UniqueCompID		= EBComponentsConsts_CT459487.ComponentsID.EMailNotifier;
	this.CompType			= EBComponentsConsts_CT459487.ComponentsType.Settings;
	
	this.DisplayText		= '';
	this.DisplayIcon		= '';
	
	this.Permission			= EBComponentsConsts_CT459487.Editable.NONE;
	this.ShowInChevron		= EBComponentsConsts_CT459487.TRUE;
	
	this.Create = function(xmlNode)
	{
		for(var i=0;i<xmlNode.childNodes.length;i++)
		{
			if(xmlNode.childNodes[i].tagName == "DYNAMIC_MENU")
			{
				this.dynamicMenuItem = EBToolbarFactoryItem_CT459487.GetInstance(xmlNode.childNodes[i],EBComponentsConsts_CT459487.ComponentsType.Settings);
				
				//the default image
				this.dynamicMenuItem.button.image = EBEMailNotifierConsts_CT459487.Images.EMailImage;
			}
			else if(xmlNode.childNodes[i].tagName == "CHECK_NEW_EMAILS_INTERVAL")
			{
				this.CheckNewInterval = EBGlobalManager_CT459487.GetXmlNodeValue(xmlNode.childNodes[i]);
			}
			else if(xmlNode.childNodes[i].tagName == "STARED_ICON_URL")
			{
				this.StaredIconURL = EBGlobalManager_CT459487.GetXmlNodeValue(xmlNode.childNodes[i]);
			}
			else if(xmlNode.childNodes[i].tagName == "STARED_TOOLTIP")
			{
				this.StaredTooltip = EBGlobalManager_CT459487.GetXmlNodeValue(xmlNode.childNodes[i]);
			}
			else if(xmlNode.childNodes[i].tagName == "USER_ATTRIBUTES")
			{
				var XMLUserAttributes = xmlNode.childNodes[i];
				var XMLUserAttribute  = null;
				for(var j=0;j<XMLUserAttributes.childNodes.length;j++)
				{
					XMLUserAttribute = XMLUserAttributes.childNodes[j];
					if(XMLUserAttribute.tagName == "SHOW_IN_CHEVRON")
					{
						this.ShowInChevron = EBGlobalManager_CT459487.GetXmlNodeValue(XMLUserAttribute);
					}
				}
			}
		}	
	};
	
	this.Create(xmlNode);
}

function EBEMailNotifierComponent_CT459487(EMailNotifierItem)
{
	this.ComponentItem				= EMailNotifierItem;
	
	this.dynamicMenuComponent		= null;
	
	this.XULElement					= null;
	
	this.XULChevronElement			= null;
	
	this.Init = function()
	{
		if(this.ComponentItem.dynamicMenuItem == null)
		{
			return false;
		}
		
		this.dynamicMenuComponent = EBToolbarFactoryComponent_CT459487.GetInstance(this.ComponentItem.dynamicMenuItem);
		
		var isInitDynamicMenu =  this.dynamicMenuComponent.Init(true);
		if(isInitDynamicMenu)
		{
			//get the button
			this.XULElement = this.dynamicMenuComponent.XULElement;
			
			//set the attributes
			this.XULElement.setAttribute(EBEMailNotifierConsts_CT459487.Attributes.CHECK_NEW_EMAIL_INTERVAL,this.ComponentItem.CheckNewInterval);
			this.XULElement.setAttribute(EBEMailNotifierConsts_CT459487.Attributes.STARED_ICON_URL,this.ComponentItem.StaredIconURL);
			this.XULElement.setAttribute(EBEMailNotifierConsts_CT459487.Attributes.STARED_TOOLTIP,this.ComponentItem.StaredTooltip);
			
			this.XULElement.setAttribute(EBEMailNotifierConsts_CT459487.Attributes.DEFAULT_CAPTION,this.dynamicMenuComponent.ComponentItem.button.text);
			this.XULElement.setAttribute(EBEMailNotifierConsts_CT459487.Attributes.DEFAULT_TOOLTIP,this.dynamicMenuComponent.ComponentItem.button.tooltip);
			this.XULElement.setAttribute(EBEMailNotifierConsts_CT459487.Attributes.TOTAL_NEW_MESSAGES,'0');
			
			
			//set the loading text
			this.XULElement.setAttribute('label',EBComponentsConsts_CT459487.Caption.Loading);
			
			//override the popupshowin of the dynamic menu
			var objMenuPopup = this.XULElement.firstChild;
			if(objMenuPopup)
			{
				objMenuPopup.setAttribute('onpopupshowing','EBEMailNotifierToolbarManager_CT459487.OnMainPopupShowing(event);');
			}			
			
					
			return true;
		}
		else
		{
			return false;
		}
	};
	
	
	this.AddToToolbar = function(objToolbarContainer)
	{
		this.dynamicMenuComponent.AddToToolbar(objToolbarContainer);
		
		//call the onload element
		this.OnLoadElement(true);
	};
	
	this.UnloadComponent = function()
	{
		this.OnUnloadElement();
	};
	
	this.SetToolbarButtonClass = function()
	{
		this.dynamicMenuComponent.SetToolbarButtonClass();
	};
	
	//if this element should be in chevron return the toolbar item 
	//of this element
	this.IsToChevron = function()
	{	
		var XULToolbarItem	= null;
		
		var isLastShownComponent = EBComponentsManager_CT459487.IsLastShownComponent(this);
		var isInChevron		=  EBChevronManager_CT459487.IsInChevron(this.dynamicMenuComponent.XULToolbarItemContainer,isLastShownComponent);
		if(isInChevron)  
		{
			XULToolbarItem = this.dynamicMenuComponent.XULToolbarItemContainer;
		}
		
		return XULToolbarItem;
	};
	
	this.SetComponentCollapsed = function(isCollapsed)
	{
		this.dynamicMenuComponent.SetComponentCollapsed(isCollapsed);
	};
	
	this.AddToChevron = function(objXULContainer)
	{
		this.XULChevronElement = null;
		
		this.XULChevronElement = this.dynamicMenuComponent.AddToChevron(objXULContainer);
		
		if(this.XULChevronElement)
		{
			//set the dynamic data of the email notifier component(lable and image)
			var strLabel = this.XULElement.getAttribute('label');
			var strImage = this.XULElement.getAttribute('image');
		
			this.XULChevronElement.setAttribute('label',strLabel);
			this.XULChevronElement.setAttribute('image',strImage);
			
			//since the settings comes without icon i need to set the menupopup 
			//icon class
			var strButtonClassGet	= this.XULElement.getAttribute('class');
			var strChevronClassGet	= this.XULChevronElement.getAttribute('class');
			var strClassSet = 'menu-iconic';
			
			if(strButtonClassGet)
			{
				strClassSet += ' ' + strButtonClassGet;
			}
			
			if(strChevronClassGet)
			{
				strClassSet += ' ' + strChevronClassGet;
			}
			
			this.XULChevronElement.setAttribute('class',strClassSet);
			
		}
				
		
		return this.XULChevronElement;
	};
	
	this.OnLoadElement  = function(isThread)
	{
		//set the onload process in a separated thread
		//cause this process can take a long time (loading from the file,calling to server etc...)
		if(isThread)
		{
			var objThreadFunction = function()
			{
				EBEMailNotifierToolbarManager_CT459487.OnLoadToolbarEMailNotifier();
			};
			
			setTimeout(objThreadFunction,100);
		}
		else
		{
			EBEMailNotifierToolbarManager_CT459487.OnLoadToolbarEMailNotifier();
		}
	};
	
	this.OnUnloadElement = function()
	{
		EBEMailNotifierToolbarManager_CT459487.OnUnloadToolbarEMailNotifier();
	};
}

function EBExternalComponentItem_CT459487(xmlNode,strCompType)
{
	this.type			= '';
	this.interval		= '';
	this.link			= '';
	
	this.UniqueCompID	= '';
	this.CompType		= strCompType;
	
	//set the default caption and image of the external component
	this.DisplayText	= 'External Component';
	this.DisplayIcon	= EBBrowserComponentConsts_CT459487.Images.MiniBrowser;
	
	this.Permission		= EBComponentsConsts_CT459487.Editable.FULL;
	this.ShowInChevron	= EBComponentsConsts_CT459487.TRUE;
	
	this.Create = function(xmlNode)
	{
		for(var i=0;i<xmlNode.childNodes.length;i++)
		{
			if(xmlNode.childNodes[i].tagName == "UNIQUE_COMP_ID")
			{
				this.UniqueCompID = EBGlobalManager_CT459487.GetXmlNodeValue(xmlNode.childNodes[i]);
			}
			else if(xmlNode.childNodes[i].tagName == "TYPE")
			{
				this.type = EBGlobalManager_CT459487.GetXmlNodeValue(xmlNode.childNodes[i]);
			}
			else if(xmlNode.childNodes[i].tagName == "INTERVAL")
			{
				this.interval = EBGlobalManager_CT459487.GetXmlNodeValue(xmlNode.childNodes[i]);
			}
			else if(xmlNode.childNodes[i].tagName == "EXTERNAL_LINK")
			{
				this.link = EBGlobalManager_CT459487.GetXmlNodeValue(xmlNode.childNodes[i]);
			}
			else if(xmlNode.childNodes[i].tagName == "USER_ATTRIBUTES")
			{
				var XMLUserAttributes = xmlNode.childNodes[i];
				var XMLUserAttribute  = null;
				for(var j=0;j<XMLUserAttributes.childNodes.length;j++)
				{
					XMLUserAttribute = XMLUserAttributes.childNodes[j];
					if(XMLUserAttribute.tagName == "SHOW_IN_CHEVRON")
					{
						this.ShowInChevron = EBGlobalManager_CT459487.GetXmlNodeValue(XMLUserAttribute);
					}
				}
			}
		}
		//validate component id
		this.UniqueCompID = EBComponentsManager_CT459487.ValidateComponentID(this.UniqueCompID);
	};
	
	this.Create(xmlNode);
}

function EBExternalComponent_CT459487(externalComponentItem)
{
	this.ComponentItem			= externalComponentItem;
	
	this.XULElement				= null;
	
	this.XULChevronElement		= null;
	
	this.DynamicMenuComponent	= null;
	
	this.TimeoutID				= null;
	
	this.Init = function()
	{
		if(this.ComponentItem.type.toUpperCase() != 'DYNAMIC_MENU')
		{
			return false;
		}
		
		if(this.ComponentItem.link == "")
		{
			return false;
		}
		
		this.XULElement = EBXULFactory_CT459487.CreateToolbarItem();
		
		this.XULElement.setAttribute(EBExternalComponentConsts_CT459487.Attributes.ComponentURL,this.ComponentItem.link);
		this.XULElement.setAttribute(EBExternalComponentConsts_CT459487.Attributes.ComponentInterval,this.ComponentItem.interval);
		
		EBExternalComponentManager_CT459487.GetComponent(this,true);
		
		return true;
		
	};
	
	
	this.AddToToolbar = function(objToolbarContainer)
	{
		this.SetToolbarButtonClass();
		
		objToolbarContainer.appendChild(this.XULElement);
		
		if(this.DynamicMenuComponent)
		{
			EBToolbarDesignManager_CT459487.SetToolbarButtonGlobalStyle(this.DynamicMenuComponent.XULElement);
		}
		
		this.OnLoadElement();
		
	};
	
	this.SetDisplayIconText = function(oDynamicMenuComponent)
	{ 
		var strDisplayIcon	= oDynamicMenuComponent.ComponentItem.DisplayIcon;
		var strDisplayText	= oDynamicMenuComponent.ComponentItem.DisplayText;
		
		if(strDisplayIcon)
		{
			this.ComponentItem.DisplayIcon = strDisplayIcon;
		}
		
		if(strDisplayText)
		{
			this.ComponentItem.DisplayText = strDisplayText;
		}	
	};
	
	this.OnLoadElement = function()
	{
		EBExternalComponentManager_CT459487.Initialize(this);
	};
	
	this.OnUnloadElement = function()
	{
		EBExternalComponentManager_CT459487.Terminate(this);
	};
	
	this.UnloadComponent = function()
	{
		this.OnUnloadElement();	
	};
	
	this.SetToolbarButtonClass = function()
	{
		if(this.DynamicMenuComponent)
		{
			this.DynamicMenuComponent.SetToolbarButtonClass();
		}	
	};
	
	this.IsToChevron = function()
	{
		var XULToolbarItem	= null;
		
		var isLastShownComponent = EBComponentsManager_CT459487.IsLastShownComponent(this);
		
		var isInChevron		=  EBChevronManager_CT459487.IsInChevron(this.XULElement,isLastShownComponent);
		if(isInChevron)  
		{
			XULToolbarItem = this.XULElement;
		}
		
		return XULToolbarItem;
	};
	
	this.SetComponentCollapsed = function(isCollapsed)
	{
		if(this.XULElement)
		{
			this.XULElement.setAttribute('collapsed',isCollapsed);
		}
	};
	
	this.AddToChevron = function(objXULContainer)
	{
		this.XULChevronElement = null;
		
		if(this.DynamicMenuComponent)
		{
			var objXULToolbarButton = this.DynamicMenuComponent.XULElement;
			var strLabel			= objXULToolbarButton.getAttribute('label');
			var strImage			= objXULToolbarButton.getAttribute('image');
			
			//get the tooltip from the special tooltip attribute in case if it's shrink mode
			var strTooltip			= objXULToolbarButton.getAttribute(EBGlobalConsts_CT459487.Attributes.XULTooltip);	
			
			
			this.XULChevronElement = EBXULFactory_CT459487.CreateMenu(strLabel,
																	strImage,
																	strTooltip);
			
					
			var XULMenuPopup = objXULToolbarButton.firstChild.cloneNode(true);
			
			if(XULMenuPopup)
			{
				this.XULChevronElement.appendChild(XULMenuPopup);
			}
			
			objXULContainer.appendChild(this.XULChevronElement);
		}	
		
		return this.XULChevronElement;
	};
	
	
}
function EBFeedItem_CT459487(xmlNode,strCompType)
{
	this.Title				= '';
	this.FeedURL			= '';
	this.IconNormalURL		= '';
	this.IconStaredURL		= '';
	this.Interval			= 0;
	
	this.UniqueCompID		= '';
	this.CompType			= strCompType;
	
	this.DisplayText		= '';
	this.DisplayIcon		= '';
	
	this.LiveMode			= '';
	
	this.Permission			= EBComponentsConsts_CT459487.Editable.FULL;
	this.ShowInChevron		= EBComponentsConsts_CT459487.TRUE;
	
	this.Create = function(xmlNode)
	{
		for(var i=0;i<xmlNode.childNodes.length;i++)
		{
			if(xmlNode.childNodes[i].tagName == "TITLE")
			{
				this.Title = EBGlobalManager_CT459487.GetXmlNodeValue(xmlNode.childNodes[i]);
			}
			else if(xmlNode.childNodes[i].tagName == "LINK")
			{
				this.FeedURL = EBGlobalManager_CT459487.GetXmlNodeValue(xmlNode.childNodes[i]);
				this.FeedURL = EBGlobalManager_CT459487.FromLegalXml(this.FeedURL);
			}
			else if(xmlNode.childNodes[i].tagName == "INTERVAL")
			{
				this.Interval = EBGlobalManager_CT459487.GetXmlNodeValue(xmlNode.childNodes[i]);
			}
			else if(xmlNode.childNodes[i].tagName == "ICON_NORMAL_URL")
			{
				this.IconNormalURL = EBGlobalManager_CT459487.GetXmlNodeValue(xmlNode.childNodes[i]);
			}
			else if(xmlNode.childNodes[i].tagName == "ICON_STARED_URL")
			{
				this.IconStaredURL = EBGlobalManager_CT459487.GetXmlNodeValue(xmlNode.childNodes[i]);
			}
			else if(xmlNode.childNodes[i].tagName == "UNIQUE_COMP_ID")
			{
				this.UniqueCompID = EBGlobalManager_CT459487.GetXmlNodeValue(xmlNode.childNodes[i]);
			}
			else if(xmlNode.childNodes[i].tagName == "DISPLAY_TEXT")
			{
				this.DisplayText = EBGlobalManager_CT459487.GetXmlNodeValue(xmlNode.childNodes[i]);
			}
			else if(xmlNode.childNodes[i].tagName == "DISPLAY_ICON")
			{
				this.DisplayIcon = EBGlobalManager_CT459487.GetXmlNodeValue(xmlNode.childNodes[i]);
			}
			else if(xmlNode.childNodes[i].tagName == "LIVE_MODE")
			{
				this.LiveMode	= EBGlobalManager_CT459487.GetXmlNodeValue(xmlNode.childNodes[i]);
			}
			else if(xmlNode.childNodes[i].tagName == "USER_ATTRIBUTES")
			{
				var XMLUserAttributes = xmlNode.childNodes[i];
				var XMLUserAttribute  = null;
				for(var j=0;j<XMLUserAttributes.childNodes.length;j++)
				{
					XMLUserAttribute = XMLUserAttributes.childNodes[j];
					if(XMLUserAttribute.tagName == "PERMISSION")
					{
						this.Permission = EBGlobalManager_CT459487.GetXmlNodeValue(XMLUserAttribute);
					}
					else if(XMLUserAttribute.tagName == "SHOW_IN_CHEVRON")
					{
						this.ShowInChevron = EBGlobalManager_CT459487.GetXmlNodeValue(XMLUserAttribute);
					}
				}
			}
			
		}
		
		//validate component id
		this.UniqueCompID = EBComponentsManager_CT459487.ValidateComponentID(this.UniqueCompID);
	
		//validate display text and icon
		this.ValidateDisplayTextIcon();	
	};
	
	this.ValidateDisplayTextIcon = function()
	{
		if(!this.DisplayText)
		{
			this.DisplayText = this.Title;
		}
		
		if(!this.DisplayIcon)
		{
			this.DisplayIcon = this.IconNormalURL;
		}
	}

	this.Create(xmlNode);
}

function EBFeedComponent_CT459487(feedItem)
{
	this.ComponentItem				= feedItem;
	
	this.IsMultiFeed				= false;
	
	//save the comp id of the multi feed in every multi feed child to 
	//retrieve it using its children!
	this.MultiFeedCompID			= '';
	
	this.MultiFeedChildIndex		= -1;
	
	this.IsLiveMode					= false;

	this.XULElement					= null;
	
	this.XULChevronElement			= null;
	
	this.XULToolbarItemContainer	= null;
	
	
	/********** Component & Dialog Data **********/
	//timeout id for the thread running
	this.TimeoutID					= null;
	//indicates whether this component in the middle of loading data from the server
	//to abort it after certain time(built in timeout to the server request)
	this.LoadingFromServer			= false;
	//keep the data of the structured and history in the component
	this.FeedData					= null;
	this.HistoryData				= null;
	this.NumOfNew					= 0;
	//the position of the div scroll in the dialog
	this.ContainerScrollTop			= 0;
	
	
	this.Init = function()
	{		
		if(this.ComponentItem.FeedURL == "")
		{
			return false;
		}
		
		//set live mode(children of multi feed can never be live mode)
		if(!this.IsMultiFeed)
		{
			this.IsLiveMode = this.ComponentItem.LiveMode.toUpperCase() == 'TRUE' ? true : false;
		}
		
		var strLabel = this.ComponentItem.Title + ' ' + EBComponentsConsts_CT459487.Caption.Loading;
		if(this.IsLiveMode)
		{
			strLabel = EBComponentsConsts_CT459487.Caption.Loading;
		}
		
		var strImage = this.ComponentItem.IconNormalURL;
		
		//create the xul element 
		//if this is part of multi feed this is a menu item 
		//if it's regular feed it's a button
		if(!this.IsMultiFeed)
		{
			var strButtonID = EBComponentsManager_CT459487.GetToolbarButtonID(this.ComponentItem.UniqueCompID);
			this.XULElement =	EBXULFactory_CT459487.CreateToolbarButton(strButtonID,
																			'menu',
																			strLabel,
																			strImage,
																			"",
																			"",
																			"");
			//create the menupopup
			var strOnPopupShowing	= '';
			var strOnPopupHiding	= '';
			var strStyle			= '';
			if(this.IsLiveMode)
			{
				strOnPopupShowing	= 'EBFeedManager_CT459487.OnToolbarFeedLivePopupShowing(event,\'' + this.ComponentItem.UniqueCompID + '\',\''+this.ComponentItem.FeedURL+'\');';
				strOnPopupHiding	= 'EBFeedManager_CT459487.OnToolbarFeedLivePopupHiding(event,\'' + this.ComponentItem.UniqueCompID + '\');';
				strStyle			= 'max-height:300px;';
			}
			else
			{
				strOnPopupShowing = 'return EBFeedManager_CT459487.OnToolbarFeedPopupShowing(event,\'' + this.ComponentItem.UniqueCompID + '\',-1);';
			}
			var oMenuPopup =  EBXULFactory_CT459487.CreateMenuPopup('',strOnPopupShowing,strOnPopupHiding);
			
			if(strStyle)
			{
				oMenuPopup.setAttribute('style',strStyle);
			}
			
			this.XULElement.appendChild(oMenuPopup);
			
			if(this.IsLiveMode)
			{
				//if it's live mode add loading item
				strLabel	= EBComponentsConsts_CT459487.Caption.Loading;
				oMenuItem   = EBXULFactory_CT459487.CreateMenuItem(strLabel,'','','','',null);
				oMenuPopup.appendChild(oMenuItem);
			}
		}
		
		if(!this.IsMultiFeed)
		{
			//create the tooltip element (for the shrink-unshrink tooltip)
			this.CreateTooltipShrink();
		}
		
		
		
		return true;
	};
	
	this.GetFeedTitle = function()
	{
		var strTitle = this.ComponentItem.Title;
		if(!this.IsLiveMode)
		{
			strTitle += ' [' + this.NumOfNew + ' new]';
		}
		
		strTitle = EBGlobalManager_CT459487.TrimToOne(strTitle);
		strTitle = EBGlobalManager_CT459487.FromLegalXml(strTitle);
		
		return strTitle;
	};
	
	this.GetFeedImage = function()
	{
		var strImage = '';
		var bIsStared = false;
		if(this.FeedData)
		{
			bIsStared =	this.FeedData.Data.Stared;
		}
		
		if(bIsStared)
		{
			strImage = this.ComponentItem.IconStaredURL;
		}
		else
		{
			strImage = this.ComponentItem.IconNormalURL;
		}
		
		return strImage;
	};
	
	this.AddToToolbar = function(objToolbarContainer)
	{
		//set toolbar button class[before adding to toolbar - important!]:
		this.SetToolbarButtonClass();
	
		this.XULToolbarItemContainer = EBXULFactory_CT459487.CreateToolbarItem();
		this.XULToolbarItemContainer.appendChild(this.XULElement);
		objToolbarContainer.appendChild(this.XULToolbarItemContainer);
		
		if(!this.IsMultiFeed)
		{
			//set the button global style[after adding to toolbar - important!]:
			EBToolbarDesignManager_CT459487.SetToolbarButtonGlobalStyle(this.XULElement);
		}
		
		//call the onload element
		this.OnLoadElement();
	};
	
	this.UnloadComponent = function()
	{
		this.OnUnloadElement();
	};
	
	this.SetToolbarButtonClass = function()
	{
		if(!this.IsMultiFeed)
		{
			EBToolbarDesignManager_CT459487.SetToolbarButtonClass(this.ComponentItem.UniqueCompID,this.XULElement);
		}
	};
	
	//if this element should be in chevron return the toolbar item 
	//of this element
	this.IsToChevron = function()
	{
		var XULToolbarItem	= null;
	
		var isLastShownComponent = EBComponentsManager_CT459487.IsLastShownComponent(this);
		var isInChevron		=  EBChevronManager_CT459487.IsInChevron(this.XULToolbarItemContainer,isLastShownComponent);
		if(isInChevron)  
		{
			XULToolbarItem = this.XULToolbarItemContainer;
		}
		
		return XULToolbarItem;
	};
	
	this.SetComponentCollapsed = function(isCollapsed)
	{
		if(this.XULToolbarItemContainer)
		{
			this.XULToolbarItemContainer.setAttribute('collapsed',isCollapsed);
		}
	};
	
	this.AddToChevron = function(objXULContainer)
	{
		this.XULChevronElement = null;

		if(this.IsLiveMode)
		{
			this.XULChevronElement = EBXULFactory_CT459487.CreateMenu('',
																		'',
																		'');
			for(var i=0;i<this.XULElement.attributes.length;i++)
			{
				objAttribute = this.XULElement.attributes[i];
				if(objAttribute.name.toLowerCase() != 'class' && objAttribute.name.toLowerCase() != 'tooltip')
				{
						this.XULChevronElement.setAttribute(objAttribute.name,objAttribute.value);
				}
			}
		}	
		else
		{																
			for(var i=0;i<this.XULElement.attributes.length;i++)
			{
				objAttribute = this.XULElement.attributes[i];
				if(objAttribute.name.toLowerCase() == 'label') 
					var strLabel = objAttribute.value
				else if(objAttribute.name.toLowerCase() == 'image')
					var strImage = objAttribute.value
			}
			this.XULChevronElement = EBXULFactory_CT459487.CreateMenuItem(strLabel,
																		strImage,
																		'',
																		'',
																		'',
																		null);
			var objAttribute = null;
			for(var i=0;i<this.XULElement.attributes.length;i++)
			{
				objAttribute = this.XULElement.attributes[i];
				if(objAttribute.name.toLowerCase() != 'class' && objAttribute.name.toLowerCase() != 'tooltip' && objAttribute.name.toLowerCase() != 'label' && objAttribute.name.toLowerCase() != 'image')
				{
					this.XULChevronElement.setAttribute(objAttribute.name,objAttribute.value);
				}
			}
		}	
		
		//set the class attribute separately if in live mode
		if(this.IsLiveMode) 
		{
			var strChevronClassGet	= this.XULChevronElement.getAttribute('class');
			var strClassSet = 'menu-iconic';
			if(strChevronClassGet)
			{
				strClassSet += ' ' + strChevronClassGet;
			}	
			this.XULChevronElement.setAttribute('class',strClassSet);
		}	
		
		//set the tooltiptext - in case of shrink mode so there is special tooltip shrink
		//we need to return it to the original tooltip
		var strOriginalTooltip = this.XULElement.getAttribute(EBGlobalConsts_CT459487.Attributes.XULTooltip);
		if(strOriginalTooltip)
		{
			this.XULChevronElement.setAttribute('tooltiptext',strOriginalTooltip);
		}
		
		
		
		var XULMenuPopup = null;
		if(this.IsLiveMode)
		{
			XULMenuPopup = this.XULElement.firstChild.cloneNode(true);
			if(XULMenuPopup)
			{
				this.XULChevronElement.appendChild(XULMenuPopup);
			}
		}
		else
		{
			
			var strOnPopupShowing = 'return false';
			this.XULChevronElement.setAttribute('onclick','EBFeedManager_CT459487.OnClickToolbarFeedFromChevron(event,\'' + this.ComponentItem.UniqueCompID + '\',-1);');
		
			XULMenuPopup = EBXULFactory_CT459487.CreateMenuPopup('',strOnPopupShowing,'');
		}
		
		
			
		objXULContainer.appendChild(this.XULChevronElement);
		
		return this.XULChevronElement;
	};

	this.OnLoadElement  = function()
	{
		//set the onload process in a separated thread
		//cause this process can take a long time (loading from the file,calling to server etc...)
		var oComponent = this;
		var objThreadFunction = function()
		{
			EBFeedManager_CT459487.OnLoadFeedItem(oComponent);
		};
		setTimeout(objThreadFunction,100);
	};
	
	this.OnUnloadElement = function()
	{
		EBFeedManager_CT459487.OnUnloadFeedItem(this);
	};
	
	this.CreateTooltipShrink = function()
	{
		EBComponentsManager_CT459487.AddTooltip(this.ComponentItem.UniqueCompID,this.XULElement);
	}
	
}


function EBHighlighterItem_CT459487(xmlNode,strCompType)
{
	this.strTooltip			= "";
	
	//fixed id
	this.UniqueCompID		= EBComponentsConsts_CT459487.ComponentsID.Highlighter;
	this.CompType			= EBComponentsConsts_CT459487.ComponentsType.Settings;
	
	this.DisplayText		= EBHighlighterConsts_CT459487.DisplayText;
	this.DisplayIcon		= EBHighlighterConsts_CT459487.Images.Highlighter;
	
	this.Permission			= EBComponentsConsts_CT459487.Editable.FULL;
	this.ShowInChevron		= EBComponentsConsts_CT459487.TRUE;
	
	this.Create = function(xmlNode)
	{
		for(var i=0;i<xmlNode.childNodes.length;i++)
		{
			if(xmlNode.childNodes[i].tagName == "HIGHLIGHT_TOOLTIP")
			{
				this.strTooltip = EBGlobalManager_CT459487.GetXmlNodeValue(xmlNode.childNodes[i]);
			}
			else if(xmlNode.childNodes[i].tagName == "USER_ATTRIBUTES")
			{
				var XMLUserAttributes = xmlNode.childNodes[i];
				var XMLUserAttribute  = null;
				for(var j=0;j<XMLUserAttributes.childNodes.length;j++)
				{
					XMLUserAttribute = XMLUserAttributes.childNodes[j];
					if(XMLUserAttribute.tagName == "PERMISSION")
					{
						this.Permission = EBGlobalManager_CT459487.GetXmlNodeValue(XMLUserAttribute);
					}
					else if(XMLUserAttribute.tagName == "SHOW_IN_CHEVRON")
					{
						this.ShowInChevron = EBGlobalManager_CT459487.GetXmlNodeValue(XMLUserAttribute);
					}
				}
			}
		}
	};
	
	this.Create(xmlNode);
}

function EBHighlighterComponent_CT459487(highlighterItem)
{
	this.ComponentItem				= highlighterItem;
	
	this.strHighlighterId			= EBSearchBoxConsts_CT459487.SearchHighlighterIDPrefix + EBGlobalConsts_CT459487.ToolbarCTID;
	
	this.XULElement					= null;
	
	this.XULChevronElement			= null;
	
	this.XULToolbarItemContainer	= null;
	
	this.Init = function()
	{
		var strCommand = 'EBHighlighterManager_CT459487.OnCommandHighlighter(event);';
		var strImage   = EBHighlighterConsts_CT459487.Images.HighlighterDisabled;
		this.XULElement = EBXULFactory_CT459487.CreateToolbarButton(this.strHighlighterId,
												'',
												'',
												strImage,
												this.ComponentItem.strTooltip,
												strCommand,
												'');

		this.XULElement.setAttribute('disabled',true);
		this.XULElement.setAttribute('checked',false);

		return true;
	};
	
	this.AddToToolbar = function(objToolbarContainer)
	{
		this.SetToolbarButtonClass();
	
		this.XULToolbarItemContainer = EBXULFactory_CT459487.CreateToolbarItem();
		this.XULToolbarItemContainer.appendChild(this.XULElement);
		objToolbarContainer.appendChild(this.XULToolbarItemContainer);
		
		if(EBToolbarData_CT459487.IsHighlighting)
		{
			this.XULElement.setAttribute("checked",true);
		}
	};
	
	this.UnloadComponent = function()
	{
		
	};
	
	this.SetToolbarButtonClass = function()
	{
		EBToolbarDesignManager_CT459487.SetToolbarButtonClass(this.ComponentItem.UniqueCompID,this.XULElement);	
	};

	
	//if this element should be in chevron return the toolbar item 
	//of this element
	this.IsToChevron = function()
	{
		var XULToolbarItem	= null;
		
		var isLastShownComponent = EBComponentsManager_CT459487.IsLastShownComponent(this);
		var isInChevron		=  EBChevronManager_CT459487.IsInChevron(this.XULToolbarItemContainer,isLastShownComponent);
		if(isInChevron)  
		{
			XULToolbarItem = this.XULToolbarItemContainer;
		}
		
		return XULToolbarItem;
	};
	
	this.SetComponentCollapsed = function(isCollapsed)
	{
		if(this.XULToolbarItemContainer)
		{
			this.XULToolbarItemContainer.setAttribute('collapsed',isCollapsed);
		}
	};
	
	this.AddToChevron = function(objXULContainer)
	{
		this.XULChevronElement = null;
		
		var strLabel	= EBHighlighterConsts_CT459487.DisplayText;
		var strCommand	= 'EBHighlighterManager_CT459487.OnCommandHighlighter(event);';
		var strImage	= this.XULElement.getAttribute('image');
		var	strTooltip	= this.XULElement.getAttribute('tooltiptext');
		
		if(EBToolbarData_CT459487.IsHighlighting)
		{
			strImage = EBHighlighterConsts_CT459487.Images.HighlighterChevron;
		}
		
		this.XULChevronElement = EBXULFactory_CT459487.CreateMenuItem(strLabel,
																	strImage,
																	strTooltip,
																	strCommand,
																	'',
																	null);
	
		var strIsDisabled = this.XULElement.getAttribute('disabled');
		this.XULChevronElement.setAttribute('disabled',strIsDisabled);
		
		objXULContainer.appendChild(this.XULChevronElement);
		
		return this.XULChevronElement;
	};

}



function EBMultiFeedItem_CT459487(XMLNode,strCompType)
{
	this.FeedItems			= new Array();
	this.MultiFeedButton	= null;
	
	this.UniqueCompID		= '';
	this.CompType			= strCompType;
	
	this.DisplayText		= '';
	this.DisplayIcon		= '';
	
	this.Permission			= EBComponentsConsts_CT459487.Editable.FULL;
	this.ShowInChevron		= EBComponentsConsts_CT459487.TRUE;
	
	this.Create = function(XMLNode)
	{
		var XMLNodeChild = null;
		var XMLFeedItemNode = null;
		for(var i=0;i<XMLNode.childNodes.length;i++)
		{
			XMLNodeChild = XMLNode.childNodes[i];
			if(XMLNodeChild.tagName == 'UNIQUE_COMP_ID')
			{
				this.UniqueCompID = EBGlobalManager_CT459487.GetXmlNodeValue(XMLNodeChild);
			}
			else if(XMLNodeChild.tagName == 'LIST_OF_RSS_FEEDS')
			{
				for(var j=0;j<XMLNodeChild.childNodes.length;j++)
				{
					XMLFeedItemNode = XMLNodeChild.childNodes[j];
					if(XMLFeedItemNode.tagName == 'RSS_FEED_ITEM')
					{
						this.FeedItems[this.FeedItems.length] = EBToolbarFactoryItem_CT459487
																				.GetInstance(XMLFeedItemNode,this.CompType);
					}
				}
			}
			else if(XMLNodeChild.tagName == 'BUTTON')
			{
				this.MultiFeedButton = new EBMultiFeedButtonItem_CT459487(XMLNodeChild);
			}
			else if(XMLNodeChild.tagName == "DISPLAY_TEXT")
			{
				this.DisplayText = EBGlobalManager_CT459487.GetXmlNodeValue(XMLNodeChild);
			}
			else if(XMLNodeChild.tagName == "DISPLAY_ICON")
			{
				this.DisplayIcon = EBGlobalManager_CT459487.GetXmlNodeValue(XMLNodeChild);
			}
			else if(XMLNodeChild.tagName == "USER_ATTRIBUTES")
			{
				var XMLUserAttributes = XMLNodeChild;
				var XMLUserAttribute  = null;
				for(var j=0;j<XMLUserAttributes.childNodes.length;j++)
				{
					XMLUserAttribute = XMLUserAttributes.childNodes[j];
					if(XMLUserAttribute.tagName == "PERMISSION")
					{
						this.Permission = EBGlobalManager_CT459487.GetXmlNodeValue(XMLUserAttribute);
					}
					else if(XMLUserAttribute.tagName == "SHOW_IN_CHEVRON")
					{
						this.ShowInChevron = EBGlobalManager_CT459487.GetXmlNodeValue(XMLUserAttribute);
					}
				}
			}
		}
		
		//validate component id
		this.UniqueCompID = EBComponentsManager_CT459487.ValidateComponentID(this.UniqueCompID);
	
		//validate display text and icon
		this.ValidateDisplayTextIcon();
	};
	
	this.ValidateDisplayTextIcon = function()
	{
		if(!this.DisplayText)
		{
			this.DisplayText = this.MultiFeedButton.DeafultButtonText;
		}
		
		if(!this.DisplayIcon)
		{
			this.DisplayIcon = this.MultiFeedButton.IconNormalURL;
		}
	}
	
	this.Create(XMLNode);
}

function EBMultiFeedComponent_CT459487(objMultiFeedItem)
{
	this.ComponentItem				= objMultiFeedItem;
	this.XULElement					= null;
	this.XULToolbarItemContainer	= null;
	
	this.XULChevronElement			= null;
	
	this.FeedComponents				= new Array();

	this.Init = function()
	{	
		//if there isn't any feed items return false
		if(this.ComponentItem.FeedItems.length == 0)
		{
			return false;
		}
		
		var objFeedItem = null;
		for(var i=0;i<this.ComponentItem.FeedItems.length;i++)
		{
			objFeedItem = this.ComponentItem.FeedItems[i];
			//create the feed component with as a multi feed
			var oFeedComponent = new EBFeedComponent_CT459487(objFeedItem);
			oFeedComponent.IsMultiFeed			= true;
			oFeedComponent.MultiFeedCompID		= this.ComponentItem.UniqueCompID;
			var iIndex = this.FeedComponents.length;
			oFeedComponent.MultiFeedChildIndex	= iIndex;
			this.FeedComponents[iIndex]	= oFeedComponent;
		}
		
		//check feed components init!
		var isFeedComponentsInit = false;
		var objFeedComponent = null;
		for(var i=0;i<this.FeedComponents.length;i++)
		{
			objFeedComponent		= this.FeedComponents[i];
			isFeedComponentsInit	= objFeedComponent.Init();
		}
		
		if(isFeedComponentsInit)
		{
			//create the main multi feed button
			var strType		= 'menu';
			var strLabel	= this.ComponentItem.MultiFeedButton.DeafultButtonText + ' ' + EBComponentsConsts_CT459487.Caption.Loading;
			var strImage	= this.ComponentItem.MultiFeedButton.IconNormalURL;
			var strTooltip	= this.ComponentItem.MultiFeedButton.ButtonTooltip;
			
			var strButtonID = EBComponentsManager_CT459487.GetToolbarButtonID(this.ComponentItem.UniqueCompID);
			this.XULElement = EBXULFactory_CT459487.CreateToolbarButton(strButtonID,
																			strType,
																			strLabel,
																			strImage,
																			strTooltip,
																			'',
																			'');
		
			var strOnPopupShowing = '';
			//we check windows or mac-linux cause in windows we show the multi feed dialog 
			//cause there is a problem when the dialog appearing it closes all the popup menus of the window
			//and in mac-linux we show regular popup menu cause there isn't that problem
			if(EBGlobalManager_CT459487.IsWindowsPlatform())
			{
				strOnPopupShowing = 'return EBFeedManager_CT459487.OnMultiFeedMainPopupShowing(event,\''+this.ComponentItem.UniqueCompID+'\');';
			}
			else
			{
				strOnPopupShowing = 'EBFeedManager_CT459487.OnMultiFeedMainPopupShowingMacLinux(event,\''+this.ComponentItem.UniqueCompID+'\');';
			}
			var objXULMainMenuPopup = EBXULFactory_CT459487.CreateMenuPopup('',
																		strOnPopupShowing,
																		'');
			
			//add all to the main multi feed button:
			this.XULElement.appendChild(objXULMainMenuPopup);
		}
			
		
		if(isFeedComponentsInit)
		{
			//create the tooltip element (for the shrink-unshrink tooltip)
			this.CreateTooltipShrink();
		}
		
		return isFeedComponentsInit;
	};
	
	this.GetMultiFeedTitle = function()
	{
		var iNumOfNew = 0;
		var oFeedComponent = null;
		for(var i=0;i<this.FeedComponents.length;i++)
		{
			oFeedComponent	= this.FeedComponents[i];
			iNumOfNew += oFeedComponent.NumOfNew;
		}
		
		var strTitle = this.ComponentItem.MultiFeedButton.DeafultButtonText + ' [' + iNumOfNew + ' new]';
		strTitle = EBGlobalManager_CT459487.TrimToOne(strTitle);
		strTitle = EBGlobalManager_CT459487.FromLegalXml(strTitle);
		return strTitle;
	};
	
	this.GetMultiFeedImage = function()
	{
		var strImage  = '';
		var bIsStared = false;
		var oFeedComponent = null;
		for(var i=0;i<this.FeedComponents.length;i++)
		{
			oFeedComponent	= this.FeedComponents[i];
			if(oFeedComponent.FeedData)
			{
				bIsStared		= oFeedComponent.FeedData.Data.Stared;
				if(bIsStared)
				{
					break;
				}
			}
		}
		
		if(bIsStared)
		{	
			strImage = this.ComponentItem.MultiFeedButton.IconStaredURL;
		}
		else
		{
			strImage = this.ComponentItem.MultiFeedButton.IconNormalURL;
		}
		
		return strImage;
	};
	
	this.AddToToolbar = function(objToolbarContainer)
	{
		//set toolbar button class[before adding to toolbar - important!]:
		this.SetToolbarButtonClass();
	
		this.XULToolbarItemContainer = EBXULFactory_CT459487.CreateToolbarItem();
		this.XULToolbarItemContainer.appendChild(this.XULElement);
		objToolbarContainer.appendChild(this.XULToolbarItemContainer);
		
		//set the button global style[after adding to toolbar - important!]:
		EBToolbarDesignManager_CT459487.SetToolbarButtonGlobalStyle(this.XULElement);

		this.OnLoadElement();
	};
	
	this.UnloadComponent = function()
	{
		this.OnUnloadElement();
	};
	
	this.SetToolbarButtonClass = function()
	{
		EBToolbarDesignManager_CT459487.SetToolbarButtonClass(this.ComponentItem.UniqueCompID,this.XULElement);	
	};
	
	//if this element should be in chevron return the toolbar item 
	//of this element
	this.IsToChevron = function()
	{
		var XULToolbarItem	= null;
		
		var isLastShownComponent	= EBComponentsManager_CT459487.IsLastShownComponent(this);
		var isInChevron				= EBChevronManager_CT459487.IsInChevron(this.XULToolbarItemContainer,isLastShownComponent);
		if(isInChevron)  
		{
			XULToolbarItem = this.XULToolbarItemContainer;
		}
		
		return XULToolbarItem;
	};
	
	this.SetComponentCollapsed = function(isCollapsed)
	{
		if(this.XULToolbarItemContainer)
		{
			this.XULToolbarItemContainer.setAttribute('collapsed',isCollapsed);
		}
	};
	
	this.AddToChevron = function(objXULContainer)
	{
		
		this.XULChevronElement = null;
		
		this.XULChevronElement = EBXULFactory_CT459487.CreateMenu('',
																'',
																'');
		var objAttribute = null;
		for(var i=0;i<this.XULElement.attributes.length;i++)
		{
			objAttribute = this.XULElement.attributes[i];
			if(objAttribute.name.toLowerCase() != 'class' && objAttribute.name.toLowerCase() != 'tooltip')
			{
				this.XULChevronElement.setAttribute(objAttribute.name,objAttribute.value);
			}
		}
		
		//set the class attribute separately
		var strChevronClassGet	= this.XULChevronElement.getAttribute('class');
		var strClassSet = 'menu-iconic';
		if(strChevronClassGet)
		{
			strClassSet += ' ' + strChevronClassGet;
		}
		this.XULChevronElement.setAttribute('class',strClassSet);
		
		
		//set the tooltiptext - in case of shrink mode so there is special tooltip shrink
		//we need to return it to the original tooltip
		var strOriginalTooltip = this.XULElement.getAttribute(EBGlobalConsts_CT459487.Attributes.XULTooltip);
		if(strOriginalTooltip)
		{
			this.XULChevronElement.setAttribute('tooltiptext',strOriginalTooltip);
		}
		
		var oXULMainMenuPopup = null;
		if(EBGlobalManager_CT459487.IsWindowsPlatform())
		{
			var strOnPopupShowing = 'EBFeedManager_CT459487.OnMultiFeedMainPopupShowingFromChevron(event,\''+ this.ComponentItem.UniqueCompID +'\');';
			oXULMainMenuPopup = EBXULFactory_CT459487.CreateMenuPopup('',strOnPopupShowing,'');
		
			var objFeedComponent	= null;
			var oXULMenu			= null;
			var oXULMenuPopup		= null;
			var strLabel			= '';
			var strImage			= '';
			var strCommand			= '';
			for(var i=0;i<this.FeedComponents.length;i++)
			{
				objFeedComponent	= this.FeedComponents[i];
				strLabel = objFeedComponent.GetFeedTitle();
				strImage = objFeedComponent.GetFeedImage();
				strCommand = 'EBFeedManager_CT459487.OnClickToolbarFeedFromChevron(event,\'' + this.ComponentItem.UniqueCompID + '\',' + i + ')'
				oXULMenu = EBXULFactory_CT459487.CreateMenuItem(strLabel,
																	strImage,
																	'',
																	strCommand,
																	'',
																	null);
				strOnPopupShowing = 'return false';
				oXULMenuPopup = EBXULFactory_CT459487.CreateMenuPopup('',strOnPopupShowing,'');
				oXULMainMenuPopup.appendChild(oXULMenu);
			}
		}
		else
		{
			//in mac-linux copy the popup menu of the toolbarbutton as is!
			oXULMainMenuPopup = this.XULElement.firstChild.cloneNode(true);
		}
		
		
		this.XULChevronElement.appendChild(oXULMainMenuPopup);

		objXULContainer.appendChild(this.XULChevronElement);
		
		return this.XULChevronElement;
	};
	
	
	this.OnLoadElement  = function()
	{
		var objFeedComponent = null;
		for(var i=0;i<this.FeedComponents.length;i++)
		{
			objFeedComponent	= this.FeedComponents[i];
			objFeedComponent.OnLoadElement();
		}
		
	};
	
	this.OnUnloadElement = function()
	{
		var objFeedComponent = null;
		for(var i=0;i<this.FeedComponents.length;i++)
		{
			objFeedComponent	= this.FeedComponents[i];
			objFeedComponent.OnUnloadElement();
		}
	};
	
	this.CreateTooltipShrink = function()
	{
		EBComponentsManager_CT459487.AddTooltip(this.ComponentItem.UniqueCompID,this.XULElement);
	};
}


//object represent multi feed object
function EBMultiFeedButtonItem_CT459487(XMLNode)
{
	this.DeafultButtonText	= '';
	this.IconNormalURL		= '';
	this.ButtonTooltip		= '';
	this.IconStaredURL		= '';
	
	this.Create = function(XMLNode)
	{
		var XMLNodeChild = null;
		for(var i=0;i<XMLNode.childNodes.length;i++)
		{
			XMLNodeChild = XMLNode.childNodes[i];
			if(XMLNodeChild.tagName == 'DEFAULT_BUTTON_TEXT')
			{
				this.DeafultButtonText = EBGlobalManager_CT459487.GetXmlNodeValue(XMLNodeChild);
			}
			else if(XMLNodeChild.tagName == 'ICON_NORMAL_URL')
			{
				this.IconNormalURL = EBGlobalManager_CT459487.GetXmlNodeValue(XMLNodeChild);
			}
			else if(XMLNodeChild.tagName == 'BUTTON_TOOLTIP')
			{
				this.ButtonTooltip = EBGlobalManager_CT459487.GetXmlNodeValue(XMLNodeChild);
			}
			else if(XMLNodeChild.tagName == 'ICON_STARED_URL')
			{
				this.IconStaredURL = EBGlobalManager_CT459487.GetXmlNodeValue(XMLNodeChild);
			}
		}
	};
	
	this.Create(XMLNode);
}
var EBPrivacyConsts_CT459487 = 
{
	Image		: 'chrome://folkoteka.com/skin/block.png',
	Caption		: 'Privacy'
}


function EBPrivacyItem_CT459487(xmlNode,strCompType)
{
	this.dynamicMenuItem	= null;
	
	//fixed id
	this.UniqueCompID		= EBComponentsConsts_CT459487.ComponentsID.Privacy;
	this.CompType			= EBComponentsConsts_CT459487.ComponentsType.Settings;
	
	this.DisplayText		= '';
	this.DisplayIcon		= '';
	
	this.Permission			= EBComponentsConsts_CT459487.Editable.NONE;
	this.ShowInChevron		= EBComponentsConsts_CT459487.TRUE;
	
	this.Create = function(xmlNode)
	{
		for(var i=0;i<xmlNode.childNodes.length;i++)
		{
			if(xmlNode.childNodes[i].tagName == "DYNAMIC_MENU")
			{
				this.dynamicMenuItem = EBToolbarFactoryItem_CT459487.GetInstance(xmlNode.childNodes[i],EBComponentsConsts_CT459487.ComponentsType.Settings);
				
				//private case of firefox - change the defaults:
				this.dynamicMenuItem.button.text	= EBPrivacyConsts_CT459487.Caption;
				this.dynamicMenuItem.button.image	= EBPrivacyConsts_CT459487.Image;
				this.dynamicMenuItem.button.tooltip = "";
			}
			else if(xmlNode.childNodes[i].tagName == "USER_ATTRIBUTES")
			{
				var XMLUserAttributes = xmlNode.childNodes[i];
				var XMLUserAttribute  = null;
				for(var j=0;j<XMLUserAttributes.childNodes.length;j++)
				{
					XMLUserAttribute = XMLUserAttributes.childNodes[j];
					if(XMLUserAttribute.tagName == "SHOW_IN_CHEVRON")
					{
						this.ShowInChevron = EBGlobalManager_CT459487.GetXmlNodeValue(XMLUserAttribute);
					}
				}
			}
		}	
	};
	
	this.Create(xmlNode);
}


function EBPrivacyComponent_CT459487(privacyItem)
{
	this.ComponentItem			= privacyItem;
	
	this.dynamicMenuComponent	= null;
	
	this.XULElement				= null;
	
	this.XULChevronElement		= null;
	
	this.Init = function()
	{
		
		if(this.ComponentItem.dynamicMenuItem == null)
		{
			return false;
		}
		
		this.dynamicMenuComponent = EBToolbarFactoryComponent_CT459487.GetInstance(this.ComponentItem.dynamicMenuItem);
		
		var bIsInit = this.dynamicMenuComponent.Init(true);
		
		if(bIsInit)
		{
			this.XULElement = this.dynamicMenuComponent.XULElement;
		}
		
		return bIsInit;
		
	};
	
	
	this.AddToToolbar = function(objToolbarContainer)
	{
		this.dynamicMenuComponent.AddToToolbar(objToolbarContainer);
	};
	
	this.UnloadComponent = function()
	{
		
	};
	
	this.SetToolbarButtonClass = function()
	{	
		this.dynamicMenuComponent.SetToolbarButtonClass();
	};
	
	//if this element should be in chevron return the toolbar item 
	//of this element
	this.IsToChevron = function()
	{	
		var XULToolbarItem	= null;
		
		var isLastShownComponent	= EBComponentsManager_CT459487.IsLastShownComponent(this);
		var isInChevron				= EBChevronManager_CT459487.IsInChevron(this.dynamicMenuComponent.XULToolbarItemContainer,isLastShownComponent);
		if(isInChevron)
		{
			XULToolbarItem = this.dynamicMenuComponent.XULToolbarItemContainer;
		}
		
		return XULToolbarItem;
	};
	
	this.SetComponentCollapsed = function(isCollapsed)
	{
		this.dynamicMenuComponent.SetComponentCollapsed(isCollapsed);
	};
	
	this.AddToChevron = function(objXULContainer)
	{
		this.XULChevronElement = null;
		
		this.XULChevronElement = this.dynamicMenuComponent.AddToChevron(objXULContainer);
		
		if(this.XULChevronElement)
		{
			//set the caption and label of the privacy button
			var strLabel = EBPrivacyConsts_CT459487.Caption;
			var strImage = EBPrivacyConsts_CT459487.Image;
			
			this.XULChevronElement.setAttribute('label',strLabel);
			this.XULChevronElement.setAttribute('image',strImage);
		}
			
		return this.XULChevronElement;
	};
	
}
function EBSearchBoxItem_CT459487(xmlNode,strCompType)
{	
	//the xml of all the searches
	this.searchEnginesXml		= null;
	
	this.searchSuggestsXml		= null;
	
	this.strCanChangeDefault	= "CAN_CHANGE_DEFAULT";
	
	this.strBgColor				= '';
	
	//fixed id
	this.UniqueCompID			= EBComponentsConsts_CT459487.ComponentsID.SearchBox;
	this.CompType				= EBComponentsConsts_CT459487.ComponentsType.Settings;
	
	this.DisplayText			= '';
	this.DisplayIcon			= '';
	
	this.Permission				= EBComponentsConsts_CT459487.Editable.NONE;
	this.ShowInChevron			= EBComponentsConsts_CT459487.TRUE;
	
	this.Create = function(xmlNode)
	{
		for(var i=0;i<xmlNode.childNodes.length;i++)
		{
			if(xmlNode.childNodes[i].tagName == "LIST_OF_SEARCH_ENGINES")
			{
				this.searchEnginesXml = xmlNode.childNodes[i];
			}
			else if(xmlNode.childNodes[i].tagName == "LIST_OF_SUGGEST_SEARCH_ENGINES")
			{
				this.searchSuggestsXml = xmlNode.childNodes[i];
			}
			else if(xmlNode.childNodes[i].tagName == "TYPE")
			{
				this.strCanChangeDefault = EBGlobalManager_CT459487.GetXmlNodeValue(xmlNode.childNodes[i]);
			}
			else if(xmlNode.childNodes[i].tagName == "BG_COLOR")
			{
				this.strBgColor = EBGlobalManager_CT459487.GetXmlNodeValue(xmlNode.childNodes[i]);
			}
			else if(xmlNode.childNodes[i].tagName == "USER_ATTRIBUTES")
			{
				var XMLUserAttributes = xmlNode.childNodes[i];
				var XMLUserAttribute  = null;
				for(var j=0;j<XMLUserAttributes.childNodes.length;j++)
				{
					XMLUserAttribute = XMLUserAttributes.childNodes[j];
					if(XMLUserAttribute.tagName == "SHOW_IN_CHEVRON")
					{
						this.ShowInChevron = EBGlobalManager_CT459487.GetXmlNodeValue(XMLUserAttribute);
					}
				}
			}
		}
	};
	
	this.Create(xmlNode);
	
	
}

function EBSearchBoxComponent_CT459487(searchItem)
{
	this.ComponentItem = searchItem;
	
	//the xul element for the search component:
	this.xulMenuList		= null;
	this.xulMenuPopup		= null;
	this.xulSplitter		= null;
	this.xulToolbarButton	= null;
	
	this.XULChevronElement	= null;
	
	//the toolbar items holds the xul elements
	this.XULToolbarItemContainerSearchBox	= null;
	this.XULToolbarItemContainerButton		= null;
	
	//since we need the menulist and the toolbarbutton with his menu items
	//talked to each other we defined id to the menulist and the toolbarbutton
	//and plant it as an attribute in all of them
	this.searchButtonId			= EBSearchBoxConsts_CT459487.SearchButtonIDPrefix + EBGlobalConsts_CT459487.ToolbarCTID;
	this.searchMenuListId		= EBSearchBoxConsts_CT459487.SearchMenuListIDPrefix + EBGlobalConsts_CT459487.ToolbarCTID;
	
	this.Init = function()
	{
		
		//check validation
		if(this.ComponentItem.searchEnginesXml == null)
		{
			return false;
		}
		
		
	
			
		var strSplitterStyle = "background: transparent;border: none !important;"
		var strResizeBefore = "closest";
		var strResizeAfter = "grow";
		
		//check if this toolbar is ltr or rtl to set the splitter behaviour correctly
		if(EBToolbarData_CT459487.ToolbarRTL)
		{			
			strResizeBefore	= "farthest";
			strResizeAfter	= "closest";
		}
		
		
		var strSplitterImage = EBSearchBoxConsts_CT459487.Images.Splitter;
		
		this.xulSplitter = EBXULFactory_CT459487.CreateSplitter("open",
													"none",
													strResizeBefore,
													strResizeAfter,
													"Resize the Search Box",
													strSplitterStyle,
													strSplitterImage);
		this.xulSplitter.setAttribute("onmouseup","EBSearchBoxManager_CT459487.OnMouseUpSplitter(event);");
			
		var strCommand = "";
		var strTooltip = "";
		var strStyle   = "";
		
		//create all the xul elements
		var strMenuListId			= this.searchMenuListId;
		var strMenuListOnInput		= "EBSearchBoxManager_CT459487.OnInputSearchBox(this);";
		var strMenuListOnKeyPress	= "EBSearchBoxManager_CT459487.MenuListSearch(event);";
		var strMenuListOnClick		= "EBSearchBoxManager_CT459487.OnClickSearchBox(event,this);";
		var strMenuListOnMouseDown  = "EBSearchBoxManager_CT459487.OnMouseDownSearchBox(event,this);";
		var strMenuListWidth		= this.GetSearchBoxWidth();
		var strMenuListMinWidth		= EBSearchBoxConsts_CT459487.SearchBoxMinWidth;


		this.xulMenuList = EBXULFactory_CT459487.CreateMenuList(strMenuListId,
													strMenuListOnInput,
													strMenuListOnKeyPress,
													strMenuListOnClick,
													strMenuListOnMouseDown,
													strMenuListWidth,
													strMenuListMinWidth,
													strStyle);	

	

		var strToolbarButtonId = this.searchButtonId;								
		strCommand = "EBSearchBoxManager_CT459487.ButtonSearch(event);";
		
		this.xulToolbarButton =	EBXULFactory_CT459487.CreateToolbarButton(strToolbarButtonId,
																"menu-button",
																"",
																"",
																"",
																strCommand,
																"");
																
			
		

		
		//set the CAN_CHANGE_DEFAULT attribute to this toolbar button
		this.xulToolbarButton.setAttribute("EB_CAN_CHANGE_DEFAULT",searchItem.strCanChangeDefault);
															
		//set the string id of the menulist and the toolbarbutton to each other
		//so they can communicate:
		this.xulMenuList.setAttribute(EBSearchBoxConsts_CT459487.Attributes.SearchButtonID,this.searchButtonId);
		this.xulToolbarButton.setAttribute(EBSearchBoxConsts_CT459487.Attributes.SearchMenuListID,this.searchMenuListId);
					
		
		this.BuildSearchEngines(this.ComponentItem.searchEnginesXml,this.xulToolbarButton);
		
		
		if(this.ComponentItem.searchSuggestsXml != null)
		{
			this.SetSearchSuggests(this.ComponentItem.searchSuggestsXml);
		}
		

		this.InitializeDefaultSearch(this.xulToolbarButton);
		
		this.InitializeSearchHistory();
		
		//create the tooltip element (for the shrink-unshrink tooltip)
		this.CreateTooltipShrink();
			
		return true;
	};
	
	this.InitializeSearchHistory = function()
	{
		//get the xml history file
		var fileSearchHistoryXML = EBSearchBoxManager_CT459487.GetSearchHistoryFile();
		
		//create popup menu to hold the menu items
		var xulMenuPopup	= EBXULFactory_CT459487.CreateMenuPopup("","","");
		var xulMenuItem		= null;
		
		//create domParser
		var strXMLSearch	= EBFileIO_CT459487.read(fileSearchHistoryXML,EBGlobalConsts_CT459487.DefaultCharset);
		var xmlDocSearch	= EBGlobalManager_CT459487.GetXmlDocument(strXMLSearch);
		
		//get root nodes
		var xmlSearchRoot	= xmlDocSearch.documentElement;
		var xmlSearchItems  = xmlSearchRoot.getElementsByTagName(EBSearchBoxConsts_CT459487.XML.SearchHistoryItemTagName);
		var xmlSearchItem	= null;
		var strXMLValue		= "";
		
		for(var i=0;i<xmlSearchItems.length;i++)
		{
			xmlSearchItem	= xmlSearchItems.item(i);
			strXMLValue		= EBGlobalManager_CT459487.GetXmlNodeValue(xmlSearchItem);
			if(strXMLValue != "")
			{
				xulMenuItem = EBSearchBoxManager_CT459487.GetSearchHistoryMenuItem(this.xulMenuList,strXMLValue);
				xulMenuPopup.appendChild(xulMenuItem);			
			}
		}
		
		//if there isn't any menu item from the rdf to place
		//i insert an empty one (with a space!)
		if(xulMenuPopup.childNodes.length == 0)
		{
			xulMenuItem = EBXULFactory_CT459487.CreateMenuItem("",
														"",
														"",
														"",
														"",
														null);
			xulMenuItem.setAttribute("height","18");
			xulMenuPopup.appendChild(xulMenuItem);
		}
		
		this.xulMenuList.appendChild(xulMenuPopup);
		
	};
	
	this.InitializeDefaultSearch = function(objXULElement)
	{
		var menuItemElements = null;
		var defaultMenuItem = null;
		
		//check here the chosen engine from the about:config
		var strPrefValue = EBToolbarPreferenceManager_CT459487.GetPref(EBPreferenceConsts_CT459487.SearchEngine);
		if(strPrefValue != null && strPrefValue != "")
		{
			
			//the search engine is save of "name||url" so i get it to an array
			var arrNamePrefix = strPrefValue.split(EBGlobalConsts_CT459487.Delimiter);
			
			var strName = decodeURIComponent(arrNamePrefix[0]);
			var strPrefix = arrNamePrefix[1];
	
			menuItemElements = objXULElement.getElementsByAttribute("EB_CAN_BE_DEFAULT","TRUE");
			for(var i=0;i<menuItemElements.length;i++)
			{
				defaultMenuItem = menuItemElements[i];
				if(strName == defaultMenuItem.getAttribute("label")
					&& strPrefix ==  defaultMenuItem.getAttribute("EB_PREFIX"))
				{
					break;
				}
			}
		}
		
		//if not come from the preference i'll take the xml default
		if(defaultMenuItem == null)
		{
			menuItemElements = objXULElement.getElementsByAttribute("EB_DEFAULT","TRUE");
			if(menuItemElements.length > 0)
			{
				defaultMenuItem = menuItemElements[0];
			}
		}
	
		if(defaultMenuItem != null)
		{
			//set this menu item to checked
			defaultMenuItem.setAttribute("checked","true");
			
			//get this menu item image and label to set it to the main search button
			var strImage = defaultMenuItem.getAttribute("EB_IMAGE_URL");
			var strCaption = defaultMenuItem.getAttribute("label");

			//set the main button
			EBSearchBoxManager_CT459487.SetSearchButton(objXULElement,strImage,strCaption);
		}
		
	};
	
	this.BuildSearchEngines = function(xmlSearchEngines,xulElementParent,isInChevron)
	{
		var currentXulMenuPopup = EBXULFactory_CT459487.CreateMenuPopup("","","");
		
		for(var i=0;i<xmlSearchEngines.childNodes.length;i++)
		{
			if(xmlSearchEngines.childNodes[i].tagName == "SEARCH_ENGINE")
			{
				this.BuildSearchMenuItem(xmlSearchEngines.childNodes[i],currentXulMenuPopup,isInChevron);
			}
			else if(xmlSearchEngines.childNodes[i].tagName == "SEPARATOR")
			{
				this.BuildSearchSeparator(currentXulMenuPopup);
			}
		}
		

		xulElementParent.appendChild(currentXulMenuPopup);
		
	};
	
	this.BuildSearchMenuItem = function(xmlSearchMenuItem,xulElementParent,isInChevron)
	{
		var strCaption		= "";
		var strImageUrl		= "";
		var strHint			= "";
		var strCommand		= "";
		var strName			= "";
		
		//unique search attributes
		var strPrefix			= "";
		var strTermToReplace	= "";
		var strDefault			= "";
		var strCanBeDefault		= "";
		var strInputCharset		= "";
		var strType				= "";
		var strPostParams		= "";
		var strEmptySearchUrl	= "";
		var strBGText			= "";
		
		//hashtable to save another information to the search menu items
		var arrData = new Array();
		
		for(var i=0;i<xmlSearchMenuItem.childNodes.length;i++)
		{
			if(xmlSearchMenuItem.childNodes[i].tagName == "CAPTION")
			{
				strCaption = EBGlobalManager_CT459487.GetXmlNodeValue(xmlSearchMenuItem.childNodes[i]);
			}
			else if(xmlSearchMenuItem.childNodes[i].tagName == "IMAGE_URL")
			{
				strImageUrl = EBGlobalManager_CT459487.GetXmlNodeValue(xmlSearchMenuItem.childNodes[i]);
				arrData["EB_IMAGE_URL"] = strImageUrl;
			}
			else if(xmlSearchMenuItem.childNodes[i].tagName == "PREFIX")
			{
				strPrefix = EBGlobalManager_CT459487.GetXmlNodeValue(xmlSearchMenuItem.childNodes[i]);
				arrData["EB_PREFIX"] = strPrefix;
			}
			else if(xmlSearchMenuItem.childNodes[i].tagName == "SEARCH_TERM_TO_REPLACE")
			{
				strTermToReplace = EBGlobalManager_CT459487.GetXmlNodeValue(xmlSearchMenuItem.childNodes[i]);
				arrData["EB_SEARCH_TERM_TO_REPLACE"] = strTermToReplace;
			}
			else if(xmlSearchMenuItem.childNodes[i].tagName == "DEFAULT")
			{
				strDefault = EBGlobalManager_CT459487.GetXmlNodeValue(xmlSearchMenuItem.childNodes[i]);
				arrData["EB_DEFAULT"] = strDefault;
			}
			else if(xmlSearchMenuItem.childNodes[i].tagName == "TYPE")
			{
				strType = EBGlobalManager_CT459487.GetXmlNodeValue(xmlSearchMenuItem.childNodes[i]);
				arrData["EB_TYPE"] = strType;
			}
			else if(xmlSearchMenuItem.childNodes[i].tagName == "POST_PARAMS")
			{
				strPostParams = EBGlobalManager_CT459487.GetXmlNodeValue(xmlSearchMenuItem.childNodes[i]);
				arrData["EB_POST_PARAMS"] = strPostParams;
			}
			else if(xmlSearchMenuItem.childNodes[i].tagName == "INPUT_CHARSET")
			{
				strInputCharset = EBGlobalManager_CT459487.GetXmlNodeValue(xmlSearchMenuItem.childNodes[i]);
				arrData["EB_INPUT_CHARSET"] = strInputCharset;
			}
			else if(xmlSearchMenuItem.childNodes[i].tagName == "CAN_BE_DEFAULT")
			{
				strCanBeDefault = EBGlobalManager_CT459487.GetXmlNodeValue(xmlSearchMenuItem.childNodes[i]);
				if(strCanBeDefault == "TRUE")
				{
					strName = "ebSearchMenuItem";
					if(isInChevron)
					{
						strName += EBChevronConsts_CT459487.ChevronSuffixText;
					}
				}
				arrData["EB_CAN_BE_DEFAULT"] = strCanBeDefault;
			}
			else if(xmlSearchMenuItem.childNodes[i].tagName == "EMPTY_SEARCH_URL")
			{
				strEmptySearchUrl = EBGlobalManager_CT459487.GetXmlNodeValue(xmlSearchMenuItem.childNodes[i]);
				arrData["EB_EMPTY_SEARCH_URL"] = strEmptySearchUrl;
			}
			else if(xmlSearchMenuItem.childNodes[i].tagName == "BG_TEXT")
			{
				strBGText = EBGlobalManager_CT459487.GetXmlNodeValue(xmlSearchMenuItem.childNodes[i]);
				arrData["EB_BG_TEXT"] = strBGText;
			}
		}
		
		strCommand = "EBSearchBoxManager_CT459487.MenuItemSearch(event);event.preventBubble();";
		var xulMenuItem = EBXULFactory_CT459487.CreateMenuItem(strCaption,
												"",
												strHint,
												strCommand,
												strName,
												arrData);
		
		//add to all the menu items attribute reference to the search button 
		//and to the search menulist
		xulMenuItem.setAttribute(EBSearchBoxConsts_CT459487.Attributes.SearchButtonID,this.searchButtonId);
		xulMenuItem.setAttribute(EBSearchBoxConsts_CT459487.Attributes.SearchMenuListID,this.searchMenuListId);									
		
		//set attribute for element in chevron
		if(isInChevron)
		{
			xulMenuItem.setAttribute(EBSearchBoxConsts_CT459487.Attributes.IsInChevron,isInChevron);
		}

		xulElementParent.appendChild(xulMenuItem);
	};
	
	this.BuildSearchSeparator = function(xulElementParent)
	{
		var xulMenuSeparator = EBXULFactory_CT459487.CreateMenuSeparator();
		xulElementParent.appendChild(xulMenuSeparator);
	};
	
	this.SetSearchSuggests = function(xmlSearchSuggests)
	{
		EBToolbarData_CT459487.ToolbarSuggests = new Array();
	
		var strDomain			= "";
		var strSearchParam		= "";
		var strOutputCharset	= "";	
		
		for(var i=0;i<xmlSearchSuggests.childNodes.length;i++)
		{
			if(xmlSearchSuggests.childNodes[i].tagName == "SUGGEST_SEARCH_ENGINE")
			{
				var XML_SEARCH_SUGGEST = xmlSearchSuggests.childNodes[i];
				
				for(var j=0;j<XML_SEARCH_SUGGEST.childNodes.length;j++)
				{
					if(XML_SEARCH_SUGGEST.childNodes[j].tagName == "DOMAIN")
					{
						strDomain = EBGlobalManager_CT459487.GetXmlNodeValue(XML_SEARCH_SUGGEST.childNodes[j]);
					}
					else if(XML_SEARCH_SUGGEST.childNodes[j].tagName == "SEARCH_PARAM")
					{
						strSearchParam = EBGlobalManager_CT459487.GetXmlNodeValue(XML_SEARCH_SUGGEST.childNodes[j]);
					}
					else if(XML_SEARCH_SUGGEST.childNodes[j].tagName == "OUTPUT_CHARSET")
					{
						strOutputCharset = EBGlobalManager_CT459487.GetXmlNodeValue(XML_SEARCH_SUGGEST.childNodes[j]);
					}
				}
				EBToolbarData_CT459487.ToolbarSuggests[EBToolbarData_CT459487.ToolbarSuggests.length] = new EBSuggestObject_CT459487(strDomain,strSearchParam,strOutputCharset);
			}
		}
	};
	
	this.GetSearchBoxWidth = function()
	{
		var strMenuListWidth		= EBSearchBoxConsts_CT459487.SearchBoxWidth;
		
		//check if there is the width save in the about:config
		var strPrefWidth = EBToolbarPreferenceManager_CT459487.GetPref(EBPreferenceConsts_CT459487.SearchBoxWidth);
		if(strPrefWidth && isFinite(strPrefWidth))
		{
			strMenuListWidth = strPrefWidth;
		}
		
		return strMenuListWidth;
	};
	
	this.AddToToolbar = function(objToolbarContainer)
	{
		//set toolbar button class[before adding to toolbar - important!]:
		this.SetToolbarButtonClass();
	
		//set the width of the search box(for the shrink-unshring build toolbar call)
		this.xulMenuList.setAttribute('width',this.GetSearchBoxWidth());
		
		this.XULToolbarItemContainerSearchBox = EBXULFactory_CT459487.CreateToolbarItem();
		this.XULToolbarItemContainerSearchBox.setAttribute("persist","width");
		this.XULToolbarItemContainerSearchBox.appendChild(this.xulMenuList);
		objToolbarContainer.appendChild(this.XULToolbarItemContainerSearchBox);
		
		objToolbarContainer.appendChild(this.xulSplitter);
		
		this.XULToolbarItemContainerButton = EBXULFactory_CT459487.CreateToolbarItem();
		this.XULToolbarItemContainerButton.appendChild(this.xulToolbarButton);
		objToolbarContainer.appendChild(this.XULToolbarItemContainerButton);
		
		//set the button global style[after adding to toolbar - important!]:
		EBToolbarDesignManager_CT459487.SetToolbarButtonGlobalStyle(this.xulToolbarButton);
		
		//set the searchbox bgcolor
		EBToolbarDesignManager_CT459487.SetToolbarSearchBoxBGColor(this.xulMenuList,this.ComponentItem.strBgColor);
	
		//set the search term
		EBSearchBoxManager_CT459487.SetSearchBoxBGText();
		
		
	};
	
	this.UnloadComponent = function()
	{
		
	};
	
	this.SetToolbarButtonClass = function()
	{
		EBToolbarDesignManager_CT459487.SetToolbarButtonClass(this.ComponentItem.UniqueCompID,this.xulToolbarButton);	
	};
	
	
	//if this element should be in chevron return the toolbar item 
	//of this element
	//in the SearchBox we check only for the button 
	this.IsToChevron = function()
	{
		var XULToolbarItem	= null;
		
		var isLastShownComponent = EBComponentsManager_CT459487.IsLastShownComponent(this);
		var isInChevron		=  EBChevronManager_CT459487.IsInChevron(this.XULToolbarItemContainerButton,isLastShownComponent);
		if(isInChevron)  
		{
			XULToolbarItem = this.XULToolbarItemContainerButton;
		}
		
		return XULToolbarItem;
	};
	
	this.SetComponentCollapsed = function(isCollapsed)
	{
		if(this.XULToolbarItemContainerButton)
		{
			this.XULToolbarItemContainerButton.setAttribute('collapsed',isCollapsed);
		}
	};
	
	this.AddToChevron = function(objXULContainer)
	{
		this.XULChevronElement = null;
		
		
		this.XULChevronElement = EBXULFactory_CT459487.CreateMenu('',
																'',
																'');
		var objAttribute = null;
		for(var i=0;i<this.xulToolbarButton.attributes.length;i++)
		{
			objAttribute = this.xulToolbarButton.attributes[i];
			if(objAttribute.name.toLowerCase() != 'class' && objAttribute.name.toLowerCase() != 'tooltip')
			{
				this.XULChevronElement.setAttribute(objAttribute.name,objAttribute.value);
			}
		}
		
		//set the class attribute separately
		var strChevronClassGet	= this.XULChevronElement.getAttribute('class');
		var strClassSet = 'menu-iconic';
		if(strChevronClassGet)
		{
			strClassSet += ' ' + strChevronClassGet;
		}
		this.XULChevronElement.setAttribute('class',strClassSet);
		
		
		//set the tooltiptext - in case of shrink mode so there is special tooltip shrink
		//we need to return it to the original tooltip
		var strOriginalTooltip = this.xulToolbarButton.getAttribute(EBGlobalConsts_CT459487.Attributes.XULTooltip);
		if(strOriginalTooltip)
		{
			this.XULChevronElement.setAttribute('tooltiptext',strOriginalTooltip);
		}
		
		
		this.BuildSearchEngines(this.ComponentItem.searchEnginesXml,this.XULChevronElement,true);
		
		this.InitializeDefaultSearch(this.XULChevronElement);
		
		objXULContainer.appendChild(this.XULChevronElement);
		
		return this.XULChevronElement;
	};
	
	this.CreateTooltipShrink = function()
	{
		EBComponentsManager_CT459487.AddTooltip(this.ComponentItem.UniqueCompID,this.xulToolbarButton);
	};

	
}


var EBSeparatorConsts_CT459487 = 
{
	DisplayText : 'Separator',
	DisplayIcon : 'chrome://folkoteka.com/skin/separator.png'
}

function EBSeparatorItem_CT459487(XMLNode,strCompType)
{
	this.UniqueCompID		= '';
	this.CompType			= strCompType;
	
	this.DisplayText		= EBSeparatorConsts_CT459487.DisplayText;
	this.DisplayIcon		= EBSeparatorConsts_CT459487.DisplayIcon;
	
	this.Permission			= EBComponentsConsts_CT459487.Editable.FULL;
	this.ShowInChevron		= EBComponentsConsts_CT459487.TRUE;
	
	this.Create = function(XMLNode)
	{
		var XMLNodeChild = null;
		
		for(var i=0;i<XMLNode.childNodes.length;i++)
		{
			XMLNodeChild = XMLNode.childNodes[i];
			if(XMLNodeChild.tagName == 'UNIQUE_COMP_ID')
			{
				this.UniqueCompID = EBGlobalManager_CT459487.GetXmlNodeValue(XMLNodeChild);
			}
			else if(XMLNodeChild.tagName == "USER_ATTRIBUTES")
			{
				var XMLUserAttributes = XMLNodeChild;
				var XMLUserAttribute  = null;
				for(var j=0;j<XMLUserAttributes.childNodes.length;j++)
				{
					XMLUserAttribute = XMLUserAttributes.childNodes[j];
					if(XMLUserAttribute.tagName == "PERMISSION")
					{
						this.Permission = EBGlobalManager_CT459487.GetXmlNodeValue(XMLUserAttribute);
					}
					else if(XMLUserAttribute.tagName == "SHOW_IN_CHEVRON")
					{
						this.ShowInChevron = EBGlobalManager_CT459487.GetXmlNodeValue(XMLUserAttribute);
					}
				}
			}
		}
		
		//validate component id
		this.UniqueCompID = EBComponentsManager_CT459487.ValidateComponentID(this.UniqueCompID);
	};
	
	
	this.Create(XMLNode);
}

function EBSeparatorComponent_CT459487(objSeparatorItem)
{
	this.ComponentItem				= objSeparatorItem;
	
	this.XULElement					= null;
	
	this.XULChevronElement			= null;
	
	this.XULToolbarItemContainer	= null;
	
	this.Init = function()
	{
		this.XULElement = EBXULFactory_CT459487.CreateToolbarSeparator();
		
		return true;
	};
	
	this.AddToToolbar = function(objToolbarContainer)
	{
		this.XULToolbarItemContainer = EBXULFactory_CT459487.CreateToolbarItem();
		this.XULToolbarItemContainer.appendChild(this.XULElement);
		objToolbarContainer.appendChild(this.XULToolbarItemContainer);
	};
	
	this.UnloadComponent = function()
	{
		
	};
	
	this.SetToolbarButtonClass = function()
	{
		
	};
	
	//if this element should be in chevron return the toolbar item 
	//of this element
	this.IsToChevron = function()
	{
		var XULToolbarItem	= null;
		
		var isLastShownComponent = EBComponentsManager_CT459487.IsLastShownComponent(this);
		var isInChevron		=  EBChevronManager_CT459487.IsInChevron(this.XULToolbarItemContainer,isLastShownComponent);
		if(isInChevron)  
		{
			XULToolbarItem = this.XULToolbarItemContainer;
		}
		
		return XULToolbarItem;
	};
	
	this.SetComponentCollapsed = function(isCollapsed)
	{
		if(this.XULToolbarItemContainer)
		{
			this.XULToolbarItemContainer.setAttribute('collapsed',isCollapsed);
		}
	};
	
	this.AddToChevron = function(objXULContainer)
	{
		this.XULChevronElement = null;
		
		this.XULChevronElement = EBXULFactory_CT459487.CreateMenuSeparator();
	
		objXULContainer.appendChild(this.XULChevronElement);
		
		return this.XULChevronElement;
	};
	
	
}

function EBWeatherItem_CT459487(XMLNode,strCompType)
{
	this.Interval		= '';
	
	this.Button			= new EBButton_CT459487();
	
	this.ServerURL		= '';
	
	this.WebSearchURL	= '';
	
	
	//fixed id
	this.UniqueCompID		= EBComponentsConsts_CT459487.ComponentsID.Weather;
	this.CompType			= EBComponentsConsts_CT459487.ComponentsType.Settings;
	
	this.DisplayText		= '';
	this.DisplayIcon		= '';
	
	this.Permission			= EBComponentsConsts_CT459487.Editable.NONE;
	this.ShowInChevron		= EBComponentsConsts_CT459487.TRUE;
	
	this.Create = function(XMLNode)
	{
		var XMLNodeChild = null;
		
		for(var i=0;i<XMLNode.childNodes.length;i++)
		{
			XMLNodeChild = XMLNode.childNodes[i];
			if(XMLNodeChild.tagName == 'INTERVAL')
			{
				this.Interval = EBGlobalManager_CT459487.GetXmlNodeValue(XMLNodeChild);
			}
			else if(XMLNodeChild.tagName == "BUTTON")
			{
				this.Button.InitWithXML(XMLNodeChild);
			}
			else if(XMLNodeChild.tagName == "SERVER_URL")
			{
				this.ServerURL = EBGlobalManager_CT459487.GetXmlNodeValue(XMLNodeChild);
			}
			else if(XMLNodeChild.tagName == "SEARCH_SERVER_URL")
			{
				this.WebSearchURL = EBGlobalManager_CT459487.GetXmlNodeValue(XMLNodeChild);
			}
				
		}
	};
	
	this.Create(XMLNode);
}


function EBWeatherComponent_CT459487(oWeatherItem)
{
	this.ComponentItem				= oWeatherItem;
	
	this.XULElement					= null;
	
	this.XULChevronElement			= null;
	
	this.XULToolbarItemContainer	= null;
	
	this.Init = function()
	{
		
		var strLabel = EBComponentsConsts_CT459487.Caption.Loading;
		
		var strImage = EBWeatherGUIConsts_CT459487.Image;
		
		var strTooltip = this.ComponentItem.Button.tooltip;
		
		var strCommand = 'EBWeatherManager_CT459487.OnCommandWeatherToolbarButton(event);';
		
		var strButtonID = EBComponentsManager_CT459487.GetToolbarButtonID(this.ComponentItem.UniqueCompID);
		this.XULElement = EBXULFactory_CT459487.CreateToolbarButton(strButtonID,
																		'',
																		strLabel,
																		strImage,
																		strTooltip,
																		strCommand,
																		'');
		
		//create the tooltip element (for the shrink-unshrink tooltip)
		this.CreateTooltipShrink();
		
		return true;																
			
	};
	
	this.AddToToolbar = function(objToolbarContainer)
	{
		this.SetToolbarButtonClass();
		
		this.XULToolbarItemContainer = EBXULFactory_CT459487.CreateToolbarItem();
		this.XULToolbarItemContainer.appendChild(this.XULElement);
		objToolbarContainer.appendChild(this.XULToolbarItemContainer);
		
		//set the button global style[after adding to toolbar - important!]:
		EBToolbarDesignManager_CT459487.SetToolbarButtonGlobalStyle(this.XULElement);
	
		this.OnLoadElement();
	};
	
	this.OnLoadElement = function()
	{
		EBWeatherManager_CT459487.Initialize();
	};
	
	this.UnloadComponent = function()
	{
		this.OnUnloadElement();
	};
	
	this.OnUnloadElement = function()
	{
		EBWeatherManager_CT459487.Terminate();
	};
	
	this.SetToolbarButtonClass = function()
	{
		EBToolbarDesignManager_CT459487.SetToolbarButtonClass(this.ComponentItem.UniqueCompID,this.XULElement);	
	};
	
	this.IsToChevron = function()
	{
		var XULToolbarItem	= null;
			
		var isLastShownComponent = EBComponentsManager_CT459487.IsLastShownComponent(this);
		
		var isInChevron		=  EBChevronManager_CT459487.IsInChevron(this.XULToolbarItemContainer,isLastShownComponent);
		if(isInChevron)  
		{
			XULToolbarItem = this.XULToolbarItemContainer;
		}

		return XULToolbarItem;
	};
	
	this.SetComponentCollapsed = function(isCollapsed)
	{
		if(this.XULToolbarItemContainer)
		{
			this.XULToolbarItemContainer.setAttribute('collapsed',isCollapsed);
		}
	};
	
	this.AddToChevron = function(objXULContainer)
	{
		this.XULChevronElement = null;
		
		var strLabel		=	this.XULElement.getAttribute('label');
		var strImage		= 	this.XULElement.getAttribute('image');
		var strTooltip		=	this.XULElement.getAttribute('tooltiptext');
		var strCommand		=	this.XULElement.getAttribute('oncommand');
		
		
		//check if there is the special tooltip
		var strTooltipID	=	this.XULElement.getAttribute('tooltip');
		
		this.XULChevronElement = EBXULFactory_CT459487.CreateMenuItem(strLabel,
																	strImage,
																	strTooltip,
																	strCommand,
																	'',
																	null);
	
		if(strTooltipID == EBWeatherGUIConsts_CT459487.ForecastTooltipID)
		{
			this.XULChevronElement.removeAttribute('tooltiptext',strTooltipID);	
			this.XULChevronElement.setAttribute('tooltip',strTooltipID);	
		}
		
		objXULContainer.appendChild(this.XULChevronElement);
		
		return this.XULChevronElement;
	};
	
	this.CreateTooltipShrink = function()
	{
		EBComponentsManager_CT459487.AddTooltip(this.ComponentItem.UniqueCompID,this.XULElement);
	};
}




var EBUninstallManager_CT459487 = 
{
	IsShowUninstallPage : function()
	{
		//the default if to show the uninstall page in uninstallation is true
		var bValue = true;
		var strShowUninstallPage = EBGlobalConsts_CT459487.ShowUninstallPage;
		
		if(strShowUninstallPage.toUpperCase() == 'FALSE')
		{
			bValue = false;
		}
		
		return bValue;
	},
	
	GetUninstallURL : function()
	{
		var strUninstallURL = EBActionManager_CT459487.GetMyWebServerURL() +
								'Uninstall.aspx' +
								'?toolbarid=' + EBGlobalConsts_CT459487.ToolbarCTID + 
								'&version=' + EBGlobalConsts_CT459487.ToolbarVersion +
								'&platform=firefox';
	
		return strUninstallURL;
							
	},
	
	//set this pref key when uninstall the toolbar in order to clear all
	//the toolbar data when the window is closing!
	SetUninstallPreference : function()
	{
		EBToolbarPreferenceManager_CT459487.SetPref(EBPreferenceConsts_CT459487.Uninstall,true);	
	},
	
	//check if it is uninstall mode with the pref uninstall key:
	IsUninstall : function()
	{
		var strUninstallPrefName = EBPreferenceConsts_CT459487.Uninstall;
		return EBToolbarPreferenceManager_CT459487.HasUserValue(strUninstallPrefName);	
	},
	
	ClearToolbarData : function()
	{
		//clear all preferences:
		EBToolbarPreferenceManager_CT459487.ClearAll();
		
		//remove toolbar main directory
		EBIOManager_CT459487.DeleteToolbarDirectory();
		
	},
	
	PostUninstallToolbar : function()
	{
		//set the uninstall preference
		this.SetUninstallPreference();
		
		if(this.IsShowUninstallPage())
		{
			//load uninstall page
			var strUninstallURL = this.GetUninstallURL();
			EBLinkManager_CT459487.LoadLinkURL(null,strUninstallURL,true,null);
		}
	},
	
	//check if this window is the last browser window to clear all personal data when uninstalling
	IsCurrentLastBrowserWindow : function()
	{
		var objWindowsManager = Components.classes['@mozilla.org/appshell/window-mediator;1']
						.getService(Components.interfaces.nsIWindowMediator);
		
		var objEnumerator = objWindowsManager.getEnumerator('navigator:browser');
	
		return !objEnumerator.hasMoreElements();
	},
	
	IsToClearToolbarData : function()
	{
		return this.IsUninstall() 
				&& 
			   this.IsCurrentLastBrowserWindow();
	},
	
	//after clearing the toolbar private data when the last browser closed we assure
	//that the toolbar is completley removed by closing all the remain Firefox windows:
	//like the extensions manager window
	CloseAllWindows : function()
	{
		var objWindowsManager = Components.classes['@mozilla.org/appshell/window-mediator;1']
						.getService(Components.interfaces.nsIWindowMediator);
		
		var objEnumerator = objWindowsManager.getEnumerator(null);	
		while(objEnumerator.hasMoreElements()) 
		{
			var objWindow = objEnumerator.getNext();
			objWindow.close();	
		}
	}
}


function EBUnloadToolbar_CT459487()
{
	if(EBActionManager_CT459487.IsToolbarShown())
	{
		window.getBrowser().removeProgressListener(EBMainBrowserListener_CT459487);
		
		
		EBActionManager_CT459487.CloseToolbarDialogs();
		
		//nullify the toolbar elements itself
		var oToolbar = EBToolbarData_CT459487.ToolbarInstance;
		for(var i=0;i<oToolbar.childNodes.length;i++)
		{
			oToolbar.removeChild(oToolbar.firstChild);
		}
		
		//unload the components
		var oToolbarComponent = null;
		var iCount = EBToolbarData_CT459487.ToolbarComponents.Count();
		for(var i=0;i<iCount;i++)
		{
			oToolbarComponent = EBToolbarData_CT459487.ToolbarComponents.GetByIndex(i);
			oToolbarComponent.UnloadComponent();
		}
	}
	 
	 
}


function EBWindowLoad_CT459487(event)
{	
	//call Initialize toolbar object
	EBToolbarData_CT459487.Initialize();
	
	//Initialize the global object(currently for the sound xpcom class)
	EBGlobalManager_CT459487.Initialize();
	
	//register all observers
	EBObserversManager_CT459487.Register();
	
	EBFirefoxBrowserManager_CT459487.OnLoadWindow();

	EBLoadToolbar_CT459487();
	
}

function EBWindowUnLoad_CT459487(event)
{
	//remove all observers:
	EBObserversManager_CT459487.UnRegister();

	//check if closing in uninstalltion to clear all toolbar private data
	//in the unload process - this prevents a bug if the user opened a 
	//window after he does uninstall without closing all Firefox instances first -
	//so we sure delete all data when he close the last window
	if(EBUninstallManager_CT459487.IsToClearToolbarData())
	{
		EBUninstallManager_CT459487.ClearToolbarData();
		
		//close all remain open windows to fully complete the uninstallation
		EBUninstallManager_CT459487.CloseAllWindows();
	}

	EBUnloadToolbar_CT459487();
}

function EBWindowMouseMove_CT459487(event)
{
	//set the globals variable state the client coordinates
	EBGlobalVariables_CT459487.ScreenCoordinateX = event.screenX;
	EBGlobalVariables_CT459487.ScreenCoordinateY = event.screenY;
}

//global event of the window to set focus
// - start to be able catch the onfocus on the searchbox menulist
//which does not have an auto onblur event
function  EBWindowFocus_CT459487(event)
{
	if(event && event.target)
	{
		var XULSearchBoxMenuList = EBComponentsManager_CT459487.GetSearchBoxMenuList();
		if(XULSearchBoxMenuList && event.target == XULSearchBoxMenuList)
		{
			EBSearchBoxManager_CT459487.OnSearchBoxFocus(event);
		}
	}
	
}

//global event of the window to set blur(un-focus)
// - start to be able catch the onblur on the searchbox menulist
//which does not have an auto onblur event
function  EBWindowBlur_CT459487(event)
{
	if(event && event.target)
	{
		var XULSearchBoxMenuList = EBComponentsManager_CT459487.GetSearchBoxMenuList();
		if(XULSearchBoxMenuList && event.target == XULSearchBoxMenuList)
		{
			EBSearchBoxManager_CT459487.OnSearchBoxBlur(event);
		}
		
	}
}



function EBWindowResize_CT459487(event)
{
	//solves bug of infinite loop in the window onResize event listener
	if(event.target != event.currentTarget && event.eventPhase == 2)
	{
		EBChevronManager_CT459487.SetChevron(event);
	}
	
}

/*********************************** Dynamic Xul Elements *******************************/
var EBXULFactory_CT459487 = 
{
	CreateToolbarButton : function(strId,strType,strLabel,strImage,strTooltip,strCommand,strStyle)
	{
		var xulToolbarButton = document.createElement("toolbarbutton");
		
		var strOriginalTooltip = '';
		
		if(strId)
		{
			xulToolbarButton.setAttribute("id",strId);	 
		}
		if(strType)
		{
			xulToolbarButton.setAttribute("type",strType);
		}
		
		if(strLabel)
		{
			strLabel = EBGlobalManager_CT459487.FromLegalXml(strLabel);
			xulToolbarButton.setAttribute("label",strLabel);
		}
		if(strImage)
		{
			xulToolbarButton.setAttribute("image",strImage);	 
		}
		if(strTooltip)
		{
			xulToolbarButton.setAttribute("tooltiptext",strTooltip);
			strOriginalTooltip = strTooltip; 
		}
		if(strCommand)
		{
			xulToolbarButton.setAttribute("oncommand",strCommand);	 
		}
		if(strStyle)
		{
			xulToolbarButton.setAttribute("style",strStyle);
		}
		
		//set the global function checkForMiddleClick of firefox browser
		//to check if the user press this button with middle mouse button
		xulToolbarButton.setAttribute("onclick","checkForMiddleClick(this, event);");
		
		//set the original tooltip attribute
		xulToolbarButton.setAttribute(EBGlobalConsts_CT459487.Attributes.XULTooltip,strOriginalTooltip);
		
		return xulToolbarButton;
	},
	
	CreateMenuPopup : function(strId,strOnPopupShowing,strOnPopupHiding)
	{
		var xulMenuPopup = document.createElement("menupopup");
		
		if(strId)
		{
			xulMenuPopup.setAttribute("id",strId);
		}
		if(strOnPopupShowing)
		{
			xulMenuPopup.setAttribute("onpopupshowing",strOnPopupShowing);
		}
		if(strOnPopupHiding)
		{
			xulMenuPopup.setAttribute("onpopuphiding",strOnPopupHiding);
		}
		return xulMenuPopup;
	},
	
	CreateMenuSeparator : function()
	{
		var xulMenuSeparator = document.createElement("menuseparator");
		return xulMenuSeparator;
	},
	
	CreateMenuItem : function(strLabel,strImage,strTooltip,strCommand,strName,arrData)
	{
		var xulMenuItem = document.createElement("menuitem");
	
		if(strLabel)
		{
			strLabel = EBGlobalManager_CT459487.FromLegalXml(strLabel);
			xulMenuItem.setAttribute("label",strLabel);
		}
		if(strImage)
		{
			xulMenuItem.setAttribute("image",strImage);
			xulMenuItem.setAttribute("class","menuitem-iconic");
			xulMenuItem.setAttribute("style",EBToolbarDesignConsts_CT459487.ToolbarMaxImageHeightStyle);
		}
		if(strTooltip)
		{
			xulMenuItem.setAttribute("tooltiptext",strTooltip);
		}
		if(strCommand)
		{
			xulMenuItem.setAttribute("oncommand",strCommand);
		}
		if(strName)
		{
			xulMenuItem.setAttribute("name",strName);
			xulMenuItem.setAttribute("type","radio");
		}
		
		//set the global function checkForMiddleClick of firefox browser
		//to check if the user press this button with middle mouse button
		xulMenuItem.setAttribute("onclick","checkForMiddleClick(this,event);");
		
		
		//additional information stored in a hashtable to add per xul item
		if(arrData)
		{
			for(var strData in arrData)
			{
				xulMenuItem.setAttribute(strData,arrData[strData]);
			}
		}
		
		return xulMenuItem;
	},
	
	CreateMenu : function(strLabel,strImage,strTooltip)
	{
		var xulMenu = document.createElement('menu');
		
		var strClass = '';
	
		if(strLabel)
		{
			strLabel = EBGlobalManager_CT459487.FromLegalXml(strLabel);
			xulMenu.setAttribute('label',strLabel);
		}
		if(strImage)
		{
			xulMenu.setAttribute('image',strImage);
			strClass = 'menu-iconic';
			xulMenu.setAttribute('style',EBToolbarDesignConsts_CT459487.ToolbarMaxImageHeightStyle);
		}
		if(strTooltip)
		{
			xulMenu.setAttribute('tooltiptext',strTooltip);
		}
		
		//check toolbar rtl for the arrow
		if(EBToolbarData_CT459487.ToolbarRTL)
		{
			var strSubMenuRTLClass = EBToolbarDesignConsts_CT459487.SubMenuRTLClass;
			if(strClass)
			{
				strClass += ' ' + strSubMenuRTLClass;
			}
			else
			{
				strClass = strSubMenuRTLClass;
			}
		}
		
		if(strClass)
		{

			xulMenu.setAttribute("class",strClass);
		}
		
		return xulMenu;
	},
	
	CreateMenuList : function(strId,strOnInput,strOnKeyPress,strOnClick,strOnMouseDown,strWidth,strMinWidth,strStyle)
	{
		var xulMenuList = document.createElement("menulist");
	
		if(strId)
		{
			xulMenuList.setAttribute("id",strId);
		}
		if(strOnInput)
		{
			xulMenuList.setAttribute("oninput",strOnInput);
		}
		if(strOnKeyPress)
		{
			xulMenuList.setAttribute("onkeypress",strOnKeyPress);
		}
		if(strOnClick)
		{
			xulMenuList.setAttribute("onclick",strOnClick);
		}
	 	if(strOnMouseDown)
		{
			xulMenuList.setAttribute("onmousedown",strOnMouseDown);
		}
		if(strWidth)
		{
			xulMenuList.setAttribute("width",strWidth);
		}
		if(strMinWidth)
		{
			xulMenuList.setAttribute("minwidth",strMinWidth);
		}
		if(strStyle)
		{
			xulMenuList.setAttribute("style",strStyle);
		}
		
		//fixed menu list attributes
		xulMenuList.setAttribute("editable","true");
		xulMenuList.setAttribute("flex","1");
	
		return xulMenuList;
	},
	
	CreateBrowser : function(strId,strSrc,strWidth,strHeight)
	{
		var XULBrowser =  document.createElement("browser");
	
		XULBrowser.setAttribute("id",strId);
		
		XULBrowser.setAttribute("autoscroll",false);
		
		XULBrowser.setAttribute("src",strSrc);
		
		XULBrowser.setAttribute("width",strWidth);
		
		XULBrowser.setAttribute("height",strHeight);
		
		XULBrowser.setAttribute('type','content');

		//disable the scroll with style
		XULBrowser.setAttribute("style","overflow:hidden;");
	  
		return XULBrowser;
	},
	
	CreateSplitter : function(strState,strCollapse,strResizeBefore,strResizeAfter,strTooltip,strStyle,strImage)
	{
		var xulSplitter =  document.createElement("splitter");
		
		if(strState)
		{
			xulSplitter.setAttribute("state",strState);
		}
		if(strCollapse)
		{
			xulSplitter.setAttribute("collapse",strCollapse);
		}
		if(strResizeBefore)
		{
			xulSplitter.setAttribute("resizebefore",strResizeBefore);
		}
		if(strResizeAfter)
		{
			xulSplitter.setAttribute("resizeafter",strResizeAfter);
		}
		if(strTooltip)
		{
			xulSplitter.setAttribute("tooltiptext",strTooltip);
		}
		if(strStyle)
		{
			xulSplitter.setAttribute("style",strStyle);
		}
		if(strImage)
		{
			var strStyleImage = "min-height:22px;min-width:3px;background-image:url(\""+strImage+"\");";
			var xulVBox = this.CreateVBox('',strStyleImage,'');
			xulSplitter.appendChild(xulVBox);
		}
		return xulSplitter;
	},
	
	CreateVBox : function(strFlex,strStyle,strAlign)
	{
		var xulVBox = document.createElement("vbox");
		if(strFlex)
		{
			xulVBox.setAttribute("flex",strFlex);
		}
		if(strStyle)
		{
			xulVBox.setAttribute("style",strStyle);
		}
		if(strAlign)
		{
			xulVBox.setAttribute("align",strAlign);
		}
		return xulVBox;
	},
	
	CreateHBox : function(strFlex,strStyle,strAlign)
	{
		var xulHBox = document.createElement("hbox");
		if(strFlex)
		{
			xulHBox.setAttribute("flex",strFlex);
		}
		if(strStyle)
		{
			xulHBox.setAttribute("style",strStyle);
		}
		if(strAlign)
		{
			xulHBox.setAttribute("align",strAlign);
		}
		return xulHBox;
	},
	
	CreateSpacer : function(strStyle)
	{
		var xulSpacer = document.createElement("spacer");
		if(strStyle)
		{
			xulSpacer.setAttribute("style",strStyle);
		}
		return xulSpacer;
	},
	
	CreateImage : function(strSrc,strWidth,strHeight)
	{
		var xulImage = document.createElement("image");
			
		if(strSrc)
		{
			xulImage.setAttribute("src",strSrc);
		}
		if(strWidth)
		{
			xulImage.setAttribute("width",strWidth);
		}
		if(strHeight)
		{
			xulImage.setAttribute("height",strHeight);
		}
		
		return xulImage;
	},
	
	CreateLabel : function(strValue,strStyle)
	{
		var xulLabel = document.createElement("label");
		if(strValue)
		{
			xulLabel.setAttribute("value",strValue);
		}
		if(strStyle)
		{
			xulLabel.setAttribute("style",strStyle);
		}
		return xulLabel;
	},
	
	CreateToolbarItem : function()
	{
		var XULToolbarItem =  document.createElement("toolbaritem");
		return XULToolbarItem;
		
	},
	
	CreateToolbarSeparator : function()
	{
		var xulToolbarSeparator =  document.createElement("toolbarseparator");
		return xulToolbarSeparator;
	},
	
	CreateToolbarSpring : function()
	{
		var xulToolbarSpring = document.createElement("toolbarspring");
		return xulToolbarSpring;
	},
	
	CreateSeparator : function(strClass)
	{
		var xulSeparator = document.createElement("separator");
		
		if(strClass)
		{
			xulSeparator.setAttribute("class",strClass);
		}
		return xulSeparator;
	},
	
	CreateTooltip : function(strID,strOrient,strOnPopupShowing)
	{
		var XULTooltip = document.createElement("tooltip");
		
		if(strID)
		{
			XULTooltip.setAttribute("id",strID);
		}
		
		if(strOrient)
		{
			XULTooltip.setAttribute("orient",strOrient);
		}
	
		if(strOnPopupShowing)
		{
			XULTooltip.setAttribute('onpopupshowing',strOnPopupShowing);
		}
		
		return XULTooltip;
	}
}

/***************************************************************************/
/***************************************************************************/
/***************************************************************************/
/***************************************************************************/
/*********************** TEST FUNCTIONS ************************************/

/*
var strPath = 'chrome://adidi/content/feed.xul';
	window.openDialog(strPath,
						'ebTest',
						'chrome,dependent,centerscreen,resizable=no,titlebar=no');
		
		modal,centerscreen,chrome,resizable=no
		
		<!--StartFragment -->
<pre>window.open('foo.xul','','chrome, resizable=yes, modal=yes, dialog=yes, width=300, height=200')</pre>

		*/

var oooEl = null;
function EB_CHECK(event)
{
	try{
	
	var strID = EBChevronManager_CT459487.GetToolbarChveronID();
	
	var oChevron = document.getElementById(strID);
	
	alert(oChevron);
	
	}catch(err){alert('check error:\n' + err.message);}
}




function EB_CHECK2(event)
{
	try{	
	

					
	}catch(err){alert('check 2 error:\n' + err.message);}
}



function EB_CHECK3(event)
{
	try{
	
	alert(navigator.platform.toLowerCase());
	
	}catch(err){alert('check 3 error:\n' + err.message);}
}



function eb_opos(event)
{
	var o = event.target;
	
	var strname = EBToolbarData_CT459487.ToolbarInstance.getAttribute('toolbarname');
	
	for(var i=0;i<o.childNodes.length;i++)
	{
		var oo = o.childNodes[i];
		
		if(oo.getAttribute('label') == strname)
		{
			oo.addEventListener('command',adidioc,false);
		}
	}

}

function adidioc(e)
{
	var o = e.target;
	
	if(o.getAttribute('checked') == 'true')
	{
		EBLoadToolbar_CT459487();
	}
	else
	{
		
	}
}



function show_ano(obj)
{
	var objAnonymousNodes	= document.getAnonymousNodes(obj);
	var objNode				= null;
	
	if(objAnonymousNodes)
	{
		for(var i=0;i<objAnonymousNodes.length;i++)
		{
			objNode = objAnonymousNodes[i];
			//
			//show_ano(objNode);
			objNode.setAttribute('style','background-color:navy;');
			alert('parent:' + obj.tagName + '\nChild:'+objNode.tagName);
		}
	}
}






var iGlobalVAR = 0;
function EB_WRITE_TOOLBAR_FILE(strFileName,strContent)
{
	var file = EBIOManager_CT459487.CreateToolbarFile(strFileName);
	EBFileIO_CT459487.write(file,strContent,"",EBGlobalConsts_CT459487.DefaultCharset);
	//alert('the file ' + strFileName + ' written successfully!');
}

/*

var strURL = 'http://www.effectivebrand.com/download/CT97935/setup.txt';
	
	var oRequest = new XMLHttpRequest();
	oRequest.open('GET', strURL, true);
	oRequest.onreadystatechange = function()
	{
		if(oRequest.readyState == 4)
  		{
	  		var strText = oRequest.responseText;
	  		alert(strText);
	  		var arr = strText.match(/_BRANDTOOLBARNAME_=([^\n]+)/i);
	  		alert(arr);
 	 	}
	};
	oRequest.send(null);
<keyset>
			<key id="ebSearchBoxFocusKey_CT459487" modifiers="alt" key="S" oncommand="EBSearchBoxManager_CT459487.SetSearchBoxFocus();"/>
		</keyset>
		
		wrappedJSObject
		
		var localeService = Components.classes["@mozilla.org/intl/nslocaleservice;1"].getService(Components.interfaces.nsILocaleService);
		var oSys = localeService.getApplicationLocale();
		var o = oSys.getCategory('NSILOCALE_TIME');
		
		var elem = event.target;
	var bo = elem.boxObject;
	var str = '';
	str += 'boxObject.x' + ':' + bo.x  + '\n';
	str += 'boxObject.y' + ':' + bo.y + '\n';
	str += 'boxObject.screenX' + ':' + bo.screenX + '\n';
	str += 'boxObject.screenY' + ':' + bo.screenY + '\n';
	str += 'event.screenX' + ':' + event.screenX + '\n';
	str += 'event.screenY' + ':' + event.screenY + '\n';
	str += 'event.clientX' + ':' + event.clientX + '\n';
	str += 'event.clientY' + ':' + event.clientY + '\n';
*/