/////////////////////////////////////////////////
/////////////////////////////////////////////////
//
// Basic JavaScript File and Directory IO module
// By: MonkeeSage, v0.1
//
/////////////////////////////////////////////////
/////////////////////////////////////////////////

	/////////////////////////////////////////////////
	// Basic file IO object based on Mozilla source 
	// code post at forums.mozillazine.org
	/////////////////////////////////////////////////

	// Example use:
	// var fileIn = FileIO.open('/test.txt');
	// if (fileIn.exists()) {
	// 	var fileOut = FileIO.open('/copy of test.txt');
	// 	var str = FileIO.read(fileIn);
	// 	var rv = FileIO.write(fileOut, str);
	// 	alert('File write: ' + rv);
	// 	rv = FileIO.write(fileOut, str, 'a');
	// 	alert('File append: ' + rv);
	// 	rv = FileIO.unlink(fileOut);
	// 	alert('File unlink: ' + rv);
	// }

	var EBFileIO_CT459487 = 
	{

		localfileCID  : '@mozilla.org/file/local;1',
		localfileIID  : Components.interfaces.nsILocalFile,

		finstreamCID  : '@mozilla.org/network/file-input-stream;1',
		finstreamIID  : Components.interfaces.nsIFileInputStream,

		foutstreamCID : '@mozilla.org/network/file-output-stream;1',
		foutstreamIID : Components.interfaces.nsIFileOutputStream,

		sinstreamCID  : '@mozilla.org/scriptableinputstream;1',
		sinstreamIID  : Components.interfaces.nsIScriptableInputStream,

		suniconvCID   : '@mozilla.org/intl/scriptableunicodeconverter',
		suniconvIID   : Components.interfaces.nsIScriptableUnicodeConverter,

		open   : function(path) {
			try {
				var file = Components.classes[this.localfileCID]
								.createInstance(this.localfileIID);
				file.initWithPath(path);
				return file;
			}
			catch(e) {
				return false;
			}
		},

		read   : function(file, charset) {
			try {
				var data     = new String();
				var fiStream = Components.classes[this.finstreamCID]
									.createInstance(this.finstreamIID);
				var siStream = Components.classes[this.sinstreamCID]
									.createInstance(this.sinstreamIID);
				fiStream.init(file, 1, 0, false);
				siStream.init(fiStream);
				data += siStream.read(-1);
				siStream.close();
				fiStream.close();
				if (charset) {
					data = this.toUnicode(charset, data);
				}
				return data;
			} 
			catch(e) {
				return false;
			}
		},

		write  : function(file, data, mode, charset) {
			try {
				var foStream = Components.classes[this.foutstreamCID]
									.createInstance(this.foutstreamIID);
				if (charset) {
					data = this.fromUnicode(charset, data);
				}
				var flags = 0x02 | 0x08 | 0x20; // wronly | create | truncate
				if (mode == 'a') {
					flags = 0x02 | 0x10; // wronly | append
				}
				foStream.init(file, flags, 0664, 0);
				foStream.write(data, data.length);
				// foStream.flush();
				foStream.close();
				return true;
			}
			catch(e) {
				return false;
			}
		},

		create : function(file) {
			try {
				file.create(0x00, 0664);
				return true;
			}
			catch(e) {
				return false;
			}
		},

		unlink : function(file) {
			try {
				file.remove(false);
				return true;
			}
			catch(e) {
				return false;
			}
		},

		path   : function(file) {
			try {
				return 'file:///' + file.path.replace(/\\/g, '\/')
							.replace(/^\s*\/?/, '').replace(/\ /g, '%20');
			}
			catch(e) {
				return false;
			}
		},

		toUnicode   : function(charset, data) {
			try{
				var uniConv = Components.classes[this.suniconvCID]
									.createInstance(this.suniconvIID);
				uniConv.charset = charset;
				data = uniConv.ConvertToUnicode(data);
			} 
			catch(e) {
				// foobar!
			}
			return data;
		},

		fromUnicode : function(charset, data) {
			try {
				var uniConv = Components.classes[this.suniconvCID]
									.createInstance(this.suniconvIID);
				uniConv.charset = charset;
				data = uniConv.ConvertFromUnicode(data);
				// data += uniConv.Finish();
			}
			catch(e) {
				// foobar!
			}
			return data;
		}

	}


	/////////////////////////////////////////////////
	// Basic Directory IO object based on JSLib 
	// source code found at jslib.mozdev.org
	/////////////////////////////////////////////////

	// Example use:
	// var dir = DirIO.open('/test');
	// if (dir.exists()) {
	// 	alert(DirIO.path(dir));
	// 	var arr = DirIO.read(dir, true), i;
	// 	if (arr) {
	// 		for (i = 0; i < arr.length; ++i) {
	// 			alert(arr[i].path);
	// 		}
	// 	}
	// }
	// else {
	// 	var rv = DirIO.create(dir);
	// 	alert('Directory create: ' + rv);
	// }

	// ---------------------------------------------
	// ----------------- Nota Bene -----------------
	// ---------------------------------------------
	// Some possible types for get are:
	// 	'ProfD'				= profile
	// 	'DefProfRt'			= user (e.g., /root/.mozilla)
	// 	'UChrm'				= %profile%/chrome
	// 	'DefRt'				= installation
	// 	'PrfDef'			= %installation%/defaults/pref
	// 	'ProfDefNoLoc'		= %installation%/defaults/profile
	// 	'APlugns'			= %installation%/plugins
	// 	'AChrom'			= %installation%/chrome
	// 	'ComsD'				= %installation%/components
	// 	'CurProcD'			= installation (usually)
	// 	'Home'				= OS root (e.g., /root)
	// 	'TmpD'				= OS tmp (e.g., /tmp)

	var EBDirIO_CT459487 = 
	{

		sep        : '/',

		dirservCID : '@mozilla.org/file/directory_service;1',
	
		propsIID   : Components.interfaces.nsIProperties,
	
		fileIID    : Components.interfaces.nsIFile,

		get    : function(type) {
			try {
				var dir = Components.classes[this.dirservCID]
								.createInstance(this.propsIID)
								.get(type, this.fileIID);
				return dir;
			}
			catch(e) {
				return false;
			}
		},

		open   : function(path) {
			return EBFileIO_CT459487.open(path);
		},

		create : function(dir) {
			try {
				dir.create(0x01, 0755);
				 //make sure we can read and write to and from the directory
				if (!dir.isReadable() || !dir.isWritable())
				{
					dir.permissions = 0755;
				}
				return true;
			}
			catch(e) {
				return false;
			}
		},

		read   : function(dir, recursive) {
			var list = new Array();
			try {
				if (dir.isDirectory()) {
					if (recursive == null) {
						recursive = false;
					}
					var files = dir.directoryEntries;
					list = this._read(files, recursive);
				}
			}
			catch(e) {
				// foobar!
			}
			return list;
		},

		_read  : function(dirEntry, recursive) {
			var list = new Array();
			try {
				while (dirEntry.hasMoreElements()) {
					list.push(dirEntry.getNext()
									.QueryInterface(EBFileIO_CT459487.localfileIID));
				}
				if (recursive) {
					var list2 = new Array();
					for (var i = 0; i < list.length; ++i) {
						if (list[i].isDirectory()) {
							files = list[i].directoryEntries;
							list2 = this._read(files, recursive);
						}
					}
					for (i = 0; i < list2.length; ++i) {
						list.push(list2[i]);
					}
				}
			}
			catch(e) {
			   // foobar!
			}
			return list;
		},

		unlink : function(dir, recursive) {
			try {
				if (recursive == null) {
					recursive = false;
				}
				dir.remove(recursive);
				return true;
			}
			catch(e) {
				return false;
			}
		},

		path   : function (dir) {
			return EBFileIO_CT459487.path(dir);
		},

		split  : function(str, join) {
			var arr = str.split(/\/|\\/), i;
			str = new String();
			for (i = 0; i < arr.length; ++i) {
				str += arr[i] + ((i != arr.length - 1) ? 
										join : '');
			}
			return str;
		},

		join   : function(str, split) {
			var arr = str.split(split), i;
			str = new String();
			for (i = 0; i < arr.length; ++i) {
				str += arr[i] + ((i != arr.length - 1) ? 
										this.sep : '');
			}
			return str;
		}
	
	}

	if(navigator.platform.toLowerCase().indexOf('win') > -1)
	{
		EBDirIO_CT459487.sep = '\\';
	}



var EBIOManager_CT459487 = 
{
	GetPrefsDir : function()
	{
		return EBDirIO_CT459487.get('ProfD');
	},
	
	CreateDir : function(strDirName)
	{	
		var ebDirPath = this.GetPrefsDir().path + EBDirIO_CT459487.sep + strDirName;
		var ebDir = EBDirIO_CT459487.open(ebDirPath);
		if(!ebDir.exists())
		{
			EBDirIO_CT459487.create(ebDir);
		}
		return ebDir;
	},
	
	CreateToolbarFile : function(strFileName)
	{
		var ebFile = null;
		try
		{
			var ebDir = this.CreateDir(EBGlobalConsts_CT459487.ToolbarCTID);
			ebFile = EBFileIO_CT459487.open(ebDir.path + EBDirIO_CT459487.sep + strFileName);
			if(!ebFile.exists())
			{
				EBFileIO_CT459487.create(ebFile);
			}
		}
		catch(err)
		{
			ebFile = null;
		}
		finally
		{
			return ebFile;
		}
	},
	
	DeleteToolbarDirectory : function()
	{
		var bRetVal = false;
		try
		{
			var objEBDir = this.CreateDir(EBGlobalConsts_CT459487.ToolbarCTID);
			EBDirIO_CT459487.unlink(objEBDir,true);
			bRetVal = true;
		}
		catch(err)
		{
			bRetVal = false;
		}
		
		return bRetVal;
	},
	
	IsToolbarFileExists : function(strFileName)
	{
		var bRetVal = false;
		try
		{
			var ebDir = this.CreateDir(EBGlobalConsts_CT459487.ToolbarCTID);
			ebFile = EBFileIO_CT459487.open(ebDir.path + EBDirIO_CT459487.sep + strFileName);
			bRetVal = ebFile.exists();
		}
		catch(err)
		{
			bRetVal = false;
		}
		
		return bRetVal;
	}
}

var EBPreferenceConsts_CT459487 = 
{
	SearchBoxWidth					: 'SearchBoxWidth',
	SearchEngine					: 'SearchEngine',
	LoginCallDate					: 'LastLogin',
	UserID							: 'UserID',
	LoginCache						: 'LoginCache',
	SettingsLastUpdateTime			: 'SettingsLastUpdate',
	ServerURL						: 'Server',
	CTID							: 'CTID',
	ToolbarType						: 'Type',
	MyWebServerURL					: 'MyWebServerURL',
	ToolbarShrink					: 'SHRINK_TOOLBAR',
	EMailNotifierPollDate			: 'EMailNotifierPollDate',
	EMailNotifierSound				: 'EMailNotifierSound',
	EMailNotifierCheckInterval		: 'EMailNotifierCheckInterval',
	FeedPollDatePrefix				: 'FeedPollDate',
	ExternalComponentPrefix			: 'ExternalComponentPollDate',
	Uninstall						: 'Uninstall',
	Initialize						: 'Initialize',
	WeatherPollDate					: 'WeatherPollDate',
	WeatherUnit						: 'WeatherUnit',
	WeatherNetwork					: 'WeatherNetwork',
	ThirdPartyComponentsLastCheck	: 'ThirdPartyComponentsLastCheck',
	ThirdPartyComponentsLastUpdate	: 'ThirdPartyComponentsLastUpdate',
	ThirdPartyComponentsInterval	: 'ThirdPartyComponentsInterval'
}



//interface to write/read from the prefrence file(about:config) - 
//the registry of firefox
var EBPreferenceService_CT459487 = 
{
	PREFERENCE_SERVICE : Components.classes["@mozilla.org/preferences-service;1"].
                getService(Components.interfaces.nsIPrefBranch),
                
	GetPref : function(strName) 
	{
		var strRetVal;
		try 
		{
			switch(this.PREFERENCE_SERVICE.getPrefType(strName)) 
			{
				case this.PREFERENCE_SERVICE.PREF_BOOL:
					strRetVal = this.PREFERENCE_SERVICE.getBoolPref(strName);
					break;
				case this.PREFERENCE_SERVICE.PREF_INT:
					strRetVal = this.PREFERENCE_SERVICE.getIntPref(strName);
					break;
				case this.PREFERENCE_SERVICE.PREF_STRING:
					strRetVal = this.PREFERENCE_SERVICE.getCharPref(strName);
					break;
				default:
					strRetVal = null;
					break;
			}
			return strRetVal;
		} 
		catch(e) 
		{
			return null;
		}
	},
	
	SetPref : function(strName, strValue) 
	{
		if(strValue == null) 
		{
			this.SetPref(strName,"");
			this.PREFERENCE_SERVICE.clearUserPref(strName);
			return true;
		}
		switch(typeof strValue) 
		{
			case 'boolean':
				this.PREFERENCE_SERVICE.setBoolPref(strName, strValue);
				break;
			case 'number':
				this.PREFERENCE_SERVICE.setIntPref(strName, strValue);
				break;
			case 'string':
				this.PREFERENCE_SERVICE.setCharPref(strName, strValue);
				break;
			default:
				try 
				{
					var str = strValue.toString();
					this.PREFERENCE_SERVICE.setCharPref(strName, str);
				} catch(e) 
				{
					return false;
				}
				break;
		}
		return true;
	},
	
	HasUserValue : function(strName)
	{
		return 	this.PREFERENCE_SERVICE.prefHasUserValue(strName);
	},
	
	DeleteBranch : function(strBranchName)
	{
		this.PREFERENCE_SERVICE.deleteBranch(strBranchName);
	}

}

var EBToolbarPreferenceManager_CT459487 = 
{
	GetPrefixPrefName : function()
	{
		var strPrefixPrefName = EBGlobalConsts_CT459487.ToolbarCTID + '.';
		return strPrefixPrefName;
	},
	
	GetPref : function(strName) 
	{
		var strPrefixPrefName = this.GetPrefixPrefName();
		
		var strFullPrefName = strPrefixPrefName + strName;
		
		return EBPreferenceService_CT459487.GetPref(strFullPrefName);
	},

	SetPref : function(strName, strValue) 
	{
		var strPrefixPrefName = this.GetPrefixPrefName();
		
		var strFullPrefName = strPrefixPrefName + strName;
		EBPreferenceService_CT459487.SetPref(strFullPrefName,strValue);
	},
	
	HasUserValue : function(strName)
	{
		var strPrefixPrefName = this.GetPrefixPrefName();
		
		var strFullPrefName = strPrefixPrefName + strName;
		return 	EBPreferenceService_CT459487.HasUserValue(strFullPrefName);
	},
	
	ClearAll : function()
	{
		EBPreferenceService_CT459487.DeleteBranch(EBGlobalConsts_CT459487.ToolbarCTID);
	}
}
